/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.LineKey;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.TimeAxis;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.TimeRange;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class JLayoutDemo
extends JApplet {
    JPane mainPane_;
    JClassTree tree_ = null;
    boolean isApplet_ = true;
    JFrame frame = null;
    JPanel controlPanel = new JPanel();
    JCheckBox stacked = new JCheckBox();
    ButtonGroup gridtype = new ButtonGroup();
    JCheckBox grid = new JCheckBox();
    JButton showTree = new JButton();

    @Override
    public void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(Color.white);
        this.setSize(426, 712);
        this.makeControlPanel();
        this.add((Component)this.controlPanel, "South");
        this.makeGraph();
        this.add((Component)this.mainPane_, "Center");
    }

    public static void main(String[] args) {
        JLayoutDemo ld = new JLayoutDemo();
        ld.isApplet_ = false;
        ld.frame = new JFrame("Layout Demo");
        ld.frame.setSize(426, 712);
        ld.frame.getContentPane().setLayout(new BorderLayout());
        ld.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }
        });
        ld.makeControlPanel();
        ld.frame.getContentPane().add((Component)ld.controlPanel, "South");
        ld.makeGraph();
        ld.mainPane_.setBackground(Color.white);
        ld.mainPane_.setBatch(true);
        ld.frame.getContentPane().add((Component)ld.mainPane_, "Center");
        ld.frame.setVisible(true);
        ld.mainPane_.setBatch(false);
    }

    void makeControlPanel() {
        this.controlPanel.setLayout(new GridBagLayout());
        this.controlPanel.setBounds(0, 679, 426, 33);
        this.controlPanel.setBorder(new EtchedBorder());
        this.gridtype.add(this.stacked);
        this.stacked.setSelected(true);
        this.stacked.setText("Overlayed");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 15, 5, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.controlPanel.add((Component)this.stacked, gbc);
        this.stacked.setBounds(15, 5, 84, 23);
        this.gridtype.add(this.grid);
        this.grid.setText("Grid");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 3;
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.controlPanel.add((Component)this.grid, gbc);
        this.grid.setBounds(109, 5, 53, 23);
        this.showTree.setText("Show Class Tree");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 3;
        gbc.insets = new Insets(5, 5, 5, 15);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.controlPanel.add((Component)this.showTree, gbc);
        this.showTree.setBackground(Color.yellow.brighter());
        this.showTree.setBounds(302, 5, 109, 23);
        SymItem lSymItem = new SymItem();
        this.stacked.addItemListener(lSymItem);
        this.grid.addItemListener(lSymItem);
        SymAction lSymAction = new SymAction();
        this.showTree.addActionListener(lSymAction);
    }

    void makeGraph() {
        this.mainPane_ = new JPane("Layout Demo", new Dimension(426, 400));
        this.mainPane_.setLayout(new StackedLayout());
        GeoDate start = null;
        GeoDate stop = null;
        try {
            start = new GeoDate("1992-11-01", "yyyy-MM-dd");
            stop = new GeoDate("1993-02-20", "yyyy-MM-dd");
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        TimeRange tr = new TimeRange(start, stop);
        TestData td = new TestData(4, tr, 1.0f, 2, 1.2f, 0.0f, 20.0f);
        SimpleLine line = (SimpleLine)td.getSGTData();
        try {
            start = new GeoDate("1992-11-01", "yyyy-MM-dd");
            stop = new GeoDate("1993-02-20", "yyyy-MM-dd");
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        tr = new TimeRange(start, stop);
        td = new TestData(4, tr, 1.0f, 2, 1.2f, 0.5f, 30.0f);
        SimpleLine line2 = (SimpleLine)td.getSGTData();
        SoTRange yRange = line.getYRange();
        yRange.add(line2.getYRange());
        SoTRange tnRange = line.getXRange();
        SoTRange ynRange = Graph.computeRange(yRange, 6);
        String yLabel = line.getYMetaData().getName();
        double xsize = 4.0;
        double xstart = 0.6;
        double xend = 3.25;
        double ysize = 3.0;
        double ystart = 0.6;
        double yend = 2.5;
        Layer layer = new Layer("First Layer", new Dimension2D(xsize, ysize));
        GeoDate stime = new GeoDate();
        SGLabel label = new SGLabel("Date Stamp", stime.toString(), new Point2D.Double(0.05, 0.05));
        label.setAlign(2, 0);
        label.setColor(Color.magenta);
        label.setHeightP(0.15);
        label.setFont(new Font("Dialog", 0, 10));
        layer.addChild(label);
        SGLabel title = new SGLabel("Title", "Layout Demo", new Point2D.Double(xsize / 2.0, ysize));
        title.setAlign(0, 1);
        title.setHeightP(0.2);
        title.setFont(new Font("Helvetica", 1, 14));
        layer.addChild(title);
        LineKey lkey = new LineKey();
        lkey.setId("Legend");
        lkey.setLocationP(new Point2D.Double(xsize - 0.01, ysize));
        lkey.setVAlign(0);
        lkey.setHAlign(2);
        layer.addChild(lkey);
        this.mainPane_.add(layer);
        CartesianGraph graph = new CartesianGraph("First Graph");
        LinearTransform xt = new LinearTransform(new Range2D(xstart, xend), tnRange);
        graph.setXTransform(xt);
        LinearTransform yt = new LinearTransform(new Range2D(ystart, yend), ynRange);
        graph.setYTransform(yt);
        SoTPoint point = new SoTPoint(ynRange.getStart(), tnRange.getStart());
        TimeAxis xbot = new TimeAxis("Bottom Axis", 2);
        xbot.setRangeU(tnRange);
        xbot.setLocationU(point);
        Font xbfont = new Font("Helvetica", 2, 14);
        xbot.setLabelFont(xbfont);
        xbot.setMinorLabelInterval(1);
        graph.addXAxis(xbot);
        PlainAxis yleft = new PlainAxis("Left Axis");
        yleft.setRangeU(ynRange);
        yleft.setLocationU(point);
        yleft.setLabelFont(xbfont);
        SGLabel ytitle = new SGLabel("Y-Axis Title", yLabel, new Point2D.Double(0.0, 0.0));
        Font ytfont = new Font("Helvetica", 0, 14);
        ytitle.setFont(ytfont);
        ytitle.setHeightP(0.2);
        yleft.setTitle(ytitle);
        graph.addYAxis(yleft);
        layer.setGraph(graph);
        LineAttribute attr = new LineAttribute(4, 20, Color.red);
        attr.setMarkHeightP(0.1);
        graph.setData(line, attr);
        lkey.addLineGraph((LineCartesianRenderer)graph.getRenderer(), new SGLabel("1st line", "Red Data", new Point2D.Double(0.0, 0.0)));
        Layer layer2 = new Layer("Second Layer", new Dimension2D(xsize, ysize));
        this.mainPane_.add(layer2);
        CartesianGraph graph2 = new CartesianGraph("Second Graph", xt, yt);
        layer2.setGraph(graph2);
        LineAttribute attr2 = new LineAttribute(4, 2, Color.blue);
        attr2.setMarkHeightP(0.1);
        graph2.setData(line2, attr2);
        lkey.addLineGraph((LineCartesianRenderer)graph2.getRenderer(), new SGLabel("2nd line", "Blue Data", new Point2D.Double(0.0, 0.0)));
    }

    void stacked_itemStateChanged(ItemEvent event) {
        Component[] comps = this.mainPane_.getComponents();
        this.mainPane_.setBatch(true);
        this.mainPane_.setLayout(new StackedLayout());
        Graph gr2 = ((Layer)comps[1]).getGraph();
        ((CartesianGraph)gr2).removeAllXAxes();
        ((CartesianGraph)gr2).removeAllYAxes();
        if (this.isApplet_) {
            this.validate();
        } else {
            this.frame.validate();
        }
        this.mainPane_.setBatch(false);
        if (this.tree_ != null && this.tree_.isVisible()) {
            this.tree_.setJPane(this.mainPane_);
            this.tree_.expandTree();
        }
    }

    void grid_itemStateChanged(ItemEvent event) {
        Component[] comps = this.mainPane_.getComponents();
        this.mainPane_.setBatch(true);
        this.mainPane_.setLayout(new GridLayout(2, 0));
        Graph gr = ((Layer)comps[0]).getGraph();
        Graph gr2 = ((Layer)comps[1]).getGraph();
        Enumeration xa = ((CartesianGraph)gr).xAxisElements();
        while (xa.hasMoreElements()) {
            ((CartesianGraph)gr2).addXAxis(((Axis)xa.nextElement()).copy());
        }
        Enumeration ya = ((CartesianGraph)gr).yAxisElements();
        while (ya.hasMoreElements()) {
            ((CartesianGraph)gr2).addYAxis(((Axis)ya.nextElement()).copy());
        }
        if (this.isApplet_) {
            this.validate();
        } else {
            this.frame.validate();
        }
        this.mainPane_.setBatch(false);
        if (this.tree_ != null && this.tree_.isVisible()) {
            this.tree_.setJPane(this.mainPane_);
            this.tree_.expandTree();
        }
    }

    void showTree_ActionPerformed(ActionEvent event) {
        if (this.tree_ == null) {
            this.tree_ = new JClassTree("Classes for LayoutDemo");
        }
        this.tree_.setJPane(this.mainPane_);
        this.tree_.setVisible(true);
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == JLayoutDemo.this.stacked) {
                JLayoutDemo.this.stacked_itemStateChanged(event);
            } else if (object == JLayoutDemo.this.grid) {
                JLayoutDemo.this.grid_itemStateChanged(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == JLayoutDemo.this.showTree) {
                JLayoutDemo.this.showTree_ActionPerformed(event);
            }
        }
    }
}

