/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LogAxis;
import gov.noaa.pmel.sgt.LogTransform;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JLogLogDemo
extends JApplet {
    JButton tree_;
    JButton space_;
    JPane mainPane_;

    @Override
    public void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(553, 438);
        this.add((Component)this.makeGraph(), "Center");
    }

    public static void main(String[] args) {
        JLogLogDemo pd = new JLogLogDemo();
        JFrame frame = new JFrame("Log-Log Demo");
        JPanel button = new JPanel();
        button.setLayout(new FlowLayout());
        pd.tree_ = new JButton("Tree View");
        MyAction myAction = pd.new MyAction();
        pd.tree_.addActionListener(myAction);
        button.add(pd.tree_);
        pd.space_ = new JButton("Add Mark");
        pd.space_.addActionListener(myAction);
        button.add(pd.space_);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }
        });
        frame.setSize(553, 438);
        JPane graph = pd.makeGraph();
        graph.setBatch(true);
        frame.getContentPane().add((Component)graph, "Center");
        frame.getContentPane().add((Component)button, "South");
        frame.pack();
        frame.setVisible(true);
        graph.setBatch(false);
    }

    JPane makeGraph() {
        this.mainPane_ = new JPane("Point Plot Demo", new Dimension(553, 438));
        this.mainPane_.setLayout(new StackedLayout());
        this.mainPane_.setBackground(Color.white);
        Range2D xrange = new Range2D(50.0, 150000.0, 1.25);
        TestData td = new TestData(11, xrange, 2, 10000.0f, 1.0f, 10.0f);
        SGTData data = td.getSGTData();
        SoTRange yrange = data.getYRange();
        double xsize = 4.0;
        double xstart = 0.6;
        double xend = 3.5;
        double ysize = 3.0;
        double ystart = 0.6;
        double yend = 2.75;
        Layer layer = new Layer("Layer 1", new Dimension2D(xsize, ysize));
        this.mainPane_.add(layer);
        CartesianGraph graph = new CartesianGraph("Log-Log Graph");
        layer.setGraph(graph);
        LogTransform xt = new LogTransform(xstart, xend, xrange.start, xrange.end);
        LogTransform yt = new LogTransform(new Range2D(ystart, yend), yrange);
        graph.setXTransform(xt);
        graph.setYTransform(yt);
        String xLabel = "X Label";
        LogAxis xbot = new LogAxis("Botton Axis");
        xbot.setRangeU(xrange);
        xbot.setLocationU(new SoTPoint(new SoTValue.Double(xrange.start), yrange.getStart()));
        Font xbfont = new Font("Helvetica", 2, 14);
        xbot.setLabelFont(xbfont);
        SGLabel xtitle = new SGLabel("xaxis title", xLabel, new Point2D.Double(0.0, 0.0));
        Font xtfont = new Font("Helvetica", 0, 14);
        xtitle.setFont(xtfont);
        xtitle.setHeightP(0.2);
        xbot.setTitle(xtitle);
        graph.addXAxis(xbot);
        String yLabel = "Y Label";
        LogAxis yleft = new LogAxis("Left Axis");
        yleft.setRangeU(yrange);
        yleft.setLocationU(new SoTPoint(new SoTValue.Double(xrange.start), yrange.getStart()));
        yleft.setLabelFont(xbfont);
        SGLabel ytitle = new SGLabel("yaxis title", yLabel, new Point2D.Double(0.0, 0.0));
        Font ytfont = new Font("Helvetica", 0, 14);
        ytitle.setFont(ytfont);
        ytitle.setHeightP(0.2);
        yleft.setTitle(ytitle);
        graph.addYAxis(yleft);
        LineAttribute lattr = new LineAttribute(0, Color.red);
        graph.setData(data, lattr);
        return this.mainPane_;
    }

    void tree_actionPerformed(ActionEvent e) {
        JClassTree ct = new JClassTree();
        ct.setModal(false);
        ct.setJPane(this.mainPane_);
        ct.setVisible(true);
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object obj = event.getSource();
            if (obj == JLogLogDemo.this.space_) {
                System.out.println("  <<Mark>>");
            }
            if (obj == JLogLogDemo.this.tree_) {
                JLogLogDemo.this.tree_actionPerformed(event);
            }
        }
    }
}

