/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.Logo;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JPointDemo
extends JApplet {
    JButton tree_;
    JButton space_;
    JPane mainPane_;

    @Override
    public void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(553, 438);
        this.add((Component)this.makeGraph(), "Center");
    }

    public static void main(String[] args) {
        JPointDemo pd = new JPointDemo();
        JFrame frame = new JFrame("Point Demo");
        JPanel button = new JPanel();
        button.setLayout(new FlowLayout());
        pd.tree_ = new JButton("Tree View");
        MyAction myAction = pd.new MyAction();
        pd.tree_.addActionListener(myAction);
        button.add(pd.tree_);
        pd.space_ = new JButton("Add Mark");
        pd.space_.addActionListener(myAction);
        button.add(pd.space_);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }
        });
        frame.setSize(553, 438);
        JPane graph = pd.makeGraph();
        graph.setBatch(true);
        frame.getContentPane().add((Component)graph, "Center");
        frame.getContentPane().add((Component)button, "South");
        frame.pack();
        frame.setVisible(true);
        graph.setBatch(false);
    }

    JPane makeGraph() {
        this.mainPane_ = new JPane("Point Plot Demo", new Dimension(553, 438));
        this.mainPane_.setLayout(new StackedLayout());
        this.mainPane_.setBackground(Color.white);
        Range2D xrange = new Range2D(50.0, 150.0, 10.0);
        Range2D yrange = new Range2D(-20.0, 20.0, 5.0);
        TestData td = new TestData(xrange, yrange, 50);
        Collection col = td.getCollection();
        double xsize = 4.0;
        double xstart = 0.6;
        double xend = 3.5;
        double ysize = 3.0;
        double ystart = 0.6;
        double yend = 2.75;
        Layer layer = new Layer("Layer 1", new Dimension2D(xsize, ysize));
        this.mainPane_.add(layer);
        Image img = this.getToolkit().getImage(this.getClass().getResource("ncBrowse48.gif"));
        if (img != null) {
            MediaTracker mt = new MediaTracker(this);
            try {
                mt.addImage(img, 0);
                mt.waitForAll();
                if (mt.isErrorAny()) {
                    System.err.println("JPointDemo: Error loading image");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Logo logo = new Logo(new Point2D.Double(0.0, 0.0), 2, 0);
        logo.setId("ncBrowse logo");
        logo.setImage(img);
        layer.addChild(logo);
        CartesianGraph graph = new CartesianGraph("Point Graph");
        layer.setGraph(graph);
        LinearTransform xt = new LinearTransform(xstart, xend, xrange.start, xrange.end);
        LinearTransform yt = new LinearTransform(ystart, yend, yrange.start, yrange.end);
        graph.setXTransform(xt);
        graph.setYTransform(yt);
        String xLabel = "X Label";
        PlainAxis xbot = new PlainAxis("Botton Axis");
        xbot.setRangeU(xrange);
        xbot.setLocationU(new Point2D.Double(xrange.start, yrange.start));
        Font xbfont = new Font("Helvetica", 2, 14);
        xbot.setLabelFont(xbfont);
        SGLabel xtitle = new SGLabel("xaxis title", xLabel, new Point2D.Double(0.0, 0.0));
        Font xtfont = new Font("Helvetica", 0, 14);
        xtitle.setFont(xtfont);
        xtitle.setHeightP(0.2);
        xbot.setTitle(xtitle);
        graph.addXAxis(xbot);
        String yLabel = "Y Label";
        PlainAxis yleft = new PlainAxis("Left Axis");
        yleft.setRangeU(yrange);
        yleft.setLocationU(new Point2D.Double(xrange.start, yrange.start));
        yleft.setLabelFont(xbfont);
        SGLabel ytitle = new SGLabel("yaxis title", yLabel, new Point2D.Double(0.0, 0.0));
        Font ytfont = new Font("Helvetica", 0, 14);
        ytitle.setFont(ytfont);
        ytitle.setHeightP(0.2);
        yleft.setTitle(ytitle);
        graph.addYAxis(yleft);
        PointAttribute pattr = new PointAttribute(20, Color.red);
        pattr.setLabelPosition(2);
        Font pfont = new Font("Helvetica", 0, 12);
        pattr.setLabelFont(pfont);
        pattr.setLabelColor(Color.blue);
        pattr.setLabelHeightP(0.1);
        pattr.setDrawLabel(true);
        graph.setData(col, pattr);
        return this.mainPane_;
    }

    void tree_actionPerformed(ActionEvent e) {
        JClassTree ct = new JClassTree();
        ct.setModal(false);
        ct.setJPane(this.mainPane_);
        ct.setVisible(true);
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object obj = event.getSource();
            if (obj == JPointDemo.this.space_) {
                System.out.println("  <<Mark>>");
            }
            if (obj == JPointDemo.this.tree_) {
                JPointDemo.this.tree_actionPerformed(event);
            }
        }
    }
}

