/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.swing.JPlotLayout;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JFrame;

public class JProfileDemo
extends JApplet {
    @Override
    public void init() {
        this.setLayout(null);
        this.setSize(450, 600);
        this.add("Center", this.makeGraph());
    }

    public static void main(String[] args) {
        JProfileDemo pd = new JProfileDemo();
        JFrame frame = new JFrame("Profile Demo");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }
        });
        frame.setSize(450, 600);
        JPlotLayout graph = pd.makeGraph();
        graph.setBatch(true);
        frame.getContentPane().add((Component)graph, "Center");
        frame.pack();
        frame.setVisible(true);
        graph.setBatch(false);
    }

    JPlotLayout makeGraph() {
        Range2D zrange = new Range2D(0.0, 495.0, 10.0);
        TestData td = new TestData(1, zrange, 2, 1.2f, 0.5f, 30.0f);
        SGTData newData = td.getSGTData();
        JPlotLayout lpl = new JPlotLayout(newData, "Profile Demo", null, false);
        lpl.addData(newData, "First Line");
        td = new TestData(1, zrange, 2, 2.0f, 0.25f, 30.0f);
        lpl.addData(td.getSGTData(), "Second Line");
        lpl.setTitles("Profile Demo", "using a sgt.swing class", "JPlotLayout");
        lpl.setSize(new Dimension(450, 600));
        lpl.setLayerSizeP(new Dimension2D(6.0, 8.0));
        lpl.setKeyLocationP(new Point2D.Double(6.0, 8.0));
        return lpl;
    }
}

