/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.JPlotLayout;
import gov.noaa.pmel.sgt.swing.SelectionTool;
import gov.noaa.pmel.sgt.swing.ValueIcon;
import gov.noaa.pmel.sgt.swing.prop.LineAttributeDialog;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.TimeRange;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JTimeSeriesDemo
extends JApplet
implements PropertyChangeListener {
    JButton tree_;
    JButton space_ = null;
    JPlotLayout pane_;
    MyMouse myMouse_;
    LineAttributeDialog lad_;

    @Override
    public void init() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(600, 500);
        this.pane_ = this.makeGraph();
        this.pane_.setBatch(true);
        JPanel button = this.makeButtonPanel(false);
        this.getContentPane().add((Component)this.pane_, "Center");
        this.getContentPane().add((Component)button, "South");
        this.pane_.setBatch(false);
    }

    JPanel makeButtonPanel(boolean mark) {
        JPanel button = new JPanel();
        button.setLayout(new FlowLayout());
        this.tree_ = new JButton("Tree View");
        MyAction myAction = new MyAction();
        this.tree_.addActionListener(myAction);
        button.add(this.tree_);
        if (mark) {
            this.space_ = new JButton("Add Mark");
            this.space_.addActionListener(myAction);
            button.add(this.space_);
        }
        return button;
    }

    public static void main(String[] args) {
        JTimeSeriesDemo tsd = new JTimeSeriesDemo();
        JFrame frame = new JFrame("Time Series Demo");
        JPanel button = tsd.makeButtonPanel(true);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }
        });
        tsd.pane_ = tsd.makeGraph();
        tsd.addIcons();
        tsd.pane_.setBatch(true);
        frame.setSize(600, 500);
        frame.getContentPane().add((Component)tsd.pane_, "Center");
        frame.getContentPane().add((Component)button, "South");
        frame.setVisible(true);
        tsd.pane_.setBatch(false);
    }

    JPlotLayout makeGraph() {
        GeoDate start = new GeoDate();
        GeoDate stop = new GeoDate();
        try {
            start = new GeoDate("1968-11-01", "yyyy-MM-dd");
            stop = new GeoDate("2001-02-20", "yyyy-MM-dd");
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        TimeRange tr = new TimeRange(start, stop);
        TestData td = new TestData(4, tr, 75.0f, 2, 1.2f, 0.5f, 30.0f);
        SGTData newData = td.getSGTData();
        System.out.println("series length = " + ((SGTLine)newData).getYArray().length);
        JPlotLayout ltsl = new JPlotLayout(newData, "Time Series Demo", null, false);
        ltsl.addData(newData, "Random Data");
        ltsl.setTitles("Time Series Demo", "using JPlotLayout", "");
        this.myMouse_ = new MyMouse();
        ltsl.addMouseListener(this.myMouse_);
        return ltsl;
    }

    private void addIcons() {
        ValueIcon vi = new ValueIcon(this.getClass().getResource("query.gif"), "value");
        SelectionTool st = new SelectionTool(15);
        SelectionTool st2 = new SelectionTool(240);
        this.pane_.getFirstLayer().addChild(vi);
        this.pane_.getFirstLayer().addChild(st);
        this.pane_.getFirstLayer().addChild(st2);
        vi.setId("local query");
        st.setId("selection tool");
        st.addPropertyChangeListener(new WeakPropertyChangeListener(this, st));
        try {
            vi.setLocationU(new SoTPoint(new GeoDate("1989-04-01", "yyyy-MM-dd"), 1.4));
            st.setLocationU(new SoTPoint(new GeoDate("1978-04-01", "yyyy-MM-dd"), 1.3), new SoTPoint(new GeoDate("1983-04-01", "yyyy-MM-dd"), 0.9));
            st.setConstraints(new SoTPoint(new GeoDate("1968-11-01", "yyyy-MM-dd"), 1.6), new SoTPoint(new GeoDate("2001-02-20", "yyyy-MM-dd"), 0.6));
            st2.setLocationU(new SoTPoint(new GeoDate("1988-04-01", "yyyy-MM-dd"), 1.2), new SoTPoint(new GeoDate("1993-04-01", "yyyy-MM-dd"), 0.8));
            st.setFullYRange(true);
            st2.setFullXRange(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        vi.setVisible(true);
        vi.setSelectable(true);
        st.setVisible(true);
        st.setSelectable(true);
        st2.setVisible(true);
        st2.setSelectable(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        SoTPoint pt = (SoTPoint)evt.getNewValue();
        System.out.println(name + " property change: " + pt);
    }

    void tree_actionPerformed(ActionEvent e) {
        JClassTree ct = new JClassTree();
        ct.setModal(false);
        ct.setJPane(this.pane_);
        ct.setVisible(true);
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object obj = event.getSource();
            if (obj == JTimeSeriesDemo.this.space_) {
                System.out.println("  <<Mark>>");
            }
            if (obj == JTimeSeriesDemo.this.tree_) {
                JTimeSeriesDemo.this.tree_actionPerformed(event);
            }
        }
    }

    class MyMouse
    extends MouseAdapter {
        MyMouse() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == JTimeSeriesDemo.this.pane_) {
                this.maybeShowLineAttributeDialog(event);
            }
        }

        void maybeShowLineAttributeDialog(MouseEvent e) {
            if (e.isPopupTrigger() || e.getClickCount() == 2) {
                Object obj = JTimeSeriesDemo.this.pane_.getObjectAt(e.getX(), e.getY());
                JTimeSeriesDemo.this.pane_.setSelectedObject(obj);
                if (obj instanceof LineCartesianRenderer) {
                    LineAttribute attr = ((LineCartesianRenderer)obj).getLineAttribute();
                    if (JTimeSeriesDemo.this.lad_ == null) {
                        JTimeSeriesDemo.this.lad_ = new LineAttributeDialog();
                    }
                    JTimeSeriesDemo.this.lad_.setLineAttribute(attr);
                    if (!JTimeSeriesDemo.this.lad_.isShowing()) {
                        JTimeSeriesDemo.this.lad_.setVisible(true);
                    }
                }
            }
        }
    }
}

