/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.JPlotLayout;
import gov.noaa.pmel.sgt.swing.MeasurementTool;
import gov.noaa.pmel.sgt.swing.SelectionTool;
import gov.noaa.pmel.sgt.swing.ValueIcon;
import gov.noaa.pmel.sgt.swing.ValueIconFormat;
import gov.noaa.pmel.sgt.swing.prop.LineAttributeDialog;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.TimeRange;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.plaf.metal.MetalIconFactory;

public class JToolDemo
extends JApplet
implements PropertyChangeListener {
    JButton tree_;
    JButton space_ = null;
    JPlotLayout pane_;
    MyMouse myMouse_;
    LineAttributeDialog lad_;

    @Override
    public void init() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(600, 500);
        this.pane_ = this.makeGraph();
        this.pane_.setBatch(true);
        JPanel button = this.makeButtonPanel(false);
        this.getContentPane().add((Component)this.pane_, "Center");
        this.getContentPane().add((Component)button, "South");
        this.pane_.setBatch(false);
        Icon thumb = MetalIconFactory.getVerticalSliderThumbIcon();
        if (thumb != null) {
            System.out.println("thumb not NULL.");
            thumb.paintIcon(this.getContentPane(), this.getContentPane().getGraphics(), 300, 250);
        }
    }

    JPanel makeButtonPanel(boolean mark) {
        JPanel button = new JPanel();
        button.setLayout(new FlowLayout());
        this.tree_ = new JButton("Tree View");
        MyAction myAction = new MyAction();
        this.tree_.addActionListener(myAction);
        button.add(this.tree_);
        if (mark) {
            this.space_ = new JButton("Add Mark");
            this.space_.addActionListener(myAction);
            button.add(this.space_);
        }
        return button;
    }

    public static void main(String[] args) {
        JToolDemo tsd = new JToolDemo();
        JFrame frame = new JFrame("Time Series Demo");
        JPanel button = tsd.makeButtonPanel(true);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }
        });
        tsd.pane_ = tsd.makeGraph();
        tsd.addIcons();
        tsd.pane_.setBatch(true);
        frame.setSize(900, 700);
        frame.getContentPane().add((Component)tsd.pane_, "Center");
        frame.getContentPane().add((Component)button, "South");
        frame.setVisible(true);
        tsd.pane_.setBatch(false);
    }

    JPlotLayout makeGraph() {
        GeoDate start = new GeoDate();
        GeoDate stop = new GeoDate();
        try {
            start = new GeoDate("2007-09-20 1030", "yyyy-MM-dd HHmm");
            stop = new GeoDate("2007-09-21 1030", "yyyy-MM-dd HHmm");
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        TimeRange tr = new TimeRange(start, stop);
        TestData td = new TestData(4, tr, 0.003f, 2, 1.2f, 0.5f, 30.0f);
        SGTData newData = td.getSGTData();
        System.out.println("series length = " + ((SGTLine)newData).getYArray().length);
        JPlotLayout ltsl = new JPlotLayout(newData, "Tool Demo", null, false);
        ltsl.addData(newData, "Random Data");
        ltsl.setTitles("Tool Demo", "using JPlotLayout", "");
        ltsl.getMainTitle().setSelectable(false);
        this.myMouse_ = new MyMouse();
        ltsl.addMouseListener(this.myMouse_);
        return ltsl;
    }

    private void addIcons() {
        ValueIconFormat viFrmt_ = new ValueIconFormat("###.##", "###.##");
        String tFrmt_ = "MM-dd HH:mm";
        ValueIcon vi = new ValueIcon(this.getClass().getResource("query.gif"), "value");
        SelectionTool st = new SelectionTool(3, true);
        st.setHandleFullSized(true);
        st.setSelectColor(new Color(1.0f, 0.0f, 1.0f, 0.2f));
        st.setGrabColor(new Color(0.85f, 0.85f, 0.0f, 0.6f));
        st.setHandleWidth(24);
        MeasurementTool mtVert = new MeasurementTool();
        MeasurementTool mtHorz = new MeasurementTool();
        viFrmt_.setTimeFormat(tFrmt_);
        vi.setValueFormat(viFrmt_);
        mtVert.setValueFormat(viFrmt_);
        mtHorz.setValueFormat(viFrmt_);
        mtVert.setPointLabel(1);
        mtHorz.setPointLabel(2);
        mtHorz.setRuleColor(Color.GRAY);
        mtVert.setDrawRule(false);
        this.pane_.getFirstLayer().addChild(vi);
        this.pane_.getFirstLayer().addChild(st);
        this.pane_.getFirstLayer().addChild(mtVert);
        this.pane_.getFirstLayer().addChild(mtHorz);
        vi.setId("local query");
        st.setId("selection tool");
        st.addPropertyChangeListener(new WeakPropertyChangeListener(this, st));
        mtVert.setId("vert measurement tool");
        mtVert.addPropertyChangeListener(new WeakPropertyChangeListener(this, mtVert));
        mtHorz.setId("horz measurement tool");
        mtHorz.addPropertyChangeListener(new WeakPropertyChangeListener(this, mtHorz));
        try {
            vi.setLocationU(new SoTPoint(new GeoDate("2007-09-20 1130", "yyyy-MM-dd HHmm"), 1.4));
            st.setFullYRange(true);
            st.setLocationU(new SoTPoint(new GeoDate("2007-09-20 1500", "yyyy-MM-dd HHmm"), 1.0), new SoTPoint(new GeoDate("2007-09-20 1820", "yyyy-MM-dd HHmm"), 0.6));
            st.setConstraints(new SoTPoint(new GeoDate("2007-09-20 1030", "yyyy-MM-dd HHmm"), 1.6), new SoTPoint(new GeoDate("2007-09-21 1030", "yyyy-MM-dd HHmm"), 0.6));
            mtVert.setLocationU(new SoTPoint(new GeoDate("2007-09-20 1205", "yyyy-MM-dd HHmm"), 1.3), new SoTPoint(new GeoDate("2007-09-20 1205", "yyyy-MM-dd HHmm"), 0.84));
            mtHorz.setLocationU(new SoTPoint(new GeoDate("2007-09-20 1300", "yyyy-MM-dd HHmm"), 1.1), new SoTPoint(new GeoDate("2007-09-20 1400", "yyyy-MM-dd HHmm"), 1.1));
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        vi.setVisible(true);
        st.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equalsIgnoreCase("visible")) {
            System.out.println(name + " property change: " + evt.getNewValue());
        } else {
            SoTPoint pt = (SoTPoint)evt.getNewValue();
            System.out.println(name + " property change: " + pt);
        }
    }

    void tree_actionPerformed(ActionEvent e) {
        JClassTree ct = new JClassTree();
        ct.setModal(false);
        ct.setJPane(this.pane_);
        ct.setVisible(true);
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object obj = event.getSource();
            if (obj == JToolDemo.this.space_) {
                System.out.println("  <<Mark>>");
            }
            if (obj == JToolDemo.this.tree_) {
                JToolDemo.this.tree_actionPerformed(event);
            }
        }
    }

    class MyMouse
    extends MouseAdapter {
        MyMouse() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == JToolDemo.this.pane_) {
                this.maybeShowLineAttributeDialog(event);
            }
        }

        void maybeShowLineAttributeDialog(MouseEvent e) {
            if (e.isPopupTrigger() || e.getClickCount() == 2) {
                Object obj = JToolDemo.this.pane_.getObjectAt(e.getX(), e.getY());
                JToolDemo.this.pane_.setSelectedObject(obj);
                if (obj instanceof LineCartesianRenderer) {
                    LineAttribute attr = ((LineCartesianRenderer)obj).getLineAttribute();
                    if (JToolDemo.this.lad_ == null) {
                        JToolDemo.this.lad_ = new LineAttributeDialog();
                    }
                    JToolDemo.this.lad_.setLineAttribute(attr);
                    if (!JToolDemo.this.lad_.isShowing()) {
                        JToolDemo.this.lad_.setVisible(true);
                    }
                }
            }
        }
    }
}

