/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.VectorAttribute;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTVector;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.JPlotLayout;
import gov.noaa.pmel.sgt.swing.prop.VectorAttributeDialog;
import gov.noaa.pmel.util.Range2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

public class JVectorDemo
extends JApplet {
    static JPlotLayout rpl_;
    private VectorAttribute vectorAttr_;
    JButton edit_;
    JButton space_ = null;
    JButton tree_;
    JButton print_ = null;

    @Override
    public void init() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setBackground(Color.white);
        this.setSize(600, 430);
        JPanel main = new JPanel();
        rpl_ = this.makeGraph();
        JPanel button = this.makeButtonPanel(false);
        rpl_.setBatch(true);
        main.add((Component)rpl_, "Center");
        this.getContentPane().add((Component)main, "Center");
        this.getContentPane().add((Component)button, "South");
        rpl_.setBatch(false);
    }

    JPanel makeButtonPanel(boolean app) {
        JPanel button = new JPanel();
        button.setLayout(new FlowLayout());
        MyAction myAction = new MyAction();
        if (app) {
            this.print_ = new JButton("Print...");
            this.print_.addActionListener(myAction);
            button.add(this.print_);
        }
        this.tree_ = new JButton("Tree View");
        this.tree_.addActionListener(myAction);
        button.add(this.tree_);
        this.edit_ = new JButton("Edit VectorAttribute");
        this.edit_.addActionListener(myAction);
        button.add(this.edit_);
        if (app) {
            this.space_ = new JButton("Add Mark");
            this.space_.addActionListener(myAction);
            button.add(this.space_);
        }
        return button;
    }

    public static void main(String[] args) {
        JVectorDemo vd = new JVectorDemo();
        JFrame frame = new JFrame("Vector Demo");
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        frame.setSize(600, 400);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }
        });
        JPanel button = vd.makeButtonPanel(true);
        rpl_ = vd.makeGraph();
        rpl_.setBatch(true);
        main.add((Component)rpl_, "Center");
        frame.getContentPane().add((Component)main, "Center");
        frame.getContentPane().add((Component)button, "South");
        frame.pack();
        rpl_.setBatch(false);
        frame.setVisible(true);
    }

    void print_actionPerformed(ActionEvent e) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(rpl_);
        printJob.setJobName("Vector Demo");
        if (printJob.printDialog()) {
            try {
                Color saveColor = rpl_.getBackground();
                if (!saveColor.equals(Color.white)) {
                    rpl_.setBackground(Color.white);
                }
                rpl_.setPageAlign(0, 1);
                RepaintManager currentManager = RepaintManager.currentManager(rpl_);
                currentManager.setDoubleBufferingEnabled(false);
                printJob.print();
                currentManager.setDoubleBufferingEnabled(true);
                rpl_.setBackground(saveColor);
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    void edit_actionPerformed(ActionEvent e) {
        VectorAttributeDialog vad = new VectorAttributeDialog();
        vad.setJPane(rpl_);
        vad.setVectorAttribute(this.vectorAttr_);
        vad.setVisible(true);
    }

    void tree_actionPerformed(ActionEvent e) {
        JClassTree ct = new JClassTree();
        ct.setModal(false);
        ct.setJPane(rpl_);
        ct.setVisible(true);
    }

    JPlotLayout makeGraph() {
        Range2D xr = new Range2D(190.0, 250.0, 3.0);
        Range2D yr = new Range2D(0.0, 45.0, 3.0);
        TestData td = new TestData(5, xr, yr, 3, 20.0f, 10.0f, 5.0f);
        SGTGrid uComp = (SGTGrid)td.getSGTData();
        td = new TestData(5, xr, yr, 3, 20.0f, 0.0f, 3.0f);
        SGTGrid vComp = (SGTGrid)td.getSGTData();
        SGTVector vector = new SGTVector(uComp, vComp);
        JPlotLayout rpl = new JPlotLayout(3, false, false, "test layout", null, false);
        rpl.setEditClasses(false);
        this.vectorAttr_ = new VectorAttribute(0.0075, Color.red);
        this.vectorAttr_.setHeadScale(0.5);
        rpl.addData(vector, (Attribute)this.vectorAttr_, "First Data");
        rpl.setTitles("Vector Plot Demo", "using a JPlotLayout", "");
        rpl.setSize(new Dimension(600, 400));
        return rpl;
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object obj = event.getSource();
            if (obj == JVectorDemo.this.edit_) {
                JVectorDemo.this.edit_actionPerformed(event);
            } else if (obj == JVectorDemo.this.space_) {
                System.out.println("  <<Mark>>");
            } else if (obj == JVectorDemo.this.tree_) {
                JVectorDemo.this.tree_actionPerformed(event);
            } else if (obj == JVectorDemo.this.print_) {
                JVectorDemo.this.print_actionPerformed(event);
            }
        }
    }
}

