/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DataGroupLayer;
import gov.noaa.pmel.sgt.beans.DataHolder;
import gov.noaa.pmel.sgt.beans.DataModel;
import gov.noaa.pmel.sgt.beans.Page;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PanelModel;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.dm.SimplePoint;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.util.SoTDomain;
import gov.noaa.pmel.util.SoTRange;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class MapProjTest {
    private JFrame mframe;
    private Page page_ = new Page();
    private PanelModel panelModel_ = new PanelModel();
    private DataModel dataModel_ = new DataModel();
    private JPanel mapPanel_;
    private SGTLine coastLine_ = null;
    private PanelHolder mapPanelHolder_;
    private DataHolder coastDataHolder_;
    private JButton zoomToButton;
    private JButton resetZoomButton_;
    private JButton lastZoomButton_;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MapProjTest window = new MapProjTest();
                    window.mframe.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public MapProjTest() {
        this.initialize();
        this.createGraphic();
    }

    private void initialize() {
        this.mframe = new JFrame();
        this.mframe.setBounds(100, 100, 710, 670);
        this.mframe.setDefaultCloseOperation(3);
        this.mapPanel_ = new JPanel();
        this.mapPanel_.setBackground(Color.WHITE);
        this.mframe.getContentPane().add((Component)this.mapPanel_, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        this.mframe.getContentPane().add((Component)buttonPanel, "South");
        JButton treeViewButton = new JButton("Tree View");
        treeViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JClassTree ct = new JClassTree();
                ct.setModal(false);
                ct.setJPane(MapProjTest.this.page_.getJPane());
                ct.setVisible(true);
            }
        });
        buttonPanel.add(treeViewButton);
        this.zoomToButton = new JButton("Zoom To TAO");
        this.zoomToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataGroupLayer panel = MapProjTest.this.page_.findPanel(MapProjTest.this.mapPanelHolder_).findLayer(MapProjTest.this.coastDataHolder_);
                SoTRange.Double xRange = new SoTRange.Double(130.0, 290.0, 20.0);
                SoTRange.Double yRange = new SoTRange.Double(-10.0, 14.0, 2.0);
                SoTDomain domain = new SoTDomain(xRange, yRange);
                panel.zoomTo(domain);
            }
        });
        buttonPanel.add(this.zoomToButton);
        this.resetZoomButton_ = new JButton("Reset Zoom");
        this.resetZoomButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapProjTest.this.page_.resetZoom();
            }
        });
        this.lastZoomButton_ = new JButton("Last Zoom");
        this.lastZoomButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapProjTest.this.page_.resetToLastZoom();
            }
        });
        buttonPanel.add(this.lastZoomButton_);
        buttonPanel.add(this.resetZoomButton_);
    }

    private void createGraphic() {
        this.mapPanel_.add((Component)this.page_, "Center");
        this.page_.setDataModel(this.dataModel_);
        try {
            this.panelModel_ = PanelModel.loadFromXML(this.getClass().getResource("MapProjTestPanelModel.xml").openStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.page_.setPanelModel(this.panelModel_);
        this.mapPanelHolder_ = this.panelModel_.findPanelHolder("MapPanel");
        DataGroup mapDataGroup = this.mapPanelHolder_.findDataGroup("MapData");
        this.coastLine_ = this.getCoastLine("finerezcoast.bin", 50200);
        LineAttribute lAttr = new LineAttribute(0, new Color(225, 137, 66));
        this.coastDataHolder_ = this.dataModel_.addData(this.coastLine_, lAttr, this.mapPanelHolder_, mapDataGroup, null);
        Collection TAO = this.readPointCollection("TAO.dat");
        Color markColor = new Color(200, 0, 255);
        PointAttribute pattr = new PointAttribute(44, markColor);
        pattr.setLabelPosition(2);
        Font pfont = new Font("Helvetica", 0, 12);
        pattr.setLabelFont(pfont);
        pattr.setLabelColor(Color.red.darker());
        pattr.setLabelHeightP(0.16);
        pattr.setMarkHeightP(0.16);
        pattr.setDrawLabel(true);
        this.dataModel_.addData(TAO, pattr, this.mapPanelHolder_, mapDataGroup, null);
    }

    public JPanel getMapPanel() {
        return this.mapPanel_;
    }

    Collection readPointCollection(String file) {
        SimplePoint sp = null;
        BufferedReader in = null;
        String line = null;
        Collection pc = new Collection(file);
        InputStream is = this.getClass().getResourceAsStream(file);
        try {
            in = new BufferedReader(new InputStreamReader(is));
            line = in.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (line != null) {
            StringTokenizer st = new StringTokenizer(line, ";");
            String token1 = st.nextToken();
            String token2 = st.nextToken();
            String title = st.nextToken();
            int lat = Integer.parseInt(token1);
            int lon = Integer.parseInt(token2);
            if (lon < 0) {
                lon += 360;
            }
            sp = new SimplePoint(lon %= 360, lat, title);
            pc.addElement(sp);
            try {
                line = in.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return pc;
    }

    SGTLine getCoastLine(String coastFileName, int bufsize) {
        int i;
        if (coastFileName.length() == 0) {
            return null;
        }
        double[] lat = new double[bufsize];
        double[] lon = new double[bufsize];
        int cpt = 0;
        int cpt_save = 0;
        int cut_count = 0;
        InputStream is = this.getClass().getResourceAsStream(coastFileName);
        try {
            int numEntries;
            BufferedInputStream bis = new BufferedInputStream(is, 1000000);
            DataInputStream inData = new DataInputStream(bis);
            while ((numEntries = inData.readShort()) != -1) {
                cpt_save = cpt;
                for (i = 0; i < numEntries; ++i) {
                    lat[cpt] = inData.readDouble();
                    ++cpt;
                }
                cpt = cpt_save;
                for (i = 0; i < numEntries; ++i) {
                    lon[cpt] = (inData.readDouble() + 360.0) % 360.0;
                    if (cpt > 0 && Math.abs(lon[cpt] - lon[cpt - 1]) > 50.0) {
                        ++cut_count;
                    }
                    ++cpt;
                }
                lat[cpt] = Double.NaN;
                lon[cpt] = Double.NaN;
                ++cpt;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(cpt + " points read");
        System.out.println(cut_count + " cuts added");
        int length = cpt;
        double[] latVal = new double[cpt + cut_count];
        double[] lonVal = new double[cpt + cut_count];
        cpt = 0;
        for (i = 0; i < length; ++i) {
            if (i > 0 && Math.abs(lon[i] - lon[i - 1]) > 50.0) {
                latVal[cpt] = Double.NaN;
                lonVal[cpt] = Double.NaN;
                ++cpt;
            }
            latVal[cpt] = lat[i];
            lonVal[cpt] = lon[i];
            ++cpt;
        }
        SimpleLine line = new SimpleLine(lonVal, latVal, "CoastLine");
        SGTMetaData yMeta = new SGTMetaData("Latitude", "degrees_N", false, false);
        SGTMetaData xMeta = new SGTMetaData("Longitude", "degrees_E", false, true);
        line.setXMetaData(xMeta);
        line.setYMetaData(yMeta);
        return line;
    }
}

