/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.SoTRange;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Timer;

public class PseudoRealTimeData
implements SGTLine,
ActionListener {
    private SGTMetaData xMeta_;
    private SGTMetaData yMeta_;
    private SoTRange.GeoDate xRange_;
    private SoTRange.Double yRange_;
    private GeoDate[] xData_;
    private double[] yData_;
    private GeoDate tend_;
    private int count_;
    private String title_;
    private SGLabel keyTitle_ = null;
    private String id_;
    private Timer timer_;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private Graph graph_ = null;
    private GeoDate ref_ = null;
    private int bufsize_ = 241;
    private int offset_;
    private int offsetIncrement_ = 24;
    private boolean dynamic_ = false;
    private double minorIncrement_ = 1.0;
    private double majorIncrement_ = 24.0;
    private int units_ = 5;
    private double A0_ = 1.0;
    private double A1_ = 0.375;
    private double A2_ = 0.2;
    private double omega0_ = 0.251327412;
    private double omega1_ = 0.3;

    public PseudoRealTimeData(String id, String title) {
        this.xMeta_ = new SGTMetaData("Time", "");
        this.yMeta_ = new SGTMetaData("PseudoData", "Ps/day");
        this.title_ = title;
        this.id_ = id;
        this.timer_ = new Timer(250, this);
        this.resetData();
    }

    @Override
    public double[] getXArray() {
        return null;
    }

    @Override
    public double[] getYArray() {
        if (this.count_ > 0) {
            double[] temp = new double[this.count_ + this.offset_];
            for (int i = 0; i < this.count_ + this.offset_; ++i) {
                temp[i] = this.yData_[i];
            }
            return temp;
        }
        return null;
    }

    @Override
    public GeoDate[] getTimeArray() {
        if (this.count_ > 0) {
            GeoDate[] temp = new GeoDate[this.count_ + this.offset_];
            for (int i = 0; i < this.count_ + this.offset_; ++i) {
                temp[i] = this.xData_[i];
            }
            return temp;
        }
        return null;
    }

    @Override
    public GeoDateArray getGeoDateArray() {
        return new GeoDateArray(this.getTimeArray());
    }

    @Override
    public double[] getAssociatedData() {
        return null;
    }

    @Override
    public boolean hasAssociatedData() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    @Override
    public SGLabel getKeyTitle() {
        return this.keyTitle_;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public SGTData copy() {
        return null;
    }

    @Override
    public boolean isXTime() {
        return true;
    }

    @Override
    public boolean isYTime() {
        return false;
    }

    @Override
    public SGTMetaData getXMetaData() {
        return this.xMeta_;
    }

    @Override
    public SGTMetaData getYMetaData() {
        return this.yMeta_;
    }

    @Override
    public SoTRange getXRange() {
        return this.xRange_.copy();
    }

    @Override
    public SoTRange getYRange() {
        return this.yRange_.copy();
    }

    @Override
    public void setGraph(Graph graph) {
        this.graph_ = graph;
    }

    @Override
    public Object getPaneLock() {
        if (this.graph_ == null) {
            return this;
        }
        return this.graph_.getPaneLock();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    public void startData() {
        this.timer_.start();
    }

    public void stopData() {
        this.timer_.stop();
    }

    public void resetData() {
        this.xData_ = new GeoDate[this.bufsize_];
        this.yData_ = new double[this.bufsize_];
        try {
            this.ref_ = new GeoDate("1999-01-01 00:00", "yyyy-MM-dd HH:mm");
        }
        catch (IllegalTimeValue e) {
            e.printStackTrace();
        }
        this.tend_ = new GeoDate(this.ref_);
        this.tend_.increment(10.0, 7);
        this.yRange_ = new SoTRange.Double(-1.5, 1.5);
        this.xRange_ = new SoTRange.GeoDate(new GeoDate(this.ref_), this.tend_.increment(this.majorIncrement_, this.units_));
        this.xData_[0] = new GeoDate(this.ref_);
        this.yData_[0] = 0.0;
        this.count_ = 1;
        this.offset_ = 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.count_ + this.offset_ >= this.bufsize_) {
            this.offset_ -= this.offsetIncrement_;
            for (int i = 0; i < this.bufsize_ - this.offsetIncrement_; ++i) {
                this.xData_[i] = this.xData_[i + this.offsetIncrement_];
                this.yData_[i] = this.yData_[i + this.offsetIncrement_];
            }
            this.xRange_.start = this.xData_[0];
        }
        this.xData_[this.count_ + this.offset_] = new GeoDate(this.ref_.increment(this.minorIncrement_, this.units_));
        this.yData_[this.count_ + this.offset_] = this.tSeries(this.count_);
        if (this.xData_[this.count_ + this.offset_].after(this.tend_)) {
            SoTRange.GeoDate oldRange = (SoTRange.GeoDate)this.xRange_.copy();
            this.tend_.increment(this.majorIncrement_, this.units_);
            this.xRange_.end = this.tend_;
            this.changes_.firePropertyChange("rangeModified", oldRange, this.xRange_);
        } else {
            this.changes_.firePropertyChange("dataModified", new Integer(this.count_), new Integer(this.count_ + 1));
        }
        ++this.count_;
    }

    private double tSeries(int val) {
        return this.A0_ * Math.sin(this.omega0_ * (double)val) + this.A1_ * Math.sin(this.omega1_ * (double)val) + this.A2_ * Math.random();
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic_;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic_ = dynamic;
    }
}

