/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DataModel;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.MouseValue;
import gov.noaa.pmel.sgt.beans.MouseValueEvent;
import gov.noaa.pmel.sgt.beans.MouseValueListener;
import gov.noaa.pmel.sgt.beans.Page;
import gov.noaa.pmel.sgt.beans.PageReSizeHelper;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PanelModel;
import gov.noaa.pmel.sgt.beans.PanelModelEditor;
import gov.noaa.pmel.sgt.demo.AddDataFrame;
import gov.noaa.pmel.sgt.demo.BeanDemoValue;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SimpleGrid;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.ValueIcon;
import gov.noaa.pmel.sgt.swing.ValueIconFormat;
import gov.noaa.pmel.swing.JSystemPropertiesDialog;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.ImageCapabilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

class ResizeAnimaDemoFrame
extends JFrame
implements MouseValueListener {
    private Page page = new Page();
    private PanelModel panelModel = new PanelModel();
    private DataModel dataModel = new DataModel();
    private SimpleGrid grid;
    private Attribute gridAttr;
    private JPanel contentPane;
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu jMenuFile = new JMenu();
    private JMenuItem jMenuFileExit = new JMenuItem();
    private JMenu jMenuHelp = new JMenu();
    private JMenuItem jMenuHelpAbout = new JMenuItem();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JMenu jMenuView = new JMenu();
    private JMenuItem jMenuViewReset = new JMenuItem();
    private JMenuItem jMenuViewTree = new JMenuItem();
    private JMenuItem jMenuViewMouse = new JMenuItem();
    private JPanel pagePanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JMenuItem jMenuHelpProps = new JMenuItem();
    private JMenu jMenuEdit = new JMenu();
    private JMenuItem jMenuEditData = new JMenuItem();
    private JMenuItem jMenuEditPM = new JMenuItem();
    private JMenuItem jMenuFilePrint = new JMenuItem();
    private JMenuItem jMenuFilePage = new JMenuItem();
    private JPanel ratePanel = null;
    private JLabel dataRate = null;
    private JLabel bitBlitRate = null;
    private JLabel drawRate = null;
    private DecimalFormat format = new DecimalFormat("0.0");
    private double frameRate = 0.0;
    private PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
    JMenuItem jMenuEditRemoveAll = new JMenuItem();
    private BeanDemoValue beanValue = null;
    private Anima animaTask;
    private JMenu animaMenu = null;
    private JMenuItem startAnimaMenuItem = null;
    private JMenuItem stopAnimaMenuItem = null;
    private JMenuItem resetAnimaMenuItem = null;
    private JMenu swingMenu = null;
    private JCheckBoxMenuItem swingMenuItem = null;
    private long animationSpeed = 10L;
    private int animationType = 2;
    boolean animationRunning = false;
    private Range2D range1;
    private Range2D range2;
    private int dir;
    private int type;
    private float amp;
    private float off;
    private float per;
    private JMenuItem speedMenuItem = null;
    private JMenuItem typeMenuItem = null;
    private JMenuItem repaintMenuItem = null;
    Timer timer = new Timer("animation timer");

    public ResizeAnimaDemoFrame() {
        this.enableEvents(64L);
        this.page.getJPane().setBackground(Color.lightGray);
        this.page.setName("Animation Demo");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.createGraphic();
        this.pack();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        System.out.println("number of GraphicsDevices: " + gs.length);
        for (int j = 0; j < gs.length; ++j) {
            System.out.println("  Graphic Device: " + gs[j].getIDstring());
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            System.out.println("    number of GraphicsConfigurations: " + gc.length);
            for (int i = 0; i < gc.length; ++i) {
                BufferCapabilities bc = gc[i].getBufferCapabilities();
                ImageCapabilities front = bc.getFrontBufferCapabilities();
                ImageCapabilities back = bc.getBackBufferCapabilities();
                System.out.println("      Color model: " + gc[i].getColorModel().toString());
                System.out.println("      Bounds: " + gc[i].getBounds().toString());
                System.out.println("      Is full screen required: " + bc.isFullScreenRequired());
                System.out.println("      Is MultiBufferAvailable: " + bc.isMultiBufferAvailable());
                System.out.println("      Is PageFlipping: " + bc.isPageFlipping());
                System.out.println("      Back is Accelerated: " + back.isAccelerated());
                System.out.println("      Back is true volatile: " + back.isTrueVolatile());
                System.out.println("      Front is Accelerated: " + front.isAccelerated());
                System.out.println("      Front is true volatile: " + front.isTrueVolatile());
            }
        }
        Timer refresh = new Timer("Refresh Footer");
        refresh.schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ResizeAnimaDemoFrame.this.dataRate.setText("Data: " + ResizeAnimaDemoFrame.this.format.format(ResizeAnimaDemoFrame.this.frameRate));
                        ResizeAnimaDemoFrame.this.bitBlitRate.setText("Blit: " + ResizeAnimaDemoFrame.this.format.format(ResizeAnimaDemoFrame.this.page.getJPane().getBitBlitRate()));
                        ResizeAnimaDemoFrame.this.drawRate.setText("Draw: " + ResizeAnimaDemoFrame.this.format.format(ResizeAnimaDemoFrame.this.page.getJPane().getDrawRate()));
                    }
                });
            }
        }, 100L, 100L);
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setTitle("SGT Animation Demo");
        this.setSize(new Dimension(276, 145));
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeAnimaDemoFrame.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeAnimaDemoFrame.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        this.jMenuView.setText("View");
        this.jMenuViewReset.setText("Reset All Zoom");
        this.jMenuViewReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeAnimaDemoFrame.this.jMenuViewReset_actionPerformed(e);
            }
        });
        this.jMenuViewTree.setText("Class Tree...");
        this.jMenuViewTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeAnimaDemoFrame.this.jMenuViewTree_actionPerformed(e);
            }
        });
        this.jMenuViewMouse.setText("Mouse Values...");
        this.jMenuViewMouse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeAnimaDemoFrame.this.jMenuViewMouse_actionPerformed(e);
            }
        });
        this.pagePanel.setLayout(this.borderLayout2);
        this.jMenuHelpProps.setText("System Properties...");
        this.jMenuHelpProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeAnimaDemoFrame.this.jMenuHelpProps_actionPerformed(e);
            }
        });
        this.jMenuEdit.setText("Edit");
        this.jMenuEditData.setText("Add Data...");
        this.jMenuEditData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeAnimaDemoFrame.this.jMenuEditData_actionPerformed(e);
            }
        });
        this.jMenuEditPM.setText("PanelModel");
        this.jMenuEditPM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeAnimaDemoFrame.this.jMenuEditPM_actionPerformed(e);
            }
        });
        this.jMenuFilePrint.setText("Print...");
        this.jMenuFilePrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeAnimaDemoFrame.this.jMenuFilePrint_actionPerformed(e);
            }
        });
        this.jMenuFilePage.setText("Page Layout...");
        this.jMenuFilePage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeAnimaDemoFrame.this.jMenuFilePage_actionPerformed(e);
            }
        });
        this.jMenuEditRemoveAll.setText("Remove All Data");
        this.jMenuEditRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeAnimaDemoFrame.this.jMenuEditRemoveAll_actionPerformed(e);
            }
        });
        this.jMenuFile.add(this.jMenuFilePage);
        this.jMenuFile.add(this.jMenuFilePrint);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpProps);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuEdit);
        this.jMenuBar1.add(this.jMenuView);
        this.jMenuBar1.add(this.getAnimaMenu());
        this.jMenuBar1.add(this.getSwingMenu());
        this.jMenuBar1.add(this.jMenuHelp);
        this.jMenuView.add(this.jMenuViewMouse);
        this.jMenuView.add(this.jMenuViewReset);
        this.jMenuView.add(this.jMenuViewTree);
        this.contentPane.add((Component)this.pagePanel, "Center");
        this.contentPane.add((Component)this.getRatePanel(), "South");
        this.jMenuEdit.add(this.jMenuEditData);
        this.jMenuEdit.add(this.jMenuEditPM);
        this.jMenuEdit.addSeparator();
        this.jMenuEdit.add(this.jMenuEditRemoveAll);
        this.setJMenuBar(this.jMenuBar1);
    }

    private void jMenuFileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    private void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(this, "ResizeBeanDemo: SGT version 3.6", "About ResizeBeanDemo", 1);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    private void createGraphic() {
        this.pagePanel.add((Component)this.page, "Center");
        this.page.setDataModel(this.dataModel);
        try {
            this.panelModel = PanelModel.loadFromXML(this.getClass().getResource("ResizeAnimaDemoPanelModel.xml").openStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.page.setPanelModel(this.panelModel);
        PanelHolder ul = this.panelModel.findPanelHolder("UpperLeft");
        DataGroup uldg = ul.findDataGroup("Grid");
        Legend ullg = ul.findLegend("ColorKey");
        this.createGrid();
        this.dataModel.addData(this.grid, this.gridAttr, ul, uldg, ullg);
        this.addIcons();
        new PageReSizeHelper(this.page, true, true, false);
    }

    void createGrid() {
        int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] green = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.dir = 5;
        this.type = 1;
        double min1 = 160.0;
        double max1 = 260.0;
        double delta1 = 2.0;
        this.range1 = new Range2D(min1, max1, delta1);
        double min2 = -50.0;
        double max2 = 50.0;
        double delta2 = 2.0;
        this.range2 = new Range2D(min2, max2, delta2);
        this.amp = 0.5f;
        this.off = 0.5f;
        this.per = 20.0f;
        TestData td = new TestData(this.dir, this.range1, this.range2, this.type, this.amp, this.off, this.per);
        this.grid = (SimpleGrid)td.getSGTData();
        IndexedColorMap cmap = new IndexedColorMap(red, green, blue);
        LinearTransform ctrans = new LinearTransform(0.0, (double)red.length, 0.0, 1.0);
        cmap.setTransform(ctrans);
        this.gridAttr = new GridAttribute(0, cmap);
        ContourLevels cl = ContourLevels.getDefault(Graph.computeRange(new Range2D(-1.5, 1.5), 40));
        this.gridAttr = new GridAttribute(cl);
    }

    private void addIcons() {
        ValueIconFormat viFrmt_ = new ValueIconFormat("###.##", "###.##");
        ValueIcon vi = new ValueIcon(this.getClass().getResource("query.gif"), "value");
        vi.setValueFormat(viFrmt_);
        this.page.getJPane().getFirstLayer().addChild(vi);
        vi.setId("local query");
        try {
            vi.setLocationU(new SoTPoint(170.0, 40.0));
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        vi.setVisible(true);
    }

    void jMenuViewReset_actionPerformed(ActionEvent e) {
        this.page.resetZoom();
    }

    void jMenuViewTree_actionPerformed(ActionEvent e) {
        JClassTree ct = new JClassTree();
        ct.setModal(false);
        ct.setJPane(this.page.getJPane());
        ct.setVisible(true);
    }

    void jMenuViewMouse_actionPerformed(ActionEvent e) {
        this.beanValue = new BeanDemoValue("Values at Mouse");
        this.beanValue.setVisible(true);
        this.page.addMouseValueListener(this);
    }

    void jMenuEditData_actionPerformed(ActionEvent e) {
        AddDataFrame adf = new AddDataFrame(this.page);
        adf.setVisible(true);
    }

    void jMenuEditPM_actionPerformed(ActionEvent e) {
        PanelModelEditor pme = new PanelModelEditor(this.panelModel);
        pme.setVisible(true);
    }

    void jMenuHelpProps_actionPerformed(ActionEvent e) {
        JSystemPropertiesDialog sysProps = new JSystemPropertiesDialog(this, "System Properties", false);
        sysProps.setVisible(true);
    }

    void jMenuFilePrint_actionPerformed(ActionEvent e) {
        JPane pane = this.page.getJPane();
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this.page, this.pageFormat);
        printJob.setJobName("BeanDemo");
        if (printJob.printDialog()) {
            try {
                RepaintManager currentManager = RepaintManager.currentManager(pane);
                currentManager.setDoubleBufferingEnabled(false);
                printJob.print();
                currentManager.setDoubleBufferingEnabled(true);
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    void jMenuFilePage_actionPerformed(ActionEvent e) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        this.pageFormat = pj.pageDialog(this.pageFormat);
    }

    void jMenuEditRemoveAll_actionPerformed(ActionEvent e) {
        this.page.getDataModel().removeAllData();
    }

    @Override
    public void mouseValue(MouseValueEvent event) {
        MouseValue[] mv = event.getMouseValue();
        for (int i = 0; i < mv.length; ++i) {
            if (this.beanValue == null) continue;
            this.beanValue.setMouseValue(mv[0]);
        }
    }

    private JMenu getAnimaMenu() {
        if (this.animaMenu == null) {
            this.animaMenu = new JMenu();
            this.animaMenu.setText("Animation");
            this.animaMenu.add(this.getSpeedMenuItem());
            this.animaMenu.add(this.getTypeMenuItem());
            this.animaMenu.addSeparator();
            this.animaMenu.add(this.getStartAnimaMenuItem());
            this.animaMenu.add(this.getStopAnimaMenuItem());
            this.animaMenu.add(this.getResetAnimaMenuItem());
            this.animaMenu.addSeparator();
            this.animaMenu.add(this.getRepaintMenuItem());
        }
        return this.animaMenu;
    }

    private void start() {
        if (this.animaTask != null) {
            this.animaTask.cancel();
        }
        switch (this.animationType) {
            case 0: {
                this.animaTask = new Anima(0, this.dir, this.range1, this.range2, this.type, this.amp, this.off, this.per, 1.0f, 0.0f, 20.0f);
                break;
            }
            default: {
                this.animaTask = new Anima(2, this.dir, this.range1, this.range2, this.type, this.amp, this.off, this.per, 15.0f, 0.0f, 20.0f);
            }
        }
        this.timer.schedule((TimerTask)this.animaTask, 10L, this.animationSpeed);
        this.animationRunning = true;
    }

    private void stop() {
        if (this.animaTask != null) {
            this.animaTask.cancel();
            this.animationRunning = false;
        }
        System.gc();
        this.animaTask = null;
    }

    private JMenuItem getStartAnimaMenuItem() {
        if (this.startAnimaMenuItem == null) {
            this.startAnimaMenuItem = new JMenuItem();
            this.startAnimaMenuItem.setText("Start");
            this.startAnimaMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResizeAnimaDemoFrame.this.start();
                }
            });
        }
        return this.startAnimaMenuItem;
    }

    private JMenuItem getStopAnimaMenuItem() {
        if (this.stopAnimaMenuItem == null) {
            this.stopAnimaMenuItem = new JMenuItem();
            this.stopAnimaMenuItem.setText("Stop");
            this.stopAnimaMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResizeAnimaDemoFrame.this.stop();
                }
            });
        }
        return this.stopAnimaMenuItem;
    }

    private JMenuItem getResetAnimaMenuItem() {
        if (this.resetAnimaMenuItem == null) {
            this.resetAnimaMenuItem = new JMenuItem();
            this.resetAnimaMenuItem.setText("Reset");
            this.resetAnimaMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ResizeAnimaDemoFrame.this.animaTask != null) {
                        ResizeAnimaDemoFrame.this.stop();
                    }
                    TestData td = new TestData(ResizeAnimaDemoFrame.this.dir, ResizeAnimaDemoFrame.this.range1, ResizeAnimaDemoFrame.this.range2, ResizeAnimaDemoFrame.this.type, ResizeAnimaDemoFrame.this.amp, ResizeAnimaDemoFrame.this.off, ResizeAnimaDemoFrame.this.per);
                    ResizeAnimaDemoFrame.this.grid.setZArray(((SimpleGrid)td.getSGTData()).getZArray());
                }
            });
        }
        return this.resetAnimaMenuItem;
    }

    private JMenu getSwingMenu() {
        if (this.swingMenu == null) {
            this.swingMenu = new JMenu();
            this.swingMenu.setText("Swing");
            this.swingMenu.add(this.getSwingMenuItem());
        }
        return this.swingMenu;
    }

    private JCheckBoxMenuItem getSwingMenuItem() {
        if (this.swingMenuItem == null) {
            this.swingMenuItem = new JCheckBoxMenuItem();
            this.swingMenuItem.setSelected(false);
            this.swingMenuItem.setText("Update data in Swing thread");
        }
        return this.swingMenuItem;
    }

    private JMenuItem getSpeedMenuItem() {
        if (this.speedMenuItem == null) {
            this.speedMenuItem = new JMenuItem();
            this.speedMenuItem.setText("Speed...");
            this.speedMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = JOptionPane.showInputDialog(ResizeAnimaDemoFrame.this.contentPane, "Animation Delay in milliseconds", Long.toString(ResizeAnimaDemoFrame.this.animationSpeed));
                    if (value != null && value.trim().length() != 0) {
                        boolean saveRunning = ResizeAnimaDemoFrame.this.animationRunning;
                        if (ResizeAnimaDemoFrame.this.animationRunning) {
                            ResizeAnimaDemoFrame.this.stop();
                        }
                        ResizeAnimaDemoFrame.this.animationSpeed = Long.parseLong(value.trim());
                        if (ResizeAnimaDemoFrame.this.animationSpeed == 0L) {
                            ResizeAnimaDemoFrame.this.animationSpeed = 1L;
                        }
                        if (saveRunning) {
                            ResizeAnimaDemoFrame.this.start();
                        }
                    }
                }
            });
        }
        return this.speedMenuItem;
    }

    private JMenuItem getTypeMenuItem() {
        if (this.typeMenuItem == null) {
            this.typeMenuItem = new JMenuItem();
            this.typeMenuItem.setText("Type...");
            this.typeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] options = new String[]{"Vary Amplitude", "Vary Period"};
                    Object value = JOptionPane.showInputDialog(ResizeAnimaDemoFrame.this.contentPane, "Animation Type", "Select Animation Type", 2, null, options, options[1]);
                    if (value != null) {
                        boolean saveRunning = ResizeAnimaDemoFrame.this.animationRunning;
                        if (ResizeAnimaDemoFrame.this.animationRunning) {
                            ResizeAnimaDemoFrame.this.stop();
                        }
                        if (value.equals(options[0])) {
                            ResizeAnimaDemoFrame.this.animationType = 0;
                        } else {
                            ResizeAnimaDemoFrame.this.animationType = 2;
                        }
                        if (saveRunning) {
                            ResizeAnimaDemoFrame.this.start();
                        }
                    }
                }
            });
        }
        return this.typeMenuItem;
    }

    private JMenuItem getRepaintMenuItem() {
        if (this.repaintMenuItem == null) {
            this.repaintMenuItem = new JMenuItem();
            this.repaintMenuItem.setText("Repaint");
            this.repaintMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResizeAnimaDemoFrame.this.page.getJPane().repaint();
                }
            });
        }
        return this.repaintMenuItem;
    }

    private JPanel getRatePanel() {
        if (this.ratePanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            gridLayout.setVgap(5);
            gridLayout.setHgap(5);
            gridLayout.setColumns(3);
            this.ratePanel = new JPanel();
            this.ratePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.bitBlitRate = new JLabel("FPS");
            this.dataRate = new JLabel("Data:");
            this.drawRate = new JLabel("Draw:");
            this.ratePanel.setLayout(gridLayout);
            this.ratePanel.add((Component)this.bitBlitRate, null);
            this.ratePanel.add((Component)this.drawRate, null);
            this.ratePanel.add((Component)this.dataRate, null);
        }
        return this.ratePanel;
    }

    class Anima
    extends TimerTask {
        static final int AMP = 0;
        static final int OFF = 1;
        static final int PER = 2;
        int atype;
        int dir;
        int type;
        Range2D range1 = null;
        Range2D range2 = null;
        float amp;
        float off;
        float per;
        float deltaAmp;
        float deltaOff;
        float deltaPer;
        int counter = 0;
        long lastTime = 0L;
        double[] buffer1 = null;
        double[] buffer2 = null;
        int num1;
        int num2;
        double[] axis1;
        double[] axis2;
        float rAmp = 0.0f;
        float rOff = 0.0f;
        float rPer = 0.0f;
        double[] newdata;
        long delta;

        public Anima(int aType, int dir, Range2D range1, Range2D range2, int type, float amp, float off, float per, float deltaAmp, float deltaOff, float deltaPer) {
            int count;
            this.dir = dir;
            this.range1 = range1;
            this.range2 = range2;
            this.type = type;
            this.amp = amp;
            this.off = off;
            this.per = per;
            this.deltaAmp = deltaAmp;
            this.deltaOff = deltaOff;
            this.deltaPer = deltaPer;
            this.atype = aType;
            this.buffer1 = new double[ResizeAnimaDemoFrame.this.grid.getZArray().length];
            this.buffer2 = new double[ResizeAnimaDemoFrame.this.grid.getZArray().length];
            this.num1 = (int)((range1.end - range1.start) / range1.delta) + 1;
            this.axis1 = new double[this.num1];
            this.num2 = (int)((range2.end - range2.start) / range2.delta) + 1;
            this.axis2 = new double[this.num2];
            for (count = 0; count < this.num1; ++count) {
                this.axis1[count] = range1.start + (double)count * range1.delta;
            }
            for (count = 0; count < this.num2; ++count) {
                this.axis2[count] = range2.start + (double)count * range2.delta;
            }
        }

        @Override
        public void run() {
            switch (this.atype) {
                default: {
                    this.rAmp = this.amp + this.deltaAmp * (float)Math.sin((float)this.counter++ / this.deltaPer) + this.deltaOff;
                    this.rOff = this.off;
                    this.rPer = this.per;
                    break;
                }
                case 1: {
                    this.rAmp = this.amp;
                    this.rOff = this.off + this.deltaAmp * (float)Math.sin((float)this.counter++ / this.deltaPer) + this.deltaOff;
                    this.rPer = this.per;
                    break;
                }
                case 2: {
                    this.rAmp = this.amp;
                    this.rOff = this.off;
                    this.rPer = this.per + this.deltaAmp * (float)Math.sin((float)this.counter++ / this.deltaPer) + this.deltaOff;
                }
            }
            if (this.counter % 2 == 0) {
                this.buffer1 = this.getValues(this.buffer1, this.axis1, this.num1, this.axis2, this.num2, this.rAmp, this.rOff, this.rPer);
                this.newdata = this.buffer1;
            } else {
                this.buffer2 = this.getValues(this.buffer2, this.axis1, this.num1, this.axis2, this.num2, this.rAmp, this.rOff, this.rPer);
                this.newdata = this.buffer2;
            }
            if (ResizeAnimaDemoFrame.this.swingMenuItem.isSelected()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ResizeAnimaDemoFrame.this.grid.setZArray(Anima.this.newdata);
                    }
                });
            } else {
                ResizeAnimaDemoFrame.this.grid.setZArray(this.newdata);
            }
            this.delta = System.currentTimeMillis() - this.lastTime;
            this.lastTime = System.currentTimeMillis();
            ResizeAnimaDemoFrame.this.frameRate = 1.0 / ((double)this.delta / 1000.0);
        }

        private double[] getValues(double[] values, double[] axis1, int num1, double[] axis2, int num2, float amp, float off, float per) {
            int count = 0;
            for (int count1 = 0; count1 < num1; ++count1) {
                for (int count2 = 0; count2 < num2; ++count2) {
                    values[count] = (double)amp * Math.sin(axis1[count1] / (double)per) * Math.sin(axis2[count2] / (double)per) + (double)off;
                    ++count;
                }
            }
            return values;
        }
    }
}

