/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.PointCartesianRenderer;
import gov.noaa.pmel.sgt.PointCollectionKey;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.dm.SimplePoint;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.ValueIcon;
import gov.noaa.pmel.sgt.swing.ValueIconFormat;
import gov.noaa.pmel.sgt.swing.prop.PointAttributeDialog;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TAOMap
extends JApplet
implements PropertyChangeListener {
    JButton tree_;
    JButton space_ = null;
    JButton reset_;
    JPane mainPane_;
    SGTLine coastLine_ = null;
    CartesianGraph graph_;
    LinearTransform xt_;
    LinearTransform yt_;
    Layer layer_;
    PlainAxis xbot_;
    PlainAxis yleft_;
    Range2D xrange_;
    Range2D yrange_;
    PointAttributeDialog pAttrDialog_ = null;

    @Override
    public void init() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(553, 438);
        JPane graph = this.makeGraph();
        graph.setBatch(true);
        this.getContentPane().add((Component)graph, "Center");
        this.getContentPane().add((Component)this.makeButtonPanel(false), "South");
        this.addValueIcon();
        graph.setBatch(false);
    }

    JPanel makeButtonPanel(boolean mark) {
        JPanel button = new JPanel();
        button.setLayout(new FlowLayout());
        this.tree_ = new JButton("Tree View");
        MyAction myAction = new MyAction();
        this.tree_.addActionListener(myAction);
        button.add(this.tree_);
        if (mark) {
            this.space_ = new JButton("Add Mark");
            this.space_.addActionListener(myAction);
            button.add(this.space_);
        }
        this.reset_ = new JButton("Reset Zoom");
        this.reset_.addActionListener(myAction);
        button.add(this.reset_);
        return button;
    }

    public static void main(String[] args) {
        TAOMap pd = new TAOMap();
        JFrame frame = new JFrame("TAO Mooring Map");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }
        });
        frame.setSize(553, 438);
        JPane graph = pd.makeGraph();
        JPanel button = pd.makeButtonPanel(true);
        graph.setBatch(true);
        frame.getContentPane().add((Component)graph, "Center");
        frame.getContentPane().add((Component)button, "South");
        frame.pack();
        frame.setVisible(true);
        pd.addValueIcon();
        graph.setBatch(false);
    }

    JPane makeGraph() {
        this.coastLine_ = this.getCoastLine("finerezcoast.bin", 50200);
        this.mainPane_ = new JPane("Point Plot Demo", new Dimension(553, 438));
        this.mainPane_.setLayout(new StackedLayout());
        this.mainPane_.setBackground(Color.white);
        Collection TAO = this.readPointCollection("TAO.dat");
        Collection TRITON = this.readPointCollection("TRITON.dat");
        this.xrange_ = new Range2D(130.0, 270.0, 20.0);
        this.yrange_ = new Range2D(-10.0, 14.0, 2.0);
        double xsize = 4.0;
        double xstart = 0.45;
        double xend = 3.75;
        double ysize = 3.0;
        double ystart = 0.45;
        double yend = 2.95;
        this.xt_ = new LinearTransform(xstart, xend, this.xrange_.start, this.xrange_.end);
        this.yt_ = new LinearTransform(ystart, yend, this.yrange_.start, this.yrange_.end);
        if (this.coastLine_ != null) {
            Layer layer = new Layer("CoastLine", new Dimension2D(xsize, ysize));
            this.mainPane_.add(layer);
            CartesianGraph cstgraph = new CartesianGraph("CoastLine Graph");
            layer.setGraph(cstgraph);
            cstgraph.setXTransform(this.xt_);
            cstgraph.setYTransform(this.yt_);
            LineAttribute lattr = new LineAttribute();
            lattr.setColor(new Color(165, 42, 42));
            cstgraph.setData(this.coastLine_, lattr);
            cstgraph.setClip(this.xrange_.start, this.xrange_.end, this.yrange_.start, this.yrange_.end);
            cstgraph.setClipping(true);
        }
        this.layer_ = new Layer("Layer 1", new Dimension2D(xsize, ysize));
        this.mainPane_.add(this.layer_);
        this.graph_ = new CartesianGraph("Point Graph");
        this.layer_.setGraph(this.graph_);
        this.graph_.setXTransform(this.xt_);
        this.graph_.setYTransform(this.yt_);
        String xLabel = "Longitude";
        this.xbot_ = new PlainAxis("Botton Axis");
        this.xbot_.setRangeU(this.xrange_);
        this.xbot_.setLocationU(new Point2D.Double(this.xrange_.start, this.yrange_.start));
        Font xbfont = new Font("Helvetica", 2, 14);
        this.xbot_.setLabelFont(xbfont);
        SGLabel xtitle = new SGLabel("xaxis title", xLabel, new Point2D.Double(0.0, 0.0));
        Font xtfont = new Font("Helvetica", 0, 14);
        xtitle.setFont(xtfont);
        xtitle.setHeightP(0.2);
        this.xbot_.setTitle(xtitle);
        this.graph_.addXAxis(this.xbot_);
        String yLabel = "Latitude";
        this.yleft_ = new PlainAxis("Left Axis");
        this.yleft_.setRangeU(this.yrange_);
        this.yleft_.setLocationU(new Point2D.Double(this.xrange_.start, this.yrange_.start));
        this.yleft_.setLabelFont(xbfont);
        SGLabel ytitle = new SGLabel("yaxis title", yLabel, new Point2D.Double(0.0, 0.0));
        Font ytfont = new Font("Helvetica", 0, 14);
        ytitle.setFont(ytfont);
        ytitle.setHeightP(0.2);
        this.yleft_.setTitle(ytitle);
        this.graph_.addYAxis(this.yleft_);
        PointCollectionKey key = new PointCollectionKey();
        key.setId("Mooring Key");
        key.setVAlign(0);
        key.setHAlign(0);
        key.setBorderStyle(0);
        key.setLocationP(new Point2D.Double(xstart + 0.1, yend));
        this.layer_.addChild(key);
        Color markColor = new Color(200, 0, 255);
        PointAttribute pattr = new PointAttribute(44, markColor);
        pattr.setLabelPosition(2);
        Font pfont = new Font("Helvetica", 0, 12);
        pattr.setLabelFont(pfont);
        pattr.setLabelColor(Color.red.darker());
        pattr.setLabelHeightP(0.08);
        pattr.setDrawLabel(true);
        this.graph_.setData(TAO, pattr);
        SGLabel pointTitle = new SGLabel("TAO title", "TAO Moorings", new Point2D.Double(0.0, 0.0));
        pointTitle.setHeightP(0.16);
        key.addPointGraph((PointCartesianRenderer)this.graph_.getRenderer(), pointTitle);
        Layer layer2 = new Layer("Layer 2", new Dimension2D(xsize, ysize));
        this.mainPane_.add(layer2);
        CartesianGraph graph2 = new CartesianGraph("Point Graph2");
        layer2.setGraph(graph2);
        graph2.setXTransform(this.xt_);
        graph2.setYTransform(this.yt_);
        PointAttribute pattr2 = new PointAttribute(13, markColor);
        pattr2.setLabelPosition(2);
        pattr2.setLabelFont(pfont);
        pattr2.setLabelColor(Color.blue.darker());
        pattr2.setLabelHeightP(0.08);
        pattr2.setDrawLabel(true);
        graph2.setData(TRITON, pattr2);
        SGLabel pointTitle2 = new SGLabel("TRITON title", "TRITON Moorings", new Point2D.Double(0.0, 0.0));
        pointTitle2.setHeightP(0.16);
        key.addPointGraph((PointCartesianRenderer)graph2.getRenderer(), pointTitle2);
        this.mainPane_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.mainPane_));
        return this.mainPane_;
    }

    private void addValueIcon() {
        ValueIcon vi = new ValueIcon(this.getClass().getResource("query.gif"), "value");
        this.layer_.addChild(vi);
        vi.setId("local query");
        try {
            vi.setLocationU(new SoTPoint(220.0, -5.0));
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        vi.setVisible(true);
        vi.setSelectable(true);
        vi.setValueFormat(new GeoFormat());
    }

    void tree_actionPerformed(ActionEvent e) {
        JClassTree ct = new JClassTree();
        ct.setModal(false);
        ct.setJPane(this.mainPane_);
        ct.setVisible(true);
    }

    Collection readPointCollection(String file) {
        SimplePoint sp = null;
        BufferedReader in = null;
        String line = null;
        Collection pc = new Collection(file);
        InputStream is = this.getClass().getResourceAsStream(file);
        try {
            in = new BufferedReader(new InputStreamReader(is));
            line = in.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (line != null) {
            StringTokenizer st = new StringTokenizer(line, ";");
            String token1 = st.nextToken();
            String token2 = st.nextToken();
            String title = st.nextToken();
            int lat = Integer.parseInt(token1);
            int lon = Integer.parseInt(token2);
            if (lon < 0) {
                lon += 360;
            }
            sp = new SimplePoint(lon %= 360, lat, title);
            pc.addElement(sp);
            try {
                line = in.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return pc;
    }

    SGTLine getCoastLine(String coastFileName, int bufsize) {
        int i;
        if (coastFileName.length() == 0) {
            return null;
        }
        double[] lat = new double[bufsize];
        double[] lon = new double[bufsize];
        int cpt = 0;
        int cpt_save = 0;
        int cut_count = 0;
        InputStream is = this.getClass().getResourceAsStream(coastFileName);
        try {
            int numEntries;
            BufferedInputStream bis = new BufferedInputStream(is, 1000000);
            DataInputStream inData = new DataInputStream(bis);
            while ((numEntries = inData.readShort()) != -1) {
                cpt_save = cpt;
                for (i = 0; i < numEntries; ++i) {
                    lat[cpt] = inData.readDouble();
                    ++cpt;
                }
                cpt = cpt_save;
                for (i = 0; i < numEntries; ++i) {
                    lon[cpt] = (inData.readDouble() + 360.0) % 360.0;
                    if (cpt > 0 && Math.abs(lon[cpt] - lon[cpt - 1]) > 50.0) {
                        ++cut_count;
                    }
                    ++cpt;
                }
                lat[cpt] = Double.NaN;
                lon[cpt] = Double.NaN;
                ++cpt;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(cpt + " points read");
        System.out.println(cut_count + " cuts added");
        int length = cpt;
        double[] latVal = new double[cpt + cut_count];
        double[] lonVal = new double[cpt + cut_count];
        cpt = 0;
        for (i = 0; i < length; ++i) {
            if (i > 0 && Math.abs(lon[i] - lon[i - 1]) > 50.0) {
                latVal[cpt] = Double.NaN;
                lonVal[cpt] = Double.NaN;
                ++cpt;
            }
            latVal[cpt] = lat[i];
            lonVal[cpt] = lon[i];
            ++cpt;
        }
        SimpleLine line = new SimpleLine(lonVal, latVal, "CoastLine");
        SGTMetaData yMeta = new SGTMetaData("Latitude", "degrees_N", false, false);
        SGTMetaData xMeta = new SGTMetaData("Longitude", "degrees_E", false, true);
        line.setXMetaData(xMeta);
        line.setYMetaData(yMeta);
        return line;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if (name.equals("zoomRectangle")) {
            double temp;
            Range2D xr = new Range2D();
            Range2D yr = new Range2D();
            Rectangle zm = (Rectangle)event.getNewValue();
            if (zm.width <= 1 || zm.height <= 1) {
                return;
            }
            xr.start = this.graph_.getXPtoU(this.layer_.getXDtoP(zm.x));
            xr.end = this.graph_.getXPtoU(this.layer_.getXDtoP(zm.x + zm.width));
            if (xr.start > xr.end) {
                temp = xr.start;
                xr.start = xr.end;
                xr.end = temp;
            }
            yr.start = this.graph_.getYPtoU(this.layer_.getYDtoP(zm.y));
            yr.end = this.graph_.getYPtoU(this.layer_.getYDtoP(zm.y + zm.height));
            if (yr.start > yr.end) {
                temp = yr.start;
                yr.start = yr.end;
                yr.end = temp;
            }
            this.mainPane_.setBatch(true);
            this.xt_.setRangeU(xr);
            this.yt_.setRangeU(yr);
            Point2D.Double orig = new Point2D.Double(xr.start, yr.start);
            this.xbot_.setRangeU(xr);
            this.xbot_.setLocationU(orig);
            this.yleft_.setRangeU(yr);
            this.yleft_.setLocationU(orig);
            Component[] comps = this.mainPane_.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof Layer)) continue;
                Layer ly = (Layer)comps[i];
                ((CartesianGraph)ly.getGraph()).setClip(xr.start, xr.end, yr.start, yr.end);
            }
            this.mainPane_.setBatch(false);
        } else if (name.equals("objectSelected")) {
            if (event.getNewValue() instanceof PointCartesianRenderer) {
                PointAttribute pattr = ((PointCartesianRenderer)event.getNewValue()).getPointAttribute();
                if (this.pAttrDialog_ == null) {
                    this.pAttrDialog_ = new PointAttributeDialog();
                }
                this.pAttrDialog_.setPointAttribute(pattr, this.mainPane_);
                this.pAttrDialog_.setVisible(true);
            } else {
                System.out.println("objectSelected = " + event.getNewValue());
            }
        }
    }

    void reset_actionPerformed(ActionEvent e) {
        this.mainPane_.setBatch(true);
        Component[] comps = this.mainPane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Layer)) continue;
            Layer ly = (Layer)comps[i];
            if (ly.getId().equals("CoastLine")) {
                ((CartesianGraph)ly.getGraph()).setClip(this.xrange_.start, this.xrange_.end, this.yrange_.start, this.yrange_.end);
                continue;
            }
            ((CartesianGraph)ly.getGraph()).setClipping(false);
        }
        this.xt_.setRangeU(this.xrange_);
        this.yt_.setRangeU(this.yrange_);
        Point2D.Double orig = new Point2D.Double(this.xrange_.start, this.yrange_.start);
        this.xbot_.setRangeU(this.xrange_);
        this.xbot_.setLocationU(orig);
        this.yleft_.setRangeU(this.yrange_);
        this.yleft_.setLocationU(orig);
        this.mainPane_.setBatch(false);
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object obj = event.getSource();
            if (obj == TAOMap.this.space_) {
                System.out.println("  <<Mark>>");
            }
            if (obj == TAOMap.this.tree_) {
                TAOMap.this.tree_actionPerformed(event);
            }
            if (obj == TAOMap.this.reset_) {
                TAOMap.this.reset_actionPerformed(event);
            }
        }
    }

    class GeoFormat
    extends ValueIconFormat {
        public GeoFormat() {
            super("#####.##;#####.##W", "#####.##N;#####.##S");
            this.xfrm_.setPositiveSuffix("E");
        }

        @Override
        public String format(double x, double y) {
            if (x > 180.0) {
                x -= 360.0;
            }
            return "(" + this.xfrm_.format(x) + ", " + this.yfrm_.format(y) + ")";
        }
    }
}

