/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.contour.ZGrid;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.JPlotLayout;
import gov.noaa.pmel.sgt.swing.prop.GridAttributeDialog;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

public class ZGridDemo
extends JApplet {
    static JPlotLayout rpl_;
    private GridAttribute gridAttr_;
    JButton edit_;
    JButton space_ = null;
    JButton tree_;
    JButton print_;
    JButton layout_;
    PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
    private double[] xp_ = null;
    private double[] yp_ = null;
    private double[] zp_ = null;

    @Override
    public void init() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setBackground(Color.white);
        this.setSize(600, 550);
        JPanel main = new JPanel();
        rpl_ = this.makeGraph();
        JPanel button = this.makeButtonPanel(false);
        rpl_.setBatch(true);
        main.add((Component)rpl_, "Center");
        JPane gridKeyPane = rpl_.getKeyPane();
        gridKeyPane.setSize(new Dimension(600, 100));
        main.add((Component)gridKeyPane, "South");
        this.getContentPane().add((Component)main, "Center");
        this.getContentPane().add((Component)button, "South");
        rpl_.setBatch(false);
    }

    JPanel makeButtonPanel(boolean mark) {
        MyAction myAction = new MyAction();
        JPanel button = new JPanel();
        button.setLayout(new FlowLayout());
        this.print_ = new JButton("Print...");
        this.print_.addActionListener(myAction);
        button.add(this.print_);
        this.layout_ = new JButton("Page Layout...");
        this.layout_.addActionListener(myAction);
        button.add(this.layout_);
        this.tree_ = new JButton("Tree View");
        this.tree_.addActionListener(myAction);
        button.add(this.tree_);
        this.edit_ = new JButton("Edit GridAttribute");
        this.edit_.addActionListener(myAction);
        button.add(this.edit_);
        if (mark) {
            this.space_ = new JButton("Add Mark");
            this.space_.addActionListener(myAction);
            button.add(this.space_);
        }
        return button;
    }

    public static void main(String[] args) {
        ZGridDemo gd = new ZGridDemo();
        JFrame frame = new JFrame("ZGrid Demo");
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        frame.setSize(600, 500);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }

            @Override
            public void windowOpened(WindowEvent event) {
                rpl_.getKeyPane().repaint();
            }
        });
        JPanel button = gd.makeButtonPanel(true);
        rpl_ = gd.makeGraph();
        rpl_.setBatch(true);
        main.add((Component)rpl_, "Center");
        JPane gridKeyPane = rpl_.getKeyPane();
        gridKeyPane.setBatch(true);
        gridKeyPane.setSize(new Dimension(600, 100));
        rpl_.setKeyLayerSizeP(new Dimension2D(6.0, 1.0));
        rpl_.setKeyBoundsP(new Rectangle2D.Double(0.0, 1.0, 6.0, 1.0));
        main.add((Component)gridKeyPane, "South");
        frame.getContentPane().add((Component)main, "Center");
        frame.getContentPane().add((Component)button, "South");
        Object foo = null;
        Object bar = null;
        Object foobutton = null;
        Object barbutton = null;
        frame.pack();
        frame.setVisible(true);
        gridKeyPane.setBatch(false);
        rpl_.setBatch(false);
    }

    void edit_actionPerformed(ActionEvent e) {
        GridAttributeDialog gad = new GridAttributeDialog();
        gad.setJPane(rpl_);
        CartesianRenderer rend = ((CartesianGraph)rpl_.getFirstLayer().getGraph()).getRenderer();
        gad.setGridCartesianRenderer((GridCartesianRenderer)rend);
        gad.setVisible(true);
    }

    void tree_actionPerformed(ActionEvent e) {
        JClassTree ct = new JClassTree();
        ct.setModal(false);
        ct.setJPane(rpl_);
        ct.setVisible(true);
    }

    void print_actionPerformed(ActionEvent e) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(rpl_, this.pageFormat);
        printJob.setJobName("ZGrid Demo");
        if (printJob.printDialog()) {
            try {
                Color saveColor = rpl_.getBackground();
                if (!saveColor.equals(Color.white)) {
                    rpl_.setBackground(Color.white);
                }
                rpl_.setPageAlign(0, 1);
                RepaintManager currentManager = RepaintManager.currentManager(rpl_);
                currentManager.setDoubleBufferingEnabled(false);
                printJob.print();
                currentManager.setDoubleBufferingEnabled(true);
                rpl_.setBackground(saveColor);
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    void layout_actionPerformed(ActionEvent e) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        this.pageFormat = pj.pageDialog(this.pageFormat);
    }

    JPlotLayout makeGraph() {
        this.readPointCollection("zgriddemo.dat");
        ZGrid grid = new ZGrid(51, 51, 0.0, 0.0, 2.0, 2.0, this.xp_, this.yp_, this.zp_, 5.0, 5);
        grid.setXMetaData(new SGTMetaData("X Axis", ""));
        grid.setYMetaData(new SGTMetaData("Y Axis", ""));
        SimpleLine line = new SimpleLine(this.xp_, this.yp_, "line");
        line.setXMetaData(new SGTMetaData("X Axis", ""));
        line.setYMetaData(new SGTMetaData("Y Axis", ""));
        JPlotLayout rpl = new JPlotLayout(true, false, false, "ZGridDemo Pane", null, true);
        rpl.setEditClasses(false);
        rpl.setLayerSizeP(new Dimension2D(6.0, 6.0));
        Range2D datar = new Range2D(-400.0, 1100.0, 50.0);
        ContourLevels clevels = ContourLevels.getDefault(datar);
        this.gridAttr_ = new GridAttribute(clevels);
        ColorMap cmap = this.createColorMap(datar);
        this.gridAttr_.setColorMap(cmap);
        this.gridAttr_.setStyle(3);
        rpl.addData(grid, (Attribute)this.gridAttr_, "First Data");
        rpl.addData(line, (Attribute)new LineAttribute(4, 2, Color.red), "Second Data");
        rpl.setTitles("ZGrid Plot Demo", "using a JPlotLayout", "");
        rpl.setSize(new Dimension(600, 600));
        return rpl;
    }

    ColorMap createColorMap(Range2D datar) {
        int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] green = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IndexedColorMap cmap = new IndexedColorMap(red, green, blue);
        cmap.setTransform(new LinearTransform(0.0, (double)red.length, datar.start, datar.end));
        return cmap;
    }

    private void readPointCollection(String file) {
        this.xp_ = new double[200];
        this.yp_ = new double[200];
        this.zp_ = new double[200];
        BufferedReader in = null;
        String line = null;
        InputStream is = this.getClass().getResourceAsStream(file);
        try {
            in = new BufferedReader(new InputStreamReader(is));
            line = in.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int count = 0;
        while (line != null) {
            StringTokenizer st = new StringTokenizer(line, " ");
            String token1 = st.nextToken();
            String token2 = st.nextToken();
            String token3 = st.nextToken();
            this.xp_[count] = Double.parseDouble(token1);
            this.yp_[count] = Double.parseDouble(token2);
            this.zp_[count] = Double.parseDouble(token3);
            ++count;
            try {
                line = in.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object obj = event.getSource();
            if (obj == ZGridDemo.this.edit_) {
                ZGridDemo.this.edit_actionPerformed(event);
            } else if (obj == ZGridDemo.this.space_) {
                System.out.println("  <<Mark>>");
            } else if (obj == ZGridDemo.this.tree_) {
                ZGridDemo.this.tree_actionPerformed(event);
            } else if (obj == ZGridDemo.this.print_) {
                ZGridDemo.this.print_actionPerformed(event);
            } else if (obj == ZGridDemo.this.layout_) {
                ZGridDemo.this.layout_actionPerformed(event);
            }
        }
    }
}

