/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.AbstractData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SGTPoint;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.dm.SimplePoint;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.Rectangle2D;
import gov.noaa.pmel.util.SoTDomain;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.Color;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class Annote
extends AbstractData
implements SGTData,
PropertyChangeListener {
    private static final long serialVersionUID = 7305616377566581275L;

    protected Annote() {
    }

    protected Rectangle computeBounds(Graph graph, SoTDomain domain) {
        int height;
        int yd;
        int width;
        int xd;
        Rectangle rect = null;
        if (domain == null || !(graph instanceof CartesianGraph)) {
            return rect;
        }
        CartesianGraph cg = (CartesianGraph)graph;
        int xd1 = cg.getXUtoD(domain.getXRange().getStart());
        int yd1 = cg.getYUtoD(domain.getYRange().getStart());
        int xd2 = cg.getXUtoD(domain.getXRange().getEnd());
        int yd2 = cg.getYUtoD(domain.getYRange().getEnd());
        if (xd1 < xd2) {
            xd = xd1;
            width = xd2 - xd1;
        } else {
            xd = xd2;
            width = xd1 - xd2;
        }
        if (yd1 < yd2) {
            yd = yd1;
            height = yd2 - yd1;
        } else {
            yd = yd2;
            height = yd1 - yd2;
        }
        rect = new Rectangle(xd, yd, width, height);
        return rect;
    }

    public abstract Rectangle getBounds(Graph var1);

    public abstract SoTDomain getDomain();

    public abstract void moveBy(SoTPoint var1);

    @Override
    public abstract void propertyChange(PropertyChangeEvent var1);

    public String getAnnoteId() {
        return this.id_;
    }

    public abstract void init();

    public static class Rect
    extends Annote {
        SoTPoint upperLeft;
        SoTPoint lowerRight;
        LineAttribute attr;
        Color color;
        SoTRange xRange_ = null;
        SoTRange yRange_ = null;

        public Rect(String id, SoTPoint upperLeft, SoTPoint lowerRight, LineAttribute attr, Color color) {
            this.id_ = id;
            this.upperLeft = upperLeft;
            this.lowerRight = lowerRight;
            this.attr = attr;
            this.color = color;
            this.init();
            this.computeRange();
        }

        @Override
        public void init() {
            if (this.attr != null) {
                this.attr.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.attr));
            }
            this.changes_ = new PropertyChangeSupport(this);
        }

        public SoTPoint getUpperLeft() {
            return this.upperLeft;
        }

        public void setUpperLeft(SoTPoint ul) {
            this.upperLeft = ul;
            this.computeRange();
            this.changes_.firePropertyChange("rectMoved", true, false);
        }

        public SoTPoint getLowerRight() {
            return this.lowerRight;
        }

        public void setLowerRight(SoTPoint lr) {
            this.lowerRight = lr;
            this.computeRange();
            this.changes_.firePropertyChange("rectMoved", true, false);
        }

        public void setLocation(SoTPoint ul, SoTPoint lr) {
            this.upperLeft = ul;
            this.lowerRight = lr;
            this.computeRange();
            this.changes_.firePropertyChange("rectMoved", true, false);
        }

        public LineAttribute getLineAttribute() {
            return this.attr;
        }

        public Color getFillColor() {
            return this.color;
        }

        public void setFillColor(Color color) {
            this.color = color;
            this.changes_.firePropertyChange("colorChanged", true, false);
        }

        @Override
        public SoTDomain getDomain() {
            return new SoTDomain(this.xRange_, this.yRange_);
        }

        @Override
        public Rectangle getBounds(Graph graph) {
            return this.computeBounds(graph, this.getDomain());
        }

        @Override
        public void moveBy(SoTPoint point) {
            this.upperLeft.add(point);
            this.lowerRight.add(point);
            this.computeRange();
            this.changes_.firePropertyChange("rectMoved", true, false);
        }

        private void computeRange() {
            if (this.upperLeft.getX().isTime()) {
                this.xRange_ = new SoTRange.Time(this.upperLeft.getX().getLongTime(), this.lowerRight.getX().getLongTime());
            } else {
                double xmin = ((Number)this.upperLeft.getX().getObjectValue()).doubleValue();
                double xmax = ((Number)this.lowerRight.getX().getObjectValue()).doubleValue();
                this.xRange_ = new SoTRange.Double(xmin, xmax);
            }
            if (this.upperLeft.getY().isTime()) {
                this.yRange_ = new SoTRange.Time(this.lowerRight.getY().getLongTime(), this.upperLeft.getY().getLongTime());
            } else {
                double ymin = ((Number)this.lowerRight.getY().getObjectValue()).doubleValue();
                double ymax = ((Number)this.upperLeft.getY().getObjectValue()).doubleValue();
                this.yRange_ = new SoTRange.Double(ymin, ymax);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.changes_.firePropertyChange(evt);
        }

        @Override
        public SGTData copy() {
            SGTData copy = null;
            try {
                copy = (SGTData)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
            return copy;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public SGLabel getKeyTitle() {
            return null;
        }

        @Override
        public String getTitle() {
            return null;
        }

        @Override
        public SGTMetaData getXMetaData() {
            return null;
        }

        @Override
        public SoTRange getXRange() {
            return this.xRange_;
        }

        @Override
        public SGTMetaData getYMetaData() {
            return null;
        }

        @Override
        public SoTRange getYRange() {
            return this.yRange_;
        }

        @Override
        public boolean isXTime() {
            return this.upperLeft.isXTime();
        }

        @Override
        public boolean isYTime() {
            return this.upperLeft.isYTime();
        }
    }

    public static class Oval
    extends Annote {
        SoTPoint upperLeft;
        SoTPoint lowerRight;
        LineAttribute attr;
        Color color;
        SoTRange xRange_ = null;
        SoTRange yRange_ = null;

        public Oval(String id, SoTPoint upperLeft, SoTPoint lowerRight, LineAttribute attr, Color color) {
            this.id_ = id;
            this.upperLeft = upperLeft;
            this.lowerRight = lowerRight;
            this.attr = attr;
            this.color = color;
            this.init();
            this.computeRange();
        }

        @Override
        public void init() {
            if (this.attr != null) {
                this.attr.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.attr));
            }
            this.changes_ = new PropertyChangeSupport(this);
        }

        public SoTPoint getUpperLeft() {
            return this.upperLeft;
        }

        public void setUpperLeft(SoTPoint ul) {
            this.upperLeft = ul;
            this.computeRange();
            this.changes_.firePropertyChange("ovalMoved", true, false);
        }

        public SoTPoint getLowerRight() {
            return this.lowerRight;
        }

        public void setLowerRight(SoTPoint lr) {
            this.lowerRight = lr;
            this.computeRange();
            this.changes_.firePropertyChange("ovalMoved", true, false);
        }

        public void setLocation(SoTPoint ul, SoTPoint lr) {
            this.upperLeft = ul;
            this.lowerRight = lr;
            this.computeRange();
            this.changes_.firePropertyChange("ovalMoved", true, false);
        }

        public LineAttribute getLineAttribute() {
            return this.attr;
        }

        public Color getFillColor() {
            return this.color;
        }

        public void setFillColor(Color color) {
            this.color = color;
            this.changes_.firePropertyChange("colorChanged", true, false);
        }

        @Override
        public SoTDomain getDomain() {
            return new SoTDomain(this.xRange_, this.yRange_);
        }

        @Override
        public Rectangle getBounds(Graph graph) {
            return this.computeBounds(graph, this.getDomain());
        }

        @Override
        public void moveBy(SoTPoint point) {
            this.upperLeft.add(point);
            this.lowerRight.add(point);
            this.computeRange();
            this.changes_.firePropertyChange("ovalMoved", true, false);
        }

        private void computeRange() {
            if (this.upperLeft.getX().isTime()) {
                this.xRange_ = new SoTRange.Time(this.upperLeft.getX().getLongTime(), this.lowerRight.getX().getLongTime());
            } else {
                double xmin = ((Number)this.upperLeft.getX().getObjectValue()).doubleValue();
                double xmax = ((Number)this.lowerRight.getX().getObjectValue()).doubleValue();
                this.xRange_ = new SoTRange.Double(xmin, xmax);
            }
            if (this.upperLeft.getY().isTime()) {
                this.yRange_ = new SoTRange.Time(this.lowerRight.getY().getLongTime(), this.upperLeft.getY().getLongTime());
            } else {
                double ymin = ((Number)this.lowerRight.getY().getObjectValue()).doubleValue();
                double ymax = ((Number)this.upperLeft.getY().getObjectValue()).doubleValue();
                this.yRange_ = new SoTRange.Double(ymin, ymax);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.changes_.firePropertyChange(evt);
        }

        @Override
        public SGTData copy() {
            SGTData copy = null;
            try {
                copy = (SGTData)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
            return copy;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public SGLabel getKeyTitle() {
            return null;
        }

        @Override
        public String getTitle() {
            return null;
        }

        @Override
        public SGTMetaData getXMetaData() {
            return null;
        }

        @Override
        public SoTRange getXRange() {
            return this.xRange_;
        }

        @Override
        public SGTMetaData getYMetaData() {
            return null;
        }

        @Override
        public SoTRange getYRange() {
            return this.yRange_;
        }

        @Override
        public boolean isXTime() {
            return this.upperLeft.isXTime();
        }

        @Override
        public boolean isYTime() {
            return this.upperLeft.isYTime();
        }
    }

    public static class Text
    extends Annote {
        SoTPoint location;
        SGLabel text;

        public Text(String id, SoTPoint location, SGLabel text) {
            this.id_ = id;
            this.location = location;
            this.text = text;
            this.init();
        }

        @Override
        public void init() {
            if (this.text != null) {
                this.text.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.text));
            }
            this.changes_ = new PropertyChangeSupport(this);
        }

        public SoTPoint getLocation() {
            return this.location;
        }

        public SGLabel getText() {
            return this.text;
        }

        @Override
        public SoTDomain getDomain() {
            return null;
        }

        private SoTDomain getDomain(Graph graph) {
            long max;
            long min;
            CartesianGraph cg = (CartesianGraph)graph;
            SoTRange xRange = null;
            SoTRange yRange = null;
            Rectangle2D.Double bnds = this.text.getBoundsP();
            double xloc = cg.getXUtoP(this.location.getX());
            double yloc = cg.getYUtoP(this.location.getY());
            double width = bnds.width;
            double height = bnds.height;
            if (this.location.isXTime()) {
                min = cg.getXPtoLongTime(xloc);
                max = cg.getXPtoLongTime(xloc + width);
                xRange = new SoTRange.Time(min, max);
            } else {
                double min2 = cg.getXPtoU(xloc);
                double max2 = cg.getXPtoU(xloc + width);
                xRange = new SoTRange.Double(min2, max2);
            }
            if (this.location.isYTime()) {
                min = cg.getYPtoLongTime(yloc);
                max = cg.getYPtoLongTime(yloc + height);
                yRange = new SoTRange.Time(min, max);
            } else {
                double min3 = cg.getYPtoU(yloc);
                double max3 = cg.getYPtoU(yloc + height);
                yRange = new SoTRange.Double(min3, max3);
            }
            return new SoTDomain(xRange, yRange);
        }

        @Override
        public Rectangle getBounds(Graph graph) {
            return this.computeBounds(graph, this.getDomain(graph));
        }

        @Override
        public void moveBy(SoTPoint point) {
            this.location.add(point);
            this.changes_.firePropertyChange("textMoved", true, false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.changes_.firePropertyChange(evt);
        }

        @Override
        public SGTData copy() {
            SGTData copy = null;
            try {
                copy = (SGTData)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
            return copy;
        }

        @Override
        public String getId() {
            return this.text.getId();
        }

        @Override
        public SGLabel getKeyTitle() {
            return null;
        }

        @Override
        public String getTitle() {
            return null;
        }

        @Override
        public SGTMetaData getXMetaData() {
            return null;
        }

        @Override
        public SoTRange getXRange() {
            return null;
        }

        @Override
        public SGTMetaData getYMetaData() {
            return null;
        }

        @Override
        public SoTRange getYRange() {
            return null;
        }

        @Override
        public boolean isXTime() {
            return this.location.isXTime();
        }

        @Override
        public boolean isYTime() {
            return this.location.isYTime();
        }
    }

    public static class Point
    extends Annote {
        SGTPoint point;
        PointAttribute attr;

        public Point(String id, SGTPoint point, PointAttribute attr) {
            this.id_ = id;
            this.point = point;
            this.attr = attr;
            this.init();
        }

        @Override
        public void init() {
            if (this.attr != null) {
                this.attr.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.attr));
            }
            this.changes_ = new PropertyChangeSupport(this);
        }

        public SGTPoint getPoint() {
            return this.point;
        }

        public PointAttribute getAttribute() {
            return this.attr;
        }

        @Override
        public SoTDomain getDomain() {
            return new SoTDomain(this.point.getXRange(), this.point.getYRange());
        }

        @Override
        public Rectangle getBounds(Graph graph) {
            Rectangle rect = this.computeBounds(graph, this.getDomain());
            double hgt = this.attr.getMarkHeightP();
            int ihgt = graph.getLayer().getXPtoD(hgt);
            rect.setBounds(rect.x - ihgt / 2, rect.y - ihgt / 2, ihgt, ihgt);
            return rect;
        }

        @Override
        public void moveBy(SoTPoint pnt) {
            double delta;
            long tdelta;
            double xu = 0.0;
            double yu = 0.0;
            long tu = 0L;
            if (!(this.point instanceof SimplePoint)) {
                return;
            }
            if (this.point.isXTime()) {
                tu = this.point.getLongTime();
                tdelta = pnt.getX().getLongTime();
                ((SimplePoint)this.point).setTime(tu += tdelta);
            } else {
                xu = this.point.getX();
                delta = ((Number)pnt.getX().getObjectValue()).doubleValue();
                ((SimplePoint)this.point).setX(xu += delta);
            }
            if (this.point.isYTime()) {
                tu = this.point.getLongTime();
                tdelta = pnt.getY().getLongTime();
                ((SimplePoint)this.point).setTime(tu += tdelta);
            } else {
                yu = this.point.getY();
                delta = ((Number)pnt.getY().getObjectValue()).doubleValue();
                ((SimplePoint)this.point).setY(yu += delta);
            }
            this.changes_.firePropertyChange("pointMoved", true, false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.changes_.firePropertyChange(evt);
        }

        @Override
        public SGTData copy() {
            SGTData copy = null;
            try {
                copy = (SGTData)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
            return copy;
        }

        @Override
        public String getId() {
            return this.point.getId();
        }

        @Override
        public SGLabel getKeyTitle() {
            return this.point.getKeyTitle();
        }

        @Override
        public String getTitle() {
            return this.point.getTitle();
        }

        @Override
        public SGTMetaData getXMetaData() {
            return this.point.getXMetaData();
        }

        @Override
        public SoTRange getXRange() {
            return this.point.getXRange();
        }

        @Override
        public SGTMetaData getYMetaData() {
            return this.point.getYMetaData();
        }

        @Override
        public SoTRange getYRange() {
            return this.point.getYRange();
        }

        @Override
        public boolean isXTime() {
            return this.point.isXTime();
        }

        @Override
        public boolean isYTime() {
            return this.point.isYTime();
        }
    }

    public static class Line
    extends Annote {
        SGTLine line;
        LineAttribute attr;

        public Line(String id, SGTLine line, LineAttribute attr) {
            this.id_ = id;
            this.line = line;
            this.attr = attr;
            this.init();
        }

        @Override
        public void init() {
            if (this.attr != null) {
                this.attr.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.attr));
            }
            this.changes_ = new PropertyChangeSupport(this);
        }

        public SGTLine getLine() {
            return this.line;
        }

        public LineAttribute getAttribute() {
            return this.attr;
        }

        @Override
        public SoTDomain getDomain() {
            return new SoTDomain(this.line.getXRange(), this.line.getYRange());
        }

        @Override
        public Rectangle getBounds(Graph graph) {
            return this.computeBounds(graph, this.getDomain());
        }

        @Override
        public void moveBy(SoTPoint point) {
            double delta;
            int i;
            long tdelta;
            double[] xu = null;
            double[] yu = null;
            long[] tu = null;
            if (!(this.line instanceof SimpleLine)) {
                return;
            }
            if (this.line.isXTime()) {
                tu = this.line.getGeoDateArray().getTime();
                tdelta = point.getX().getLongTime();
                i = 0;
                while (i < tu.length) {
                    int n = i++;
                    tu[n] = tu[n] + tdelta;
                }
                ((SimpleLine)this.line).setTimeArray(new GeoDateArray(tu));
            } else {
                xu = this.line.getXArray();
                delta = ((Number)point.getX().getObjectValue()).doubleValue();
                i = 0;
                while (i < xu.length) {
                    int n = i++;
                    xu[n] = xu[n] + delta;
                }
                ((SimpleLine)this.line).setXArray(xu);
            }
            if (this.line.isYTime()) {
                tu = this.line.getGeoDateArray().getTime();
                tdelta = point.getY().getLongTime();
                i = 0;
                while (i < tu.length) {
                    int n = i++;
                    tu[n] = tu[n] + tdelta;
                }
                ((SimpleLine)this.line).setTimeArray(new GeoDateArray(tu));
            } else {
                yu = this.line.getYArray();
                delta = ((Number)point.getY().getObjectValue()).doubleValue();
                i = 0;
                while (i < yu.length) {
                    int n = i++;
                    yu[n] = yu[n] + delta;
                }
                ((SimpleLine)this.line).setYArray(yu);
            }
            this.changes_.firePropertyChange("lineMoved", true, false);
        }

        public void setXArray(double[] xa) {
        }

        public void setYArray(double[] ya) {
        }

        public void setTimeArray(GeoDateArray gda) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.changes_.firePropertyChange(evt);
        }

        @Override
        public SGTData copy() {
            SGTData copy = null;
            try {
                copy = (SGTData)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
            return copy;
        }

        @Override
        public String getId() {
            return this.line.getId();
        }

        @Override
        public SGLabel getKeyTitle() {
            return this.line.getKeyTitle();
        }

        @Override
        public String getTitle() {
            return this.line.getTitle();
        }

        @Override
        public SGTMetaData getXMetaData() {
            return this.line.getXMetaData();
        }

        @Override
        public SoTRange getXRange() {
            return this.line.getXRange();
        }

        @Override
        public SGTMetaData getYMetaData() {
            return this.line.getYMetaData();
        }

        @Override
        public SoTRange getYRange() {
            return this.line.getYRange();
        }

        @Override
        public boolean isXTime() {
            return this.line.isXTime();
        }

        @Override
        public boolean isYTime() {
            return this.line.isYTime();
        }
    }
}

