/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import com.vividsolutions.jts.geom.Coordinate;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGeometry;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class GeometryCollection
extends Collection
implements PropertyChangeListener {
    private SoTRange.Double xRange_ = new SoTRange.Double();
    private SoTRange.Double yRange_ = new SoTRange.Double();
    private Range2D valueRange_ = new Range2D();
    private int colLen_ = 0;
    private SGTMetaData xMetaData_;
    private SGTMetaData yMetaData_;
    private SGTMetaData valueMetaData_;
    private SGTMetaData labelMetaData_;

    public GeometryCollection() {
        this("");
    }

    public GeometryCollection(String title) {
        super(title);
    }

    public GeometryCollection(String title, int initialCapacity) {
        super(title, initialCapacity);
    }

    public GeometryCollection(String title, int initialCapacity, int increment) {
        super(title, initialCapacity, increment);
    }

    @Override
    public SGTData copy() {
        GeometryCollection newCollection = (GeometryCollection)this.clone();
        return newCollection;
    }

    @Override
    public boolean add(Object geom) {
        if (geom instanceof SGTGeometry) {
            return this.add((SGTGeometry)geom);
        }
        return false;
    }

    @Override
    public boolean add(SGTGeometry geom) {
        geom.addPropertyChangeListener(new WeakPropertyChangeListener(this, geom));
        return super.add(geom);
    }

    public SGTGeometry findId(String id) {
        for (SGTGeometry sgeom : this) {
            if (!sgeom.getId().equals(id)) continue;
            return sgeom;
        }
        return null;
    }

    @Override
    public SoTRange getXRange() {
        this.computeRange();
        return this.xRange_.copy();
    }

    @Override
    public SoTRange getYRange() {
        this.computeRange();
        return this.yRange_.copy();
    }

    private void computeRange() {
        if (this.colLen_ == this.size()) {
            return;
        }
        this.colLen_ = this.size();
        if (this.colLen_ <= 0) {
            this.xRange_.start = Double.NaN;
            this.xRange_.end = Double.NaN;
            this.yRange_.start = Double.NaN;
            this.yRange_.end = Double.NaN;
            return;
        }
        double minx = Double.POSITIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        double maxv = Double.NEGATIVE_INFINITY;
        double minv = Double.POSITIVE_INFINITY;
        for (int k = 0; k < this.colLen_; ++k) {
            SGTGeometry sg = (SGTGeometry)this.get(k);
            Coordinate[] coords = sg.getEnvelope().getCoordinates();
            miny = Math.min(miny, coords[0].y);
            minx = Math.min(minx, coords[0].x);
            if (coords.length < 3) {
                maxy = miny;
                maxx = minx;
            } else {
                maxy = Math.max(maxy, coords[2].y);
                maxx = Math.max(maxx, coords[1].x);
            }
            if (!sg.hasValue()) continue;
            double v = sg.getValue();
            maxv = Math.max(maxv, v);
            minv = Math.min(minv, v);
        }
        this.yRange_.start = miny;
        this.yRange_.end = maxy;
        this.xRange_.start = minx;
        this.xRange_.end = maxx;
        if (!Double.isInfinite(minv)) {
            this.valueRange_.start = minv;
            this.valueRange_.end = maxv;
        }
    }

    public Range2D getValueRange() {
        return this.valueRange_;
    }

    @Override
    public SGTMetaData getXMetaData() {
        return this.xMetaData_;
    }

    public void setXMetaData(SGTMetaData xMetaData) {
        this.xMetaData_ = xMetaData;
    }

    @Override
    public SGTMetaData getYMetaData() {
        return this.yMetaData_;
    }

    public void setYMetaData(SGTMetaData yMetaData) {
        this.yMetaData_ = yMetaData;
    }

    public SGTMetaData getValueMetaData() {
        return this.valueMetaData_;
    }

    public void setValueMetaData(SGTMetaData meta) {
        this.valueMetaData_ = meta;
    }

    public SGTMetaData getLabelMetaData() {
        return this.labelMetaData_;
    }

    public void setLabelMetaData(SGTMetaData meta) {
        this.labelMetaData_ = meta;
    }

    @Override
    public boolean isXTime() {
        return false;
    }

    @Override
    public boolean isYTime() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt);
    }
}

