/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SGTPoint;
import gov.noaa.pmel.util.SoTRange;
import java.util.Enumeration;

public class PointCollection
extends Collection {
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private int colLen_ = 0;
    private SGTMetaData xMetaData_;
    private SGTMetaData yMetaData_;

    public PointCollection() {
        this("");
    }

    public PointCollection(String title) {
        super(title);
    }

    public PointCollection(String title, int initialCapacity) {
        super(title, initialCapacity);
    }

    public PointCollection(String title, int initialCapacity, int increment) {
        super(title, initialCapacity, increment);
    }

    @Override
    public SGTData copy() {
        PointCollection newCollection = (PointCollection)this.clone();
        return newCollection;
    }

    @Override
    public SoTRange getXRange() {
        this.computeRange();
        return this.xRange_.copy();
    }

    @Override
    public SoTRange getYRange() {
        this.computeRange();
        return this.yRange_.copy();
    }

    private void computeRange() {
        if (this.colLen_ == this.size()) {
            return;
        }
        this.colLen_ = this.size();
        double xmin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymin = xmin;
        double ymax = xmax;
        int count = 0;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof SGTPoint)) continue;
            SGTPoint pt = (SGTPoint)obj;
            double ptx = pt.getX();
            double pty = pt.getY();
            if (Double.isNaN(ptx) || Double.isNaN(pty)) continue;
            xmin = Math.min(xmin, ptx);
            xmax = Math.max(xmax, ptx);
            ymin = Math.min(ymin, pty);
            ymax = Math.max(ymax, pty);
            ++count;
        }
        if (count == 0) {
            this.xRange_ = new SoTRange.Double(Double.NaN, Double.NaN);
            this.yRange_ = new SoTRange.Double(Double.NaN, Double.NaN);
        } else {
            this.xRange_ = new SoTRange.Double(xmin, xmax);
            this.yRange_ = new SoTRange.Double(ymin, ymax);
        }
    }

    @Override
    public SGTMetaData getXMetaData() {
        return this.xMetaData_;
    }

    public void setXMetaData(SGTMetaData xMetaData) {
        this.xMetaData_ = xMetaData;
    }

    @Override
    public SGTMetaData getYMetaData() {
        return this.yMetaData_;
    }

    public void setYMetaData(SGTMetaData yMetaData) {
        this.yMetaData_ = yMetaData;
    }
}

