/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import gov.noaa.pmel.sgt.dm.AbstractData;
import gov.noaa.pmel.sgt.dm.Cartesian;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGeometry;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.SoTRange;

public class SimpleGeometry
extends AbstractData
implements Cartesian,
Cloneable,
SGTGeometry {
    protected Geometry geom_ = null;
    protected double[] values_ = null;
    protected int valueLength_ = 0;
    protected String label_ = null;
    protected SGTMetaData[] valuesMetaData_;
    protected SGTMetaData labelMetaData_;

    public SimpleGeometry() {
        this(null, Double.NaN, null);
    }

    public SimpleGeometry(Geometry geom, String title) {
        this(geom, Double.NaN, title);
    }

    public SimpleGeometry(Geometry geom, double value, String title) {
        this(null, geom, new double[]{value}, title);
    }

    public SimpleGeometry(Geometry geom, double[] values, String title) {
        this(null, geom, values, title);
    }

    public SimpleGeometry(String id, Geometry geom, double[] values, String title) {
        this.id_ = id;
        this.geom_ = geom;
        this.valueLength_ = values.length;
        this.values_ = new double[this.valueLength_];
        System.arraycopy(values, 0, this.values_, 0, this.valueLength_);
        this.valuesMetaData_ = new SGTMetaData[this.valueLength_];
        this.label_ = title;
    }

    @Override
    public String getLabel() {
        return this.label_;
    }

    @Override
    public SGTData copy() {
        SGTGeometry newGeom;
        try {
            newGeom = (SGTGeometry)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGeom = new SimpleGeometry();
        }
        return newGeom;
    }

    @Override
    public boolean isXTime() {
        return false;
    }

    @Override
    public boolean isYTime() {
        return false;
    }

    @Override
    public SoTRange getXRange() {
        if (this.geom_ == null) {
            return null;
        }
        Geometry env = this.geom_.getEnvelope();
        if (env instanceof Point) {
            Coordinate coord = env.getCoordinate();
            if (coord != null) {
                return new SoTRange(coord.x, coord.x);
            }
        } else if (env instanceof Polygon) {
            Coordinate[] coords = env.getCoordinates();
            double minx = coords[0].x;
            double maxx = coords[1].x;
            return new SoTRange(minx, maxx);
        }
        return null;
    }

    @Override
    public Geometry getEnvelope() {
        if (this.geom_ == null) {
            return null;
        }
        return this.geom_.getEnvelope();
    }

    @Override
    public SoTRange getYRange() {
        if (this.geom_ == null) {
            return null;
        }
        Geometry env = this.geom_.getEnvelope();
        if (env instanceof Point) {
            Coordinate coord = env.getCoordinate();
            if (coord != null) {
                return new SoTRange(coord.y, coord.y);
            }
        } else if (env instanceof Polygon) {
            Coordinate[] coords = env.getCoordinates();
            double miny = coords[0].y;
            double maxy = coords[2].y;
            return new SoTRange(miny, maxy);
        }
        return null;
    }

    @Override
    public boolean hasValue() {
        return !Double.isNaN(this.values_[0]);
    }

    @Override
    public double getValue() {
        return this.values_[0];
    }

    public void setValue(double value) {
        double old = this.values_[0];
        this.values_[0] = value;
        this.changes_.firePropertyChange("dataModified", new Double(old), new Double(this.values_[0]));
    }

    @Override
    public double getValue(int index) {
        if (index < 0 || index >= this.valueLength_) {
            throw new IndexOutOfBoundsException("Number of values is " + this.valueLength_ + " asked for " + index);
        }
        return this.values_[index];
    }

    public void setValue(int index, double value) {
        if (index < 0 || index >= this.valueLength_) {
            throw new IndexOutOfBoundsException("Number of values is " + this.valueLength_ + " asked for " + index);
        }
        double old = this.values_[index];
        this.values_[index] = value;
        this.changes_.firePropertyChange("dataModified", new Double(old), new Double(this.values_[index]));
    }

    @Override
    public SGTMetaData getValueMetaData() {
        return this.valuesMetaData_[0];
    }

    public void setValueMetaData(SGTMetaData meta) {
        this.valuesMetaData_[0] = meta;
    }

    @Override
    public SGTMetaData getValueMetaData(int index) {
        if (index < 0 || index >= this.valueLength_) {
            throw new IndexOutOfBoundsException("Number of ValueMetaData is " + this.valueLength_ + " asked for " + index);
        }
        return this.valuesMetaData_[index];
    }

    public void setValueMetaData(int index, SGTMetaData meta) {
        if (index < 0 || index >= this.valueLength_) {
            throw new IndexOutOfBoundsException("Number of ValueMetaData is " + this.valueLength_ + " asked for " + index);
        }
        this.valuesMetaData_[index] = meta;
    }

    @Override
    public SGTMetaData getLabelMetaData() {
        return this.labelMetaData_;
    }

    public void setLabelMetaData(SGTMetaData meta) {
        this.labelMetaData_ = meta;
    }

    @Override
    public Geometry getGeometry() {
        return this.geom_;
    }

    public void setGeometry(Geometry geom) {
        Geometry old = this.geom_;
        this.geom_ = geom;
        this.changes_.firePropertyChange("dataModified", old, this.geom_);
    }

    public Point getCentroid() {
        if (this.geom_ == null) {
            return null;
        }
        return this.geom_.getCentroid();
    }

    @Override
    public void setTitle(String title) {
        this.setLabel(title);
    }

    public void setLabel(String label) {
        String old = this.label_;
        this.label_ = label;
        this.changes_.firePropertyChange("dataModified", old, this.label_);
    }
}

