/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.dm.AbstractData;
import gov.noaa.pmel.sgt.dm.Cartesian;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;

public class SimpleGrid
extends AbstractData
implements SGTGrid,
Cartesian,
Cloneable {
    protected double[] xloc_;
    protected double[] yloc_;
    protected GeoDateArray tloc_;
    protected double[] grid_;
    protected double[] xEdges_;
    protected double[] yEdges_;
    protected GeoDateArray tEdges_;
    protected boolean hasXEdges_;
    protected boolean hasYEdges_;
    protected SGTMetaData zMetaData_ = null;
    protected SGTGrid associatedData_;
    protected SoTRange xEdgesRange_ = null;
    protected SoTRange yEdgesRange_ = null;
    protected Range2D zRange_ = null;
    private double[] xValEdges_;
    private double[] yValEdges_;
    private long[] tValEdges_;
    private boolean valEdgesComputed_ = false;

    public SimpleGrid() {
        this(null, (double[])null, (double[])null, "");
    }

    public SimpleGrid(double[] grid, double[] xloc, double[] yloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.yloc_ = yloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid(double[] grid, GeoDate[] tloc, double[] yloc, String title) {
        this.grid_ = grid;
        this.tloc_ = new GeoDateArray(tloc);
        this.yloc_ = yloc;
        this.title_ = title;
        this.xTime_ = true;
        this.yTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid(double[] grid, double[] xloc, GeoDate[] tloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.tloc_ = new GeoDateArray(tloc);
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = true;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(this.tloc_);
        this.zRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid(double[] grid, GeoDateArray tloc, double[] yloc, String title) {
        this.grid_ = grid;
        this.tloc_ = tloc;
        this.yloc_ = yloc;
        this.title_ = title;
        this.xTime_ = true;
        this.yTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid(double[] grid, double[] xloc, GeoDateArray tloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.tloc_ = tloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = true;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(this.tloc_);
        this.zRange_ = this.computeRange2D(grid);
    }

    @Override
    public SGTData copy() {
        SGTGrid newGrid;
        try {
            newGrid = (SGTGrid)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGrid = new SimpleGrid();
        }
        return newGrid;
    }

    @Override
    public double[] getXArray() {
        return this.xloc_;
    }

    @Override
    public int getXSize() {
        return this.xloc_.length;
    }

    @Override
    public double[] getYArray() {
        return this.yloc_;
    }

    @Override
    public int getYSize() {
        return this.yloc_.length;
    }

    @Override
    public double[] getZArray() {
        return this.grid_;
    }

    @Override
    public GeoDate[] getTimeArray() {
        return this.tloc_.getGeoDate();
    }

    @Override
    public GeoDateArray getGeoDateArray() {
        return this.tloc_;
    }

    @Override
    public int getTSize() {
        return this.tloc_.getLength();
    }

    @Override
    public SGTMetaData getZMetaData() {
        return this.zMetaData_;
    }

    public void setAssociatedData(SGTGrid assoc) {
        this.associatedData_ = assoc;
        if (this.changes_ != null) {
            String property = this.isDynamic() ? "dynamicAssociatedDataModified" : "associatedDataModified";
            this.changes_.firePropertyChange(property, null, assoc);
        }
    }

    @Override
    public SGTGrid getAssociatedData() {
        return this.associatedData_;
    }

    @Override
    public boolean hasAssociatedData() {
        return this.associatedData_ != null;
    }

    @Override
    public boolean hasXEdges() {
        return this.hasXEdges_;
    }

    @Override
    public double[] getXEdges() {
        return this.xEdges_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXEdges(double[] edge) {
        Object object = this.getPaneLock();
        synchronized (object) {
            this.xEdges_ = edge;
            this.hasXEdges_ = true;
            this.xEdgesRange_ = this.computeSoTRange(edge);
        }
    }

    @Override
    public boolean hasYEdges() {
        return this.hasYEdges_;
    }

    @Override
    public double[] getYEdges() {
        return this.yEdges_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setYEdges(double[] edge) {
        Object object = this.getPaneLock();
        synchronized (object) {
            this.yEdges_ = edge;
            this.hasYEdges_ = true;
            this.yEdgesRange_ = this.computeSoTRange(edge);
        }
    }

    @Override
    public GeoDate[] getTimeEdges() {
        return this.tEdges_.getGeoDate();
    }

    @Override
    public GeoDateArray getGeoDateArrayEdges() {
        return this.tEdges_;
    }

    public void setTimeEdges(GeoDate[] edge) {
        this.setTimeEdges(new GeoDateArray(edge));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeEdges(GeoDateArray tarray) {
        Object object = this.getPaneLock();
        synchronized (object) {
            this.tEdges_ = tarray;
            if (this.xTime_) {
                this.hasXEdges_ = true;
                this.xEdgesRange_ = this.computeSoTRange(tarray);
            } else if (this.yTime_) {
                this.hasYEdges_ = true;
                this.yEdgesRange_ = this.computeSoTRange(tarray);
            }
        }
    }

    public void setZMetaData(SGTMetaData md) {
        this.zMetaData_ = md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXArray(double[] xloc) {
        Object object = this.getPaneLock();
        synchronized (object) {
            this.valEdgesComputed_ = false;
            this.xloc_ = xloc;
            this.xTime_ = false;
            this.xRange_ = this.computeSoTRange(xloc);
            if (this.changes_ != null) {
                this.fireChange(xloc.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setYArray(double[] yloc) {
        Object object = this.getPaneLock();
        synchronized (object) {
            this.valEdgesComputed_ = false;
            this.yloc_ = yloc;
            this.yTime_ = false;
            this.yRange_ = this.computeSoTRange(yloc);
            if (this.changes_ != null) {
                this.fireChange(yloc.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZArray(double[] grid) {
        Object object = this.getPaneLock();
        synchronized (object) {
            this.grid_ = grid;
            this.zRange_ = this.computeRange2D(grid);
            if (this.changes_ != null) {
                this.fireChange(grid.length);
            }
        }
    }

    public void setTimeArray(GeoDate[] tloc) {
        this.setTimeArray(new GeoDateArray(tloc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeArray(GeoDateArray tarray) {
        Object object = this.getPaneLock();
        synchronized (object) {
            this.valEdgesComputed_ = false;
            this.tloc_ = tarray;
            if (this.xTime_) {
                this.xRange_ = this.computeSoTRange(tarray);
            } else if (this.yTime_) {
                this.yRange_ = this.computeSoTRange(tarray);
            }
            if (this.changes_ != null) {
                this.fireChange(tarray.getLength());
            }
        }
    }

    @Override
    public Range2D getZRange() {
        return this.zRange_;
    }

    @Override
    public SoTRange getXEdgesRange() {
        return this.xEdgesRange_;
    }

    @Override
    public SoTRange getYEdgesRange() {
        return this.yEdgesRange_;
    }

    @Override
    public double getValueAt(SoTValue x, SoTValue y) {
        int i;
        boolean increasing;
        if (!this.valEdgesComputed_) {
            this.computeEdges();
        }
        int xIdx = -1;
        int yIdx = -1;
        int tIdx = -1;
        if (this.xTime_ || this.yTime_) {
            if (this.tloc_.getLength() < 2) {
                return Double.NaN;
            }
            long val = this.xTime_ ? x.getLongTime() : y.getLongTime();
            increasing = this.tValEdges_[0] < this.tValEdges_[1];
            for (i = 0; i < this.tloc_.getLength(); ++i) {
                if (increasing) {
                    if (val <= this.tValEdges_[i] || val > this.tValEdges_[i + 1]) continue;
                    tIdx = i;
                    break;
                }
                if (val >= this.tValEdges_[i] || val < this.tValEdges_[i + 1]) continue;
                tIdx = i;
                break;
            }
        }
        if (!this.xTime_) {
            if (this.xloc_.length < 2) {
                return Double.NaN;
            }
            double val = x.getDouble();
            increasing = this.xValEdges_[0] < this.xValEdges_[1];
            for (i = 0; i < this.xloc_.length; ++i) {
                if (increasing) {
                    if (!(val > this.xValEdges_[i]) || !(val <= this.xValEdges_[i + 1])) continue;
                    xIdx = i;
                } else {
                    if (!(val < this.xValEdges_[i]) || !(val >= this.xValEdges_[i + 1])) continue;
                    xIdx = i;
                }
                break;
            }
        } else {
            xIdx = tIdx;
        }
        if (!this.yTime_) {
            if (this.yloc_.length < 2) {
                return Double.NaN;
            }
            double val = y.getDouble();
            increasing = this.yValEdges_[0] < this.yValEdges_[1];
            for (i = 0; i < this.yloc_.length; ++i) {
                if (increasing) {
                    if (!(val > this.yValEdges_[i]) || !(val <= this.yValEdges_[i + 1])) continue;
                    yIdx = i;
                } else {
                    if (!(val < this.yValEdges_[i]) || !(val >= this.yValEdges_[i + 1])) continue;
                    yIdx = i;
                }
                break;
            }
        } else {
            yIdx = tIdx;
        }
        if (yIdx < 0 || xIdx < 0) {
            return Double.NaN;
        }
        int index = yIdx + this.yloc_.length * xIdx;
        return this.grid_[index];
    }

    private void computeEdges() {
        int i;
        if (this.xTime_ || this.yTime_) {
            long[] time = this.tloc_.getTime();
            int len = time.length;
            if (len < 2) {
                return;
            }
            this.tValEdges_ = new long[len + 1];
            this.tValEdges_[0] = (3L * time[0] - time[1]) / 2L;
            for (int i2 = 1; i2 < len; ++i2) {
                this.tValEdges_[i2] = (time[i2] + time[i2 - 1]) / 2L;
            }
            this.tValEdges_[len] = (3L * time[len - 1] - time[len - 2]) / 2L;
        }
        if (!this.xTime_) {
            int len = this.xloc_.length;
            if (len < 2) {
                return;
            }
            this.xValEdges_ = new double[len + 1];
            this.xValEdges_[0] = (3.0 * this.xloc_[0] - this.xloc_[1]) * 0.5;
            for (i = 1; i < len; ++i) {
                this.xValEdges_[i] = (this.xloc_[i] + this.xloc_[i - 1]) * 0.5;
            }
            this.xValEdges_[len] = (3.0 * this.xloc_[len - 1] - this.xloc_[len - 2]) * 0.5;
        }
        if (!this.yTime_) {
            int len = this.yloc_.length;
            if (len < 2) {
                return;
            }
            this.yValEdges_ = new double[len + 1];
            this.yValEdges_[0] = (3.0 * this.yloc_[0] - this.yloc_[1]) * 0.5;
            for (i = 1; i < len; ++i) {
                this.yValEdges_[i] = (this.yloc_[i] + this.yloc_[i - 1]) * 0.5;
            }
            this.yValEdges_[len] = (3.0 * this.yloc_[len - 1] - this.yloc_[len - 2]) * 0.5;
        }
        this.valEdgesComputed_ = true;
    }

    private SoTRange computeSoTRange(double[] array) {
        Range2D range = this.computeRange2D(array);
        return new SoTRange.Double(range.start, range.end);
    }

    private SoTRange computeSoTRange(GeoDateArray tarray) {
        if (tarray == null) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        long start = Long.MAX_VALUE;
        long end = Long.MIN_VALUE;
        long[] tar = tarray.getTime();
        int count = 0;
        for (int i = 0; i < tar.length; ++i) {
            if (tar[i] == Long.MAX_VALUE) continue;
            start = Math.min(start, tar[i]);
            end = Math.max(end, tar[i]);
            ++count;
        }
        if (count == 0) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        return new SoTRange.Time(start, end);
    }

    private Range2D computeRange2D(double[] array) {
        if (array == null) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        double start = Double.POSITIVE_INFINITY;
        double end = Double.NEGATIVE_INFINITY;
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            start = Math.min(start, array[i]);
            end = Math.max(end, array[i]);
            ++count;
        }
        if (count == 0) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        return new Range2D(start, end);
    }

    private void fireChange(int length) {
        String property = this.isDynamic() ? "dynamicDataModified" : "dataModified";
        this.changes_.firePropertyChange(property, new Integer(0), new Integer(length));
    }
}

