/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.dm.AbstractData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTGrid3D;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;

public class SimpleGrid3D
extends AbstractData
implements SGTGrid3D {
    protected double[] xloc_;
    protected double[] yloc_;
    protected double[] zloc_;
    protected GeoDateArray tloc_;
    protected double[] grid_;
    protected double[] xEdges_;
    protected double[] yEdges_;
    protected double[] zEdges_;
    protected GeoDateArray tEdges_;
    protected boolean hasXEdges_;
    protected boolean hasYEdges_;
    protected boolean hasZEdges_;
    protected boolean zTime_;
    protected SGTMetaData zMetaData_ = null;
    protected SGTMetaData gridMetaData_ = null;
    protected SGTGrid3D associatedData_;
    protected SoTRange zRange_ = null;
    protected SoTRange xEdgesRange_ = null;
    protected SoTRange yEdgesRange_ = null;
    protected SoTRange zEdgesRange_ = null;
    protected Range2D gridRange_ = null;

    public SimpleGrid3D() {
        this(null, (double[])null, (double[])null, (double[])null, "");
    }

    public SimpleGrid3D(double[] grid, double[] xloc, double[] yloc, double[] zloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.yloc_ = yloc;
        this.zloc_ = zloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = false;
        this.zTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeSoTRange(zloc);
        this.gridRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid3D(double[] grid, GeoDate[] tloc, double[] yloc, double[] zloc, String title) {
        this.grid_ = grid;
        this.tloc_ = new GeoDateArray(tloc);
        this.yloc_ = yloc;
        this.zloc_ = zloc;
        this.title_ = title;
        this.xTime_ = true;
        this.yTime_ = false;
        this.zTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeSoTRange(zloc);
        this.gridRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid3D(double[] grid, double[] xloc, GeoDate[] tloc, double[] zloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.tloc_ = new GeoDateArray(tloc);
        this.zloc_ = zloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = true;
        this.zTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(this.tloc_);
        this.zRange_ = this.computeSoTRange(zloc);
        this.gridRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid3D(double[] grid, GeoDateArray tloc, double[] yloc, double[] zloc, String title) {
        this.grid_ = grid;
        this.tloc_ = tloc;
        this.yloc_ = yloc;
        this.zloc_ = zloc;
        this.title_ = title;
        this.xTime_ = true;
        this.yTime_ = false;
        this.zTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeSoTRange(zloc);
        this.gridRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid3D(double[] grid, double[] xloc, GeoDateArray tloc, double[] zloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.tloc_ = tloc;
        this.zloc_ = zloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = true;
        this.zTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(this.tloc_);
        this.zRange_ = this.computeSoTRange(zloc);
        this.gridRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid3D(double[] grid, double[] xloc, double[] yloc, GeoDate[] tloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.yloc_ = yloc;
        this.tloc_ = new GeoDateArray(tloc);
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = false;
        this.zTime_ = true;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeSoTRange(this.tloc_);
        this.gridRange_ = this.computeRange2D(grid);
    }

    public SimpleGrid3D(double[] grid, double[] xloc, double[] yloc, GeoDateArray tloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.yloc_ = yloc;
        this.tloc_ = tloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = false;
        this.zTime_ = true;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeSoTRange(this.tloc_);
        this.gridRange_ = this.computeRange2D(grid);
    }

    @Override
    public double[] getGridArray() {
        return this.grid_;
    }

    @Override
    public SGTMetaData getGridMetaData() {
        return this.gridMetaData_;
    }

    @Override
    public Range2D getGridRange() {
        return this.gridRange_;
    }

    @Override
    public double[] getZEdges() {
        return this.zEdges_;
    }

    public void setZEdges(double[] edge) {
        this.zEdges_ = edge;
        this.hasZEdges_ = true;
        this.zEdgesRange_ = this.computeSoTRange(edge);
    }

    @Override
    public int getZSize() {
        return this.zloc_.length;
    }

    @Override
    public boolean hasZEdges() {
        return this.hasZEdges_;
    }

    @Override
    public SoTRange getZEdgesRange() {
        return this.zEdgesRange_;
    }

    @Override
    public boolean isZTime() {
        return this.zTime_;
    }

    @Override
    public SGTGrid getAssociatedData() {
        throw new UnsupportedOperationException();
    }

    public void setAssociatedData(SGTGrid3D assoc) {
        this.associatedData_ = assoc;
        this.changes_.firePropertyChange("associatedDataModified", null, assoc);
    }

    @Override
    public SGTGrid3D getAssociatedData3D() {
        return this.associatedData_;
    }

    @Override
    public GeoDateArray getGeoDateArray() {
        return this.tloc_;
    }

    @Override
    public GeoDateArray getGeoDateArrayEdges() {
        return this.tEdges_;
    }

    @Override
    public int getTSize() {
        return this.tloc_.getLength();
    }

    @Override
    public GeoDate[] getTimeArray() {
        return this.tloc_.getGeoDate();
    }

    @Override
    public GeoDate[] getTimeEdges() {
        return this.tEdges_.getGeoDate();
    }

    @Override
    public double[] getXArray() {
        return this.xloc_;
    }

    @Override
    public double[] getXEdges() {
        return this.xEdges_;
    }

    public void setXEdges(double[] edge) {
        this.xEdges_ = edge;
        this.hasXEdges_ = true;
        this.xEdgesRange_ = this.computeSoTRange(edge);
    }

    @Override
    public SoTRange getXEdgesRange() {
        return this.xEdgesRange_;
    }

    @Override
    public int getXSize() {
        return this.xloc_.length;
    }

    @Override
    public double[] getYArray() {
        return this.yloc_;
    }

    @Override
    public double[] getYEdges() {
        return this.yEdges_;
    }

    public void setYEdges(double[] edge) {
        this.yEdges_ = edge;
        this.hasYEdges_ = true;
        this.yEdgesRange_ = this.computeSoTRange(edge);
    }

    @Override
    public SoTRange getYEdgesRange() {
        return this.yEdgesRange_;
    }

    @Override
    public int getYSize() {
        return this.yloc_.length;
    }

    @Override
    public double[] getZArray() {
        return this.zloc_;
    }

    @Override
    public SGTMetaData getZMetaData() {
        return this.zMetaData_;
    }

    @Override
    public Range2D getZRange() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SoTRange getZRangeSoT() {
        return this.zRange_.copy();
    }

    @Override
    public boolean hasAssociatedData() {
        return this.associatedData_ != null;
    }

    @Override
    public boolean hasXEdges() {
        return this.hasXEdges_;
    }

    @Override
    public boolean hasYEdges() {
        return this.hasYEdges_;
    }

    public void setTimeEdges(GeoDate[] edge) {
        this.setTimeEdges(new GeoDateArray(edge));
    }

    public void setTimeEdges(GeoDateArray tarray) {
        this.tEdges_ = tarray;
        if (this.xTime_) {
            this.hasXEdges_ = true;
            this.xEdgesRange_ = this.computeSoTRange(tarray);
        } else if (this.yTime_) {
            this.hasYEdges_ = true;
            this.yEdgesRange_ = this.computeSoTRange(tarray);
        } else if (this.zTime_) {
            this.hasZEdges_ = true;
            this.zEdgesRange_ = this.computeSoTRange(tarray);
        }
    }

    public void setZMetaData(SGTMetaData md) {
        this.zMetaData_ = md;
    }

    @Override
    public SGTData copy() {
        SGTGrid3D newGrid;
        try {
            newGrid = (SGTGrid3D)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGrid = new SimpleGrid3D();
        }
        return newGrid;
    }

    public void setXArray(double[] xloc) {
        this.xloc_ = xloc;
        this.xTime_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(xloc.length));
    }

    public void setYArray(double[] yloc) {
        this.yloc_ = yloc;
        this.yTime_ = false;
        this.yRange_ = this.computeSoTRange(yloc);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(yloc.length));
    }

    public void setZArray(double[] zloc) {
        this.zloc_ = zloc;
        this.zRange_ = this.computeSoTRange(zloc);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(zloc.length));
    }

    public void setGridArray(double[] grid) {
        this.grid_ = grid;
        this.gridRange_ = this.computeRange2D(grid);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(grid.length));
    }

    public void setTimeArray(GeoDate[] tloc) {
        this.setTimeArray(new GeoDateArray(tloc));
    }

    public void setTimeArray(GeoDateArray tarray) {
        this.tloc_ = tarray;
        if (this.xTime_) {
            this.xRange_ = this.computeSoTRange(tarray);
        } else if (this.yTime_) {
            this.yRange_ = this.computeSoTRange(tarray);
        }
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(tarray.getLength()));
    }

    @Override
    public double getValueAt(SoTValue x, SoTValue y) {
        return Double.NaN;
    }

    private SoTRange computeSoTRange(double[] array) {
        Range2D range = this.computeRange2D(array);
        return new SoTRange.Double(range.start, range.end);
    }

    private SoTRange computeSoTRange(GeoDateArray tarray) {
        if (tarray == null) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        long start = Long.MAX_VALUE;
        long end = Long.MIN_VALUE;
        long[] tar = tarray.getTime();
        int count = 0;
        for (int i = 0; i < tar.length; ++i) {
            if (tar[i] == Long.MAX_VALUE) continue;
            start = Math.min(start, tar[i]);
            end = Math.max(end, tar[i]);
            ++count;
        }
        if (count == 0) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        return new SoTRange.Time(start, end);
    }

    private Range2D computeRange2D(double[] array) {
        if (array == null) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        double start = Double.POSITIVE_INFINITY;
        double end = Double.NEGATIVE_INFINITY;
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            start = Math.min(start, array[i]);
            end = Math.max(end, array[i]);
            ++count;
        }
        if (count == 0) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        return new Range2D(start, end);
    }
}

