/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.dm.AbstractData;
import gov.noaa.pmel.sgt.dm.Cartesian;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.SoTRange;

public class SimpleLine
extends AbstractData
implements SGTLine,
Cartesian,
Cloneable {
    protected double[] xloc_ = null;
    protected double[] yloc_ = null;
    protected GeoDateArray tloc_;
    protected double[] associatedData_ = null;

    public SimpleLine() {
        this((double[])null, (double[])null, "");
    }

    public SimpleLine(double[] xloc, double[] yloc, String title) {
        this.xloc_ = xloc;
        this.yloc_ = yloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(yloc);
    }

    public SimpleLine(GeoDate[] tloc, double[] yloc, String title) {
        this.tloc_ = new GeoDateArray(tloc);
        this.yloc_ = yloc;
        this.title_ = title;
        this.xTime_ = true;
        this.yTime_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(yloc);
    }

    public SimpleLine(GeoDateArray tloc, double[] yloc, String title) {
        this.tloc_ = tloc;
        this.yloc_ = yloc;
        this.title_ = title;
        this.xTime_ = true;
        this.yTime_ = false;
        this.xRange_ = this.computeSoTRange(this.tloc_);
        this.yRange_ = this.computeSoTRange(yloc);
    }

    public SimpleLine(double[] xloc, GeoDateArray tloc, String title) {
        this.xloc_ = xloc;
        this.tloc_ = tloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = true;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(this.tloc_);
    }

    public SimpleLine(double[] xloc, GeoDate[] tloc, String title) {
        this.xloc_ = xloc;
        this.tloc_ = new GeoDateArray(tloc);
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = true;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(this.tloc_);
    }

    @Override
    public SGTData copy() {
        SGTLine newLine;
        try {
            newLine = (SGTLine)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newLine = new SimpleLine();
        }
        return newLine;
    }

    @Override
    public double[] getXArray() {
        return this.xloc_;
    }

    @Override
    public double[] getYArray() {
        return this.yloc_;
    }

    @Override
    public GeoDate[] getTimeArray() {
        return this.tloc_.getGeoDate();
    }

    @Override
    public GeoDateArray getGeoDateArray() {
        return this.tloc_;
    }

    public void setAssociatedData(double[] assoc) {
        this.associatedData_ = assoc;
        String property = this.isDynamic() ? "dynamicAssociatedDataModified" : "associatedDataModified";
        this.changes_.firePropertyChange(property, null, assoc);
    }

    @Override
    public double[] getAssociatedData() {
        return this.associatedData_;
    }

    @Override
    public boolean hasAssociatedData() {
        return this.associatedData_ != null;
    }

    public void setXArray(double[] xloc) {
        this.xloc_ = xloc;
        this.xTime_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.fireChange(xloc.length);
    }

    public void setYArray(double[] yloc) {
        this.yloc_ = yloc;
        this.yTime_ = false;
        this.yRange_ = this.computeSoTRange(yloc);
        this.fireChange(yloc.length);
    }

    public void setTimeArray(GeoDate[] tloc) {
        this.setTimeArray(new GeoDateArray(tloc));
    }

    public void setTimeArray(GeoDateArray tarray) {
        this.tloc_ = tarray;
        if (this.xTime_) {
            this.xRange_ = this.computeSoTRange(tarray);
        } else if (this.yTime_) {
            this.yRange_ = this.computeSoTRange(tarray);
        }
        this.fireChange(tarray.getLength());
    }

    protected SoTRange computeSoTRange(double[] array) {
        if (array == null) {
            return new SoTRange.Double(Double.NaN, Double.NaN);
        }
        double dstart = Double.POSITIVE_INFINITY;
        double dend = Double.NEGATIVE_INFINITY;
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            dstart = Math.min(dstart, array[i]);
            dend = Math.max(dend, array[i]);
            ++count;
        }
        if (count == 0) {
            return new SoTRange.Double(Double.NaN, Double.NaN);
        }
        return new SoTRange.Double(dstart, dend);
    }

    protected SoTRange computeSoTRange(GeoDateArray tarray) {
        if (tarray == null) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        long tstart = Long.MAX_VALUE;
        long tend = Long.MIN_VALUE;
        long[] tar = tarray.getTime();
        int count = 0;
        for (int i = 0; i < tar.length; ++i) {
            if (tar[i] == Long.MAX_VALUE) continue;
            tstart = Math.min(tstart, tar[i]);
            tend = Math.max(tend, tar[i]);
            ++count;
        }
        if (count == 0) {
            return new SoTRange.Time(Long.MAX_VALUE, Long.MAX_VALUE);
        }
        return new SoTRange.Time(tstart, tend);
    }

    private void fireChange(int length) {
        String property = this.isDynamic() ? "dynamicDataModified" : "dataModified";
        this.changes_.firePropertyChange(property, new Integer(0), new Integer(length));
    }
}

