/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.dm.AbstractData;
import gov.noaa.pmel.sgt.dm.Cartesian;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SGTPoint;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;

public class SimplePoint
extends AbstractData
implements SGTPoint,
Cartesian,
Cloneable {
    protected double xloc_ = Double.NaN;
    protected double yloc_ = Double.NaN;
    protected long tloc_;
    protected double value_;
    protected SGTMetaData valueMetaData_;
    protected boolean hasValue_ = false;

    public SimplePoint() {
    }

    public SimplePoint(double xloc, double yloc, String title) {
        this.xloc_ = xloc;
        this.yloc_ = yloc;
        this.title_ = title;
    }

    public SimplePoint(SoTPoint loc, String title) {
        this.xTime_ = loc.isXTime();
        this.yTime_ = loc.isYTime();
        if (this.xTime_) {
            this.tloc_ = loc.getX().getLongTime();
        } else {
            this.xloc_ = ((Number)loc.getX().getObjectValue()).doubleValue();
        }
        if (this.yTime_) {
            this.tloc_ = loc.getY().getLongTime();
        } else {
            this.yloc_ = ((Number)loc.getY().getObjectValue()).doubleValue();
        }
        this.title_ = title;
    }

    @Override
    public SGTData copy() {
        SGTPoint newPoint;
        try {
            newPoint = (SGTPoint)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newPoint = new SimplePoint();
        }
        return newPoint;
    }

    @Override
    public double getX() {
        return this.xloc_;
    }

    @Override
    public double getY() {
        return this.yloc_;
    }

    @Override
    public double getValue() {
        return this.value_;
    }

    @Override
    public boolean hasValue() {
        return this.hasValue_;
    }

    @Override
    public GeoDate getTime() {
        return new GeoDate(this.tloc_);
    }

    @Override
    public long getLongTime() {
        return this.tloc_;
    }

    public void setTime(GeoDate date) {
        this.setTime(date.getTime());
    }

    public void setTime(long t) {
        long old = this.tloc_;
        this.tloc_ = t;
        this.changes_.firePropertyChange("dataModified", new Long(old), new Long(this.tloc_));
    }

    @Override
    public SGTMetaData getValueMetaData() {
        return this.valueMetaData_;
    }

    public void setX(double xloc) {
        double old = this.xloc_;
        this.xloc_ = xloc;
        this.changes_.firePropertyChange("dataModified", new Double(old), new Double(this.xloc_));
    }

    public void setY(double yloc) {
        double old = this.yloc_;
        this.yloc_ = yloc;
        this.changes_.firePropertyChange("dataModified", new Double(old), new Double(this.yloc_));
    }

    public void setValue(double value, String name, String units) {
        double old = this.value_;
        this.value_ = value;
        this.valueMetaData_ = new SGTMetaData(name, units);
        this.hasValue_ = true;
        this.changes_.firePropertyChange("associatedDataModified", new Double(old), new Double(this.value_));
    }

    @Override
    public SoTRange getXRange() {
        if (this.xTime_) {
            return new SoTRange.Time(this.tloc_, this.tloc_);
        }
        return new SoTRange.Double(this.xloc_, this.xloc_);
    }

    @Override
    public SoTRange getYRange() {
        if (this.yTime_) {
            return new SoTRange.Time(this.tloc_, this.tloc_);
        }
        return new SoTRange.Double(this.yloc_, this.yloc_);
    }
}

