/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.dm;

import gov.noaa.pmel.sgt.dm.AbstractData;
import gov.noaa.pmel.sgt.dm.Cartesian;
import gov.noaa.pmel.sgt.dm.SGT3DGrid;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;

public class ThreeDGrid
extends AbstractData
implements SGT3DGrid,
Cartesian,
Cloneable {
    protected double[] xloc_;
    protected double[] yloc_;
    protected double[] zloc_;
    protected GeoDate[] tloc_;
    protected double[] grid_;
    protected double[] xEdges_;
    protected double[] yEdges_;
    protected double[] zEdges_;
    protected GeoDate[] tEdges_;
    protected boolean hasXEdges_;
    protected boolean hasYEdges_;
    protected boolean hasZEdges_;
    protected boolean zTime_;
    protected SGTMetaData zMetaData_ = null;
    protected SGTMetaData valMetaData_ = null;
    protected SGTGrid associatedData_;
    private SoTRange zRange_ = null;
    private SoTRange xEdgesRange_ = null;
    private SoTRange yEdgesRange_ = null;
    private SoTRange zEdgesRange_ = null;
    private Range2D valRange_ = null;

    public ThreeDGrid() {
    }

    public ThreeDGrid(double[] grid, double[] xloc, double[] yloc, double[] zloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.yloc_ = yloc;
        this.zloc_ = zloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = false;
        this.zTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeSoTRange(yloc);
        this.valRange_ = this.computeRange2D(grid);
    }

    public ThreeDGrid(double[] grid, GeoDate[] tloc, double[] yloc, double[] zloc, String title) {
        this.grid_ = grid;
        this.tloc_ = tloc;
        this.yloc_ = yloc;
        this.zloc_ = zloc;
        this.title_ = title;
        this.xTime_ = true;
        this.yTime_ = false;
        this.zTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(tloc);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeSoTRange(zloc);
        this.valRange_ = this.computeRange2D(grid);
    }

    public ThreeDGrid(double[] grid, double[] xloc, GeoDate[] tloc, double[] zloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.tloc_ = tloc;
        this.zloc_ = zloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = true;
        this.zTime_ = false;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(tloc);
        this.zRange_ = this.computeSoTRange(zloc);
        this.valRange_ = this.computeRange2D(grid);
    }

    public ThreeDGrid(double[] grid, double[] xloc, double[] yloc, GeoDate[] tloc, String title) {
        this.grid_ = grid;
        this.xloc_ = xloc;
        this.yloc_ = yloc;
        this.tloc_ = tloc;
        this.title_ = title;
        this.xTime_ = false;
        this.yTime_ = false;
        this.zTime_ = true;
        this.hasXEdges_ = false;
        this.hasYEdges_ = false;
        this.hasZEdges_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.yRange_ = this.computeSoTRange(yloc);
        this.zRange_ = this.computeSoTRange(tloc);
        this.valRange_ = this.computeRange2D(grid);
    }

    @Override
    public SGTData copy() {
        SGT3DGrid newGrid;
        try {
            newGrid = (SGT3DGrid)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGrid = new ThreeDGrid();
        }
        return newGrid;
    }

    public double[] getXArray() {
        return this.xloc_;
    }

    public int getXSize() {
        return this.xloc_.length;
    }

    public double[] getYArray() {
        return this.yloc_;
    }

    public int getYSize() {
        return this.yloc_.length;
    }

    public double[] getZArray() {
        return this.zloc_;
    }

    @Override
    public int getZSize() {
        return this.zloc_.length;
    }

    public double[] getValArray() {
        return this.grid_;
    }

    public int getValArraySize() {
        return this.grid_.length;
    }

    public GeoDate[] getTimeArray() {
        return this.tloc_;
    }

    public int getTSize() {
        return this.tloc_.length;
    }

    @Override
    public boolean isZTime() {
        return this.zTime_;
    }

    public void setZTime(boolean flag) {
        this.zTime_ = flag;
    }

    public SGTMetaData getZMetaData() {
        return this.zMetaData_;
    }

    @Override
    public SGTMetaData getValMetaData() {
        return this.valMetaData_;
    }

    public void setAssociatedData(SGTGrid assoc) {
        this.associatedData_ = assoc;
        this.changes_.firePropertyChange("associatedDataModified", null, assoc);
    }

    public SGTGrid getAssociatedData() {
        return this.associatedData_;
    }

    public boolean hasAssociatedData() {
        return this.associatedData_ != null;
    }

    public boolean hasXEdges() {
        return this.hasXEdges_;
    }

    public double[] getXEdges() {
        return this.xEdges_;
    }

    @Override
    public boolean hasZEdges() {
        return this.hasZEdges_;
    }

    public void setZEdges(double[] edge) {
        this.zEdges_ = edge;
        this.hasZEdges_ = true;
        this.zEdgesRange_ = this.computeSoTRange(edge);
    }

    @Override
    public double[] getZEdges() {
        return this.zEdges_;
    }

    public void setXEdges(double[] edge) {
        this.xEdges_ = edge;
        this.hasXEdges_ = true;
        this.xEdgesRange_ = this.computeSoTRange(edge);
    }

    public boolean hasYEdges() {
        return this.hasYEdges_;
    }

    public double[] getYEdges() {
        return this.yEdges_;
    }

    public void setYEdges(double[] edge) {
        this.yEdges_ = edge;
        this.hasYEdges_ = true;
        this.yEdgesRange_ = this.computeSoTRange(edge);
    }

    public GeoDate[] getTimeEdges() {
        return this.tEdges_;
    }

    public void setTimeEdges(GeoDate[] edge) {
        this.tEdges_ = edge;
        if (this.xTime_) {
            this.hasXEdges_ = true;
            this.xEdgesRange_ = this.computeSoTRange(edge);
        } else if (this.yTime_) {
            this.hasYEdges_ = true;
            this.yEdgesRange_ = this.computeSoTRange(edge);
        } else if (this.zTime_) {
            this.hasZEdges_ = true;
            this.zEdgesRange_ = this.computeSoTRange(edge);
        }
    }

    public void setZMetaData(SGTMetaData md) {
        this.zMetaData_ = md;
    }

    public void setValMetaData(SGTMetaData md) {
        this.valMetaData_ = md;
    }

    public void setXArray(double[] xloc) {
        this.xloc_ = xloc;
        this.xTime_ = false;
        this.xRange_ = this.computeSoTRange(xloc);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(xloc.length));
    }

    public void setYArray(double[] yloc) {
        this.yloc_ = yloc;
        this.yTime_ = false;
        this.yRange_ = this.computeSoTRange(yloc);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(yloc.length));
    }

    public void setZArray(double[] zloc) {
        this.zloc_ = zloc;
        this.zTime_ = false;
        this.zRange_ = this.computeSoTRange(zloc);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(zloc.length));
    }

    public void setValArray(double[] grid) {
        this.grid_ = grid;
        this.valRange_ = this.computeRange2D(grid);
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(grid.length));
    }

    public void setTimeArray(GeoDate[] tloc) {
        this.tloc_ = tloc;
        if (this.xTime_) {
            this.xRange_ = this.computeSoTRange(tloc);
        } else if (this.yTime_) {
            this.yRange_ = this.computeSoTRange(tloc);
        } else if (this.zTime_) {
            this.zRange_ = this.computeSoTRange(tloc);
        }
        this.changes_.firePropertyChange("dataModified", new Integer(0), new Integer(tloc.length));
    }

    public SoTRange getZRange() {
        return this.zRange_.copy();
    }

    @Override
    public Range2D getValRange() {
        return this.valRange_;
    }

    public SoTRange getXEdgesRange() {
        return this.xEdgesRange_;
    }

    public SoTRange getYEdgesRange() {
        return this.yEdgesRange_;
    }

    @Override
    public SoTRange getZEdgesRange() {
        return this.zEdgesRange_;
    }

    private SoTRange computeSoTRange(double[] array) {
        Range2D range = this.computeRange2D(array);
        return new SoTRange.Double(range.start, range.end);
    }

    private SoTRange computeSoTRange(GeoDate[] tarray) {
        long start = Long.MAX_VALUE;
        long end = Long.MIN_VALUE;
        int count = 0;
        for (int i = 0; i < tarray.length; ++i) {
            if (tarray[i] == null || tarray[i].isMissing()) continue;
            long value = tarray[i].getTime();
            start = Math.min(start, value);
            end = Math.max(end, value);
            ++count;
        }
        if (count == 0) {
            return new SoTRange.GeoDate(new GeoDate(Long.MIN_VALUE), new GeoDate(Long.MAX_VALUE));
        }
        return new SoTRange.GeoDate(new GeoDate(start), new GeoDate(end));
    }

    private Range2D computeRange2D(double[] array) {
        double start = Double.POSITIVE_INFINITY;
        double end = Double.NEGATIVE_INFINITY;
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            start = Math.min(start, array[i]);
            end = Math.max(end, array[i]);
            ++count;
        }
        if (count == 0) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        return new Range2D(start, end);
    }
}

