/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.swing.SelectionHandle;
import java.awt.Graphics;
import java.awt.Rectangle;

class DefaultSelectionHandle
implements SelectionHandle {
    private int height_;
    private int width_;
    private int type_;
    private boolean handleFullSized_;

    public DefaultSelectionHandle(boolean fullSized, int type, int width, int height) {
        this.type_ = type;
        this.width_ = width;
        this.height_ = height;
        this.handleFullSized_ = fullSized;
    }

    @Override
    public void draw(Graphics g, Rectangle toolBounds) {
        Rectangle bounds = this.getBounds(toolBounds);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public boolean contains(Rectangle toolBounds, int xm, int ym) {
        Rectangle bnds = this.getBounds(toolBounds);
        return bnds.contains(xm, ym);
    }

    @Override
    public Rectangle getSelectionBounds(Rectangle toolBounds) {
        return this.getBounds(toolBounds);
    }

    @Override
    public Rectangle getBounds(Rectangle toolBounds) {
        Rectangle bounds = toolBounds;
        int xref = 0;
        int yref = 0;
        int wid = this.width_;
        int hgt = this.height_;
        if (this.handleFullSized_) {
            switch (this.type_) {
                case 2: {
                    hgt = bounds.height - 1;
                    xref = bounds.x + bounds.width - this.width_;
                    yref = bounds.y + 1;
                    break;
                }
                case 1: {
                    hgt = bounds.height - 1;
                    xref = bounds.x + 1;
                    yref = bounds.y + 1;
                    break;
                }
                case 4: {
                    wid = bounds.width - 1;
                    xref = bounds.x + 1;
                    yref = bounds.y + 1;
                    break;
                }
                case 8: {
                    wid = bounds.width - 1;
                    xref = bounds.x + 1;
                    yref = bounds.y + bounds.height - this.height_;
                    break;
                }
                case 32: {
                    xref = bounds.x + bounds.width - this.width_;
                    yref = bounds.y + 1;
                    break;
                }
                case 16: {
                    xref = bounds.x + 1;
                    yref = bounds.y;
                    break;
                }
                case 128: {
                    xref = bounds.x + bounds.width - this.width_;
                    yref = bounds.y + bounds.height - this.height_;
                    break;
                }
                case 64: {
                    xref = bounds.x + 1;
                    yref = bounds.y + bounds.height - this.height_;
                }
            }
        } else {
            switch (this.type_) {
                case 2: {
                    xref = bounds.x + bounds.width - this.width_;
                    yref = bounds.y + bounds.height / 2 - this.height_ / 2;
                    break;
                }
                case 1: {
                    xref = bounds.x + 1;
                    yref = bounds.y + bounds.height / 2 - this.height_ / 2;
                    break;
                }
                case 4: {
                    xref = bounds.x + bounds.width / 2 - this.width_ / 2;
                    yref = bounds.y + 1;
                    break;
                }
                case 8: {
                    xref = bounds.x + bounds.width / 2 - this.width_ / 2;
                    yref = bounds.y + bounds.height - this.height_;
                    break;
                }
                case 32: {
                    xref = bounds.x + bounds.width - this.width_;
                    yref = bounds.y + 1;
                    break;
                }
                case 16: {
                    xref = bounds.x + 1;
                    yref = bounds.y + 1;
                    break;
                }
                case 128: {
                    xref = bounds.x + bounds.width - this.width_;
                    yref = bounds.y + bounds.height - this.height_;
                    break;
                }
                case 64: {
                    xref = bounds.x + 1;
                    yref = bounds.y + bounds.height - this.height_;
                }
            }
        }
        Rectangle result = new Rectangle(xref, yref, wid, hgt);
        return result;
    }

    @Override
    public int getType() {
        return this.type_;
    }
}

