/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.DataNotFoundException;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.Logo;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.TimeAxis;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTVector;
import gov.noaa.pmel.sgt.swing.prop.LogoDialog;
import gov.noaa.pmel.sgt.swing.prop.SGLabelDialog;
import gov.noaa.pmel.sgt.swing.prop.SpaceAxisDialog;
import gov.noaa.pmel.sgt.swing.prop.TimeAxisDialog;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Domain;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.TimeRange;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class JGraphicLayout
extends JPane {
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static final int Z_AXIS = 3;
    protected static double XSIZE_ = 6.0;
    protected static double XMIN_ = 0.6;
    protected static double XMAX_ = 5.4;
    protected static double YSIZE_ = 4.5;
    protected static double YMIN_ = 0.75;
    protected static double YMAX_ = 3.3;
    protected static double MAIN_TITLE_HEIGHT_ = 0.25;
    protected static double TITLE_HEIGHT_ = 0.22;
    protected static double LABEL_HEIGHT_ = 0.18;
    protected static double WARN_HEIGHT_ = 0.15;
    protected static double KEY_HEIGHT_ = 0.16;
    protected static double XKEYSIZE_ = 6.0;
    protected static double YKEYSIZE_ = 12.0;
    protected static Color PANE_COLOR = Color.white;
    protected static Color KEYPANE_COLOR = Color.white;
    protected int base_units_ = 0;
    private JGraphicLayout me_;
    protected JPane keyPane_;
    protected Vector data_;
    protected Hashtable dataAttrMap_ = new Hashtable();
    protected String ident_;
    protected boolean overlayed_;
    protected boolean clipping_ = false;
    protected Image iconImage_ = null;
    protected SGLabel mainTitle_;
    protected SGLabel title2_;
    protected SGLabel title3_;
    protected SymMouse aSymMouse_;
    protected boolean editClasses_ = true;
    protected SGLabelDialog sg_props_;
    protected SpaceAxisDialog pa_props_;
    protected TimeAxisDialog ta_props_;
    protected LogoDialog lo_props_;
    protected PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    protected VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);

    public JGraphicLayout() {
        this("", null, new Dimension(50, 50));
    }

    public JGraphicLayout(String id, Image img) {
        this(id, img, new Dimension(50, 50));
    }

    public JGraphicLayout(String id, Image img, Dimension size) {
        super(id, size);
        this.ident_ = id;
        this.overlayed_ = true;
        this.data_ = new Vector(10);
        this.iconImage_ = img;
        this.mainTitle_ = null;
        this.title2_ = null;
        this.title3_ = null;
        this.me_ = this;
        if (this.aSymMouse_ == null) {
            this.aSymMouse_ = new SymMouse();
        }
        this.addMouseListener(this.aSymMouse_);
    }

    @Override
    public void setId(String id) {
        this.ident_ = id;
    }

    @Override
    public String getId() {
        return this.ident_;
    }

    public void setTitles(String title, String title2, String title3) {
        if (this.mainTitle_ != null) {
            this.mainTitle_.setText(title);
        }
        if (this.title2_ != null) {
            this.title2_.setText(title2);
        }
        if (this.title3_ != null) {
            this.title3_.setText(title3);
        }
    }

    public SGLabel getMainTitle() {
        return this.mainTitle_;
    }

    public void setBaseUnit(int base) {
        this.base_units_ = base;
    }

    public int getBaseUnit() {
        return this.base_units_;
    }

    public void setOverlayed(boolean over) {
        this.overlayed_ = over;
    }

    public boolean isOverlayed() {
        return this.overlayed_;
    }

    public Image getIconImage() {
        return this.iconImage_;
    }

    public JPane getKeyPane() {
        return this.keyPane_;
    }

    public boolean isKeyPane() {
        return this.keyPane_ != null;
    }

    public void addData(SGTData data) {
        this.data_.addElement(data);
    }

    public void addAttribute(SGTData data, Attribute attr) {
        this.dataAttrMap_.put(data, attr);
    }

    public Attribute getAttribute(SGTData data) throws DataNotFoundException {
        Attribute attr = (Attribute)this.dataAttrMap_.get(data);
        if (attr == null) {
            throw new DataNotFoundException();
        }
        return attr;
    }

    public Attribute findAttribute(String id) {
        Attribute attr = null;
        Enumeration e = this.dataAttrMap_.elements();
        while (e.hasMoreElements()) {
            attr = (Attribute)e.nextElement();
            if (!attr.getId().equals(id)) continue;
            return attr;
        }
        return attr;
    }

    public abstract void addData(SGTData var1, String var2);

    public abstract String getLocationSummary(SGTData var1);

    public Range2D findRange(SGTLine data, int dir) {
        int i;
        int num;
        double[] values;
        int first = 0;
        double amin = 0.0;
        double amax = 0.0;
        boolean good = false;
        switch (dir) {
            case 1: {
                values = data.getXArray();
                num = values.length;
                break;
            }
            default: {
                values = data.getYArray();
                num = values.length;
            }
        }
        for (i = 0; i < num; ++i) {
            if (Double.isNaN(values[i])) continue;
            amin = values[i];
            amax = values[i];
            good = true;
            first = i + 1;
            break;
        }
        if (!good) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        for (i = first; i < num; ++i) {
            if (Double.isNaN(values[i])) continue;
            amin = Math.min(amin, values[i]);
            amax = Math.max(amax, values[i]);
        }
        return new Range2D(amin, amax);
    }

    public SoTRange findSoTRange(SGTLine line, int dir) {
        switch (dir) {
            case 1: {
                return line.getXRange();
            }
            case 2: {
                return line.getYRange();
            }
        }
        return null;
    }

    public SoTRange findSoTRange(SGTVector data, int dir) {
        int i;
        int first = 0;
        double amin = 0.0;
        double amax = 0.0;
        boolean good = false;
        switch (dir) {
            case 1: {
                return data.getU().getXRange();
            }
            case 2: {
                return data.getU().getYRange();
            }
        }
        double[] ucomp = data.getU().getZArray();
        double[] vcomp = data.getV().getZArray();
        double[] veclen = new double[ucomp.length];
        for (i = 0; i < veclen.length; ++i) {
            veclen[i] = Math.sqrt(ucomp[i] * ucomp[i] + vcomp[i] * vcomp[i]);
        }
        int num = veclen.length;
        for (i = 0; i < num; ++i) {
            if (Double.isNaN(veclen[i])) continue;
            amin = veclen[i];
            amax = veclen[i];
            good = true;
            first = i + 1;
            break;
        }
        if (!good) {
            return new SoTRange.Double(Double.NaN, Double.NaN);
        }
        for (i = first; i < num; ++i) {
            if (Double.isNaN(veclen[i])) continue;
            amin = Math.min(amin, veclen[i]);
            amax = Math.max(amax, veclen[i]);
        }
        return new SoTRange.Double(amin, amax);
    }

    public SoTRange findSoTRange(SGTGrid data, GridAttribute attr, int dir) {
        int num;
        int i;
        double[] values;
        int first = 0;
        double amin = 0.0;
        double amax = 0.0;
        boolean good = false;
        if (attr.isRaster() && (data.isXTime() && dir == 1 && !data.hasXEdges() || data.isYTime() && dir == 2 && !data.hasYEdges())) {
            GeoDate[] torig = data.getTimeArray();
            int onum = torig.length;
            GeoDate[] taxis = new GeoDate[onum + 1];
            taxis[0] = torig[0].subtract(torig[1].subtract(torig[0]).divide(2.0));
            for (int i2 = 1; i2 < onum; ++i2) {
                taxis[i2] = torig[i2 - 1].add(torig[i2]).divide(2.0);
            }
            taxis[onum] = torig[onum - 1].add(torig[onum - 1].subtract(torig[onum - 2]).divide(2.0));
            int num2 = taxis.length;
            return new SoTRange.Time(taxis[0].getTime(), taxis[num2 - 1].getTime());
        }
        switch (dir) {
            case 1: {
                int onum;
                double[] orig;
                if (attr.isRaster()) {
                    if (data.hasXEdges()) {
                        return data.getXEdgesRange();
                    }
                    orig = data.getXArray();
                    onum = orig.length;
                    values = new double[onum + 1];
                    values[0] = orig[0] - (orig[1] - orig[0]) * 0.5;
                    for (i = 1; i < onum; ++i) {
                        values[i] = (orig[i - 1] + orig[i]) * 0.5;
                    }
                    values[onum] = orig[onum - 1] + (orig[onum - 1] - orig[onum - 2]) * 0.5;
                    num = values.length;
                    break;
                }
                return data.getXRange();
            }
            case 2: {
                int onum;
                double[] orig;
                if (attr.isRaster()) {
                    if (data.hasYEdges()) {
                        return data.getYEdgesRange();
                    }
                    orig = data.getYArray();
                    onum = orig.length;
                    values = new double[onum + 1];
                    values[0] = orig[0] - (orig[1] - orig[0]) * 0.5;
                    for (i = 1; i < onum; ++i) {
                        values[i] = (orig[i - 1] + orig[i]) * 0.5;
                    }
                    values[onum] = orig[onum - 1] + (orig[onum - 1] - orig[onum - 2]) * 0.5;
                    num = values.length;
                    break;
                }
                return data.getYRange();
            }
            default: {
                values = data.getZArray();
                num = values.length;
            }
        }
        for (i = 0; i < num; ++i) {
            if (Double.isNaN(values[i])) continue;
            amin = values[i];
            amax = values[i];
            good = true;
            first = i + 1;
            break;
        }
        if (!good) {
            return new SoTRange.Double(Double.NaN, Double.NaN);
        }
        for (i = first; i < num; ++i) {
            if (Double.isNaN(values[i])) continue;
            amin = Math.min(amin, values[i]);
            amax = Math.max(amax, values[i]);
        }
        return new SoTRange.Double(amin, amax);
    }

    public Range2D findRange(SGTGrid data, GridAttribute attr, int dir) {
        int i;
        int num;
        double[] values;
        int first = 0;
        double amin = 0.0;
        double amax = 0.0;
        boolean good = false;
        switch (dir) {
            case 1: {
                int onum;
                double[] orig;
                if (attr.isRaster()) {
                    if (data.hasXEdges()) {
                        values = data.getXEdges();
                        num = values.length;
                        break;
                    }
                    orig = data.getXArray();
                    onum = orig.length;
                    values = new double[onum + 1];
                    values[0] = orig[0] - (orig[1] - orig[0]) * 0.5;
                    for (i = 1; i < onum; ++i) {
                        values[i] = (orig[i - 1] + orig[i]) * 0.5;
                    }
                    values[onum] = orig[onum - 1] + (orig[onum - 1] - orig[onum - 2]) * 0.5;
                    num = values.length;
                    break;
                }
                values = data.getXArray();
                num = values.length;
                break;
            }
            case 2: {
                int onum;
                double[] orig;
                if (attr.isRaster()) {
                    if (data.hasYEdges()) {
                        values = data.getYEdges();
                        num = values.length;
                        break;
                    }
                    orig = data.getYArray();
                    onum = orig.length;
                    values = new double[onum + 1];
                    values[0] = orig[0] - (orig[1] - orig[0]) * 0.5;
                    for (i = 1; i < onum; ++i) {
                        values[i] = (orig[i - 1] + orig[i]) * 0.5;
                    }
                    values[onum] = orig[onum - 1] + (orig[onum - 1] - orig[onum - 2]) * 0.5;
                    num = values.length;
                    break;
                }
                values = data.getYArray();
                num = values.length;
                break;
            }
            default: {
                values = data.getZArray();
                num = values.length;
            }
        }
        for (i = 0; i < num; ++i) {
            if (Double.isNaN(values[i])) continue;
            amin = values[i];
            amax = values[i];
            good = true;
            first = i + 1;
            break;
        }
        if (!good) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        for (i = first; i < num; ++i) {
            if (Double.isNaN(values[i])) continue;
            amin = Math.min(amin, values[i]);
            amax = Math.max(amax, values[i]);
        }
        return new Range2D(amin, amax);
    }

    public TimeRange findTimeRange(SGTLine data) {
        long[] taxis = data.getGeoDateArray().getTime();
        int num = taxis.length;
        return new TimeRange(taxis[0], taxis[num - 1]);
    }

    public TimeRange findTimeRange(SGTGrid data, GridAttribute attr) {
        long[] taxis;
        if (attr.isRaster() && (data.isXTime() || data.isYTime())) {
            if (data.hasXEdges() || data.hasYEdges()) {
                taxis = data.getGeoDateArrayEdges().getTime();
            } else {
                long[] orig = data.getGeoDateArray().getTime();
                int onum = orig.length;
                taxis = new long[onum + 1];
                taxis[0] = orig[0] - (orig[1] - orig[0]) / 2L;
                for (int i = 1; i < onum; ++i) {
                    taxis[i] = (orig[i - 1] + orig[i]) / 2L;
                }
                taxis[onum] = orig[onum - 1] + (orig[onum - 1] - orig[onum - 2]) / 2L;
            }
        } else {
            taxis = data.getGeoDateArray().getTime();
        }
        int num = taxis.length;
        return new TimeRange(taxis[0], taxis[num - 1]);
    }

    public void setClipping(boolean clip) {
        this.clipping_ = clip;
    }

    public boolean isClipping() {
        return this.clipping_;
    }

    public abstract void resetZoom();

    public abstract void setRange(Domain var1) throws PropertyVetoException;

    public Domain getRange() {
        Domain domain = new Domain();
        Layer layer = this.getFirstLayer();
        Graph graph = layer.getGraph();
        if (graph instanceof CartesianGraph) {
            CartesianGraph cg = (CartesianGraph)graph;
            AxisTransform xt = cg.getXTransform();
            AxisTransform yt = cg.getYTransform();
            if (xt.isTime()) {
                domain.setXRange(xt.getTimeRangeU());
            } else {
                domain.setXRange(xt.getRangeU());
            }
            if (yt.isTime()) {
                domain.setYRange(yt.getTimeRangeU());
            } else {
                domain.setYRange(yt.getRangeU());
            }
        }
        return domain;
    }

    public Domain getZoomBoundsU() {
        Domain domain = new Domain();
        Range2D xr = new Range2D();
        Range2D yr = new Range2D();
        Rectangle zoom = this.getZoomBounds();
        Layer layer = this.getFirstLayer();
        Graph graph = layer.getGraph();
        if (graph instanceof CartesianGraph) {
            long end;
            long start;
            double temp;
            CartesianGraph cg = (CartesianGraph)graph;
            AxisTransform xt = cg.getXTransform();
            AxisTransform yt = cg.getYTransform();
            if (xt.isSpace()) {
                xr.start = cg.getXPtoU(layer.getXDtoP(zoom.x));
                xr.end = cg.getXPtoU(layer.getXDtoP(zoom.x + zoom.width));
                if (xr.start > xr.end) {
                    temp = xr.start;
                    xr.start = xr.end;
                    xr.end = temp;
                }
                domain.setXRange(xr);
            } else {
                start = cg.getXPtoLongTime(layer.getXDtoP(zoom.x));
                if (start > (end = cg.getXPtoLongTime(layer.getXDtoP(zoom.x + zoom.width)))) {
                    long tmp = start;
                    start = end;
                    end = tmp;
                }
                domain.setXRange(new TimeRange(new GeoDate(start), new GeoDate(end)));
            }
            if (yt.isSpace()) {
                yr.start = cg.getYPtoU(layer.getYDtoP(zoom.y));
                yr.end = cg.getYPtoU(layer.getYDtoP(zoom.y + zoom.height));
                if (yr.start > yr.end) {
                    temp = yr.start;
                    yr.start = yr.end;
                    yr.end = temp;
                }
                domain.setYRange(yr);
            } else {
                start = cg.getYPtoLongTime(layer.getYDtoP(zoom.y));
                if (start > (end = cg.getYPtoLongTime(layer.getYDtoP(zoom.y + zoom.height)))) {
                    long tmp = start;
                    start = end;
                    end = tmp;
                }
                domain.setYRange(new TimeRange(new GeoDate(start), new GeoDate(end)));
            }
        }
        return domain;
    }

    protected String getLatString(double lat) {
        if (lat == 0.0) {
            return "Eq";
        }
        DecimalFormat dfLat = new DecimalFormat("##.##N;##.##S");
        return dfLat.format(lat);
    }

    protected String getLonString(double lond) {
        DecimalFormat dfLon = new DecimalFormat("###.##W;###.##");
        double lon = (lond + 360.0) % 360.0;
        dfLon.setNegativeSuffix("E");
        if (lon > 180.0) {
            lon = 360.0 - lon;
        }
        return dfLon.format(lon);
    }

    public Collection getData() {
        Collection col = new Collection(this.ident_ + " Data Collection", this.data_.size());
        Enumeration e = this.data_.elements();
        while (e.hasMoreElements()) {
            col.addElement(e.nextElement());
        }
        return col;
    }

    void Layout_MouseRelease(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return;
        }
        Rectangle zm = this.getZoomBounds();
        if (zm.width <= 1 || zm.height <= 1) {
            return;
        }
        Domain zoom = this.getZoomBoundsU();
        this.setClipping(true);
        if (this.getFirstLayer().getGraph() instanceof CartesianGraph) {
            try {
                this.setRange(zoom);
            }
            catch (PropertyVetoException e) {
                System.out.println("Zoom denied! " + e);
            }
        }
    }

    void Layout_MousePress(MouseEvent event) {
        if (event.isControlDown()) {
            this.resetZoom();
            this.setClipping(false);
        }
    }

    void Layout_MouseClicked(MouseEvent event) {
        if (event.isControlDown()) {
            return;
        }
        Object obj = this.getSelectedObject();
        if (obj instanceof LineCartesianRenderer) {
            LineCartesianRenderer line = (LineCartesianRenderer)obj;
            LineAttribute attr = line.getLineAttribute();
            if (attr.getStyle() == 0) {
                attr.setStyle(3);
            } else if (attr.getStyle() == 3) {
                attr.setStyle(0);
            }
        }
        if ((event.getModifiers() & 4) != 0 && this.editClasses_) {
            this.showProperties(obj);
        }
    }

    void KeyPane_MousePress(MouseEvent event) {
    }

    void KeyPane_MouseClicked(MouseEvent event) {
        if (this.keyPane_ == null) {
            return;
        }
        Object obj = this.keyPane_.getSelectedObject();
        if (obj instanceof LineCartesianRenderer) {
            LineCartesianRenderer line = (LineCartesianRenderer)obj;
            LineAttribute attr = line.getLineAttribute();
            if (attr.getStyle() == 0) {
                attr.setStyle(3);
            } else if (attr.getStyle() == 3) {
                attr.setStyle(0);
            }
        }
        if (this.editClasses_) {
            this.showProperties(obj);
        }
    }

    public void setEditClasses(boolean b) {
        this.editClasses_ = b;
    }

    public boolean isEditClasses() {
        return this.editClasses_;
    }

    void showProperties(Object obj) {
        if (obj instanceof SGLabel) {
            if (this.sg_props_ == (SGLabelDialog)null) {
                this.sg_props_ = new SGLabelDialog();
            }
            this.sg_props_.setSGLabel((SGLabel)obj, this);
            if (!this.sg_props_.isShowing()) {
                this.sg_props_.setVisible(true);
            }
        } else if (obj instanceof PlainAxis) {
            if (this.pa_props_ == (SpaceAxisDialog)null) {
                this.pa_props_ = new SpaceAxisDialog();
            }
            this.pa_props_.setSpaceAxis((PlainAxis)obj, this);
            if (!this.pa_props_.isShowing()) {
                this.pa_props_.setVisible(true);
            }
        } else if (obj instanceof TimeAxis) {
            if (this.ta_props_ == (TimeAxisDialog)null) {
                this.ta_props_ = new TimeAxisDialog();
            }
            this.ta_props_.setTimeAxis((TimeAxis)obj, this);
            if (!this.ta_props_.isShowing()) {
                this.ta_props_.setVisible(true);
            }
        } else if (obj instanceof Logo) {
            if (this.lo_props_ == (LogoDialog)null) {
                this.lo_props_ = new LogoDialog();
            }
            this.lo_props_.setLogo((Logo)obj, this);
            if (!this.lo_props_.isShowing()) {
                this.lo_props_.setVisible(true);
            }
        }
    }

    protected void setAllClip(SoTRange xr, SoTRange yr) {
        if (yr.isTime()) {
            this.setAllClip(yr.getStart().getLongTime(), yr.getEnd().getLongTime(), ((SoTRange.Double)xr).start, ((SoTRange.Double)xr).end);
        } else if (xr.isTime()) {
            this.setAllClip(xr.getStart().getLongTime(), xr.getEnd().getLongTime(), ((SoTRange.Double)yr).start, ((SoTRange.Double)yr).end);
        } else {
            this.setAllClip(((SoTRange.Double)xr).start, ((SoTRange.Double)xr).end, ((SoTRange.Double)yr).start, ((SoTRange.Double)yr).end);
        }
    }

    protected void setAllClip(double xmin, double xmax, double ymin, double ymax) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Layer)) continue;
            Layer ly = (Layer)comps[i];
            ((CartesianGraph)ly.getGraph()).setClip(xmin, xmax, ymin, ymax);
        }
    }

    protected void setAllClip(GeoDate tmin, GeoDate tmax, double min, double max) {
        this.setAllClip(tmin.getTime(), tmax.getTime(), min, max);
    }

    protected void setAllClip(long tmin, long tmax, double min, double max) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Layer ly = (Layer)comps[i];
            ((CartesianGraph)ly.getGraph()).setClip(tmin, tmax, min, max);
        }
    }

    protected void setAllClipping(boolean clip) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Layer)) continue;
            Layer ly = (Layer)comps[i];
            ((CartesianGraph)ly.getGraph()).setClipping(clip);
        }
    }

    public abstract Rectangle2D.Double getKeyBoundsP();

    public abstract void setKeyBoundsP(Rectangle2D.Double var1);

    public Dimension2D getKeyLayerSizeP() {
        if (this.keyPane_ != null) {
            return this.keyPane_.getFirstLayer().getSizeP();
        }
        return null;
    }

    public void setKeyLayerSizeP(Dimension2D d) {
        if (this.keyPane_ != null) {
            this.keyPane_.getFirstLayer().setSizeP(d);
        }
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.addVetoableChangeListener(l);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.removeVetoableChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!JGraphicLayout.this.isMouseEventsEnabled()) {
                return;
            }
            Object object = event.getSource();
            if (object == JGraphicLayout.this.me_) {
                JGraphicLayout.this.Layout_MousePress(event);
            } else if (object == JGraphicLayout.this.keyPane_) {
                JGraphicLayout.this.KeyPane_MousePress(event);
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (!JGraphicLayout.this.isMouseEventsEnabled()) {
                return;
            }
            Object object = event.getSource();
            if (object == JGraphicLayout.this.me_) {
                JGraphicLayout.this.Layout_MouseClicked(event);
            } else if (object == JGraphicLayout.this.keyPane_) {
                JGraphicLayout.this.KeyPane_MouseClicked(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (!JGraphicLayout.this.isMouseEventsEnabled()) {
                return;
            }
            Object object = event.getSource();
            if (object == JGraphicLayout.this.me_) {
                JGraphicLayout.this.Layout_MouseRelease(event);
            }
        }
    }
}

