/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.LineKey;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.Logo;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.swing.JGraphicLayout;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Domain;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import gov.noaa.pmel.util.Units;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.Enumeration;

public class JLineProfileLayout
extends JGraphicLayout {
    Logo logo_;
    LineKey lineKey_;
    int layerCount_;
    boolean zUp_ = true;
    Layer firstLayer_;
    boolean inZoom_ = false;
    double xSize_ = XSIZE_;
    double xMin_ = XMIN_;
    double xMax_ = XMAX_;
    double ySize_ = YSIZE_;
    double yMin_ = YMIN_;
    double yMax_ = YMAX_;
    double mainTitleHeight_ = MAIN_TITLE_HEIGHT_;
    double titleHeight_ = TITLE_HEIGHT_;
    double labelHeight_ = LABEL_HEIGHT_;
    double warnHeight_ = WARN_HEIGHT_;
    double keyHeight_ = KEY_HEIGHT_;
    double xKeySize_ = XKEYSIZE_;
    double yKeySize_ = YKEYSIZE_;
    Color paneColor_ = PANE_COLOR;
    Color keyPaneColor_ = KEYPANE_COLOR;
    private static final Color[] colorList_ = new Color[]{Color.blue, Color.cyan, Color.green, Color.orange.darker(), Color.red, Color.magenta, Color.black, Color.gray};
    private static final int[] markList_ = new int[]{1, 2, 9, 15, 10, 24, 11, 44};

    public JLineProfileLayout() {
        this("", null, false);
    }

    public JLineProfileLayout(String id, Image img, boolean is_key_pane) {
        super(id, img, new Dimension(400, 300));
        int halign;
        double xpos;
        Layer layer;
        this.setOpaque(true);
        this.setLayout(new StackedLayout());
        this.setBackground(this.paneColor_);
        this.firstLayer_ = layer = new Layer("Layer 1", new Dimension2D(this.xSize_, this.ySize_));
        this.add((Component)layer, 0);
        this.lineKey_ = new LineKey();
        this.lineKey_.setSelectable(false);
        this.lineKey_.setId("Line Key");
        this.lineKey_.setVAlign(0);
        if (is_key_pane) {
            this.lineKey_.setHAlign(0);
            this.lineKey_.setBorderStyle(2);
            this.lineKey_.setLocationP(new Point2D.Double(0.0, this.yKeySize_));
            int xdim = 400;
            int ydim = (int)((double)xdim / this.xKeySize_ * this.yKeySize_);
            this.keyPane_ = new JPane("KeyPane", new Dimension(xdim, ydim));
            this.keyPane_.setOpaque(true);
            this.keyPane_.setLayout(new StackedLayout());
            this.keyPane_.setBackground(this.keyPaneColor_);
            Layer key_layer = new Layer("Key Layer", new Dimension2D(this.xKeySize_, this.yKeySize_));
            this.keyPane_.add(key_layer);
            key_layer.addChild(this.lineKey_);
        } else {
            this.lineKey_.setHAlign(2);
            this.lineKey_.setLocationP(new Point2D.Double(this.xSize_ - 0.01, this.ySize_));
            layer.addChild(this.lineKey_);
        }
        if (this.iconImage_ != null) {
            this.logo_ = new Logo(new Point2D.Double(0.0, this.ySize_), 0, 0);
            this.logo_.setImage(this.iconImage_);
            layer.addChild(this.logo_);
            Rectangle bnds = this.logo_.getBounds();
            xpos = layer.getXDtoP(bnds.x + bnds.width) + 0.05;
            halign = 0;
        } else {
            xpos = (this.xMin_ + this.xMax_) * 0.5;
            halign = 1;
        }
        double ypos = this.ySize_ - (double)1.2f * this.mainTitleHeight_;
        Font titleFont = new Font("Helvetica", 1, 14);
        this.mainTitle_ = new SGLabel("Line Profile Title", "Profile Plot", this.mainTitleHeight_, new Point2D.Double(xpos, ypos), 2, halign);
        this.mainTitle_.setFont(titleFont);
        layer.addChild(this.mainTitle_);
        Font title2Font = new Font("Helvetica", 0, 10);
        this.title2_ = new SGLabel("Warning", "Warning: Browse image only", this.warnHeight_, new Point2D.Double(xpos, ypos -= (double)1.2f * this.warnHeight_), 2, halign);
        this.title2_.setFont(title2Font);
        layer.addChild(this.title2_);
        this.title3_ = new SGLabel("Warning 2", "Verify accuracy of plot before research use", this.warnHeight_, new Point2D.Double(xpos, ypos -= (double)1.1f * this.warnHeight_), 2, halign);
        this.title3_.setFont(title2Font);
        layer.addChild(this.title3_);
        this.title3_.setSelectable(false);
        this.layerCount_ = 0;
        CartesianGraph graph = new CartesianGraph("Profile Graph 1");
        LinearTransform xt = new LinearTransform(this.xMin_, this.xMax_, 10.0, 20.0);
        LinearTransform yt = new LinearTransform(this.yMin_, this.yMax_, 400.0, 0.0);
        graph.setXTransform(xt);
        graph.setYTransform(yt);
        Font axfont = new Font("Helvetica", 2, 14);
        PlainAxis xbot = new PlainAxis("Bottom Axis");
        xbot.setRangeU(new Range2D(10.0, 20.0));
        xbot.setDeltaU(2.0);
        xbot.setNumberSmallTics(0);
        xbot.setLabelHeightP(this.labelHeight_);
        xbot.setLocationU(new Point2D.Double(10.0, 400.0));
        xbot.setLabelFont(axfont);
        graph.addXAxis(xbot);
        PlainAxis yleft = new PlainAxis("Left Axis");
        yleft.setRangeU(new Range2D(400.0, 0.0));
        yleft.setDeltaU(-50.0);
        yleft.setNumberSmallTics(0);
        yleft.setLabelHeightP(this.labelHeight_);
        yleft.setLocationU(new Point2D.Double(10.0, 400.0));
        yleft.setLabelFont(axfont);
        graph.addYAxis(yleft);
        layer.setGraph(graph);
    }

    @Override
    public String getLocationSummary(SGTData grid) {
        return "";
    }

    public void addData(Collection lines) {
        this.addData(lines, null);
    }

    public void addData(Collection lines, String descrip) {
        for (int i = 0; i < lines.size(); ++i) {
            SGTLine line = (SGTLine)lines.elementAt(i);
            this.addData(line, line.getTitle());
        }
    }

    @Override
    public void addData(SGTData datum) {
        this.addData(datum, null);
    }

    @Override
    public void addData(SGTData datum, String descrip) {
        PlainAxis xbot = null;
        PlainAxis yleft = null;
        Range2D xnRange = null;
        Range2D ynRange = null;
        Point2D.Double origin = null;
        boolean data_good = true;
        if (this.data_.size() == 0) {
            this.setBaseUnit(Units.getBaseUnit(((SGTLine)datum).getXMetaData()));
        }
        datum = Units.convertToBaseUnit(datum, this.getBaseUnit(), 0);
        if (this.data_.size() == 0) {
            Layer layer;
            super.addData(datum);
            SGTData data = (SGTData)this.data_.firstElement();
            Range2D xRange = this.findRange((SGTLine)data, 1);
            Range2D yRange = this.findRange((SGTLine)data, 2);
            this.zUp_ = ((SGTLine)data).getYMetaData().isReversed();
            if (Double.isNaN(xRange.start) || Double.isNaN(yRange.start)) {
                data_good = false;
            }
            if (data_good) {
                if (!this.zUp_) {
                    double save = yRange.end;
                    yRange.end = yRange.start;
                    yRange.start = save;
                }
                xnRange = Graph.computeRange(xRange, 6);
                ynRange = Graph.computeRange(yRange, 6);
                origin = new Point2D.Double(xnRange.start, ynRange.start);
            }
            String xLabel = " (" + ((SGTLine)data).getXMetaData().getUnits() + ")";
            String yLabel = " (" + ((SGTLine)data).getYMetaData().getUnits() + ")";
            try {
                layer = this.getLayer("Layer 1");
            }
            catch (LayerNotFoundException e) {
                return;
            }
            CartesianGraph graph = (CartesianGraph)layer.getGraph();
            Font tfont = new Font("Helvetica", 0, 14);
            xbot = (PlainAxis)graph.getXAxis("Bottom Axis");
            if (xbot != null) {
                if (data_good) {
                    xbot.setRangeU(xnRange);
                    xbot.setDeltaU(xnRange.delta);
                    xbot.setLocationU(origin);
                }
                SGLabel xtitle = new SGLabel("xaxis title", xLabel, new Point2D.Double(0.0, 0.0));
                xtitle.setFont(tfont);
                xtitle.setHeightP(this.titleHeight_);
                xbot.setTitle(xtitle);
            }
            if ((yleft = (PlainAxis)graph.getYAxis("Left Axis")) != null) {
                if (data_good) {
                    yleft.setRangeU(ynRange);
                    yleft.setDeltaU(ynRange.delta);
                    yleft.setLocationU(origin);
                }
                SGLabel ytitle = new SGLabel("yaxis title", yLabel, new Point2D.Double(0.0, 0.0));
                ytitle.setFont(tfont);
                ytitle.setHeightP(this.titleHeight_);
                yleft.setTitle(ytitle);
            }
            if (data_good) {
                LinearTransform xt = (LinearTransform)graph.getXTransform();
                xt.setRangeU(xnRange);
                LinearTransform yt = (LinearTransform)graph.getYTransform();
                yt.setRangeU(ynRange);
            }
            LineAttribute lineAttr = ((SGTLine)data).getYArray().length >= 2 ? new LineAttribute(0, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]) : new LineAttribute(4, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]);
            graph.setData(data, lineAttr);
            SGLabel lineTitle = descrip == null ? new SGLabel("line title", xLabel, new Point2D.Double(0.0, 0.0)) : new SGLabel("line title", descrip, new Point2D.Double(0.0, 0.0));
            lineTitle.setHeightP(this.keyHeight_);
            this.lineKey_.addLineGraph((LineCartesianRenderer)graph.getRenderer(), lineTitle);
            if (this.keyPane_ != null) {
                Rectangle vRect = this.keyPane_.getVisibleRect();
                int nrow = vRect.height / this.lineKey_.getRowHeight();
                this.keyPane_.setScrollableUnitIncrement(1, this.lineKey_.getRowHeight());
                this.keyPane_.setScrollableBlockIncrement(vRect.width, this.lineKey_.getRowHeight() * nrow);
            }
        } else {
            if (((SGTLine)datum).getYMetaData().isReversed() != this.zUp_) {
                SGTData modified;
                datum = modified = this.flipZ(datum);
            }
            super.addData(datum);
            data_good = false;
            ++this.layerCount_;
            if (this.isOverlayed()) {
                SGLabel lineTitle;
                Layer layer;
                try {
                    layer = this.getLayer("Layer 1");
                }
                catch (LayerNotFoundException e) {
                    return;
                }
                CartesianGraph graph = (CartesianGraph)layer.getGraph();
                LinearTransform xt = (LinearTransform)graph.getXTransform();
                LinearTransform yt = (LinearTransform)graph.getYTransform();
                xbot = (PlainAxis)graph.getXAxis("Bottom Axis");
                yleft = (PlainAxis)graph.getYAxis("Left Axis");
                if (!this.inZoom_) {
                    Range2D xTotalRange = new Range2D();
                    Range2D yTotalRange = new Range2D();
                    boolean first = true;
                    Enumeration e = this.data_.elements();
                    while (e.hasMoreElements()) {
                        SGTData data = (SGTData)e.nextElement();
                        Range2D xRange = this.findRange((SGTLine)data, 1);
                        Range2D yRange = this.findRange((SGTLine)data, 2);
                        if (!((SGTLine)data).getYMetaData().isReversed()) {
                            double save = yRange.start;
                            yRange.start = yRange.end;
                            yRange.end = save;
                        }
                        if (first) {
                            if (Double.isNaN(xRange.start) || Double.isNaN(yRange.start)) {
                                first = true;
                                continue;
                            }
                            first = false;
                            data_good = true;
                            xTotalRange = new Range2D(xRange.start, xRange.end);
                            yTotalRange = new Range2D(yRange.start, yRange.end);
                            continue;
                        }
                        if (Double.isNaN(xRange.start) || Double.isNaN(yRange.start)) continue;
                        data_good = true;
                        xTotalRange.start = Math.min(xTotalRange.start, xRange.start);
                        xTotalRange.end = Math.max(xTotalRange.end, xRange.end);
                        if (!((SGTLine)data).getYMetaData().isReversed()) {
                            yTotalRange.start = Math.max(yTotalRange.start, yRange.start);
                            yTotalRange.end = Math.min(yTotalRange.end, yRange.end);
                            continue;
                        }
                        yTotalRange.start = Math.min(yTotalRange.start, yRange.start);
                        yTotalRange.end = Math.max(yTotalRange.end, yRange.end);
                    }
                    if (data_good) {
                        xnRange = Graph.computeRange(xTotalRange, 6);
                        ynRange = Graph.computeRange(yTotalRange, 6);
                        origin = new Point2D.Double(xnRange.start, ynRange.start);
                        if (xbot != null) {
                            xbot.setRangeU(xnRange);
                            xbot.setDeltaU(xnRange.delta);
                            xbot.setLocationU(origin);
                        }
                        if (yleft != null) {
                            yleft.setRangeU(ynRange);
                            yleft.setDeltaU(ynRange.delta);
                            yleft.setLocationU(origin);
                        }
                    }
                    if (data_good) {
                        xt.setRangeU(xnRange);
                        yt.setRangeU(ynRange);
                    }
                }
                Layer newLayer = new Layer("Layer " + (this.layerCount_ + 1), new Dimension2D(this.xSize_, this.ySize_));
                CartesianGraph newGraph = new CartesianGraph("Graph " + (this.layerCount_ + 1), xt, yt);
                if (this.inZoom_ && xbot != null && yleft != null) {
                    Range2D xr = xbot.getRangeU();
                    Range2D yr = yleft.getRangeU();
                    newGraph.setClip(xr.start, xr.end, yr.start, yr.end);
                    newGraph.setClipping(true);
                }
                this.add((Component)newLayer, 0);
                newLayer.setGraph(newGraph);
                newLayer.invalidate();
                this.validate();
                LineAttribute lineAttr = ((SGTLine)datum).getXArray().length >= 2 ? new LineAttribute(0, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]) : new LineAttribute(4, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]);
                newGraph.setData(datum, lineAttr);
                if (descrip == null) {
                    String xLabel = ((SGTLine)datum).getXMetaData().getName();
                    lineTitle = new SGLabel("line title", xLabel, new Point2D.Double(0.0, 0.0));
                } else {
                    lineTitle = new SGLabel("line title", descrip, new Point2D.Double(0.0, 0.0));
                }
                lineTitle.setHeightP(this.keyHeight_);
                this.lineKey_.addLineGraph((LineCartesianRenderer)newGraph.getRenderer(), lineTitle);
                if (this.keyPane_ != null) {
                    Rectangle vRect = this.keyPane_.getVisibleRect();
                    int nrow = vRect.height / this.lineKey_.getRowHeight();
                    this.keyPane_.setScrollableUnitIncrement(1, this.lineKey_.getRowHeight());
                    this.keyPane_.setScrollableBlockIncrement(vRect.width, this.lineKey_.getRowHeight() * nrow);
                }
            }
        }
    }

    private SGTData flipZ(SGTData in) {
        SimpleLine out = null;
        SGTLine line = (SGTLine)in;
        double[] values = line.getYArray();
        double[] newValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = -values[i];
        }
        out = new SimpleLine(line.getXArray(), newValues, line.getTitle());
        SGTMetaData zmetain = line.getYMetaData();
        SGTMetaData zmetaout = new SGTMetaData(zmetain.getName(), zmetain.getUnits(), !zmetain.isReversed(), zmetain.isModulo());
        zmetaout.setModuloValue(zmetain.getModuloValue());
        zmetaout.setModuloTime(zmetain.getModuloTime());
        out.setXMetaData(line.getXMetaData());
        out.setYMetaData(zmetaout);
        return out;
    }

    @Override
    public void resetZoom() {
        boolean data_good = false;
        this.inZoom_ = false;
        Range2D xTotalRange = new Range2D();
        Range2D yTotalRange = new Range2D();
        boolean first = true;
        Enumeration e = this.data_.elements();
        while (e.hasMoreElements()) {
            SGTData data = (SGTData)e.nextElement();
            Range2D xRange = this.findRange((SGTLine)data, 1);
            Range2D yRange = this.findRange((SGTLine)data, 2);
            if (!((SGTLine)data).getYMetaData().isReversed()) {
                double save = yRange.start;
                yRange.start = yRange.end;
                yRange.end = save;
            }
            if (first) {
                if (Double.isNaN(xRange.start) || Double.isNaN(yRange.start)) {
                    first = true;
                    continue;
                }
                first = false;
                data_good = true;
                xTotalRange = new Range2D(xRange.start, xRange.end);
                yTotalRange = new Range2D(yRange.start, yRange.end);
                continue;
            }
            if (Double.isNaN(xRange.start) || Double.isNaN(yRange.start)) continue;
            data_good = true;
            xTotalRange.start = Math.min(xTotalRange.start, xRange.start);
            xTotalRange.end = Math.max(xTotalRange.end, xRange.end);
            if (!((SGTLine)data).getYMetaData().isReversed()) {
                yTotalRange.start = Math.max(yTotalRange.start, yRange.start);
                yTotalRange.end = Math.min(yTotalRange.end, yRange.end);
                continue;
            }
            yTotalRange.start = Math.min(yTotalRange.start, yRange.start);
            yTotalRange.end = Math.max(yTotalRange.end, yRange.end);
        }
        if (data_good) {
            try {
                this.setRange(new Domain(xTotalRange, yTotalRange), false);
            }
            catch (PropertyVetoException e2) {
                System.out.println("zoom reset denied! " + e2);
            }
        }
    }

    @Override
    public void setRange(Domain domain) throws PropertyVetoException {
        this.setRange(domain, true);
    }

    public void setRange(Domain domain, boolean testZUp) throws PropertyVetoException {
        CartesianGraph graph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform xt = (LinearTransform)graph.getXTransform();
        LinearTransform yt = (LinearTransform)graph.getYTransform();
        Domain oldRange = new Domain(xt.getRangeU(), yt.getRangeU());
        if (!domain.equals(oldRange)) {
            this.setBatch(true, "JLineProfileLayout: setRange");
            this.vetos_.fireVetoableChange("domainRange", oldRange, domain);
            this.inZoom_ = true;
            if (!domain.isXTime()) {
                this.setXRange(domain.getXRange());
            }
            if (!domain.isYTime()) {
                this.setYRange(domain.getYRange(), testZUp);
            }
            this.changes_.firePropertyChange("domainRange", oldRange, domain);
            this.setBatch(false, "JLineProfileLayout: setRange");
        }
    }

    public void setRangeNoVeto(Domain domain) {
        this.setBatch(true, "JLineProfileLayout: setRangeNoVeto");
        this.inZoom_ = true;
        this.setClipping(true);
        if (!domain.isXTime()) {
            this.setXRange(domain.getXRange());
        }
        if (!domain.isYTime()) {
            this.setYRange(domain.getYRange(), false);
        }
        this.setBatch(false, "JLineProfileLayout: setRangeNoVeto");
    }

    void setXRange(Range2D rnge) {
        CartesianGraph graph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform xt = (LinearTransform)graph.getXTransform();
        Range2D xnRange = Graph.computeRange(rnge, 6);
        xt.setRangeU(xnRange);
        PlainAxis xbot = (PlainAxis)graph.getXAxis("Bottom Axis");
        PlainAxis yleft = (PlainAxis)graph.getYAxis("Left Axis");
        if (xbot != null && yleft != null) {
            xbot.setRangeU(xnRange);
            xbot.setDeltaU(xnRange.delta);
            Range2D xr = xbot.getRangeU();
            Range2D yr = yleft.getRangeU();
            Point2D.Double origin = new Point2D.Double(xr.start, yr.start);
            xbot.setLocationU(origin);
            yleft.setLocationU(origin);
            if (this.clipping_) {
                this.setAllClip(xr.start, xr.end, yr.start, yr.end);
            } else {
                this.setAllClipping(false);
            }
        }
    }

    void setYRange(Range2D rnge) {
        this.setYRange(rnge, true);
    }

    void setYRange(Range2D rnge, boolean testZUp) {
        SGTData grid;
        CartesianGraph graph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform yt = (LinearTransform)graph.getYTransform();
        if (testZUp && this.data_.size() > 0 && !((SGTLine)(grid = (SGTData)this.data_.elements().nextElement())).getYMetaData().isReversed()) {
            double save = rnge.end;
            rnge.end = rnge.start;
            rnge.start = save;
        }
        Range2D ynRange = Graph.computeRange(rnge, 6);
        yt.setRangeU(ynRange);
        PlainAxis xbot = (PlainAxis)graph.getXAxis("Bottom Axis");
        PlainAxis yleft = (PlainAxis)graph.getYAxis("Left Axis");
        if (xbot != null && yleft != null) {
            yleft.setRangeU(ynRange);
            yleft.setDeltaU(ynRange.delta);
            Range2D xr = xbot.getRangeU();
            Range2D yr = yleft.getRangeU();
            Point2D.Double origin = new Point2D.Double(xr.start, yr.start);
            yleft.setLocationU(origin);
            xbot.setLocationU(origin);
            if (this.clipping_) {
                this.setAllClip(xr.start, xr.end, yr.start, yr.end);
            } else {
                this.setAllClipping(false);
            }
        }
    }

    public void clear() {
        this.data_.removeAllElements();
        ((CartesianGraph)this.firstLayer_.getGraph()).setRenderer(null);
        this.removeAll();
        this.add((Component)this.firstLayer_, 0);
        this.lineKey_.clearAll();
        this.inZoom_ = false;
    }

    public void clear(String data_id) {
        Layer ly = null;
        try {
            ly = this.getLayerFromDataId(data_id);
            this.remove(ly);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
        Enumeration it = this.data_.elements();
        while (it.hasMoreElements()) {
            SGTData dat = (SGTData)it.nextElement();
            if (!dat.getId().equals(data_id)) continue;
            this.data_.removeElement(dat);
        }
        this.lineKey_.clear(data_id);
        if (this.getComponentCount() <= 0 || ly.equals(this.firstLayer_)) {
            ((CartesianGraph)this.firstLayer_.getGraph()).setRenderer(null);
            this.add((Component)this.firstLayer_, 0);
        }
    }

    @Override
    public void setKeyBoundsP(Rectangle2D.Double bounds) {
        if (this.lineKey_ != null) {
            this.lineKey_.setBoundsP(bounds);
        }
    }

    @Override
    public Rectangle2D.Double getKeyBoundsP() {
        if (this.lineKey_ == null) {
            return null;
        }
        return this.lineKey_.getBoundsP();
    }

    public Dimension2D getLayerSizeP() {
        return new Dimension2D(this.xSize_, this.ySize_);
    }

    @Override
    public Layer getFirstLayer() {
        return this.firstLayer_;
    }

    public void setLayerSizeP(Dimension2D d) {
        double xpos;
        Component[] comps = this.getComponents();
        CartesianGraph graph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform yt = (LinearTransform)graph.getYTransform();
        LinearTransform xt = (LinearTransform)graph.getXTransform();
        this.xMax_ = d.width - (this.xSize_ - this.xMax_);
        this.yMax_ = d.height - (this.ySize_ - this.yMax_);
        this.xSize_ = d.width;
        this.ySize_ = d.height;
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Layer)) continue;
            ((Layer)comps[i]).setSizeP(d);
        }
        yt.setRangeP(new Range2D(this.yMin_, this.yMax_));
        xt.setRangeP(new Range2D(this.xMin_, this.xMax_));
        if (this.iconImage_ != null) {
            Rectangle bnds = this.logo_.getBounds();
            xpos = this.firstLayer_.getXDtoP(bnds.x + bnds.width) + 0.05;
        } else {
            xpos = (this.xMin_ + this.xMax_) * 0.5;
        }
        double ypos = this.ySize_ - (double)1.2f * this.mainTitleHeight_;
        this.mainTitle_.setLocationP(new Point2D.Double(xpos, ypos));
        this.title2_.setLocationP(new Point2D.Double(xpos, ypos -= (double)1.2f * this.warnHeight_));
        this.title3_.setLocationP(new Point2D.Double(xpos, ypos -= (double)1.1f * this.warnHeight_));
        if (this.keyPane_ == null) {
            this.lineKey_.setLocationP(new Point2D.Double(this.xSize_ - 0.01, this.ySize_));
        }
    }
}

