/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.MethodNotImplementedError;
import gov.noaa.pmel.sgt.demo.BeanDemo;
import gov.noaa.pmel.sgt.swing.ReShapeable;
import gov.noaa.pmel.sgt.swing.ValueIconFormat;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTValue;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;

public class MeasurementTool
implements ReShapeable {
    private static final int POINT1 = 1;
    private static final int POINT2 = 2;
    public static final int POINT_LABEL = 0;
    public static final int NO_POINT_LABEL = 1;
    public static final int DEPENDENT_POINT_LABEL = 2;
    private DragPoint x1_ = null;
    private DragPoint x2_ = null;
    private boolean selected_ = false;
    private boolean selectable_ = true;
    private boolean moved1_ = false;
    private boolean moved2_ = false;
    private Layer layer_ = null;
    private String id_ = null;
    private boolean visible_ = true;
    private boolean inReShape_ = false;
    private boolean inMove_ = false;
    private int shapePoint_ = 1;
    private Rectangle bounds_ = new Rectangle();
    private Rectangle repaintBounds_ = new Rectangle();
    private Rectangle moveBounds_ = new Rectangle();
    private Point2D.Double locX1_ = new Point2D.Double();
    private SoTPoint uLocX1_ = new SoTPoint(0.0, 0.0);
    private Point2D.Double locX2_ = new Point2D.Double();
    private SoTPoint uLocX2_ = new SoTPoint(0.0, 0.0);
    private Font font_ = new Font("Dialog", 0, 12);
    private Color textColor_ = Color.black;
    private Color lineColor_ = Color.red;
    private Color ruleColor_ = Color.blue;
    private boolean drawRule_ = true;
    private int dragRegionWidth_ = 8;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);
    private ValueIconFormat frmt_ = new ValueIconFormat("#####.##", "#.##");
    private static final String defTFrmt = "yyyy-MM-dd";
    private DecimalFormat delFrmt_ = new DecimalFormat("#.###");
    private boolean horizontal_ = false;
    private int pointLabel_ = 0;

    public MeasurementTool() {
        this.x1_ = new DragPoint(BeanDemo.class.getResource("query.gif"), "Point 1");
        this.x2_ = new DragPoint(BeanDemo.class.getResource("query.gif"), "Point 2");
        this.frmt_.setTimeFormat(defTFrmt);
    }

    public Point2D.Double getLocationPoint1P() {
        return this.locX1_;
    }

    public Point2D.Double getLocationPoint2P() {
        return this.locX2_;
    }

    public void setLocationP(Point2D.Double locX1, Point2D.Double locX2) {
        SoTPoint temp;
        this.locX1_ = locX1;
        SoTPoint pt = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.locX1_);
        if (!pt.equals(this.uLocX1_) || this.moved1_) {
            temp = new SoTPoint(pt);
            this.changes_.firePropertyChange("location", this.uLocX1_, temp);
            this.uLocX1_ = temp;
            this.moved1_ = false;
        }
        this.locX2_ = locX2;
        pt = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.locX2_);
        if (!pt.equals(this.uLocX2_) || this.moved2_) {
            temp = new SoTPoint(pt);
            this.changes_.firePropertyChange("location", this.uLocX2_, temp);
            this.uLocX2_ = temp;
            this.moved2_ = false;
        }
        this.adjustOrientation();
        this.x1_.setBounds(this.uLocX1_);
        this.x2_.setBounds(this.uLocX2_);
    }

    public SoTPoint getLocationPoint1U() {
        return this.uLocX1_;
    }

    public SoTPoint getLocationPoint2U() {
        return this.uLocX2_;
    }

    public void setLocationUNoVeto(SoTPoint locX1, SoTPoint locX2) {
        this.moved1_ = this.moved1_ || !locX1.equals(this.uLocX1_);
        this.moved2_ = this.moved2_ || !locX2.equals(this.uLocX2_);
        this.uLocX1_ = locX1;
        this.uLocX2_ = locX2;
        this.locX1_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLocX1_.getX());
        this.locX1_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLocX1_.getY());
        this.locX2_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLocX2_.getX());
        this.locX2_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLocX2_.getY());
        this.x1_.setBounds(this.uLocX1_);
        this.x2_.setBounds(this.uLocX2_);
    }

    public void setLocationU(SoTPoint locX1, SoTPoint locX2) throws PropertyVetoException {
        if (!locX1.equals(this.uLocX1_) || this.moved1_) {
            this.vetos_.fireVetoableChange("locationX1", this.uLocX1_, locX1);
            this.changes_.firePropertyChange("locationX1", this.uLocX1_, locX1);
            this.uLocX1_ = locX1;
            this.moved1_ = false;
            this.locX1_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLocX1_.getX());
            this.locX1_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLocX1_.getY());
        }
        if (!locX2.equals(this.uLocX2_) || this.moved2_) {
            this.vetos_.fireVetoableChange("locationX2", this.uLocX2_, locX2);
            this.changes_.firePropertyChange("locationX2", this.uLocX2_, locX2);
            this.uLocX2_ = locX2;
            this.moved2_ = false;
            this.locX2_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLocX2_.getX());
            this.locX2_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLocX2_.getY());
        }
        this.adjustOrientation();
        this.x1_.setBounds(this.uLocX1_);
        this.x2_.setBounds(this.uLocX2_);
    }

    public int getPointLabel() {
        return this.pointLabel_;
    }

    public void setPointLabel(int pointLabel) {
        this.pointLabel_ = pointLabel;
    }

    public void setValueFormat(ValueIconFormat vf) {
        this.frmt_ = vf;
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.removeVetoableChangeListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    @Override
    public void adjustShape(MouseEvent e, Point loc, Point delta) {
        this.adjustShape(e, loc, delta, true);
    }

    @Override
    public void adjustShape(MouseEvent e, Point loc, Point delta, boolean fireEvent) {
        int ymouse;
        if (this.inReShape_) {
            this.reShape(this.shapePoint_, loc, delta, fireEvent);
            return;
        }
        if (this.inMove_) {
            this.setLocation(loc, fireEvent);
            return;
        }
        int xmouse = e.getX();
        if (this.x1_.contains(xmouse, ymouse = e.getY())) {
            this.inReShape_ = true;
            this.shapePoint_ = 1;
            this.reShape(this.shapePoint_, loc, delta, fireEvent);
        } else if (this.x2_.contains(xmouse, ymouse)) {
            this.inReShape_ = true;
            this.shapePoint_ = 2;
            this.reShape(this.shapePoint_, loc, delta, fireEvent);
        } else if (this.moveBounds_.contains(xmouse, ymouse)) {
            this.inMove_ = true;
            this.setLocation(loc, fireEvent);
        }
    }

    private void reShape(int point, Point loc, Point delta, boolean fireEvent) {
        Point2D.Double pt = null;
        this.locX1_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLocX1_.getX());
        this.locX1_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLocX1_.getY());
        this.locX2_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLocX2_.getX());
        this.locX2_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLocX2_.getY());
        switch (point) {
            case 1: {
                int dx1 = ((CartesianGraph)this.layer_.getGraph()).getXUtoD(this.uLocX1_.getX()) - this.bounds_.x;
                int dy1 = ((CartesianGraph)this.layer_.getGraph()).getYUtoD(this.uLocX1_.getY()) - this.bounds_.y;
                pt = new Point2D.Double(this.locX1_.x, this.locX1_.y);
                Rectangle bnds = this.x1_.getBounds();
                if (this.horizontal_) {
                    int saved = bnds.x;
                    bnds.x += delta.x;
                    pt.x = this.locX1_.x = this.layer_.getXDtoP(bnds.x + bnds.width / 2);
                    pt.y = this.layer_.getYDtoP(loc.y + dy1 + bnds.height / 2);
                    this.moved1_ = this.moved1_ || saved != bnds.x;
                } else {
                    int saved = bnds.y;
                    bnds.y += delta.y;
                    this.locX1_.y = this.layer_.getYDtoP(bnds.y + bnds.height / 2);
                    pt.x = this.layer_.getXDtoP(loc.x + dx1 + bnds.width / 2);
                    pt.y = this.locX1_.y;
                    this.moved1_ = this.moved1_ || saved != bnds.y;
                }
                this.adjustOrientation(pt, this.locX2_);
                this.locX1_ = pt;
                this.uLocX1_.setY(((CartesianGraph)this.layer_.getGraph()).getYPtoSoT(this.locX1_.y));
                this.uLocX1_.setX(((CartesianGraph)this.layer_.getGraph()).getXPtoSoT(this.locX1_.x));
                this.x1_.setBounds(this.uLocX1_);
                if (!fireEvent || !this.moved1_) break;
                this.changes_.firePropertyChange("locationPoint1", null, this.uLocX1_);
                this.moved1_ = false;
                break;
            }
            case 2: {
                int dx2 = ((CartesianGraph)this.layer_.getGraph()).getXUtoD(this.uLocX2_.getX()) - this.bounds_.x;
                int dy2 = ((CartesianGraph)this.layer_.getGraph()).getYUtoD(this.uLocX2_.getY()) - this.bounds_.y;
                pt = new Point2D.Double(this.locX2_.x, this.locX2_.y);
                Rectangle bnds = this.x2_.getBounds();
                if (this.horizontal_) {
                    int saved = bnds.x;
                    bnds.x += delta.x;
                    pt.x = this.locX2_.x = this.layer_.getXDtoP(bnds.x + bnds.width / 2);
                    pt.y = this.layer_.getYDtoP(loc.y + dy2 + bnds.height / 2);
                    this.moved2_ = this.moved2_ || saved != bnds.x;
                } else {
                    int saved = bnds.y;
                    bnds.y += delta.y;
                    this.locX2_.y = this.layer_.getYDtoP(bnds.y + bnds.height / 2);
                    pt.x = this.layer_.getXDtoP(loc.x + dx2 + bnds.width / 2);
                    pt.y = this.locX2_.y;
                    this.moved2_ = this.moved2_ || saved != bnds.y;
                }
                this.adjustOrientation(pt, this.locX1_);
                this.locX2_ = pt;
                this.uLocX2_.setY(((CartesianGraph)this.layer_.getGraph()).getYPtoSoT(this.locX2_.y));
                this.uLocX2_.setX(((CartesianGraph)this.layer_.getGraph()).getXPtoSoT(this.locX2_.x));
                this.x2_.setBounds(this.uLocX2_);
                if (!fireEvent || !this.moved2_) break;
                this.changes_.firePropertyChange("locationPoint2", null, this.uLocX2_);
                this.moved2_ = false;
            }
        }
    }

    @Override
    public void adjustShapeNoVeto(MouseEvent e, int x, int y, int dx, int dy) {
        throw new MethodNotImplementedError("NoVeto adjust not implemented");
    }

    @Override
    public void reset() {
        this.inReShape_ = false;
        this.inMove_ = false;
    }

    @Override
    public void setLocation(Point loc) {
        this.setLocation(loc, true);
    }

    @Override
    public void setLocation(Point loc, boolean fireEvent) {
        this.moveTool(loc.x, loc.y, fireEvent);
    }

    @Override
    public void setLocationNoVeto(int x, int y) {
        this.moveTool(x, y, false);
    }

    private void moveTool(int x, int y, boolean fireEvent) {
        int dx1 = ((CartesianGraph)this.layer_.getGraph()).getXUtoD(this.uLocX1_.getX()) - this.bounds_.x;
        int dy1 = ((CartesianGraph)this.layer_.getGraph()).getYUtoD(this.uLocX1_.getY()) - this.bounds_.y;
        int dx2 = ((CartesianGraph)this.layer_.getGraph()).getXUtoD(this.uLocX2_.getX()) - this.bounds_.x;
        int dy2 = ((CartesianGraph)this.layer_.getGraph()).getYUtoD(this.uLocX2_.getY()) - this.bounds_.y;
        Point2D.Double save1 = new Point2D.Double(this.locX1_.x, this.locX1_.y);
        Point2D.Double save2 = new Point2D.Double(this.locX2_.x, this.locX2_.y);
        this.locX1_.x = this.layer_.getXDtoP(x + dx1);
        this.locX1_.y = this.layer_.getYDtoP(y + dy1);
        this.locX2_.x = this.layer_.getXDtoP(x + dx2);
        this.locX2_.y = this.layer_.getYDtoP(y + dy2);
        this.uLocX1_.setX(((CartesianGraph)this.layer_.getGraph()).getXPtoSoT(this.locX1_.x));
        this.uLocX1_.setY(((CartesianGraph)this.layer_.getGraph()).getYPtoSoT(this.locX1_.y));
        this.uLocX2_.setX(((CartesianGraph)this.layer_.getGraph()).getXPtoSoT(this.locX2_.x));
        this.uLocX2_.setY(((CartesianGraph)this.layer_.getGraph()).getYPtoSoT(this.locX2_.y));
        boolean bl = this.moved1_ = this.moved1_ || save1.x != this.locX1_.x || save1.y != this.locX1_.y;
        if (fireEvent && this.moved1_) {
            this.changes_.firePropertyChange("locationPoint1", null, this.uLocX1_);
            this.moved1_ = false;
        }
        boolean bl2 = this.moved2_ = this.moved2_ || save2.x != this.locX2_.x || save2.y != this.locX2_.y;
        if (fireEvent && this.moved2_) {
            this.changes_.firePropertyChange("locationPoint2", null, this.uLocX2_);
            this.moved2_ = false;
        }
    }

    @Override
    public LayerChild copy() {
        return null;
    }

    @Override
    public void draw(Graphics g) throws LayerNotFoundException {
        this.x1_.setBounds(this.uLocX1_);
        this.x2_.setBounds(this.uLocX2_);
        int x1 = ((CartesianGraph)this.layer_.getGraph()).getXUtoD(this.uLocX1_.getX());
        int y1 = ((CartesianGraph)this.layer_.getGraph()).getYUtoD(this.uLocX1_.getY());
        int x2 = ((CartesianGraph)this.layer_.getGraph()).getXUtoD(this.uLocX2_.getX());
        int y2 = ((CartesianGraph)this.layer_.getGraph()).getYUtoD(this.uLocX2_.getY());
        int wid = this.x1_.getIconWidth();
        int hgt = this.x1_.getIconHeight();
        this.bounds_.x = x1 - wid / 2;
        this.bounds_.y = y1 - hgt / 2;
        this.bounds_.width = x2 - x1 + wid + 2;
        this.bounds_.height = y2 - y1 + hgt + 2;
        if (this.bounds_.width < 0 || this.bounds_.height < 0) {
            this.bounds_.x = x2 - wid / 2;
            this.bounds_.y = y2 - hgt / 2;
            this.bounds_.width = x1 - x2 + wid + 2;
            this.bounds_.height = y1 - y2 + hgt + 2;
        }
        if (this.visible_) {
            Color saved = g.getColor();
            g.setColor(this.lineColor_);
            g.drawLine(x1, y1, x2, y2);
            int halfWidth = this.dragRegionWidth_ / 2;
            if (this.horizontal_) {
                g.drawLine(x1, y1 - 1, x2, y2 - 1);
                this.moveBounds_.x = x1;
                this.moveBounds_.width = x2 - x1;
                this.moveBounds_.y = y1 - halfWidth;
                this.moveBounds_.height = this.dragRegionWidth_;
            } else {
                g.drawLine(x1 - 1, y1, x2 - 1, y2);
                this.moveBounds_.x = x1 - halfWidth;
                this.moveBounds_.width = this.dragRegionWidth_;
                this.moveBounds_.y = y1;
                this.moveBounds_.height = y2 - y1;
            }
            this.fixBounds(this.moveBounds_);
            this.x1_.paintIcon(this.layer_.getPane().getComponent(), g, x1 - wid / 2, y1 - hgt / 2);
            this.x2_.paintIcon(this.layer_.getPane().getComponent(), g, x2 - wid / 2, y2 - hgt / 2);
            if (this.drawRule_) {
                Rectangle bnds = ((CartesianGraph)this.layer_.getGraph()).getBounds();
                g.setColor(this.ruleColor_);
                if (this.horizontal_) {
                    g.drawLine(x1, bnds.y, x1, bnds.y + bnds.height);
                    g.drawLine(x2, bnds.y, x2, bnds.y + bnds.height);
                    this.repaintBounds_ = x2 > x1 ? new Rectangle(x1, 0, x2 - x1, this.layer_.getSize().height) : new Rectangle(x2, 0, x1 - x2, this.layer_.getSize().height);
                } else {
                    g.drawLine(bnds.x, y1, bnds.x + bnds.width, y1);
                    g.drawLine(bnds.x, y2, bnds.x + bnds.width, y2);
                    this.repaintBounds_ = y2 > y1 ? new Rectangle(0, y1, this.layer_.getSize().width, y2 - y1) : new Rectangle(0, y2, this.layer_.getSize().width, y1 - y2);
                }
            }
            if (this.horizontal_) {
                this.bounds_.add(this.drawLabel(g, this.uLocX1_, x1 + 1, y1 + hgt / 3 + 1));
                this.bounds_.add(this.drawLabel(g, this.uLocX2_, x2 + 1, y2 + hgt / 3 + 1));
                this.bounds_.add(this.drawDelta(g, (x1 + x2) / 2, y1 - 3));
            } else {
                this.bounds_.add(this.drawLabel(g, this.uLocX1_, x1 + wid / 2 + 1, y1 + hgt / 3));
                this.bounds_.add(this.drawLabel(g, this.uLocX2_, x2 + wid / 2 + 1, y2 + hgt / 3));
                this.bounds_.add(this.drawDelta(g, x1 - 3, (y1 + y2) / 2));
            }
            if (this.drawRule_) {
                this.repaintBounds_.add(this.bounds_);
            }
            g.setColor(saved);
        }
    }

    private Rectangle drawLabel(Graphics g, SoTPoint pt, int x, int y) {
        String text = null;
        Rectangle rect = null;
        switch (this.pointLabel_) {
            case 1: {
                return new Rectangle(this.bounds_);
            }
            case 0: {
                text = this.frmt_.format(pt);
                break;
            }
            case 2: {
                if (this.horizontal_) {
                    SoTValue xv = pt.getX();
                    if (xv.isTime()) {
                        text = this.frmt_.formatTime(xv.getGeoDate());
                        break;
                    }
                    text = this.frmt_.formatX(xv.getDouble());
                    break;
                }
                SoTValue yv = pt.getY();
                text = yv.isTime() ? this.frmt_.formatTime(yv.getGeoDate()) : this.frmt_.formatY(yv.getDouble());
            }
        }
        FontMetrics fmet = g.getFontMetrics();
        int wid = fmet.stringWidth(text);
        int hgt = fmet.getMaxAscent() + fmet.getMaxDescent();
        g.setFont(this.font_);
        Color bk = this.layer_.getPane().getComponent().getBackground();
        g.setColor(new Color(bk.getRed(), bk.getGreen(), bk.getBlue(), 200));
        if (this.horizontal_) {
            rect = new Rectangle(x - wid / 2, y - fmet.getMaxAscent() + hgt, wid, hgt);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setColor(this.textColor_);
            g.drawString(text, x - wid / 2, y + hgt);
        } else {
            rect = new Rectangle(x, y - fmet.getMaxAscent(), wid, hgt);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setColor(this.textColor_);
            g.drawString(text, x, y);
        }
        return rect;
    }

    private Rectangle drawDelta(Graphics g, int x, int y) {
        Rectangle rect = null;
        String suffix = "";
        double delta = 0.0;
        FontMetrics fmet = g.getFontMetrics();
        int hgt = fmet.getMaxAscent() + fmet.getMaxDescent();
        g.setFont(this.font_);
        Color bk = this.layer_.getPane().getComponent().getBackground();
        g.setColor(new Color(bk.getRed(), bk.getGreen(), bk.getBlue(), 200));
        delta = this.getDelta();
        if (this.horizontal_) {
            if (this.uLocX1_.getX().isTime()) {
                suffix = " hrs";
                if (delta > 4320.0) {
                    delta /= 8766.0;
                    suffix = " yrs";
                } else if (delta > 72.0) {
                    delta /= 24.0;
                    suffix = " days";
                }
            }
        } else if (this.uLocX1_.getY().isTime()) {
            suffix = " hrs";
            if (delta > 4320.0) {
                delta /= 8766.0;
                suffix = " yrs";
            } else if (delta > 72.0) {
                delta /= 24.0;
                suffix = " days";
            }
        }
        String text = "[" + this.delFrmt_.format(delta) + suffix + "]";
        int wid = fmet.stringWidth(text);
        if (this.horizontal_) {
            rect = new Rectangle(x - wid / 2, y - fmet.getMaxAscent() - 1, wid, hgt);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setColor(this.textColor_);
            g.drawString(text, x - wid / 2, y - 1);
        } else {
            rect = new Rectangle(x - wid, y - fmet.getMaxAscent(), wid, hgt);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setColor(this.textColor_);
            g.drawString(text, x - wid, y);
        }
        return rect;
    }

    public double getDelta() {
        double delta = 0.0;
        if (this.horizontal_) {
            SoTValue x1 = this.uLocX1_.getX();
            SoTValue x2 = this.uLocX2_.getX();
            if (x1.isTime()) {
                long del = Math.abs(x1.getLongTime() - x2.getLongTime());
                delta = (double)del / 3600000.0;
            } else {
                delta = Math.abs(x1.getDouble() - x2.getDouble());
            }
        } else {
            SoTValue y1 = this.uLocX1_.getY();
            SoTValue y2 = this.uLocX2_.getY();
            if (y1.isTime()) {
                long del = Math.abs(y1.getLongTime() - y2.getLongTime());
                delta = (double)del / 3600000.0;
            } else {
                delta = Math.abs(y1.getDouble() - y2.getDouble());
            }
        }
        return delta;
    }

    private void adjustOrientation() {
        double dely;
        double delx = Math.abs(this.locX1_.x - this.locX2_.x);
        if (delx > (dely = Math.abs(this.locX1_.y - this.locX2_.y))) {
            this.horizontal_ = true;
            this.locX2_.y = this.locX1_.y;
            this.uLocX2_.setY(this.uLocX1_.getY());
        } else {
            this.horizontal_ = false;
            this.locX2_.x = this.locX1_.x;
            this.uLocX2_.setX(this.uLocX1_.getX());
        }
    }

    private void adjustOrientation(Point2D.Double pt1, Point2D.Double pt2) {
        double dely;
        double delx = Math.abs(pt1.x - pt2.x);
        if (delx > (dely = Math.abs(pt1.y - pt2.y))) {
            this.horizontal_ = true;
            pt1.y = pt2.y;
        } else {
            this.horizontal_ = false;
            pt1.x = pt2.x;
        }
    }

    private void fixBounds(Rectangle b) {
        if (b.width < 0) {
            b.x = b.width + b.x;
            b.width = -b.width;
        }
        if (b.height < 0) {
            b.y = b.height + b.y;
            b.height = -b.height;
        }
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public Layer getLayer() {
        return this.layer_;
    }

    @Override
    public JPane getPane() {
        return this.layer_.getPane();
    }

    @Override
    public boolean isVisible() {
        return this.visible_;
    }

    @Override
    public void modified(String mess) {
        if (this.layer_ != null) {
            this.layer_.modified(mess);
        }
    }

    @Override
    public void setId(String id) {
        this.id_ = id;
    }

    @Override
    public void setLayer(Layer l) {
        this.layer_ = l;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible_ = visible;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds_;
    }

    @Override
    public Rectangle getRepaintBounds() {
        if (this.drawRule_) {
            return this.repaintBounds_;
        }
        return this.bounds_;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public String toString() {
        return "MeasurementTool: " + this.id_;
    }

    @Override
    public boolean contains(Point pt) {
        return this.contains(pt.x, pt.y);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.x1_.contains(x, y) || this.x2_.contains(x, y) || this.moveBounds_.contains(x, y);
    }

    public Font getFont() {
        return this.font_;
    }

    public void setFont(Font font) {
        this.font_ = font;
    }

    public Color getLineColor() {
        return this.lineColor_;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor_ = lineColor;
    }

    public Color getRuleColor() {
        return this.ruleColor_;
    }

    public void setRuleColor(Color ruleColor) {
        this.ruleColor_ = ruleColor;
    }

    public boolean isDrawRule() {
        return this.drawRule_;
    }

    public void setDrawRule(boolean showRule) {
        this.drawRule_ = showRule;
    }

    public Color getTextColor() {
        return this.textColor_;
    }

    public void setTextColor(Color textColor) {
        this.textColor_ = textColor;
    }

    @Override
    public void setInMove(boolean im) {
        this.inMove_ = im;
    }

    @Override
    public void setInReShape(boolean irs) {
        this.inReShape_ = irs;
    }

    public int getDragRegionWidth() {
        return this.dragRegionWidth_;
    }

    public void setDragRegionWidth(int dragRegionWidth) {
        this.dragRegionWidth_ = dragRegionWidth;
    }

    @Override
    public boolean inMoveRegion(MouseEvent sme) {
        return this.bounds_.contains(sme.getX(), sme.getY());
    }

    @Override
    public boolean inReShapeRegion(MouseEvent sme) {
        return this.x1_.contains(sme.getX(), sme.getY()) || this.x2_.contains(sme.getX(), sme.getY());
    }

    @Override
    public int getCursor(MouseEvent sme) {
        int y;
        int x = sme.getX();
        if (this.bounds_.contains(x, y = sme.getY())) {
            if (this.x1_.contains(x, y)) {
                if (this.horizontal_) {
                    return 10;
                }
                return 8;
            }
            if (this.x2_.contains(x, y)) {
                if (this.horizontal_) {
                    return 10;
                }
                return 8;
            }
            return 12;
        }
        return 0;
    }

    class DragPoint
    extends ImageIcon {
        private Rectangle bounds;

        public DragPoint(URL url, String description) {
            super(url, description);
            this.bounds = new Rectangle();
        }

        public boolean contains(int x, int y) {
            return this.bounds.contains(x, y);
        }

        public void setBounds(SoTPoint pt) {
            int wid = this.getIconWidth();
            int hgt = this.getIconHeight();
            this.bounds.x = ((CartesianGraph)MeasurementTool.this.layer_.getGraph()).getXUtoD(pt.getX()) - wid / 2;
            this.bounds.y = ((CartesianGraph)MeasurementTool.this.layer_.getGraph()).getYUtoD(pt.getY()) - hgt / 2;
            this.bounds.width = wid;
            this.bounds.height = hgt;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }
    }
}

