/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.PlotMark;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class PlotMarkIcon
extends PlotMark
implements Icon {
    private int size_;
    private double scale_;
    private Color markColor_ = null;

    public PlotMarkIcon(int mark, int size) {
        super(mark);
        this.setSize(size);
    }

    public PlotMarkIcon(int mark) {
        this(mark, 16);
    }

    public void setSize(int size) {
        this.size_ = size;
        this.scale_ = (double)this.size_ / 8.0;
    }

    public int getSize() {
        return this.size_;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int count;
        if (this.markColor_ != null) {
            g.setColor(this.markColor_);
        } else {
            g.setColor(c.getForeground());
        }
        if (this.circle_) {
            int xt = (int)(this.scale_ * 2.0) + x;
            int yt = (int)(this.scale_ * 2.0) + y;
            int w = (int)(this.scale_ * 4.0);
            if (this.fill_) {
                g.fillOval(xt, yt, w, w);
                if (this.outline_) {
                    Color save = g.getColor();
                    g.setColor(this.outlineColor_);
                    g.drawOval(xt, yt, w, w);
                    g.setColor(save);
                }
            } else {
                g.drawOval(xt, yt, w, w);
            }
            return;
        }
        int[] xl = new int[this.lastPoint_ - this.firstPoint_];
        int[] yl = new int[this.lastPoint_ - this.firstPoint_];
        int xtOld = x;
        int ytOld = y;
        int i = 0;
        if (this.newMark_) {
            for (count = this.firstPoint_; count < this.lastPoint_; ++count) {
                xl[i] = (int)(this.scale_ * (newMarkTable[count][0] + 4.0)) + x;
                yl[i] = (int)(this.scale_ * (newMarkTable[count][1] + 4.0)) + y;
                ++i;
            }
        } else {
            boolean penf = false;
            for (count = this.firstPoint_; count < this.lastPoint_; ++count) {
                int ib = table[count];
                if (ib == 0) {
                    penf = false;
                    continue;
                }
                int movex = (ib >> 3) + 1;
                int movey = 7 - (ib & 7);
                int xt = (int)(this.scale_ * (double)movex) + x;
                int yt = (int)(this.scale_ * (double)movey) + y;
                if (penf) {
                    if (this.fill_) {
                        xl[i] = xt;
                        yl[i] = yt;
                        ++i;
                    } else {
                        g.drawLine(xtOld, ytOld, xt, yt);
                    }
                }
                penf = true;
                xtOld = xt;
                ytOld = yt;
            }
        }
        if (this.fill_) {
            g.fillPolygon(xl, yl, i);
            if (this.outline_) {
                Color save = g.getColor();
                g.setColor(this.outlineColor_);
                g.drawPolygon(xl, yl, i);
                g.setColor(save);
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.size_;
    }

    @Override
    public int getIconHeight() {
        return this.size_;
    }

    public void setMarkColor(Color markColor) {
        this.markColor_ = markColor;
    }

    public Color getMarkColor() {
        return this.markColor_;
    }

    @Override
    public String toString() {
        return "PlotMarkIcon: " + this.mark_;
    }

    public static void main(String[] args) {
    }
}

