/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.swing.DefaultSelectionHandle;
import gov.noaa.pmel.sgt.swing.ReShapeable;
import gov.noaa.pmel.sgt.swing.SelectionHandle;
import gov.noaa.pmel.sgt.swing.SliderSelectionHandle;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTDomain;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;

public class SelectionTool
implements ReShapeable {
    private int handleWidth_ = 6;
    private int handleHeight_ = 12;
    private boolean handleFullSized_ = false;
    private boolean selected_ = false;
    private boolean selectable_ = true;
    private boolean moved_ = false;
    private Layer layer_ = null;
    private String id_ = null;
    private boolean visible_ = true;
    private Rectangle bounds_ = new Rectangle();
    private Rectangle selectionBounds_ = new Rectangle();
    private Rectangle repaintBounds_ = new Rectangle();
    private Point2D.Double locUL_ = new Point2D.Double();
    private SoTPoint uLocUL_ = new SoTPoint(0.0, 0.0);
    private Point2D.Double locLR_ = new Point2D.Double();
    private SoTPoint uLocLR_ = new SoTPoint(0.0, 0.0);
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);
    private Color lineColor = Color.black;
    private Color grabColor = Color.red;
    private Color selectColor = new Color(1.0f, 1.0f, 0.0f, 0.5f);
    private boolean inReShape_ = false;
    private boolean inMove_ = false;
    private int shapeType = 0;
    private SoTPoint constraintsUL_ = null;
    private SoTPoint constraintsLR_ = null;
    private boolean fullYRange_ = false;
    private boolean fullXRange_ = false;
    private boolean newStyle_ = false;
    private ArrayList handles_ = new ArrayList();
    private int handleMask_ = 3;

    public SelectionTool(int handles) {
        this(handles, false);
    }

    public SelectionTool(int handles, boolean newStyle) {
        this.handleMask_ = handles;
        this.newStyle_ = newStyle;
        this.updateHandles();
    }

    public Container getParent() {
        return this.layer_.getParent();
    }

    private void updateHandles() {
        if (this.handleMask_ > 0) {
            this.handles_.clear();
            int temp = this.handleMask_;
            for (int i = 0; i < 8; ++i) {
                if ((temp & 1) == 1) {
                    switch (i) {
                        case 0: {
                            if (this.newStyle_) {
                                this.handles_.add(new SliderSelectionHandle(this, 1));
                                break;
                            }
                            this.handles_.add(new DefaultSelectionHandle(this.handleFullSized_, 1, this.handleWidth_, this.handleHeight_));
                            break;
                        }
                        case 1: {
                            if (this.newStyle_) {
                                this.handles_.add(new SliderSelectionHandle(this, 2));
                                break;
                            }
                            this.handles_.add(new DefaultSelectionHandle(this.handleFullSized_, 2, this.handleWidth_, this.handleHeight_));
                            break;
                        }
                        case 2: {
                            this.handles_.add(new DefaultSelectionHandle(this.handleFullSized_, 4, this.handleHeight_, this.handleWidth_));
                            break;
                        }
                        case 3: {
                            this.handles_.add(new DefaultSelectionHandle(this.handleFullSized_, 8, this.handleHeight_, this.handleWidth_));
                            break;
                        }
                        case 4: {
                            this.handles_.add(new DefaultSelectionHandle(this.handleFullSized_, 16, this.handleHeight_ * 2 / 3, this.handleHeight_ * 2 / 3));
                            break;
                        }
                        case 5: {
                            this.handles_.add(new DefaultSelectionHandle(this.handleFullSized_, 32, this.handleHeight_ * 2 / 3, this.handleHeight_ * 2 / 3));
                            break;
                        }
                        case 6: {
                            this.handles_.add(new DefaultSelectionHandle(this.handleFullSized_, 64, this.handleHeight_ * 2 / 3, this.handleHeight_ * 2 / 3));
                            break;
                        }
                        case 7: {
                            this.handles_.add(new DefaultSelectionHandle(this.handleFullSized_, 128, this.handleHeight_ * 2 / 3, this.handleHeight_ * 2 / 3));
                        }
                    }
                }
                temp >>= 1;
            }
        }
    }

    @Override
    public void setInReShape(boolean irs) {
        this.inReShape_ = irs;
    }

    @Override
    public void setInMove(boolean im) {
        this.inMove_ = im;
    }

    @Override
    public void reset() {
        this.inReShape_ = false;
        this.inMove_ = false;
    }

    public Point2D.Double getLocationUpperLeftP() {
        return this.locUL_;
    }

    public Point2D.Double getLocationLowerRightP() {
        return this.locLR_;
    }

    public void setLocationP(Point2D.Double locUL, Point2D.Double locLR) {
        SoTPoint temp;
        this.locUL_ = locUL;
        SoTPoint pt = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.locUL_);
        if (!pt.equals(this.uLocUL_) || this.moved_) {
            temp = new SoTPoint(pt);
            this.changes_.firePropertyChange("location", this.uLocUL_, temp);
            this.uLocUL_ = temp;
            this.moved_ = false;
        }
        this.locLR_ = locLR;
        pt = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.locLR_);
        if (!pt.equals(this.uLocLR_) || this.moved_) {
            temp = new SoTPoint(pt);
            this.changes_.firePropertyChange("location", this.uLocLR_, temp);
            this.uLocLR_ = temp;
            this.moved_ = false;
        }
        this.setBoundsP(this.locUL_, this.locLR_);
    }

    public SoTPoint getLocationUpperLeftU() {
        return this.uLocUL_;
    }

    public SoTPoint getLocationLowerRightU() {
        return this.uLocLR_;
    }

    public void setLocationUNoVeto(SoTPoint locUL, SoTPoint locLR) {
        this.moved_ = this.moved_ || !locUL.equals(this.uLocUL_) || !locLR.equals(this.uLocLR_);
        this.uLocUL_ = locUL;
        this.uLocLR_ = locLR;
        this.locUL_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLocUL_.getX());
        this.locUL_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLocUL_.getY());
        this.locLR_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLocLR_.getX());
        this.locLR_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLocLR_.getY());
        this.setBoundsP(this.locUL_, this.locLR_);
    }

    public void setLocationU(SoTPoint locUL, SoTPoint locLR) throws PropertyVetoException {
        if (!locUL.equals(this.uLocUL_) || this.moved_) {
            this.vetos_.fireVetoableChange("locationUL", this.uLocUL_, locUL);
            this.changes_.firePropertyChange("locationUL", this.uLocUL_, locUL);
            this.uLocUL_ = locUL;
            this.moved_ = false;
            this.locUL_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLocUL_.getX());
            this.locUL_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLocUL_.getY());
        }
        if (!locLR.equals(this.uLocLR_) || this.moved_) {
            this.vetos_.fireVetoableChange("locationLR", this.uLocLR_, locLR);
            this.changes_.firePropertyChange("locationLR", this.uLocLR_, locLR);
            this.uLocLR_ = locLR;
            this.moved_ = false;
            this.locLR_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLocLR_.getX());
            this.locLR_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLocLR_.getY());
        }
        this.setBoundsP(this.locUL_, this.locLR_);
    }

    public void setBoundsP(Point2D.Double locUL, Point2D.Double locLR) {
        this.selectionBounds_.x = this.layer_.getXPtoD(locUL.x);
        this.selectionBounds_.y = this.layer_.getYPtoD(locUL.y);
        int x2 = this.layer_.getXPtoD(locLR.x);
        int y2 = this.layer_.getYPtoD(locLR.y);
        this.selectionBounds_.width = x2 - this.selectionBounds_.x;
        this.selectionBounds_.height = y2 - this.selectionBounds_.y;
    }

    public void setBounds(int xUL, int yUL, int xLR, int yLR) {
        this.selectionBounds_.x = xUL;
        this.selectionBounds_.y = yUL;
        this.selectionBounds_.width = xLR - xUL;
        this.selectionBounds_.height = yLR - yUL;
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.removeVetoableChangeListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    @Override
    public LayerChild copy() {
        return null;
    }

    private void setToFullRange() {
        SoTDomain d = ((CartesianGraph)this.layer_.getGraph()).getDomain();
        if (this.fullXRange_) {
            SoTRange xr = d.getXRange();
            this.uLocUL_.setX(xr.getStart());
            this.uLocLR_.setX(xr.getEnd());
        } else if (this.fullYRange_) {
            SoTRange yr = d.getYRange();
            this.uLocUL_.setY(yr.getEnd());
            this.uLocLR_.setY(yr.getStart());
        }
    }

    private void computeBounds() {
        Rectangle rect = new Rectangle();
        int x = ((CartesianGraph)this.layer_.getGraph()).getXUtoD(this.uLocUL_.getX());
        int y = ((CartesianGraph)this.layer_.getGraph()).getYUtoD(this.uLocUL_.getY());
        int x2 = ((CartesianGraph)this.layer_.getGraph()).getXUtoD(this.uLocLR_.getX());
        int y2 = ((CartesianGraph)this.layer_.getGraph()).getYUtoD(this.uLocLR_.getY());
        rect.x = x;
        rect.y = y;
        rect.width = x2 - x;
        rect.height = y2 - y;
        this.repaintBounds_ = new Rectangle(rect);
        this.bounds_ = new Rectangle(rect);
        for (SelectionHandle hndl : this.handles_) {
            this.repaintBounds_.add(hndl.getBounds(rect));
            this.bounds_.add(hndl.getSelectionBounds(rect));
        }
        this.selectionBounds_ = rect;
    }

    @Override
    public void draw(Graphics g) throws LayerNotFoundException {
        if (this.fullXRange_ || this.fullYRange_) {
            this.setToFullRange();
        }
        this.computeBounds();
        int[] xl = new int[4];
        int[] yl = new int[4];
        xl[0] = this.selectionBounds_.x;
        xl[1] = this.selectionBounds_.x + this.selectionBounds_.width;
        xl[2] = this.selectionBounds_.x + this.selectionBounds_.width;
        xl[3] = this.selectionBounds_.x;
        yl[0] = this.selectionBounds_.y + this.selectionBounds_.height;
        yl[1] = this.selectionBounds_.y + this.selectionBounds_.height;
        yl[2] = this.selectionBounds_.y;
        yl[3] = this.selectionBounds_.y;
        if (this.visible_) {
            Color save = g.getColor();
            g.setColor(this.selectColor);
            g.fillPolygon(xl, yl, 4);
            g.setColor(this.lineColor);
            g.drawPolygon(xl, yl, 4);
            g.setColor(this.grabColor);
            for (SelectionHandle hndl : this.handles_) {
                hndl.draw(g, this.selectionBounds_);
            }
            g.setColor(save);
        }
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public Layer getLayer() {
        return this.layer_;
    }

    @Override
    public JPane getPane() {
        return this.layer_.getPane();
    }

    @Override
    public boolean isVisible() {
        return this.visible_;
    }

    @Override
    public void modified(String mess) {
        if (this.layer_ != null) {
            this.layer_.modified(mess);
        }
    }

    @Override
    public void setId(String id) {
        this.id_ = id;
    }

    @Override
    public void setLayer(Layer l) {
        this.layer_ = l;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible_ = visible;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds_;
    }

    @Override
    public Rectangle getRepaintBounds() {
        return this.repaintBounds_;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public String toString() {
        return "SelectionTool: " + this.id_;
    }

    @Override
    public boolean contains(Point pt) {
        return this.contains(pt.x, pt.y);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    @Override
    public void setLocation(Point loc) {
        this.setLocation(loc, true);
    }

    @Override
    public void setLocation(Point loc, boolean fireEvent) {
        this.moveSelection(loc.x, loc.y, fireEvent);
    }

    @Override
    public void setLocationNoVeto(int x, int y) {
        this.moveSelection(x, y, false);
    }

    private void moveSelection(int x, int y, boolean fireEvent) {
        Point2D.Double locUL = null;
        Point2D.Double locLR = null;
        boolean newpoint = false;
        boolean moveOK = false;
        int xUL = x;
        int yUL = y;
        int xLR = this.selectionBounds_.width + x;
        int yLR = this.selectionBounds_.height + y;
        locUL = new Point2D.Double(this.layer_.getXDtoP(xUL), this.layer_.getYDtoP(yUL));
        SoTPoint ptUL = ((CartesianGraph)this.layer_.getGraph()).getPtoU(locUL);
        locLR = new Point2D.Double(this.layer_.getXDtoP(xLR), this.layer_.getYDtoP(yLR));
        SoTPoint ptLR = ((CartesianGraph)this.layer_.getGraph()).getPtoU(locLR);
        if (this.isConstraintsXOK(ptUL, ptLR) && !this.fullXRange_) {
            moveOK = true;
            this.selectionBounds_.x = xUL;
            this.locUL_.x = locUL.x;
            this.locLR_.x = locLR.x;
            newpoint = !ptUL.equals(this.uLocUL_) || !ptLR.equals(this.uLocLR_);
            this.uLocUL_.setX(ptUL.getX());
            this.uLocLR_.setX(ptLR.getX());
        }
        if (this.isConstraintsYOK(ptUL, ptLR) && !this.fullYRange_) {
            moveOK = true;
            this.selectionBounds_.y = yUL;
            this.locUL_.y = locUL.y;
            this.locLR_.y = locLR.y;
            newpoint = newpoint || !ptUL.equals(this.uLocUL_) || !ptLR.equals(this.uLocLR_);
            this.uLocUL_.setY(ptUL.getY());
            this.uLocLR_.setY(ptLR.getY());
        }
        if (moveOK) {
            if (fireEvent && (this.moved_ || newpoint)) {
                this.changes_.firePropertyChange("locationUL", null, this.uLocUL_);
                this.changes_.firePropertyChange("locationLR", null, this.uLocLR_);
                this.moved_ = false;
            } else {
                this.moved_ = this.moved_ || newpoint;
            }
        } else if (fireEvent && this.moved_) {
            this.changes_.firePropertyChange("locationUL", null, this.uLocUL_);
            this.changes_.firePropertyChange("locationLR", null, this.uLocLR_);
            this.moved_ = false;
        }
    }

    @Override
    public void adjustShape(MouseEvent e, Point loc, Point delta, boolean fireEvent) {
        if (this.inReShape_) {
            this.reShape(loc, delta, fireEvent);
            return;
        }
        if (this.inMove_) {
            this.setLocation(loc, fireEvent);
            return;
        }
        int xmouse = e.getX();
        int ymouse = e.getY();
        for (SelectionHandle handle : this.handles_) {
            if (!handle.contains(this.selectionBounds_, xmouse, ymouse)) continue;
            this.inReShape_ = true;
            this.shapeType = handle.getType();
            this.reShape(loc, delta, fireEvent);
            return;
        }
        this.inMove_ = true;
        this.setLocation(loc, fireEvent);
    }

    private void reShape(Point loc, Point delta, boolean fireEvent) {
        Rectangle saved = new Rectangle(this.selectionBounds_);
        Rectangle bounds = null;
        Point2D.Double locUL = null;
        Point2D.Double locLR = null;
        SoTPoint uLocUL = null;
        SoTPoint uLocLR = null;
        SoTValue uxLR = null;
        SoTValue uyLR = null;
        SoTValue uxUL = null;
        SoTValue uyUL = null;
        switch (this.shapeType) {
            case 2: {
                if (this.fullXRange_) break;
                bounds = new Rectangle(this.selectionBounds_);
                locLR = new Point2D.Double(this.locLR_.x, this.locLR_.y);
                uLocLR = new SoTPoint(this.uLocLR_);
                bounds.width += delta.x;
                locLR.x = this.layer_.getXDtoP(bounds.x + bounds.width);
                uxLR = ((CartesianGraph)this.layer_.getGraph()).getXPtoSoT(locLR.x);
                uLocLR.setX(uxLR);
                if (!this.isConstraintsXOK(uLocLR.getX())) break;
                SoTValue copy = uxLR.copy();
                copy.subtract(this.uLocUL_.getX());
                if (copy.isNegative()) break;
                this.selectionBounds_ = bounds;
                this.locLR_ = locLR;
                this.uLocLR_ = uLocLR;
                break;
            }
            case 1: {
                if (this.fullXRange_) break;
                bounds = new Rectangle(this.selectionBounds_);
                locUL = new Point2D.Double(this.locUL_.x, this.locUL_.y);
                uLocUL = new SoTPoint(this.uLocUL_);
                bounds.x += delta.x;
                bounds.width -= delta.x;
                locUL.x = this.layer_.getXDtoP(bounds.x);
                uxUL = ((CartesianGraph)this.layer_.getGraph()).getXPtoSoT(locUL.x);
                uLocUL.setX(uxUL);
                if (!this.isConstraintsXOK(uLocUL.getX())) break;
                SoTValue copy = this.uLocLR_.getX().copy();
                copy.subtract(uxUL);
                if (copy.isNegative()) break;
                this.selectionBounds_ = bounds;
                this.locUL_ = locUL;
                this.uLocUL_ = uLocUL;
                break;
            }
            case 4: {
                if (this.fullYRange_) break;
                bounds = new Rectangle(this.selectionBounds_);
                locUL = new Point2D.Double(this.locUL_.x, this.locUL_.y);
                uLocUL = new SoTPoint(this.uLocUL_);
                bounds.y += delta.y;
                bounds.height -= delta.y;
                locUL.y = this.layer_.getYDtoP(bounds.y);
                uyUL = ((CartesianGraph)this.layer_.getGraph()).getYPtoSoT(locUL.y);
                uLocUL.setY(uyUL);
                if (!this.isConstraintsYOK(uLocUL.getY())) break;
                SoTValue copy = uyUL.copy();
                copy.subtract(this.uLocLR_.getY());
                if (copy.isNegative()) break;
                this.selectionBounds_ = bounds;
                this.locUL_ = locUL;
                this.uLocUL_ = uLocUL;
                break;
            }
            case 8: {
                if (this.fullYRange_) break;
                bounds = new Rectangle(this.selectionBounds_);
                locLR = new Point2D.Double(this.locLR_.x, this.locLR_.y);
                uLocLR = new SoTPoint(this.uLocLR_);
                bounds.height += delta.y;
                locLR.y = this.layer_.getYDtoP(bounds.y + bounds.height);
                uyLR = ((CartesianGraph)this.layer_.getGraph()).getYPtoSoT(locLR.y);
                uLocLR.setY(uyLR);
                if (!this.isConstraintsYOK(uLocLR.getY())) break;
                SoTValue copy = this.uLocUL_.getY().copy();
                copy.subtract(uyLR);
                if (copy.isNegative()) break;
                this.selectionBounds_ = bounds;
                this.locLR_ = locLR;
                this.uLocLR_ = uLocLR;
                break;
            }
            case 32: {
                bounds = new Rectangle(this.selectionBounds_);
                locLR = new Point2D.Double(this.locLR_.x, this.locLR_.y);
                uLocLR = new SoTPoint(this.uLocLR_);
                locUL = new Point2D.Double(this.locUL_.x, this.locUL_.y);
                uLocUL = new SoTPoint(this.uLocUL_);
                if (!this.fullXRange_) {
                    bounds.width += delta.x;
                    locLR.x = this.layer_.getXDtoP(bounds.x + bounds.width);
                    uxLR = ((CartesianGraph)this.layer_.getGraph()).getXPtoSoT(locLR.x);
                    uLocLR.setX(uxLR);
                }
                if (!this.fullYRange_) {
                    bounds.y += delta.y;
                    bounds.height -= delta.y;
                    locUL.y = this.layer_.getYDtoP(bounds.y);
                    uyUL = ((CartesianGraph)this.layer_.getGraph()).getYPtoSoT(locUL.y);
                    uLocUL.setY(uyUL);
                }
                if (!this.isConstraintsXOK(uLocLR.getX()) || !this.isConstraintsYOK(uLocUL.getY())) break;
                SoTValue copy = null;
                if (uyUL != null) {
                    copy = uyUL.copy();
                    copy.subtract(this.uLocLR_.getY());
                    if (copy.isNegative()) break;
                }
                if (uxLR != null) {
                    copy = uxLR.copy();
                    copy.subtract(this.uLocUL_.getX());
                    if (copy.isNegative()) break;
                }
                this.selectionBounds_ = bounds;
                this.locLR_ = locLR;
                this.uLocLR_ = uLocLR;
                this.locUL_ = locUL;
                this.uLocUL_ = uLocUL;
                break;
            }
            case 16: {
                bounds = new Rectangle(this.selectionBounds_);
                locUL = new Point2D.Double(this.locUL_.x, this.locUL_.y);
                uLocUL = new SoTPoint(this.uLocUL_);
                if (!this.fullXRange_) {
                    bounds.x += delta.x;
                    bounds.width -= delta.x;
                    locUL.x = this.layer_.getXDtoP(bounds.x);
                    uxUL = ((CartesianGraph)this.layer_.getGraph()).getXPtoSoT(locUL.x);
                    uLocUL.setX(uxUL);
                }
                if (!this.fullYRange_) {
                    bounds.y += delta.y;
                    bounds.height -= delta.y;
                    locUL.y = this.layer_.getYDtoP(bounds.y);
                    uyUL = ((CartesianGraph)this.layer_.getGraph()).getYPtoSoT(locUL.y);
                    uLocUL.setY(uyUL);
                }
                if (!this.isConstraintsXOK(uLocUL.getX()) || !this.isConstraintsYOK(uLocUL.getY())) break;
                SoTValue copy = null;
                if (uyUL != null) {
                    copy = uyUL.copy();
                    copy.subtract(this.uLocLR_.getY());
                    if (copy.isNegative()) break;
                }
                if (uxUL != null) {
                    copy = this.uLocLR_.getX().copy();
                    copy.subtract(uxUL);
                    if (copy.isNegative()) break;
                }
                this.selectionBounds_ = bounds;
                this.locUL_ = locUL;
                this.uLocUL_ = uLocUL;
                break;
            }
            case 128: {
                bounds = new Rectangle(this.selectionBounds_);
                locLR = new Point2D.Double(this.locLR_.x, this.locLR_.y);
                uLocLR = new SoTPoint(this.uLocLR_);
                if (!this.fullXRange_) {
                    bounds.width += delta.x;
                    locLR.x = this.layer_.getXDtoP(bounds.x + bounds.width);
                    uxLR = ((CartesianGraph)this.layer_.getGraph()).getXPtoSoT(locLR.x);
                    uLocLR.setX(uxLR);
                }
                if (!this.fullYRange_) {
                    bounds.height += delta.y;
                    locLR.y = this.layer_.getYDtoP(bounds.y + bounds.height);
                    uyLR = ((CartesianGraph)this.layer_.getGraph()).getYPtoSoT(locLR.y);
                    uLocLR.setY(uyLR);
                }
                if (!this.isConstraintsXOK(uLocLR.getX()) || !this.isConstraintsYOK(uLocLR.getY())) break;
                SoTValue copy = null;
                if (uyLR != null) {
                    copy = this.uLocUL_.getY().copy();
                    copy.subtract(uyLR);
                    if (copy.isNegative()) break;
                }
                if (uxLR != null) {
                    copy = uxLR.copy();
                    copy.subtract(this.uLocUL_.getX());
                    if (copy.isNegative()) break;
                }
                this.selectionBounds_ = bounds;
                this.locLR_ = locLR;
                this.uLocLR_ = uLocLR;
                break;
            }
            case 64: {
                bounds = new Rectangle(this.selectionBounds_);
                locLR = new Point2D.Double(this.locLR_.x, this.locLR_.y);
                uLocLR = new SoTPoint(this.uLocLR_);
                locUL = new Point2D.Double(this.locUL_.x, this.locUL_.y);
                uLocUL = new SoTPoint(this.uLocUL_);
                if (!this.fullXRange_) {
                    bounds.x += delta.x;
                    bounds.width -= delta.x;
                    locUL.x = this.layer_.getXDtoP(bounds.x);
                    uxUL = ((CartesianGraph)this.layer_.getGraph()).getXPtoSoT(locUL.x);
                    uLocUL.setX(uxUL);
                }
                if (!this.fullYRange_) {
                    bounds.height += delta.y;
                    locLR.y = this.layer_.getYDtoP(bounds.y + bounds.height);
                    uyLR = ((CartesianGraph)this.layer_.getGraph()).getYPtoSoT(locLR.y);
                    uLocLR.setY(uyLR);
                }
                if (!this.isConstraintsXOK(uLocUL.getX()) || !this.isConstraintsYOK(uLocLR.getY())) break;
                SoTValue copy = null;
                if (uyLR != null) {
                    copy = this.uLocUL_.getY().copy();
                    copy.subtract(uyLR);
                    if (copy.isNegative()) break;
                }
                if (uxUL != null) {
                    copy = this.uLocLR_.getX().copy();
                    copy.subtract(uxUL);
                    if (copy.isNegative()) break;
                }
                this.selectionBounds_ = bounds;
                this.locLR_ = locLR;
                this.uLocLR_ = uLocLR;
                this.locUL_ = locUL;
                this.uLocUL_ = uLocUL;
            }
        }
        boolean bl = this.moved_ = this.moved_ || !saved.equals(this.selectionBounds_);
        if (fireEvent && this.moved_) {
            this.changes_.firePropertyChange("locationUL", null, this.uLocUL_);
            this.changes_.firePropertyChange("locationLR", null, this.uLocLR_);
            this.moved_ = false;
        }
    }

    @Override
    public void adjustShape(MouseEvent e, Point loc, Point delta) {
        this.adjustShape(e, loc, delta, true);
    }

    @Override
    public void adjustShapeNoVeto(MouseEvent e, int x, int y, int dx, int dy) {
        this.adjustShape(e, new Point(x, y), new Point(dx, dy), false);
    }

    public Color getGrabColor() {
        return this.grabColor;
    }

    public void setGrabColor(Color grabColor) {
        this.grabColor = grabColor;
    }

    public void setHandleSize(int width, int height) {
        this.handleWidth_ = width;
        this.handleHeight_ = height;
        this.updateHandles();
    }

    public int getHandleHeight() {
        return this.handleHeight_;
    }

    public void setHandleHeight(int handleHeight) {
        this.handleHeight_ = handleHeight;
        this.updateHandles();
    }

    public int getHandleWidth() {
        return this.handleWidth_;
    }

    public void setHandleWidth(int handleWidth) {
        this.handleWidth_ = handleWidth;
        this.updateHandles();
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getSelectColor() {
        return this.selectColor;
    }

    public void setSelectColor(Color selectColor) {
        this.selectColor = selectColor;
    }

    public SoTPoint getConstraintsUpperLeft() {
        return this.constraintsUL_;
    }

    public SoTPoint getConstraintsLowerRight() {
        return this.constraintsLR_;
    }

    public void setConstraints(SoTPoint constraintsUL, SoTPoint constraintsLR) {
        this.constraintsUL_ = constraintsUL;
        this.constraintsLR_ = constraintsLR;
    }

    private boolean isConstraintsXOK(SoTValue xpt) {
        if (this.constraintsUL_ == null | this.constraintsLR_ == null) {
            return true;
        }
        if (xpt.isTime()) {
            long tCL = this.constraintsUL_.getX().getLongTime();
            long tCR = this.constraintsLR_.getX().getLongTime();
            long t = xpt.getLongTime();
            if (t < tCL || t > tCR) {
                return false;
            }
        } else {
            double xCL = this.constraintsUL_.getX().getDouble();
            double xCR = this.constraintsLR_.getX().getDouble();
            double x = xpt.getDouble();
            if (x < xCL || x > xCR) {
                return false;
            }
        }
        return true;
    }

    private boolean isConstraintsYOK(SoTValue ypt) {
        if (this.constraintsUL_ == null | this.constraintsLR_ == null) {
            return true;
        }
        if (ypt.isTime()) {
            long tCT = this.constraintsUL_.getY().getLongTime();
            long tCB = this.constraintsLR_.getY().getLongTime();
            long t = ypt.getLongTime();
            if (t > tCT || t < tCB) {
                return false;
            }
        } else {
            double yCT = this.constraintsUL_.getY().getDouble();
            double yCB = this.constraintsLR_.getY().getDouble();
            double y = ypt.getDouble();
            if (y > yCT || y < yCB) {
                return false;
            }
        }
        return true;
    }

    private boolean isConstraintsXOK(SoTPoint UL, SoTPoint LR) {
        if (this.constraintsUL_ == null | this.constraintsLR_ == null) {
            return true;
        }
        SoTValue xLV = UL.getX();
        SoTValue xRV = LR.getX();
        if (xLV.isTime()) {
            long tCL = this.constraintsUL_.getX().getLongTime();
            long tCR = this.constraintsLR_.getX().getLongTime();
            long tL = xLV.getLongTime();
            long tR = xRV.getLongTime();
            if (tL < tCL || tL > tCR || tR < tCL || tR > tCR) {
                return false;
            }
        } else {
            double xCL = this.constraintsUL_.getX().getDouble();
            double xCR = this.constraintsLR_.getX().getDouble();
            double xL = xLV.getDouble();
            double xR = xRV.getDouble();
            if (xL < xCL || xL > xCR || xR < xCL || xR > xCR) {
                return false;
            }
        }
        return true;
    }

    private boolean isConstraintsYOK(SoTPoint UL, SoTPoint LR) {
        if (this.constraintsUL_ == null | this.constraintsLR_ == null) {
            return true;
        }
        SoTValue yTV = UL.getY();
        SoTValue yBV = LR.getY();
        if (yTV.isTime()) {
            long tCT = this.constraintsUL_.getY().getLongTime();
            long tCB = this.constraintsLR_.getY().getLongTime();
            long tT = yTV.getLongTime();
            long tB = yBV.getLongTime();
            if (tT > tCT || tT < tCB || tB > tCT || tB < tCB) {
                return false;
            }
        } else {
            double yCT = this.constraintsUL_.getY().getDouble();
            double yCB = this.constraintsLR_.getY().getDouble();
            double yT = yTV.getDouble();
            double yB = yBV.getDouble();
            if (yT > yCT || yT < yCB || yB > yCT || yB < yCB) {
                return false;
            }
        }
        return true;
    }

    public boolean isHandleFullSized() {
        return this.handleFullSized_;
    }

    public void setHandleFullSized(boolean handleFullSized) {
        this.handleFullSized_ = handleFullSized;
    }

    public boolean isFullXRange() {
        return this.fullXRange_;
    }

    public void setFullXRange(boolean fullXRange) {
        this.fullXRange_ = fullXRange;
    }

    public boolean isFullYRange() {
        return this.fullYRange_;
    }

    public void setFullYRange(boolean fullYRange) {
        this.fullYRange_ = fullYRange;
    }

    @Override
    public boolean inMoveRegion(MouseEvent sme) {
        this.computeBounds();
        return this.selectionBounds_.contains(sme.getX(), sme.getY());
    }

    @Override
    public boolean inReShapeRegion(MouseEvent sme) {
        Iterator iter = this.handles_.iterator();
        this.computeBounds();
        while (iter.hasNext()) {
            SelectionHandle handle = (SelectionHandle)iter.next();
            if (!handle.contains(this.selectionBounds_, sme.getX(), sme.getY())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCursor(MouseEvent sme) {
        int x = sme.getX();
        int y = sme.getY();
        this.computeBounds();
        if (this.bounds_.contains(x, y)) {
            for (SelectionHandle handle : this.handles_) {
                if (!handle.contains(this.selectionBounds_, sme.getX(), sme.getY())) continue;
                switch (handle.getType()) {
                    case 8: {
                        return 9;
                    }
                    case 64: {
                        return 4;
                    }
                    case 128: {
                        return 5;
                    }
                    case 1: {
                        return 10;
                    }
                    case 2: {
                        return 11;
                    }
                    case 4: {
                        return 8;
                    }
                    case 16: {
                        return 6;
                    }
                    case 32: {
                        return 7;
                    }
                }
                return 12;
            }
            return 12;
        }
        return 0;
    }
}

