/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.swing.SelectionHandle;
import gov.noaa.pmel.sgt.swing.SelectionTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;

public class SliderSelectionHandle
implements SelectionHandle {
    private int type_;
    private SelectionTool tool_;
    private Icon handle_;
    private Color outline_ = new Color(62, 70, 146);
    private Color hilite_ = new Color(184, 207, 229);
    private Color fill_ = new Color(89, 100, 224);
    private Insets insets_ = new Insets(5, 5, 5, 5);

    public SliderSelectionHandle(SelectionTool c, int type) {
        this.tool_ = c;
        this.type_ = type;
        switch (this.type_) {
            case 1: {
                this.handle_ = new HorizontalHandle();
                break;
            }
            case 2: {
                this.handle_ = new HorizontalHandle();
            }
        }
    }

    @Override
    public void draw(Graphics g, Rectangle toolBounds) {
        Rectangle bnds = this.getBounds(toolBounds);
        this.handle_.paintIcon(this.tool_.getParent(), g, bnds.x, bnds.y);
    }

    @Override
    public boolean contains(Rectangle toolBounds, int xm, int ym) {
        Rectangle bnds = this.getSelectionBounds(toolBounds);
        return bnds.contains(xm, ym);
    }

    @Override
    public Rectangle getSelectionBounds(Rectangle toolBounds) {
        Rectangle bnds = this.getBounds(toolBounds);
        Rectangle is = new Rectangle(bnds.x - this.insets_.left, bnds.y - this.insets_.top, bnds.width + this.insets_.left + this.insets_.right, bnds.height + this.insets_.top + this.insets_.bottom);
        return is;
    }

    @Override
    public Rectangle getBounds(Rectangle toolBounds) {
        Rectangle bounds = toolBounds;
        int hgt = this.handle_.getIconHeight();
        int wid = this.handle_.getIconWidth();
        int xref = 0;
        int yref = 0;
        switch (this.type_) {
            case 2: {
                xref = bounds.x + bounds.width - wid / 2 + 1;
                yref = bounds.y + bounds.height - hgt;
                break;
            }
            case 1: {
                xref = bounds.x - wid / 2 + 1;
                yref = bounds.y + bounds.height - hgt;
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 32: {
                break;
            }
            case 16: {
                break;
            }
            case 128: {
                break;
            }
        }
        Rectangle result = new Rectangle(xref, yref, wid, hgt);
        return result;
    }

    @Override
    public int getType() {
        return this.type_;
    }

    class HorizontalHandle
    implements Icon {
        HorizontalHandle() {
        }

        @Override
        public int getIconHeight() {
            return 15;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color save = g.getColor();
            g.translate(x, y);
            g.setColor(SliderSelectionHandle.this.outline_);
            g.drawLine(1, 0, 13, 0);
            g.drawLine(0, 1, 0, 8);
            g.drawLine(14, 1, 14, 8);
            g.drawLine(1, 9, 7, 15);
            g.drawLine(7, 15, 13, 9);
            g.setColor(SliderSelectionHandle.this.fill_);
            g.fillRect(1, 1, 13, 8);
            g.drawLine(2, 9, 12, 9);
            g.drawLine(3, 10, 11, 10);
            g.drawLine(4, 11, 10, 11);
            g.drawLine(5, 12, 9, 12);
            g.drawLine(6, 13, 8, 13);
            g.drawLine(7, 14, 7, 14);
            g.setColor(SliderSelectionHandle.this.hilite_);
            g.drawLine(1, 1, 13, 1);
            g.drawLine(1, 1, 1, 8);
            g.translate(-x, -y);
            g.setColor(save);
        }
    }

    class VerticalHandle
    implements Icon {
        VerticalHandle() {
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 15;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }
}

