/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.swing.Draggable;
import gov.noaa.pmel.sgt.swing.ValueIconFormat;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTPoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.net.URL;
import javax.swing.ImageIcon;

public class ValueIcon
extends ImageIcon
implements LayerChild,
Draggable {
    private int iWidth_ = 0;
    private int iHeight_ = 0;
    private boolean selected_ = false;
    private boolean selectable_ = true;
    private boolean moved_ = false;
    private Layer layer_ = null;
    private String id_ = null;
    private boolean visible_ = true;
    private Rectangle bounds_ = new Rectangle();
    private Point2D.Double loc_ = new Point2D.Double();
    private SoTPoint uLoc_ = new SoTPoint(0.0, 0.0);
    private Font font_ = new Font("Dialog", 0, 12);
    private Color textColor_ = Color.black;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);
    private ValueIconFormat frmt_ = new ValueIconFormat("#####.##", "#.##");
    private static final String defTFrmt = "yyyy-MM-dd";

    public ValueIcon(String filename, String description) {
        super(filename, description);
        this.getImageSize();
        this.frmt_.setTimeFormat(defTFrmt);
    }

    public ValueIcon(URL location, String description) {
        super(location, description);
        this.getImageSize();
        this.frmt_.setTimeFormat(defTFrmt);
    }

    public ValueIcon(Image image, String description) {
        super(image, description);
        this.getImageSize();
        this.frmt_.setTimeFormat(defTFrmt);
    }

    public void setValueFormat(ValueIconFormat vf) {
        this.frmt_ = vf;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        String text = this.frmt_.format(this.uLoc_);
        FontMetrics fmet = g.getFontMetrics();
        int wid = fmet.stringWidth(text);
        int hgt = fmet.getMaxAscent() + fmet.getMaxDescent();
        this.bounds_.x = x;
        this.bounds_.y = y;
        this.bounds_.width = this.iWidth_ + wid;
        this.bounds_.height = this.iHeight_ + fmet.getMaxDescent();
        if (this.visible_) {
            g.drawImage(this.getImage(), this.bounds_.x, this.bounds_.y, this.layer_.getPane().getComponent());
            int xl = this.bounds_.x + this.iWidth_;
            int yl = this.bounds_.y + this.iHeight_;
            g.setFont(this.font_);
            g.setColor(this.layer_.getPane().getComponent().getBackground());
            g.fillRect(xl, yl - fmet.getMaxAscent(), wid, hgt);
            g.setColor(this.textColor_);
            g.drawString(text, xl, yl);
        }
    }

    public void setFont(Font font) {
        this.font_ = font;
    }

    public Font getFont() {
        return this.font_;
    }

    private void getImageSize() {
        this.iWidth_ = super.getIconWidth();
        this.iHeight_ = super.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.bounds_.width;
    }

    @Override
    public int getIconHeight() {
        return this.bounds_.height;
    }

    @Override
    public LayerChild copy() {
        return null;
    }

    @Override
    public void setVisible(boolean vis) {
        if (this.visible_ != vis) {
            this.visible_ = vis;
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible_;
    }

    @Override
    public void draw(Graphics g) {
        int x = ((CartesianGraph)this.layer_.getGraph()).getXUtoD(this.uLoc_.getX()) - this.iWidth_ / 2;
        int y = ((CartesianGraph)this.layer_.getGraph()).getYUtoD(this.uLoc_.getY()) - this.iHeight_ / 2;
        this.paintIcon(this.layer_.getPane().getComponent(), g, x, y);
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public Layer getLayer() {
        return this.layer_;
    }

    @Override
    public JPane getPane() {
        return this.layer_.getPane();
    }

    @Override
    public void modified(String mess) {
        if (this.layer_ != null) {
            this.layer_.modified(mess);
        }
    }

    @Override
    public void setId(String id) {
        this.id_ = id;
    }

    @Override
    public void setLayer(Layer l) {
        this.layer_ = l;
    }

    @Override
    public String toString() {
        return "ValueIcon: " + this.id_;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds_;
    }

    @Override
    public Rectangle getRepaintBounds() {
        return this.getBounds();
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    @Override
    public boolean contains(Point pt) {
        return this.contains(pt.x, pt.y);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    public Point2D.Double getLocationP() {
        return this.loc_;
    }

    public void setLocationP(Point2D.Double loc) {
        this.loc_ = loc;
        this.bounds_.x = this.layer_.getXPtoD(this.loc_.x) - this.iWidth_ / 2;
        this.bounds_.y = this.layer_.getYPtoD(this.loc_.y) - this.iHeight_ / 2;
        SoTPoint pt = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.loc_);
        if (!pt.equals(this.uLoc_) || this.moved_) {
            SoTPoint temp = new SoTPoint(pt);
            this.changes_.firePropertyChange("location", this.uLoc_, temp);
            this.uLoc_ = temp;
            this.moved_ = false;
        }
    }

    public SoTPoint getLocationU() {
        return this.uLoc_;
    }

    public void setLocationUNoVeto(SoTPoint loc) {
        this.moved_ = this.moved_ || !loc.equals(this.uLoc_);
        this.uLoc_ = loc;
        this.loc_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLoc_.getX());
        this.loc_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLoc_.getY());
        this.bounds_.x = this.layer_.getXPtoD(this.loc_.x);
        this.bounds_.y = this.layer_.getYPtoD(this.loc_.y);
    }

    public void setLocationU(SoTPoint loc) throws PropertyVetoException {
        if (!loc.equals(this.uLoc_) || this.moved_) {
            this.vetos_.fireVetoableChange("location", this.uLoc_, loc);
            this.changes_.firePropertyChange("location", this.uLoc_, loc);
            this.uLoc_ = loc;
            this.moved_ = false;
            this.loc_.x = ((CartesianGraph)this.layer_.getGraph()).getXUtoP(this.uLoc_.getX());
            this.loc_.y = ((CartesianGraph)this.layer_.getGraph()).getYUtoP(this.uLoc_.getY());
            this.bounds_.x = this.layer_.getXPtoD(this.loc_.x) - this.iWidth_ / 2;
            this.bounds_.y = this.layer_.getYPtoD(this.loc_.y) - this.iHeight_ / 2;
        }
    }

    @Override
    public void setLocationNoVeto(int x, int y) {
        this.bounds_.x = x;
        this.bounds_.y = y;
        this.loc_.x = this.layer_.getXDtoP(x);
        this.loc_.y = this.layer_.getYDtoP(y);
        SoTPoint pt = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.loc_);
        this.moved_ = this.moved_ || !pt.equals(this.uLoc_);
        this.uLoc_ = new SoTPoint(pt);
    }

    @Override
    public void setLocation(Point loc) {
        this.setLocation(loc, true);
    }

    @Override
    public void setLocation(Point loc, boolean fireEvent) {
        this.setBounds(loc.x, loc.y, 0, 0, fireEvent);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height, true);
    }

    private void setBounds(int x, int y, int width, int height, boolean fireEvent) {
        this.bounds_.x = x;
        this.bounds_.y = y;
        this.loc_.x = this.layer_.getXDtoP(x + this.iWidth_ / 2);
        this.loc_.y = this.layer_.getYDtoP(y + this.iHeight_ / 2);
        SoTPoint pt = ((CartesianGraph)this.layer_.getGraph()).getPtoU(this.loc_);
        boolean bl = this.moved_ = this.moved_ || !pt.equals(this.uLoc_);
        if (this.moved_) {
            SoTPoint temp = new SoTPoint(pt);
            if (fireEvent) {
                this.changes_.firePropertyChange("location", this.uLoc_, temp);
                this.moved_ = false;
            }
            this.uLoc_ = temp;
        }
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.removeVetoableChangeListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }
}

