/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing;

import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTValue;
import java.text.DecimalFormat;

public class ValueIconFormat {
    protected DecimalFormat xfrm_;
    protected DecimalFormat yfrm_;
    protected String tfrm_ = "yyyy-MM-dd HH:mm:ss z";

    public ValueIconFormat(String xfrmt, String yfrmt) {
        this.xfrm_ = new DecimalFormat(xfrmt);
        this.yfrm_ = new DecimalFormat(yfrmt);
    }

    public String format(double x, double y) {
        return "(" + this.xfrm_.format(x) + ", " + this.yfrm_.format(y) + ")";
    }

    public void setTimeFormat(String tfrmt) {
        this.tfrm_ = tfrmt;
    }

    public String formatX(double x) {
        return "(" + this.xfrm_.format(x) + ")";
    }

    public String formatY(double y) {
        return "(" + this.yfrm_.format(y) + ")";
    }

    public String formatTime(GeoDate date) {
        return "(" + date.toString(this.tfrm_) + ")";
    }

    public String format(SoTPoint pt) {
        return this.format("(", pt, ")");
    }

    public String format(String prefix, SoTPoint pt, String postfix) {
        StringBuffer sbuf = new StringBuffer(prefix);
        if (pt.isXTime()) {
            sbuf.append(pt.getX().getGeoDate().toString(this.tfrm_));
        } else {
            sbuf.append(this.xfrm_.format(((SoTValue.Double)pt.getX()).getValue()));
        }
        sbuf.append(", ");
        if (pt.isYTime()) {
            sbuf.append(pt.getY().getGeoDate().toString(this.tfrm_));
        } else {
            sbuf.append(this.yfrm_.format(((SoTValue.Double)pt.getY()).getValue()));
        }
        sbuf.append(postfix);
        return sbuf.toString();
    }
}

