/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing.prop;

import gov.noaa.pmel.sgt.ContourLevelNotFoundException;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.ContourLineAttribute;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.swing.prop.ContourLineAttributeDialog;
import gov.noaa.pmel.sgt.swing.prop.DefaultContourLineAttributeDialog;
import gov.noaa.pmel.sgt.swing.prop.GridBagConstraints;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ContourLevelsDialog
extends JDialog {
    private ContourLevels conLevels_;
    private JTable table_;
    private ConLevelTableModel model_;
    private int result_;
    public static int OK_RESPONSE = 1;
    public static int CANCEL_RESPONSE = 2;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    JPanel controlPanel = new JPanel();
    JPanel JPanel1 = new JPanel();
    JButton editButton = new JButton();
    JButton aboveButton = new JButton();
    JButton belowButton = new JButton();
    JButton deleteButton = new JButton();
    JPanel JPanel4 = new JPanel();
    JButton defaultButton = new JButton();
    JButton sortButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JScrollPane gridScrollPane = new JScrollPane();
    TitledBorder titledBorder1 = new TitledBorder("Contour Levels");
    EmptyBorder emptyBorder1 = new EmptyBorder(5, 0, 0, 0);
    CompoundBorder compoundBorder1 = new CompoundBorder(this.emptyBorder1, this.etchedBorder1);
    TitledBorder titledBorder4 = new TitledBorder("Default Attributes");

    public ContourLevelsDialog(Frame parent) {
        super(parent);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(529, 307);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.gridScrollPane.setMinimumSize(new Dimension(350, 283));
        this.gridScrollPane.setPreferredSize(new Dimension(350, 283));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.controlPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.controlPanel, "East");
        this.JPanel1.setBorder(this.titledBorder1);
        this.JPanel1.setLayout(new GridBagLayout());
        this.controlPanel.add((Component)this.JPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.editButton.setToolTipText("Edit attribute of selected level.");
        this.editButton.setText("Edit Attribute");
        this.editButton.setActionCommand("Change Value");
        this.JPanel1.add((Component)this.editButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.aboveButton.setToolTipText("Insert level above selected level.");
        this.aboveButton.setText("Insert Level Above");
        this.aboveButton.setActionCommand("Before Item");
        this.JPanel1.add((Component)this.aboveButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.belowButton.setToolTipText("Insert level below selected level.");
        this.belowButton.setText("Insert Level Below");
        this.belowButton.setActionCommand("After Item");
        this.JPanel1.add((Component)this.belowButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.deleteButton.setToolTipText("Delete the selected level.");
        this.deleteButton.setText("Delete Level");
        this.deleteButton.setActionCommand("Delete Item");
        this.JPanel1.add((Component)this.deleteButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.JPanel4.setBorder(this.titledBorder4);
        this.JPanel4.setLayout(new GridBagLayout());
        this.controlPanel.add((Component)this.JPanel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.defaultButton.setToolTipText("Edit default attributes.");
        this.defaultButton.setText("Edit Default Attributes");
        this.JPanel4.add((Component)this.defaultButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.sortButton.setToolTipText("Sort levels by value.");
        this.sortButton.setText("Sort Levels");
        this.sortButton.setActionCommand("Sort");
        this.controlPanel.add((Component)this.sortButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.gridScrollPane.setBorder(this.compoundBorder1);
        this.getContentPane().add((Component)this.gridScrollPane, "Center");
        this.setTitle("Edit Contour Levels");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.cancelButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        this.editButton.addActionListener(lSymAction);
        this.aboveButton.addActionListener(lSymAction);
        this.belowButton.addActionListener(lSymAction);
        this.deleteButton.addActionListener(lSymAction);
        this.sortButton.addActionListener(lSymAction);
        this.defaultButton.addActionListener(lSymAction);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public ContourLevelsDialog(String title) {
        this();
        this.setTitle(title);
    }

    public ContourLevelsDialog() {
        this((Frame)null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void ContourLevelsDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.result_ = CANCEL_RESPONSE;
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.update();
        this.result_ = OK_RESPONSE;
        this.setVisible(false);
    }

    private void update() {
        ContourLevels cl = new ContourLevels();
        int size = this.model_.getRowCount();
        for (int i = 0; i < size; ++i) {
            Double val = (Double)this.model_.getValueAt(i, 0);
            ContourLineAttribute attr = (ContourLineAttribute)this.model_.getValueAt(i, 1);
            cl.addLevel(val, attr);
        }
        cl.setDefaultContourLineAttribute(this.conLevels_.getDefaultContourLineAttribute());
        this.conLevels_ = cl;
    }

    public static void main(String[] args) {
        ContourLevelsDialog cla = new ContourLevelsDialog();
        cla.setTitle("Test ContourLevels Dialog");
        cla.setVisible(true);
    }

    public int showDialog(ContourLevels cl) {
        this.conLevels_ = cl;
        this.result_ = CANCEL_RESPONSE;
        this.createTable();
        this.setModal(true);
        super.setVisible(true);
        return this.result_;
    }

    void createTable() {
        int size = this.conLevels_.size();
        this.model_ = new ConLevelTableModel();
        for (int i = 0; i < size; ++i) {
            try {
                Double val = new Double(this.conLevels_.getLevel(i));
                ContourLineAttribute attr = this.conLevels_.getContourLineAttribute(i);
                this.model_.add(val, attr);
                continue;
            }
            catch (ContourLevelNotFoundException contourLevelNotFoundException) {
                // empty catch block
            }
        }
        this.table_ = new JTable(this.model_);
        this.table_.setSize(1000, 1000);
        ListSelectionModel lsm = this.table_.getSelectionModel();
        lsm.setSelectionMode(0);
        TableColumn tc = this.table_.getColumnModel().getColumn(0);
        tc.setPreferredWidth(250);
        tc = this.table_.getColumnModel().getColumn(1);
        tc.setPreferredWidth(750);
        this.gridScrollPane.getViewport().add(this.table_);
    }

    public ContourLevels getContourLevels() {
        return this.conLevels_;
    }

    void editButton_actionPerformed(ActionEvent event) {
        int index = this.table_.getSelectedRow();
        if (index < 0) {
            return;
        }
        ContourLineAttributeDialog clad = new ContourLineAttributeDialog();
        ContourLineAttribute attr = (ContourLineAttribute)((ContourLineAttribute)this.model_.getValueAt(index, 1)).copy();
        int result = clad.showDialog(attr);
        if (result == ContourLineAttributeDialog.OK_RESPONSE) {
            attr = clad.getContourLineAttribute();
            this.model_.setValueAt(attr, index, 1);
        }
    }

    void aboveButton_actionPerformed(ActionEvent event) {
        int index = this.table_.getSelectedRow();
        if (index < 0) {
            return;
        }
        this.model_.insert(index, new Double(0.0), new ContourLineAttribute(0));
    }

    void belowButton_actionPerformed(ActionEvent event) {
        int index = this.table_.getSelectedRow();
        if (index < 0) {
            return;
        }
        this.model_.insert(index + 1, new Double(0.0), new ContourLineAttribute(0));
    }

    void deleteButton_actionPerformed(ActionEvent event) {
        int index = this.table_.getSelectedRow();
        if (index < 0) {
            return;
        }
        this.model_.remove(index);
    }

    void sortButton_actionPerformed(ActionEvent event) {
        this.model_.sort();
    }

    void defaultButton_actionPerformed(ActionEvent event) {
        DefaultContourLineAttributeDialog dclad = new DefaultContourLineAttributeDialog();
        DefaultContourLineAttribute attr = this.conLevels_.getDefaultContourLineAttribute();
        int result = dclad.showDialog((DefaultContourLineAttribute)attr.copy());
        if (result == DefaultContourLineAttributeDialog.OK_RESPONSE) {
            attr = dclad.getDefaultContourLineAttribute();
            this.conLevels_.setDefaultContourLineAttribute(attr);
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == ContourLevelsDialog.this) {
                ContourLevelsDialog.this.ContourLevelsDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ContourLevelsDialog.this.cancelButton) {
                ContourLevelsDialog.this.cancelButton_actionPerformed(event);
            } else if (object == ContourLevelsDialog.this.okButton) {
                ContourLevelsDialog.this.okButton_actionPerformed(event);
            } else if (object == ContourLevelsDialog.this.editButton) {
                ContourLevelsDialog.this.editButton_actionPerformed(event);
            } else if (object == ContourLevelsDialog.this.aboveButton) {
                ContourLevelsDialog.this.aboveButton_actionPerformed(event);
            } else if (object == ContourLevelsDialog.this.belowButton) {
                ContourLevelsDialog.this.belowButton_actionPerformed(event);
            }
            if (object == ContourLevelsDialog.this.deleteButton) {
                ContourLevelsDialog.this.deleteButton_actionPerformed(event);
            } else if (object == ContourLevelsDialog.this.sortButton) {
                ContourLevelsDialog.this.sortButton_actionPerformed(event);
            } else if (object == ContourLevelsDialog.this.defaultButton) {
                ContourLevelsDialog.this.defaultButton_actionPerformed(event);
            }
        }
    }

    class ConLevelTableModel
    extends AbstractTableModel {
        Vector values = new Vector();
        Vector attr = new Vector();
        String[] titles = new String[]{"Value", "Attribute"};

        ConLevelTableModel() {
        }

        public void add(Double val, ContourLineAttribute cla) {
            this.values.addElement(val);
            this.attr.addElement(cla);
        }

        public void insert(int row, Double val, ContourLineAttribute cla) {
            this.values.insertElementAt(val, row);
            this.attr.insertElementAt(cla, row);
            this.fireTableChanged(new TableModelEvent(this, row, row, -1, 1));
        }

        public void remove(int row) {
            this.values.removeElementAt(row);
            this.attr.removeElementAt(row);
            this.fireTableChanged(new TableModelEvent(this, row, row, -1, -1));
        }

        public void sort() {
            int i;
            int size = this.values.size();
            int[] index = new int[size];
            boolean flipped = true;
            for (i = 0; i < size; ++i) {
                index[i] = i;
            }
            while (flipped) {
                flipped = false;
                for (i = 0; i < size - 1; ++i) {
                    Double a = (Double)this.values.elementAt(index[i]);
                    Double b = (Double)this.values.elementAt(index[i + 1]);
                    if (!(a > b)) continue;
                    int temp = index[i];
                    index[i] = index[i + 1];
                    index[i + 1] = temp;
                    flipped = true;
                }
            }
            Vector oldValues = this.values;
            Vector oldAttr = this.attr;
            this.values = new Vector(size);
            this.attr = new Vector(size);
            for (i = 0; i < size; ++i) {
                this.values.addElement(oldValues.elementAt(index[i]));
                this.attr.addElement(oldAttr.elementAt(index[i]));
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.values.elementAt(row);
            }
            return this.attr.elementAt(row);
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            if (col == 0) {
                if (obj instanceof Double) {
                    this.values.setElementAt(obj, row);
                } else if (obj instanceof String) {
                    this.values.setElementAt(new Double((String)obj), row);
                }
            } else {
                this.attr.setElementAt(obj, row);
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            return this.titles[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }
}

