/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing.prop;

import gov.noaa.pmel.sgt.swing.prop.GridBagConstraints;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;

public class FontDialog
extends JDialog {
    private int result_;
    private Font font_;
    private String[] fontNames_;
    private int[] styles_ = new int[]{0, 1, 2, 3};
    private String[] styleNames_ = new String[]{"plain", "bold", "italic", "bold-italic"};
    public static int OK_RESPONSE = 1;
    public static int CANCEL_RESPONSE = 2;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JPanel mainPanel = new JPanel();
    JComboBox fontComboBox = new JComboBox();
    JToggleButton boldButton = new JToggleButton();
    JToggleButton italicButton = new JToggleButton();
    JLabel fontLabel = new JLabel();

    public FontDialog(Frame parent) {
        super(parent);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(450, 141);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.italicButton.setMnemonic('0');
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.mainPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.fontComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 1), 0, 0));
        this.boldButton.setText("Bold");
        this.mainPanel.add((Component)this.boldButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 1, 5, 2), 0, 0));
        this.italicButton.setText("Italic");
        this.mainPanel.add((Component)this.italicButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 2, 5, 5), 0, 0));
        this.italicButton.setFont(new Font("Dialog", 3, 12));
        this.fontLabel.setText("Font Name in font.");
        this.mainPanel.add((Component)this.fontLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setTitle("Select a Mark");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.cancelButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        this.fontComboBox.addActionListener(lSymAction);
        this.boldButton.addActionListener(lSymAction);
        this.italicButton.addActionListener(lSymAction);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public FontDialog(String title) {
        this();
        this.setTitle(title);
    }

    public FontDialog() {
        this((Frame)null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void FontDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.result_ = CANCEL_RESPONSE;
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.result_ = OK_RESPONSE;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        FontDialog la = new FontDialog();
        la.setFont(null);
        la.setTitle("Test Font Dialog");
        la.setVisible(true);
    }

    public int showDialog(Font font) {
        this.fontNames_ = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < this.fontNames_.length; ++i) {
            this.fontComboBox.addItem(this.fontNames_[i]);
        }
        this.setDefaultFont(font);
        this.result_ = CANCEL_RESPONSE;
        this.setModal(true);
        super.setVisible(true);
        return this.result_;
    }

    public void setDefaultFont(Font font) {
        int index = 0;
        this.font_ = font;
        if (this.font_ == null) {
            this.font_ = super.getFont();
        }
        for (int i = 0; i < this.fontNames_.length; ++i) {
            if (!this.font_.getName().equals(this.fontNames_[i])) continue;
            index = i;
            break;
        }
        this.boldButton.setSelected(this.font_.isBold());
        this.italicButton.setSelected(this.font_.isItalic());
        this.fontComboBox.setSelectedIndex(index);
        this.fontLabel.setText(this.fontString());
        this.fontLabel.setFont(this.font_);
    }

    public String fontString() {
        int style = (this.boldButton.isSelected() ? 1 : 0) + (this.italicButton.isSelected() ? 2 : 0);
        return this.font_.getName() + " " + this.styleNames_[style];
    }

    @Override
    public Font getFont() {
        return this.font_;
    }

    void fontComboBox_actionPerformed(ActionEvent event) {
        this.updateFont();
    }

    void boldButton_actionPerformed(ActionEvent event) {
        this.updateFont();
    }

    void italicButton_actionPerformed(ActionEvent event) {
        this.updateFont();
    }

    void updateFont() {
        Font font;
        int style = (this.boldButton.isSelected() ? 1 : 0) + (this.italicButton.isSelected() ? 2 : 0);
        this.font_ = font = new Font(this.fontNames_[this.fontComboBox.getSelectedIndex()], this.styles_[style], 12);
        this.fontLabel.setText(this.fontString());
        this.fontLabel.setFont(this.font_);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == FontDialog.this) {
                FontDialog.this.FontDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == FontDialog.this.cancelButton) {
                FontDialog.this.cancelButton_actionPerformed(event);
            } else if (object == FontDialog.this.okButton) {
                FontDialog.this.okButton_actionPerformed(event);
            } else if (object == FontDialog.this.fontComboBox) {
                FontDialog.this.fontComboBox_actionPerformed(event);
            } else if (object == FontDialog.this.boldButton) {
                FontDialog.this.boldButton_actionPerformed(event);
            } else if (object == FontDialog.this.italicButton) {
                FontDialog.this.italicButton_actionPerformed(event);
            }
        }
    }
}

