/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing.prop;

import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.GeometryAttribute;
import gov.noaa.pmel.sgt.IndexedColor;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.swing.ColorSwatchIcon;
import gov.noaa.pmel.sgt.swing.PlotMarkIcon;
import gov.noaa.pmel.sgt.swing.prop.ColorEntryPanel;
import gov.noaa.pmel.sgt.swing.prop.FontDialog;
import gov.noaa.pmel.sgt.swing.prop.GridBagConstraints;
import gov.noaa.pmel.sgt.swing.prop.LineAttributeDialog;
import gov.noaa.pmel.sgt.swing.prop.PlotMarkDialog;
import gov.noaa.pmel.swing.ThreeDotsButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class GeometryAttributeDialog
extends JDialog {
    private ColorMap colorMap_ = null;
    private JToggleButton[] colorButtons_ = new JToggleButton[256];
    private Font labelFont_ = null;
    private String[] styleNames_ = new String[]{"plain", "bold", "italic", "bold-italic"};
    private GeometryAttribute attr_ = null;
    private int mark_ = 0;
    private PlotMarkIcon pmIcon_;
    private JPane pane_ = null;
    DefaultComboBoxModel positionCBModel = new DefaultComboBoxModel();
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton applyButton = new JButton();
    JButton cancelButton = new JButton();
    JTabbedPane mainPanel = new JTabbedPane();
    JPanel polygonPanel = new JPanel();
    JPanel labelPanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    JComboBox positionComboBox = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JPanel fontPanel = new JPanel();
    JLabel fontLabel = new JLabel();
    ThreeDotsButton fontEditor = new ThreeDotsButton();
    JLabel jLabel4 = new JLabel();
    ColorEntryPanel labelColorPanel = new ColorEntryPanel();
    ColorEntryPanel boxColorPanel = new ColorEntryPanel();
    JLabel jLabel5 = new JLabel();
    JTextField labelHeightTextField = new JTextField();
    JTextField boxGrowByTextField = new JTextField();
    JLabel jLabel6 = new JLabel();
    JCheckBox drawLabelCheckBox = new JCheckBox();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel ColorMapPanel = new JPanel();
    JPanel colorControlPanel = new JPanel();
    JPanel colorMapPanel = new JPanel();
    JButton newColorMapButton = new JButton();
    JButton loadColorMapButton = new JButton();
    JButton saveColorMapButton = new JButton();
    JPanel defaultColorPanel = new JPanel();
    JPanel colorButtonsPanel = new JPanel();
    TitledBorder titledBorder2 = new TitledBorder("Color Map");
    private JLabel jLabel3 = new JLabel();
    private ColorEntryPanel defaultFillColorPanel = new ColorEntryPanel();
    private JPanel pointPanel = new JPanel();
    private JLabel jLabel8 = new JLabel();
    private JPanel jPanel2 = new JPanel();
    private JLabel plotMarkIconLabel = new JLabel();
    private ThreeDotsButton markEditor = new ThreeDotsButton();
    private JLabel jLabel10 = new JLabel();
    private JTextField markHeightTextField = new JTextField();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JLabel jLabel7 = new JLabel();
    private JCheckBox drawOutlineCB = new JCheckBox();
    private JCheckBox simplifyGeometryCB = new JCheckBox();
    private JTextField distanceToleranceTF = new JTextField();
    private JLabel jLabel9 = new JLabel();
    private JLabel jLabelSG = new JLabel();
    private JLabel jLabelTol = new JLabel();
    private JButton editLine = new JButton();
    private JLabel jLabel11 = new JLabel();
    private JLabel jLabel12 = new JLabel();
    private JLabel jLabelBox = new JLabel();
    private JLabel jLabelBoxColor = new JLabel();
    private JLabel jLabelGrow = new JLabel();
    private JCheckBox outlineCB = new JCheckBox();
    private ColorEntryPanel outlineColor = new ColorEntryPanel();
    private JLabel jLabel13 = new JLabel();
    private JCheckBox visibleCB = new JCheckBox();
    private JCheckBox drawBoxCB = new JCheckBox();

    public GeometryAttributeDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public GeometryAttributeDialog() {
        this(new Frame(), "GeometryAttributeDialog", false);
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryAttributeDialog.this.okButton_actionPerformed(e);
            }
        });
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryAttributeDialog.this.applyButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryAttributeDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.jLabel1.setText("Position:");
        this.jLabel2.setText("Font:");
        this.fontLabel.setText("Dialog, 12, Bold");
        this.fontEditor.setToolTipText("Edit font.");
        this.fontEditor.setActionCommand("...");
        this.fontEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryAttributeDialog.this.fontEditor_actionPerformed(e);
            }
        });
        this.jLabel4.setText("Color:");
        this.labelColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel5.setText("Height:");
        this.labelHeightTextField.setColumns(10);
        this.boxGrowByTextField.setColumns(10);
        this.jLabel6.setText("Draw Label?");
        this.boxColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.labelPanel.setLayout(this.gridBagLayout1);
        this.newColorMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryAttributeDialog.this.newColorMapButton_actionPerformed(e);
            }
        });
        this.loadColorMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryAttributeDialog.this.loadColorMapButton_actionPerformed(e);
            }
        });
        this.saveColorMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryAttributeDialog.this.saveColorMapButton_actionPerformed(e);
            }
        });
        this.jLabel3.setText("Default Color:");
        this.defaultFillColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel8.setText("Mark:");
        this.markEditor.setToolTipText("");
        this.markEditor.setActionCommand("...");
        this.markEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryAttributeDialog.this.markEditor_actionPerformed(e);
            }
        });
        this.jLabel10.setText("Height:");
        this.markHeightTextField.setColumns(10);
        this.pointPanel.setLayout(this.gridBagLayout2);
        this.polygonPanel.setLayout(this.gridBagLayout3);
        this.jLabel7.setText("Draw Outline?");
        this.jLabel9.setText("Outline Style:");
        this.jLabelSG.setText("Simplify Geometry:");
        this.jLabelTol.setText("Distance Tolerance:");
        this.jLabelBox.setText("Draw Box:");
        this.jLabelBoxColor.setText("Box Color:");
        this.jLabelGrow.setText("Grow Box by:");
        this.editLine.setText("Edit Line");
        this.editLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryAttributeDialog.this.editLine_actionPerformed(e);
            }
        });
        this.jLabel11.setText("Mark Outline:");
        this.jLabel12.setText("Outline Color:");
        this.outlineColor.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel13.setText("Visible:");
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.applyButton);
        this.buttonPanel.add(this.cancelButton);
        this.panel1.add((Component)this.mainPanel, "Center");
        this.fontPanel.add(this.fontLabel);
        this.fontPanel.add(this.fontEditor);
        this.mainPanel.add((Component)this.labelPanel, "Label");
        String[] tempString = new String[]{"Centered", "North", "NorthEast", "East", "SouthEast", "South", "SouthWest", "West", "NorthWest"};
        for (int i = 0; i < tempString.length; ++i) {
            this.positionCBModel.addElement(tempString[i]);
        }
        this.positionComboBox.setModel(this.positionCBModel);
        this.ColorMapPanel.setLayout(new BorderLayout(0, 0));
        this.ColorMapPanel.setBounds(2, 27, 511, 271);
        this.ColorMapPanel.setVisible(false);
        this.colorControlPanel.setLayout(new GridBagLayout());
        this.colorMapPanel.setBorder(this.titledBorder2);
        this.colorMapPanel.setLayout(new GridBagLayout());
        this.newColorMapButton.setToolTipText("Create new color map.");
        this.newColorMapButton.setText("New...");
        this.newColorMapButton.setActionCommand("New...");
        this.loadColorMapButton.setToolTipText("Load color map from disk.");
        this.loadColorMapButton.setText("Load...");
        this.loadColorMapButton.setActionCommand("Load...");
        this.colorMapPanel.add((Component)this.newColorMapButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.colorMapPanel.add((Component)this.loadColorMapButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.colorMapPanel.add((Component)this.saveColorMapButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.ColorMapPanel.add((Component)this.defaultColorPanel, "Center");
        this.saveColorMapButton.setToolTipText("Save color map to disk.");
        this.saveColorMapButton.setText("Save...");
        this.saveColorMapButton.setActionCommand("Save...");
        this.defaultColorPanel.setLayout(new GridBagLayout());
        this.ColorMapPanel.add((Component)this.colorControlPanel, "East");
        this.colorControlPanel.add((Component)this.colorMapPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.colorButtonsPanel.setLayout(new GridLayout(16, 16, 1, 1));
        this.defaultColorPanel.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 15, 3), 0, 0));
        this.defaultColorPanel.add((Component)this.defaultFillColorPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 15, 15), 0, 0));
        this.defaultColorPanel.add((Component)this.colorButtonsPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(15, 15, 15, 15), 0, 0));
        this.jPanel2.add(this.plotMarkIconLabel);
        this.jPanel2.add(this.markEditor);
        this.mainPanel.add((Component)this.pointPanel, "Point");
        this.polygonPanel.add((Component)this.jLabel7, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(25, 15, 5, 3), 0, 0));
        this.polygonPanel.add((Component)this.drawOutlineCB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 3, 5, 15), 0, 0));
        this.polygonPanel.add((Component)this.jLabel9, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.polygonPanel.add((Component)this.editLine, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 5, 15), 0, 0));
        this.polygonPanel.add((Component)this.jLabelSG, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.polygonPanel.add((Component)this.simplifyGeometryCB, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 5, 15), 0, 0));
        this.polygonPanel.add((Component)this.jLabelTol, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 25, 3), 0, 0));
        this.polygonPanel.add((Component)this.distanceToleranceTF, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 3, 25, 15), 0, 0));
        this.mainPanel.add((Component)this.polygonPanel, "Polygon");
        this.mainPanel.add((Component)this.ColorMapPanel, "Color");
        this.pointPanel.add((Component)this.jLabel8, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(25, 15, 5, 3), 0, 0));
        this.pointPanel.add((Component)this.jPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 3, 5, 15), 0, 0));
        this.pointPanel.add((Component)this.markHeightTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 5, 15), 0, 0));
        this.pointPanel.add((Component)this.jLabel10, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.pointPanel.add((Component)this.jLabel11, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.pointPanel.add((Component)this.jLabel12, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 15, 3), 0, 0));
        this.pointPanel.add((Component)this.outlineCB, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 5, 15), 0, 0));
        this.pointPanel.add((Component)this.outlineColor, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 15, 3), 0, 0));
        this.labelPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(25, 15, 5, 3), 0, 0));
        this.labelPanel.add((Component)this.positionComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 3, 5, 15), 0, 0));
        this.labelPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.labelPanel.add((Component)this.fontPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 5, 15), 0, 0));
        this.labelPanel.add((Component)this.jLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.labelPanel.add((Component)this.labelColorPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 5, 15), 0, 0));
        this.labelPanel.add((Component)this.jLabel5, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.labelPanel.add((Component)this.labelHeightTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 5, 15), 0, 0));
        this.labelPanel.add((Component)this.jLabel6, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.labelPanel.add((Component)this.drawLabelCheckBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 15), 0, 0));
        this.labelPanel.add((Component)this.jLabel13, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.labelPanel.add((Component)this.visibleCB, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 5), 0, 0));
        this.labelPanel.add((Component)this.jLabelBox, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.labelPanel.add((Component)this.drawBoxCB, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 5), 0, 0));
        this.labelPanel.add((Component)this.jLabelBoxColor, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.labelPanel.add((Component)this.boxColorPanel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 5, 15), 0, 0));
        this.labelPanel.add((Component)this.jLabelGrow, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 3), 0, 0));
        this.labelPanel.add((Component)this.boxGrowByTextField, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 5, 15), 0, 0));
        this.makeColorToggleButtons();
        this.pmIcon_ = new PlotMarkIcon(1);
        this.plotMarkIconLabel.setIcon(this.pmIcon_);
    }

    private void makeColorToggleButtons() {
        Insets insets = new Insets(0, 0, 0, 0);
        ButtonGroup bg = new ButtonGroup();
        ColorSwatchIcon csi = null;
        for (int i = 0; i < 256; ++i) {
            JToggleButton tb = new JToggleButton("");
            if (System.getProperty("mrj.version") == null || !UIManager.getSystemLookAndFeelClassName().equals(UIManager.getLookAndFeel().getClass().getName())) {
                tb.setMargin(insets);
            }
            csi = new ColorSwatchIcon(Color.white, 8, 8);
            tb.setIcon(csi);
            this.colorButtons_[i] = tb;
            this.colorButtonsPanel.add(tb);
            bg.add(tb);
        }
    }

    public void fontEditor_actionPerformed(ActionEvent e) {
        FontDialog fd = new FontDialog();
        int result = fd.showDialog(this.labelFont_);
        if (result == FontDialog.OK_RESPONSE) {
            this.labelFont_ = fd.getFont();
            this.fontLabel.setText(this.fontString(this.labelFont_));
            this.fontLabel.setFont(this.labelFont_);
        }
    }

    String fontString(Font font) {
        int style = (font.isBold() ? 1 : 0) + (font.isItalic() ? 2 : 0);
        return font.getName() + " " + this.styleNames_[style];
    }

    void newColorMapButton_actionPerformed(ActionEvent event) {
        int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] green = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.colorMap_ = new IndexedColorMap(red, green, blue);
        ((IndexedColorMap)this.colorMap_).setTransform(new LinearTransform(0.0, (double)red.length, 0.0, 1.0));
        this.initColorMap();
    }

    void loadColorMapButton_actionPerformed(ActionEvent event) {
        int[] r = new int[256];
        int[] g = new int[256];
        int[] b = new int[256];
        int lastindx = -1;
        File file = null;
        StreamTokenizer st = null;
        JFileChooser chooser = new JFileChooser("C:/local/pal");
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            file = chooser.getSelectedFile();
            try {
                BufferedReader rdr = new BufferedReader(new FileReader(file));
                st = new StreamTokenizer(rdr);
            }
            catch (FileNotFoundException e) {
                System.out.println(e);
                return;
            }
            try {
                st.nextToken();
                while (st.ttype != -1) {
                    ++lastindx;
                    if (st.ttype == -2) {
                        r[lastindx] = (int)st.nval;
                        st.nextToken();
                        g[lastindx] = (int)st.nval;
                        st.nextToken();
                        b[lastindx] = (int)st.nval;
                    }
                    if (st.nextToken() != 10) continue;
                    st.nextToken();
                }
            }
            catch (IOException e) {
                System.out.println(e);
            }
            int[] red = new int[lastindx + 1];
            int[] green = new int[lastindx + 1];
            int[] blue = new int[lastindx + 1];
            for (int i = 0; i <= lastindx; ++i) {
                red[i] = r[i];
                green[i] = g[i];
                blue[i] = b[i];
            }
            this.colorMap_ = new IndexedColorMap(red, green, blue);
            ((IndexedColorMap)this.colorMap_).setTransform(new LinearTransform(0.0, (double)red.length, 0.0, 1.0));
            this.initColorMap();
        }
    }

    private void initColorMap() {
        if (this.colorMap_ instanceof IndexedColor) {
            ColorSwatchIcon csi;
            int i;
            int maxindx = ((IndexedColor)((Object)this.colorMap_)).getMaximumIndex();
            for (i = 0; i <= maxindx; ++i) {
                csi = new ColorSwatchIcon((IndexedColor)((Object)this.colorMap_), i, 8);
                this.colorButtons_[i].setIcon(csi);
                this.colorButtons_[i].setEnabled(true);
            }
            for (i = maxindx + 1; i < 256; ++i) {
                csi = new ColorSwatchIcon(Color.white, 8, 8);
                this.colorButtons_[i].setIcon(csi);
                this.colorButtons_[i].setEnabled(false);
            }
        }
    }

    public void saveColorMapButton_actionPerformed(ActionEvent e) {
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.updateGeometryAttribute();
        this.setVisible(false);
    }

    void applyButton_actionPerformed(ActionEvent event) {
        this.updateGeometryAttribute();
    }

    public void setGeometryAttribute(GeometryAttribute attr, JPane pane) {
        this.pane_ = pane;
        this.attr_ = attr;
        this.visibleCB.setSelected(this.attr_.isVisible());
        this.drawBoxCB.setSelected(this.attr_.isDrawBox());
        this.boxColorPanel.setColor(this.attr_.getBoxColor());
        this.boxGrowByTextField.setText(Double.toString(this.attr_.getBoxGrowBy()));
        this.positionComboBox.setSelectedIndex(this.attr_.getLabelPosition());
        this.labelFont_ = this.attr_.getLabelFont();
        if (this.pane_ != null && this.labelFont_ == null) {
            this.labelFont_ = this.pane_.getComponent().getFont();
        }
        this.fontLabel.setText(this.fontString(this.labelFont_));
        this.labelColorPanel.setColor(this.attr_.getLabelColor());
        this.labelHeightTextField.setText(Double.toString(this.attr_.getLabelHeightP()));
        this.drawLabelCheckBox.setSelected(this.attr_.isDrawLabel());
        this.colorMap_ = attr.getFillColor();
        this.initColorMap();
        this.defaultFillColorPanel.setColor(this.attr_.getDefaultFillColor());
        this.drawOutlineCB.setSelected(this.attr_.isDrawOutline());
        this.simplifyGeometryCB.setSelected(this.attr_.isGeometrySimplified());
        this.distanceToleranceTF.setText(Double.toString(this.attr_.getSimplifyDistanceTolerance()));
        int mark = this.attr_.getFillMark();
        this.changeMark(mark);
        this.markHeightTextField.setText(Double.toString(this.attr_.getFillMarkHeightP()));
        this.outlineCB.setSelected(this.attr_.isMarkOutline());
        this.outlineColor.setColor(this.attr_.getMarkOutlineColor());
    }

    void updateGeometryAttribute() {
        this.attr_.setBatch(true);
        this.attr_.setVisible(this.visibleCB.isSelected());
        this.attr_.setDrawBox(this.drawBoxCB.isSelected());
        this.attr_.setBoxColor(this.boxColorPanel.getColor());
        this.attr_.setBoxGrowBy(new Double(this.boxGrowByTextField.getText()));
        this.attr_.setLabelPosition(this.positionComboBox.getSelectedIndex());
        this.attr_.setLabelFont(this.labelFont_);
        this.attr_.setLabelColor(this.labelColorPanel.getColor());
        this.attr_.setLabelHeightP(new Double(this.labelHeightTextField.getText()));
        this.attr_.setDrawLabel(this.drawLabelCheckBox.isSelected());
        this.attr_.setFillColor(this.colorMap_);
        this.attr_.setDefaultFillColor(this.defaultFillColorPanel.getColor());
        this.attr_.setDrawOutline(this.drawOutlineCB.isSelected());
        this.attr_.setGeometrySimplified(this.simplifyGeometryCB.isSelected());
        this.attr_.setSimplifyDistanceTolerance(Double.parseDouble(this.distanceToleranceTF.getText()));
        this.attr_.setFillMark(this.mark_);
        this.attr_.setFillMarkHeightP(new Double(this.markHeightTextField.getText()));
        this.attr_.setMarkOutline(this.outlineCB.isSelected());
        this.attr_.setMarkOutlineColor(this.outlineColor.getColor());
        this.attr_.setBatch(false);
    }

    void markEditor_actionPerformed(ActionEvent event) {
        PlotMarkDialog pmd = new PlotMarkDialog();
        Point loc = this.markEditor.getLocationOnScreen();
        pmd.setLocation(loc.x, loc.y);
        int result = pmd.showDialog(this.mark_);
        if (result == PlotMarkDialog.OK_RESPONSE) {
            this.changeMark(pmd.getMark());
        }
    }

    private void changeMark(int mark) {
        this.mark_ = mark;
        this.pmIcon_.setMark(mark);
        this.plotMarkIconLabel.repaint();
    }

    public void editLine_actionPerformed(ActionEvent e) {
        LineAttributeDialog lad = new LineAttributeDialog();
        lad.setJPane(this.pane_);
        lad.setLineAttribute(this.attr_.getOutlineAttribute());
        lad.setVisible(true);
    }
}

