/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.swing.prop;

import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LatitudeAxis;
import gov.noaa.pmel.sgt.LongitudeAxis;
import gov.noaa.pmel.sgt.SpaceAxis;
import gov.noaa.pmel.sgt.swing.prop.ColorEntryPanel;
import gov.noaa.pmel.sgt.swing.prop.FontDialog;
import gov.noaa.pmel.sgt.swing.prop.GeoDateDialog;
import gov.noaa.pmel.sgt.swing.prop.GridBagConstraints;
import gov.noaa.pmel.swing.ThreeDotsButton;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.TimePoint;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class SpaceAxisDialog
extends JDialog {
    private JPane pane_;
    private SpaceAxis sa_;
    private Font labelFont_;
    private boolean originIsGeoDate_;
    private GeoDate tOrigin_ = null;
    private String[] styleNames_ = new String[]{"plain", "bold", "italic", "bold-italic"};
    private String dateFormat_ = "yyyy-MM-dd HH:mm:ss";
    private boolean longitude_ = false;
    private boolean latitude_ = false;
    boolean fComponentsAdjusted = false;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton applyButton = new JButton();
    JButton cancelButton = new JButton();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JTabbedPane TabbedPane = new JTabbedPane();
    JPanel labelPanel = new JPanel();
    JLabel JLabel3 = new JLabel();
    JTextField intervalTextField = new JTextField();
    JLabel JLabel4 = new JLabel();
    JTextField sigDigitsTextField = new JTextField();
    JLabel JLabel5 = new JLabel();
    JTextField formatTextField = new JTextField();
    JLabel JLabel11 = new JLabel();
    ColorEntryPanel textColorPanel = new ColorEntryPanel();
    JLabel JLabel15 = new JLabel();
    JPanel fontPanel = new JPanel();
    JLabel fontLabel = new JLabel();
    ThreeDotsButton fontEditor = new ThreeDotsButton();
    JLabel JLabel16 = new JLabel();
    JTextField heightTextField = new JTextField();
    JLabel JLabel1 = new JLabel();
    JComboBox positionComboBox = new JComboBox();
    JPanel rangePanel = new JPanel();
    JPanel userPanel = new JPanel();
    JLabel JLabel8 = new JLabel();
    JTextField minUserTextField = new JTextField();
    JLabel JLabel9 = new JLabel();
    JTextField maxUserTextField = new JTextField();
    JLabel JLabel2 = new JLabel();
    JTextField incUserTextField = new JTextField();
    JPanel physicalPanel = new JPanel();
    JLabel JLabel10 = new JLabel();
    JTextField minPhysicalTextField = new JTextField();
    JLabel JLabel17 = new JLabel();
    JTextField maxPhysicalTextField = new JTextField();
    JLabel originLabel = new JLabel();
    JTextField originTextField = new JTextField();
    ThreeDotsButton originDateEditor = new ThreeDotsButton();
    JPanel ticsStylePanel = new JPanel();
    JPanel ticsPanel = new JPanel();
    JLabel JLabel18 = new JLabel();
    JTextField largeTicTextField = new JTextField();
    JLabel JLabel19 = new JLabel();
    JTextField smallTicTextField = new JTextField();
    JLabel JLabel20 = new JLabel();
    JTextField numSmallTicsTextField = new JTextField();
    JLabel JLabel21 = new JLabel();
    JComboBox ticPositionComboBox = new JComboBox();
    JPanel stylePanel = new JPanel();
    JLabel JLabel7 = new JLabel();
    JCheckBox axislVisibleCheckBox = new JCheckBox();
    JLabel JLabel6 = new JLabel();
    JCheckBox axisSelectableCheckBox = new JCheckBox();
    JPanel attachPanel = new JPanel();
    JLabel JLabel23 = new JLabel();
    JCheckBox transformCheckBox = new JCheckBox();
    JLabel axisLabel = new JLabel();
    JCheckBox axisCheckBox = new JCheckBox();
    DefaultComboBoxModel horizCBModel = new DefaultComboBoxModel();
    DefaultComboBoxModel vertCBModel = new DefaultComboBoxModel();
    DefaultComboBoxModel positionCBModel = new DefaultComboBoxModel();
    TitledBorder userBorder = new TitledBorder("User Range");
    TitledBorder physicalBorder = new TitledBorder("Physical Range");
    TitledBorder ticsBorder = new TitledBorder("Tics");
    TitledBorder styleBorder = new TitledBorder("Axis Style");
    DefaultComboBoxModel ticPositionCBModel = new DefaultComboBoxModel();
    DefaultComboBoxModel yLabelCBModel = new DefaultComboBoxModel();
    private ColorEntryPanel lineColorPanel = new ColorEntryPanel();
    private JLabel jLabel1 = new JLabel();
    JLabel quadrantLabel = new JLabel();
    JLabel Lon360Label = new JLabel();
    JCheckBox quadrantCB = new JCheckBox();
    JCheckBox lon360CB = new JCheckBox();
    JLabel jLabel2 = new JLabel();
    JComboBox yLabelCB = new JComboBox();

    public SpaceAxisDialog(Frame parent) {
        super(parent);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        int i;
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(457, 344);
        this.setVisible(false);
        this.buttonPanel.setBorder(this.etchedBorder1);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.jLabel1.setText("Line Color:");
        this.quadrantLabel.setText("Label Quadrant:");
        this.Lon360Label.setText("0 to 360");
        this.lon360CB.setSelected(true);
        this.quadrantCB.setSelected(true);
        this.jLabel2.setText("YLabel Orientation:");
        this.yLabelCB.setModel(this.yLabelCBModel);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add(this.okButton);
        this.applyButton.setText("Apply");
        this.applyButton.setActionCommand("Apply");
        this.buttonPanel.add(this.applyButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.TabbedPane, "Center");
        this.labelPanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.labelPanel, "labelPanel");
        this.labelPanel.setBounds(2, 27, 452, 275);
        this.labelPanel.setVisible(false);
        this.JLabel3.setText("Interval:");
        this.intervalTextField.setColumns(5);
        this.JLabel4.setText("Sig Digits:");
        this.sigDigitsTextField.setColumns(5);
        this.JLabel5.setText("Format:");
        this.formatTextField.setColumns(10);
        this.JLabel11.setText("Color:");
        this.textColorPanel.setLayout(new FlowLayout(1, 5, 5));
        this.JLabel15.setText("Font:");
        this.fontPanel.setLayout(new FlowLayout(1, 5, 5));
        this.fontLabel.setText("Dialog, 12, Bold");
        this.fontPanel.add(this.fontLabel);
        this.fontLabel.setForeground(Color.black);
        this.fontEditor.setToolTipText("Edit font.");
        this.fontEditor.setActionCommand("...");
        this.fontPanel.add(this.fontEditor);
        this.JLabel16.setText("Height:");
        this.heightTextField.setColumns(10);
        this.JLabel1.setText("Position:");
        this.positionComboBox.setModel(this.positionCBModel);
        this.rangePanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.rangePanel, "rangePanel");
        this.rangePanel.setBounds(2, 27, 452, 275);
        this.rangePanel.setVisible(false);
        this.userPanel.setBorder(this.userBorder);
        this.userPanel.setLayout(new GridBagLayout());
        this.rangePanel.add((Component)this.userPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 20, 15));
        this.JLabel8.setText("Minimum:");
        this.userPanel.add((Component)this.JLabel8, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.minUserTextField.setColumns(25);
        this.userPanel.add((Component)this.minUserTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel9.setText("Maximum:");
        this.userPanel.add((Component)this.JLabel9, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.maxUserTextField.setColumns(25);
        this.userPanel.add((Component)this.maxUserTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel2.setText("Delta:");
        this.userPanel.add((Component)this.JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.incUserTextField.setColumns(25);
        this.userPanel.add((Component)this.incUserTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.physicalPanel.setBorder(this.physicalBorder);
        this.physicalPanel.setLayout(new GridBagLayout());
        this.rangePanel.add((Component)this.physicalPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 20, 15));
        this.JLabel10.setText("Minimum:");
        this.physicalPanel.add((Component)this.JLabel10, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.minPhysicalTextField.setColumns(25);
        this.physicalPanel.add((Component)this.minPhysicalTextField, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel17.setText("Maximum:");
        this.physicalPanel.add((Component)this.JLabel17, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.maxPhysicalTextField.setColumns(25);
        this.physicalPanel.add((Component)this.maxPhysicalTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.originLabel.setText("Y Origin:");
        this.physicalPanel.add((Component)this.originLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.originTextField.setColumns(20);
        this.physicalPanel.add((Component)this.originTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.originDateEditor.setToolTipText("Edit origin date.");
        this.originDateEditor.setActionCommand("...");
        this.originDateEditor.setEnabled(false);
        this.physicalPanel.add((Component)this.originDateEditor, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.ticsStylePanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.ticsStylePanel, "ticsStylePanel");
        this.ticsStylePanel.setBounds(2, 27, 452, 275);
        this.ticsStylePanel.setVisible(false);
        this.ticsPanel.setBorder(this.ticsBorder);
        this.ticsPanel.setLayout(new GridBagLayout());
        this.ticsStylePanel.add((Component)this.ticsPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 10, 10));
        this.JLabel18.setText("Large Tic Height:");
        this.ticsPanel.add((Component)this.JLabel18, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.largeTicTextField.setColumns(15);
        this.ticsPanel.add((Component)this.largeTicTextField, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel19.setText("Small Tic Height:");
        this.ticsPanel.add((Component)this.JLabel19, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.smallTicTextField.setColumns(15);
        this.ticsPanel.add((Component)this.smallTicTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel20.setText("Number of Small Tics:");
        this.ticsPanel.add((Component)this.JLabel20, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.numSmallTicsTextField.setColumns(5);
        this.ticsPanel.add((Component)this.numSmallTicsTextField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.JLabel21.setText("Tic Position:");
        this.ticsPanel.add((Component)this.JLabel21, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.ticPositionComboBox.setModel(this.ticPositionCBModel);
        this.ticsPanel.add((Component)this.ticPositionComboBox, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.ticsPanel.add((Component)this.lineColorPanel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.stylePanel.setBorder(this.styleBorder);
        this.stylePanel.setLayout(new GridBagLayout());
        this.ticsStylePanel.add((Component)this.stylePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 20, 10));
        this.JLabel7.setText("Visible:");
        this.stylePanel.add((Component)this.JLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.axislVisibleCheckBox.setSelected(true);
        this.stylePanel.add((Component)this.axislVisibleCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.JLabel6.setHorizontalAlignment(4);
        this.JLabel6.setText("Selectable:");
        this.stylePanel.add((Component)this.JLabel6, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 61, 0));
        this.axisSelectableCheckBox.setSelected(true);
        this.stylePanel.add((Component)this.axisSelectableCheckBox, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.attachPanel.setLayout(new GridBagLayout());
        this.TabbedPane.add((Component)this.attachPanel, "attachPanel");
        this.attachPanel.setBounds(2, 27, 452, 275);
        this.attachPanel.setVisible(false);
        this.JLabel23.setText("Attach Transform to Axis:");
        this.attachPanel.add((Component)this.JLabel23, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.attachPanel.add((Component)this.transformCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.axisLabel.setText("Attach X Axis to Axis:");
        this.attachPanel.add((Component)this.axisLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.attachPanel.add((Component)this.axisCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.ticsPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.intervalTextField, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.labelPanel.add((Component)this.JLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.sigDigitsTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.labelPanel.add((Component)this.JLabel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.formatTextField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.labelPanel.add((Component)this.JLabel11, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.textColorPanel, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.JLabel15, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.fontPanel, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.JLabel16, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.heightTextField, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.labelPanel.add((Component)this.JLabel1, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.positionComboBox, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.labelPanel.add((Component)this.quadrantLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.Lon360Label, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.lon360CB, new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.labelPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.labelPanel.add((Component)this.quadrantCB, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.labelPanel.add((Component)this.yLabelCB, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.TabbedPane.setSelectedComponent(this.labelPanel);
        this.TabbedPane.setSelectedIndex(0);
        this.TabbedPane.setTitleAt(0, "Label");
        this.TabbedPane.setTitleAt(1, "Range");
        this.TabbedPane.setTitleAt(2, "Tics/Style");
        this.TabbedPane.setTitleAt(3, "Attach");
        String[] tempString = new String[]{"LEFT", "CENTER", "RIGHT"};
        for (i = 0; i < tempString.length; ++i) {
            this.horizCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"TOP", "MIDDLE", "BOTTOM"};
        for (i = 0; i < tempString.length; ++i) {
            this.vertCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"POSITIVE_SIDE", "NEGATIVE_SIDE", "NO_LABEL"};
        for (i = 0; i < tempString.length; ++i) {
            this.positionCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"POSITIVE_SIDE", "NEGATIVE_SIDE", "BOTH_SIDES"};
        for (i = 0; i < tempString.length; ++i) {
            this.ticPositionCBModel.addElement(tempString[i]);
        }
        tempString = new String[]{"HORIZONTAL", "VERTICAL"};
        for (i = 0; i < tempString.length; ++i) {
            this.yLabelCBModel.addElement(tempString[i]);
        }
        this.positionComboBox.setSelectedIndex(1);
        this.ticPositionComboBox.setSelectedIndex(1);
        this.setTitle("TimeAxis");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.cancelButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        this.fontEditor.addActionListener(lSymAction);
        this.applyButton.addActionListener(lSymAction);
        this.minUserTextField.addActionListener(lSymAction);
        this.maxUserTextField.addActionListener(lSymAction);
        this.originTextField.addActionListener(lSymAction);
        this.originDateEditor.addActionListener(lSymAction);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public SpaceAxisDialog(String title) {
        this();
        this.setTitle(title);
    }

    public SpaceAxisDialog() {
        this((Frame)null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void FontDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.updateSpaceAxis();
        this.setVisible(false);
    }

    void applyButton_actionPerformed(ActionEvent event) {
        this.updateSpaceAxis();
    }

    public static void main(String[] args) {
        SpaceAxisDialog la = new SpaceAxisDialog();
        la.setFont(null);
        la.setTitle("Test SpaceAxis Dialog");
        la.setVisible(true);
    }

    public void setSpaceAxis(SpaceAxis sa, JPane pane) {
        this.setJPane(pane);
        this.setSpaceAxis(sa);
    }

    public void setSpaceAxis(SpaceAxis sa) {
        this.sa_ = sa;
        this.longitude_ = sa instanceof LongitudeAxis;
        this.latitude_ = sa instanceof LatitudeAxis;
        if (this.longitude_) {
            this.quadrantLabel.setVisible(true);
            this.Lon360Label.setVisible(true);
            this.quadrantCB.setVisible(true);
            this.lon360CB.setVisible(true);
        } else if (this.latitude_) {
            this.quadrantLabel.setVisible(true);
            this.Lon360Label.setVisible(false);
            this.quadrantCB.setVisible(true);
            this.lon360CB.setVisible(false);
        } else {
            this.quadrantLabel.setVisible(false);
            this.Lon360Label.setVisible(false);
            this.quadrantCB.setVisible(false);
            this.lon360CB.setVisible(false);
        }
        this.setSpaceAxis();
    }

    public SpaceAxis getSpaceAxis() {
        return this.sa_;
    }

    public void setJPane(JPane pane) {
        this.pane_ = pane;
    }

    public JPane getJPane() {
        return this.pane_;
    }

    private void setSpaceAxis() {
        this.setTitle("SpaceAxis - " + this.sa_.getId());
        this.intervalTextField.setText(Integer.toString(this.sa_.getLabelInterval()));
        this.sigDigitsTextField.setText(Integer.toString(this.sa_.getSignificantDigits()));
        this.formatTextField.setText(this.sa_.getLabelFormat());
        if (this.longitude_) {
            this.quadrantCB.setSelected(((LongitudeAxis)this.sa_).isLabelQuadrant());
            this.lon360CB.setSelected(((LongitudeAxis)this.sa_).isLongitude360());
        }
        if (this.latitude_) {
            this.quadrantCB.setSelected(((LatitudeAxis)this.sa_).isLabelQuadrant());
        }
        this.yLabelCB.setSelectedIndex(this.sa_.getVerticalLabelOrientation());
        Color col = this.sa_.getLabelColor();
        if (col == null) {
            col = this.pane_.getComponent().getForeground();
        }
        this.textColorPanel.setColor(col);
        this.labelFont_ = this.sa_.getLabelFont();
        if (this.labelFont_ == null) {
            this.labelFont_ = this.pane_.getComponent().getFont();
        }
        this.fontLabel.setText(this.fontString(this.labelFont_));
        this.heightTextField.setText(String.valueOf(this.sa_.getLabelHeightP()));
        Range2D urange = this.sa_.getRangeU();
        this.minUserTextField.setText(String.valueOf(urange.start));
        this.maxUserTextField.setText(String.valueOf(urange.end));
        this.incUserTextField.setText(String.valueOf(urange.delta));
        Range2D range = this.sa_.getRangeP();
        this.minPhysicalTextField.setText(String.valueOf(range.start));
        this.maxPhysicalTextField.setText(String.valueOf(range.end));
        Point2D.Double pt = this.sa_.getLocationU();
        TimePoint tt2 = null;
        double point = 0.0;
        if (pt == null) {
            this.originIsGeoDate_ = true;
            tt2 = this.sa_.getTimeLocationU();
            this.tOrigin_ = tt2.t;
        } else {
            this.originIsGeoDate_ = false;
            point = this.sa_.getOrientation() == 0 ? pt.y : pt.x;
        }
        if (this.sa_.getOrientation() == 0) {
            this.originLabel.setText("Y Origin:");
        } else {
            this.originLabel.setText("X Origin:");
        }
        if (this.originIsGeoDate_) {
            this.originDateEditor.setEnabled(true);
            this.originTextField.setText(this.tOrigin_.toString());
        } else {
            this.originDateEditor.setEnabled(false);
            this.originTextField.setText(String.valueOf(point));
        }
        this.largeTicTextField.setText(String.valueOf(this.sa_.getLargeTicHeightP()));
        this.smallTicTextField.setText(String.valueOf(this.sa_.getSmallTicHeightP()));
        this.numSmallTicsTextField.setText(String.valueOf(this.sa_.getNumberSmallTics()));
        this.ticPositionComboBox.setSelectedIndex(this.sa_.getTicPosition());
        Color lcol = this.sa_.getLineColor();
        if (lcol == null) {
            col = this.pane_.getComponent().getForeground();
        }
        this.lineColorPanel.setColor(col);
        this.axislVisibleCheckBox.setSelected(this.sa_.isVisible());
        this.axisSelectableCheckBox.setSelected(this.sa_.isSelectable());
        boolean test = this.sa_.getNumberRegisteredTransforms() > 0;
        this.transformCheckBox.setSelected(test);
        if (this.sa_.getOrientation() == 0) {
            test = this.sa_.getGraph().getNumberXAxis() >= 2;
            this.axisLabel.setEnabled(test);
            this.axisCheckBox.setEnabled(test);
            this.axisLabel.setText("Attach X Axis to Axis:");
            test = this.sa_.getNumberRegisteredAxes() > 0;
            this.axisCheckBox.setSelected(test);
        } else {
            test = this.sa_.getGraph().getNumberYAxis() >= 2;
            this.axisLabel.setEnabled(test);
            this.axisCheckBox.setEnabled(test);
            this.axisLabel.setText("Attach Y Axis to Axis:");
            test = this.sa_.getNumberRegisteredAxes() > 0;
            this.axisCheckBox.setSelected(test);
        }
    }

    private void updateSpaceAxis() {
        Object pt;
        this.pane_.setBatch(true, "SpaceAxisDialog");
        this.sa_.setLabelInterval(Integer.parseInt(this.intervalTextField.getText()));
        this.sa_.setSignificantDigits(Integer.parseInt(this.sigDigitsTextField.getText()));
        this.sa_.setLabelFormat(this.formatTextField.getText());
        this.sa_.setLabelColor(this.textColorPanel.getColor());
        if (this.labelFont_ != null) {
            this.sa_.setLabelFont(this.labelFont_);
        }
        this.sa_.setLabelHeightP(Double.valueOf(this.heightTextField.getText()));
        this.sa_.setLabelPosition(this.positionComboBox.getSelectedIndex());
        this.sa_.setVerticalLabelOrientation(this.yLabelCB.getSelectedIndex());
        if (this.longitude_) {
            ((LongitudeAxis)this.sa_).setLabelQuadrant(this.quadrantCB.isSelected());
            ((LongitudeAxis)this.sa_).setLongitude360(this.lon360CB.isSelected());
        }
        if (this.latitude_) {
            ((LatitudeAxis)this.sa_).setLabelQuadrant(this.quadrantCB.isSelected());
        }
        double min = Double.valueOf(this.minUserTextField.getText());
        double max = Double.valueOf(this.maxUserTextField.getText());
        double inc = Double.valueOf(this.incUserTextField.getText());
        this.sa_.setRangeU(new Range2D(min, max, inc));
        min = Double.valueOf(this.minPhysicalTextField.getText());
        max = Double.valueOf(this.maxPhysicalTextField.getText());
        this.sa_.setRangeP(new Range2D(min, max));
        if (this.originIsGeoDate_) {
            pt = this.sa_.getTimeLocationU();
            ((TimePoint)pt).t = this.tOrigin_;
            this.sa_.setLocationU((TimePoint)pt);
        } else {
            pt = this.sa_.getLocationU();
            if (this.sa_.getOrientation() == 0) {
                ((Point2D.Double)pt).y = Double.valueOf(this.originTextField.getText());
            } else {
                ((Point2D.Double)pt).x = Double.valueOf(this.originTextField.getText());
            }
            this.sa_.setLocationU((Point2D.Double)pt);
        }
        this.sa_.setLargeTicHeightP(Double.valueOf(this.largeTicTextField.getText()));
        this.sa_.setSmallTicHeightP(Double.valueOf(this.smallTicTextField.getText()));
        this.sa_.setNumberSmallTics(Integer.parseInt(this.numSmallTicsTextField.getText()));
        this.sa_.setTicPosition(this.ticPositionComboBox.getSelectedIndex());
        this.sa_.setLineColor(this.lineColorPanel.getColor());
        this.sa_.setVisible(this.axislVisibleCheckBox.isSelected());
        this.sa_.setSelectable(this.axisSelectableCheckBox.isSelected());
        if (this.transformCheckBox.isSelected() && this.sa_.getNumberRegisteredTransforms() < 1) {
            if (this.sa_.getOrientation() == 0) {
                this.sa_.register(this.sa_.getGraph().getXTransform());
            } else {
                this.sa_.register(this.sa_.getGraph().getYTransform());
            }
        } else if (this.sa_.getNumberRegisteredTransforms() > 0) {
            this.sa_.clearAllRegisteredTransforms();
        }
        if (this.sa_.getOrientation() == 0) {
            boolean test;
            boolean bl = test = this.sa_.getGraph().getNumberXAxis() >= 2 && this.sa_.getNumberRegisteredAxes() < 1;
            if (this.axisCheckBox.isSelected() && test) {
                Enumeration it = this.sa_.getGraph().xAxisElements();
                while (it.hasMoreElements()) {
                    Axis ax = (Axis)it.nextElement();
                    if (ax.getId().equals(this.sa_.getId())) continue;
                    this.sa_.register(ax);
                }
            } else if (this.sa_.getNumberRegisteredAxes() > 0) {
                this.sa_.clearAllRegisteredAxes();
            }
        } else {
            boolean test;
            boolean bl = test = this.sa_.getGraph().getNumberYAxis() >= 2 && this.sa_.getNumberRegisteredAxes() < 1;
            if (this.axisCheckBox.isSelected() && test) {
                Enumeration it = this.sa_.getGraph().yAxisElements();
                while (it.hasMoreElements()) {
                    Axis ax = (Axis)it.nextElement();
                    if (ax.getId().equals(this.sa_.getId())) continue;
                    this.sa_.register(ax);
                }
            } else if (this.sa_.getNumberRegisteredAxes() > 0) {
                this.sa_.clearAllRegisteredAxes();
            }
        }
        this.pane_.setBatch(false, "SpaceAxisDialog");
    }

    void fontEditor_actionPerformed(ActionEvent event) {
        FontDialog fd = new FontDialog();
        int result = fd.showDialog(this.labelFont_);
        if (result == FontDialog.OK_RESPONSE) {
            this.labelFont_ = fd.getFont();
            this.fontLabel.setText(this.fontString(this.labelFont_));
            this.fontLabel.setFont(this.labelFont_);
        }
    }

    String fontString(Font font) {
        int style = (font.isBold() ? 1 : 0) + (font.isItalic() ? 2 : 0);
        return font.getName() + " " + this.styleNames_[style];
    }

    void originTextField_actionPerformed(ActionEvent event) {
        if (this.originIsGeoDate_) {
            try {
                this.tOrigin_ = new GeoDate(this.originTextField.getText(), this.dateFormat_);
            }
            catch (IllegalTimeValue e) {
                this.originTextField.setText(this.tOrigin_.toString());
            }
        }
    }

    void originDateEditor_actionPerformed(ActionEvent event) {
        GeoDateDialog gd = new GeoDateDialog();
        Point loc = this.originDateEditor.getLocationOnScreen();
        int result = gd.showDialog(this.tOrigin_, loc.x, loc.y);
        if (result == GeoDateDialog.OK_RESPONSE) {
            this.tOrigin_ = gd.getGeoDate();
            this.originTextField.setText(this.tOrigin_.toString());
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == SpaceAxisDialog.this) {
                SpaceAxisDialog.this.FontDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == SpaceAxisDialog.this.cancelButton) {
                SpaceAxisDialog.this.cancelButton_actionPerformed(event);
            } else if (object == SpaceAxisDialog.this.okButton) {
                SpaceAxisDialog.this.okButton_actionPerformed(event);
            } else if (object == SpaceAxisDialog.this.fontEditor) {
                SpaceAxisDialog.this.fontEditor_actionPerformed(event);
            } else if (object == SpaceAxisDialog.this.applyButton) {
                SpaceAxisDialog.this.applyButton_actionPerformed(event);
            } else if (object == SpaceAxisDialog.this.originTextField) {
                SpaceAxisDialog.this.originTextField_actionPerformed(event);
            } else if (object == SpaceAxisDialog.this.originDateEditor) {
                SpaceAxisDialog.this.originDateEditor_actionPerformed(event);
            }
        }
    }
}

