/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.DragHandle;
import gov.noaa.pmel.swing.JStretchPanel;
import java.awt.Graphics;
import java.awt.Point;

public class CenterHDragHandle
extends DragHandle {
    private static Point setPt = new Point(0, 0);

    public CenterHDragHandle(JStretchPanel jsp, int h, int v, int type, int style, int orient, int axis, int uporleft, int loworright, double uporleftval, double loworrightval, double val) {
        super(jsp, h, v, type, style, orient, axis, uporleft, loworright, uporleftval, loworrightval, val);
    }

    @Override
    public void draw(Graphics g) {
        if (this.mH > this.getAxisOrigin() + this.getAxisRange() + 1 || this.mH < this.getAxisOrigin() - 1) {
            this.setOutOfRange(true);
            return;
        }
        this.setOutOfRange(false);
        if (this.isOutOfRange()) {
            return;
        }
        if (this.isFocused()) {
            g.setColor(this.grey100);
            g.fillRect(this.mH - 3, this.mV - 18, 7, 18);
        } else {
            g.setColor(this.grey100);
            g.drawRect(this.mH - 3, this.mV - 18, 7, 18);
        }
    }

    @Override
    public void getRect() {
        this.currHandleRect.x = this.mH - 3;
        this.currHandleRect.y = this.mV - 18;
        this.currHandleRect.width = 7;
        this.currHandleRect.height = 18;
    }

    @Override
    public Point constrainPoint(int h, int v) {
        int hh = h;
        int vv = v;
        vv = this.mVLimit;
        int delta = this.mRightOrLowerNeighbor.getCurrLocation().x - this.getCurrLocation().x;
        this.constrainedPoint.x = hh + this.mDeltaH + delta <= this.mLowerOrRightLimit && hh + this.mDeltaH - delta >= this.mUpperOrLeftLimit ? hh + this.mDeltaH : this.getCurrLocation().x;
        this.constrainedPoint.y = vv;
        return this.constrainedPoint;
    }

    @Override
    public void setNeighbors(boolean b) {
        this.setNeighbors();
    }

    @Override
    public void setNeighbors() {
        int delta = this.mRightOrLowerNeighbor.getCurrLocation().x - this.mLeftOrUpperNeighbor.getCurrLocation().x;
        CenterHDragHandle.setPt.x = this.getCurrLocation().x + delta / 2;
        CenterHDragHandle.setPt.y = this.getCurrLocation().y;
        double newVal = this.getNewValue(CenterHDragHandle.setPt.x);
        this.mRightOrLowerNeighbor.setValue(newVal);
        this.mRightOrLowerNeighbor.setDontBroadcast(true);
        this.mRightOrLowerNeighbor.setLocation(setPt);
        CenterHDragHandle.setPt.x = this.getCurrLocation().x - delta / 2;
        newVal = this.getNewValue(CenterHDragHandle.setPt.x);
        this.mLeftOrUpperNeighbor.setValue(newVal);
        this.mLeftOrUpperNeighbor.setDontBroadcast(true);
        this.mLeftOrUpperNeighbor.setLocation(setPt);
    }

    @Override
    public String getPropertyName() {
        switch (this.mAxis) {
            case 0: {
                return new String("latctr");
            }
            case 1: {
                return new String("lonctr");
            }
            case 2: {
                return new String("zctr");
            }
            case 3: {
                return new String("timctr");
            }
        }
        return null;
    }
}

