/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.DragHandle;
import gov.noaa.pmel.swing.JStretchPanel;
import java.awt.Graphics;
import java.awt.Point;

public class CenterVDragHandle
extends DragHandle {
    private static Point setPt = new Point(0, 0);

    public CenterVDragHandle(JStretchPanel jsp, int h, int v, int type, int style, int orient, int axis, int uporleft, int loworright, double uporleftval, double loworrightval, double val) {
        super(jsp, h, v, type, style, orient, axis, uporleft, loworright, uporleftval, loworrightval, val);
    }

    @Override
    public void draw(Graphics g) {
        if (this.mV > this.getAxisOrigin() + this.getAxisRange() + 1) {
            this.setOutOfRange(true);
            return;
        }
        if (this.mV < this.getAxisOrigin() - 1) {
            this.setOutOfRange(true);
            return;
        }
        this.setOutOfRange(false);
        if (this.isOutOfRange()) {
            return;
        }
        if (this.isFocused()) {
            g.setColor(this.grey100);
            g.fillRect(this.mH, this.mV - 3, 18, 7);
        } else {
            g.setColor(this.grey100);
            g.drawRect(this.mH, this.mV - 3, 18, 7);
        }
    }

    @Override
    public void getRect() {
        this.currHandleRect.x = this.mH;
        this.currHandleRect.y = this.mV - 3;
        this.currHandleRect.width = 18;
        this.currHandleRect.height = 7;
    }

    @Override
    public Point constrainPoint(int h, int v) {
        int hh = h;
        int vv = v;
        hh = this.mHLimit;
        int delta = this.mRightOrLowerNeighbor.getCurrLocation().y - this.getCurrLocation().y;
        this.constrainedPoint.y = vv + this.mDeltaV + delta <= this.mLowerOrRightLimit && vv + this.mDeltaV - delta >= this.mUpperOrLeftLimit ? vv + this.mDeltaV : this.getCurrLocation().y;
        this.constrainedPoint.x = hh;
        return this.constrainedPoint;
    }

    @Override
    public void setNeighbors(boolean b) {
        this.setNeighbors();
    }

    @Override
    public void setNeighbors() {
        int delta = this.mRightOrLowerNeighbor.getCurrLocation().y - this.mLeftOrUpperNeighbor.getCurrLocation().y;
        CenterVDragHandle.setPt.x = this.getCurrLocation().x;
        CenterVDragHandle.setPt.y = this.getCurrLocation().y + delta / 2;
        double newVal = this.getNewValue(CenterVDragHandle.setPt.y);
        this.mRightOrLowerNeighbor.setValue(newVal);
        this.mRightOrLowerNeighbor.setDontBroadcast(true);
        this.mRightOrLowerNeighbor.setLocation(setPt);
        CenterVDragHandle.setPt.y = this.getCurrLocation().y - delta / 2;
        newVal = this.getNewValue(CenterVDragHandle.setPt.y);
        this.mLeftOrUpperNeighbor.setValue(newVal);
        this.mLeftOrUpperNeighbor.setDontBroadcast(true);
        this.mLeftOrUpperNeighbor.setLocation(setPt);
    }

    @Override
    public String getPropertyName() {
        switch (this.mAxis) {
            case 0: {
                return new String("latctr");
            }
            case 1: {
                return new String("lonctr");
            }
            case 2: {
                return new String("zctr");
            }
            case 3: {
                return new String("timctr");
            }
        }
        return null;
    }
}

