/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.CenterHDragHandle;
import gov.noaa.pmel.swing.CenterVDragHandle;
import gov.noaa.pmel.swing.DragHandleChangedEvent;
import gov.noaa.pmel.swing.JStretchPanel;
import gov.noaa.pmel.swing.LeftDragHandle;
import gov.noaa.pmel.swing.LowerDragHandle;
import gov.noaa.pmel.swing.RightDragHandle;
import gov.noaa.pmel.swing.UpperDragHandle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class DragHandle
extends JComponent {
    public static int VORIENTATION = 0;
    public static int HORIENTATION = 1;
    public static int LEFTHANDLE = 0;
    public static int RIGHTHANDLE = 1;
    public static int UPPERHANDLE = 2;
    public static int LOWERHANDLE = 3;
    public static int CENTERHHANDLE = 4;
    public static int CENTERVHANDLE = 5;
    public static int RECTSTYLE = 0;
    public static int FLAGSTYLE = 1;
    public static Point retPt = new Point(0, 0);
    protected int mH = 0;
    protected int mV = 0;
    protected int mDragH = 0;
    protected int mDragV = 0;
    protected int mDeltaH = 0;
    protected int mDeltaV = 0;
    protected int mOldH = 0;
    protected int mOldV = 0;
    protected int mType;
    protected int mOrientation;
    protected int mUpperOrLeftLimit;
    protected int mLowerOrRightLimit;
    protected double mUpperOrLeftLimitVal;
    protected double mLowerOrRightLimitVal;
    protected int mAxis;
    protected boolean mFlipWhenNecessary;
    protected boolean mOutofRange;
    protected boolean mIsFocused;
    protected DragHandle mLeftOrUpperNeighbor = null;
    protected DragHandle mRightOrLowerNeighbor = null;
    protected DragHandle mCtrNeighbor = null;
    protected DragHandle mFarNeighbor = null;
    protected int mVLimit;
    protected int mHLimit;
    protected double mCurrValue;
    protected double mSlope;
    protected double mOrigin;
    protected boolean mDontBroadcast = false;
    protected boolean mVisible = true;
    protected double winAxisScale;
    protected double winAxisOrigin;
    protected int mStyle = RECTSTYLE;
    protected DragHandleChangedEvent mEventToBC = null;
    protected JStretchPanel mDispatcher;
    protected Color mBGColor = new Color(200, 200, 200);
    protected Color grey100 = new Color(100, 100, 100);
    protected Rectangle currHandleRect = new Rectangle(0, 0, 0, 0);
    protected Point constrainedPoint = new Point(0, 0);
    public PropertyChangeSupport pcs;
    Vector mListeners = new Vector();

    public DragHandle(JStretchPanel jsp, int h, int v, int type, int style, int orient, int axis, int uporleft, int loworright, double uporleftval, double loworrightval, double val) {
        this.mDispatcher = jsp;
        this.mH = this.mOldH = h;
        this.mV = this.mOldV = v;
        this.mStyle = style;
        this.mOrientation = orient;
        this.mAxis = axis;
        this.mType = type;
        this.mUpperOrLeftLimit = uporleft;
        this.mLowerOrRightLimit = loworright;
        this.mUpperOrLeftLimitVal = uporleftval;
        this.mLowerOrRightLimitVal = loworrightval;
        this.mCurrValue = val;
        if (this.mOrientation == HORIENTATION) {
            this.mVLimit = v;
        } else if (this.mOrientation == VORIENTATION) {
            this.mHLimit = h;
        }
        this.scaleAxis();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.mListeners.addElement(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.mListeners.removeElement(pcl);
    }

    public boolean pointInHandle(int x, int y) {
        this.getRect();
        if (this.currHandleRect.contains(x, y)) {
            return true;
        }
        if (this.isOutOfRange()) {
            if (this.mOrientation == HORIENTATION) {
                Rectangle rect = new Rectangle(this.getAxisOrigin() + this.getAxisRange(), this.mV - 18, 7, 18);
                if (rect.contains(x, y)) {
                    return true;
                }
                rect = new Rectangle(this.getAxisOrigin(), this.mV - 18, 7, 18);
                if (rect.contains(x, y)) {
                    return true;
                }
            } else {
                Rectangle rect = new Rectangle(this.mH, this.getAxisOrigin() + this.getAxisRange(), 18, 7);
                if (rect.contains(x, y)) {
                    return true;
                }
                rect = new Rectangle(this.mH, this.getAxisOrigin(), 18, 7);
                if (rect.contains(x, y)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void scaleAxis() {
        double length = this.mLowerOrRightLimit - this.mUpperOrLeftLimit;
        this.winAxisScale = length / (this.mLowerOrRightLimitVal - this.mUpperOrLeftLimitVal);
        this.winAxisOrigin = this.mOrientation == HORIENTATION ? this.mUpperOrLeftLimitVal : this.mLowerOrRightLimitVal;
    }

    public void setAxisRangeVals(double ul, double lr) {
        this.mUpperOrLeftLimitVal = ul;
        this.mLowerOrRightLimitVal = lr;
        this.scaleAxis();
    }

    public void setAxisMaxVal(double val) {
        this.mLowerOrRightLimitVal = val;
        this.scaleAxis();
    }

    public void setAxisMinVal(double val) {
        this.mUpperOrLeftLimitVal = val;
        this.scaleAxis();
    }

    public void setMaxH(int maxh) {
        this.mHLimit = maxh;
    }

    public double getAxisMax() {
        return this.mHLimit;
    }

    public void setAxisRange(int ul, int lr) {
        if (ul == this.mUpperOrLeftLimit && this.mLowerOrRightLimit == lr) {
            return;
        }
        this.mUpperOrLeftLimit = ul;
        this.mLowerOrRightLimit = lr;
        this.scaleAxis();
        if (this.mOrientation == HORIENTATION) {
            this.mH = this.mUpperOrLeftLimit + (int)((this.mCurrValue - this.winAxisOrigin) * this.winAxisScale);
        } else {
            this.mV = this.mUpperOrLeftLimit + (int)((this.winAxisOrigin - this.mCurrValue) * this.winAxisScale);
            this.mH = this.mHLimit;
        }
    }

    public int getAxisRange() {
        return this.mLowerOrRightLimit - this.mUpperOrLeftLimit;
    }

    public int getAxisOrigin() {
        return this.mUpperOrLeftLimit;
    }

    public Point getCurrLocation() {
        DragHandle.retPt.x = this.mH;
        DragHandle.retPt.y = this.mV;
        return retPt;
    }

    public Point getOldLocation() {
        DragHandle.retPt.x = this.mOldH;
        DragHandle.retPt.y = this.mOldV;
        return retPt;
    }

    public abstract void draw(Graphics var1);

    public abstract void getRect();

    public void setDragPoint(int h, int v) {
        this.mDragH = h;
        this.mDragV = v;
        this.mDeltaH = this.mH - this.mDragH;
        this.mDeltaV = this.mV - this.mDragV;
    }

    @Override
    public void setLocation(Point pt) {
        if (pt.x == this.mOldH && pt.y == this.mOldV) {
            return;
        }
        this.mOldH = this.mH;
        this.mOldV = this.mV;
        this.mH = pt.x;
        this.mV = pt.y;
        if (!this.mDontBroadcast) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, this.getPropertyName(), new Double(this.mCurrValue), new Double(this.mCurrValue));
            for (int i = 0; i < this.mListeners.size(); ++i) {
                PropertyChangeListener target = (PropertyChangeListener)this.mListeners.elementAt(i);
                target.propertyChange(evt);
            }
        }
        this.mDontBroadcast = false;
    }

    @Override
    public void setLocation(int x, int y) {
        if (x == this.mOldH && y == this.mOldV) {
            return;
        }
        this.mOldH = this.mH;
        this.mOldV = this.mV;
        this.mH = x;
        this.mV = y;
        if (!this.mDontBroadcast) {
            this.broadcast(false);
        }
        this.mDontBroadcast = false;
    }

    public void broadcast(boolean dragEnded) {
        block4: {
            String prop;
            block3: {
                PropertyChangeListener target;
                int i;
                prop = this.getPropertyName();
                if (!dragEnded) break block3;
                PropertyChangeEvent evt = new PropertyChangeEvent(this, prop + "sel", new Double(this.mCurrValue), new Double(this.mCurrValue));
                for (i = 0; i < this.mListeners.size(); ++i) {
                    target = (PropertyChangeListener)this.mListeners.elementAt(i);
                    target.propertyChange(evt);
                }
                if (this.mFarNeighbor == null) break block4;
                evt = new PropertyChangeEvent(this.mFarNeighbor, this.mFarNeighbor.getPropertyName() + "sel", new Double(this.mFarNeighbor.getValue()), new Double(this.mFarNeighbor.getValue()));
                for (i = 0; i < this.mListeners.size(); ++i) {
                    target = (PropertyChangeListener)this.mListeners.elementAt(i);
                    target.propertyChange(evt);
                }
                break block4;
            }
            PropertyChangeEvent evt = new PropertyChangeEvent(this, prop, new Double(this.mCurrValue), new Double(this.mCurrValue));
            for (int i = 0; i < this.mListeners.size(); ++i) {
                PropertyChangeListener target = (PropertyChangeListener)this.mListeners.elementAt(i);
                target.propertyChange(evt);
            }
        }
    }

    public void setXLocation(int x) {
        if (x == this.mOldH) {
            return;
        }
        this.mOldH = this.mH;
        this.mH = x;
        if (!this.mDontBroadcast) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, this.getPropertyName(), new Double(this.mCurrValue), new Double(this.mCurrValue));
            for (int i = 0; i < this.mListeners.size(); ++i) {
                PropertyChangeListener target = (PropertyChangeListener)this.mListeners.elementAt(i);
                target.propertyChange(evt);
            }
        }
        this.mDontBroadcast = false;
    }

    public void setYLocation(int y) {
        if (y == this.mOldV) {
            return;
        }
        this.mOldV = this.mV;
        this.mV = y;
        if (!this.mDontBroadcast) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, this.getPropertyName(), new Double(this.mCurrValue), new Double(this.mCurrValue));
            for (int i = 0; i < this.mListeners.size(); ++i) {
                PropertyChangeListener target = (PropertyChangeListener)this.mListeners.elementAt(i);
                target.propertyChange(evt);
            }
        }
        this.mDontBroadcast = false;
    }

    public abstract String getPropertyName();

    public int getAxisType() {
        return this.mAxis;
    }

    public void setNeighbors() {
    }

    public void setNeighbors(boolean sf) {
    }

    public void setNeighbors(int delta, boolean sf) {
    }

    public void setDontBroadcast(boolean dbc) {
        this.mDontBroadcast = dbc;
    }

    public abstract Point constrainPoint(int var1, int var2);

    public void setValue(double val) {
        this.mCurrValue = val;
    }

    public double getNewValue(int horv) {
        if (this.mOrientation == HORIENTATION) {
            return (double)(horv - this.mUpperOrLeftLimit) / this.winAxisScale + this.winAxisOrigin;
        }
        return -1.0 * ((double)(horv - this.mUpperOrLeftLimit) / this.winAxisScale - this.winAxisOrigin);
    }

    public double getValue() {
        return this.mCurrValue;
    }

    public int getNewLocation() {
        int newLoc = 0;
        newLoc = this.mOrientation == HORIENTATION ? (int)(this.winAxisScale * (this.mCurrValue - this.winAxisOrigin) + (double)this.mUpperOrLeftLimit) : (int)(this.winAxisScale * (this.winAxisOrigin - this.mCurrValue) + (double)this.mUpperOrLeftLimit);
        return newLoc;
    }

    @Override
    public void setVisible(boolean b) {
        this.mVisible = b;
    }

    @Override
    public boolean isVisible() {
        return this.mVisible;
    }

    public void setLeftOrUpperNeighbor(DragHandle dh) {
        this.mLeftOrUpperNeighbor = dh;
    }

    public void setRightOrLowerNeighbor(DragHandle dh) {
        this.mRightOrLowerNeighbor = dh;
    }

    public void setFarNeighbor(DragHandle dh) {
        this.mFarNeighbor = dh;
    }

    public void setCtrNeighbor(DragHandle dh) {
        this.mCtrNeighbor = dh;
    }

    public DragHandle getLeftOrUpperNeighbor() {
        return this.mLeftOrUpperNeighbor;
    }

    public DragHandle getRightOrLowerNeighbor() {
        return this.mRightOrLowerNeighbor;
    }

    public DragHandle getFarNeighbor() {
        return this.mFarNeighbor;
    }

    public double getFarNeighborValue() {
        return this.mFarNeighbor.getValue();
    }

    public double getMinNeighborValue() {
        if (this.mOrientation == HORIENTATION) {
            return this.mLeftOrUpperNeighbor.getValue();
        }
        return this.mRightOrLowerNeighbor.getValue();
    }

    public double getMaxNeighborValue() {
        if (this.mOrientation == HORIENTATION) {
            return this.mRightOrLowerNeighbor.getValue();
        }
        return this.mLeftOrUpperNeighbor.getValue();
    }

    @Override
    public String toString() {
        String retVal = null;
        if (this instanceof LeftDragHandle) {
            retVal = new String("LeftDragHandle");
        }
        if (this instanceof RightDragHandle) {
            retVal = new String("RightDragHandle");
        }
        if (this instanceof UpperDragHandle) {
            retVal = new String("UpperDragHandle");
        }
        if (this instanceof LowerDragHandle) {
            retVal = new String("LowerDragHandle");
        }
        if (this instanceof CenterVDragHandle) {
            retVal = new String("CenterVDragHandle");
        }
        if (this instanceof CenterHDragHandle) {
            retVal = new String("CenterHDragHandle");
        }
        return retVal;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public void setStyle(int style) {
        this.mStyle = style;
    }

    public void resetStyle() {
        this.mStyle = RECTSTYLE;
    }

    public boolean isOutOfRange() {
        return this.mOutofRange;
    }

    public void setFocused(boolean b) {
        this.mIsFocused = b;
    }

    public boolean isFocused() {
        return this.mIsFocused;
    }

    public void setOutOfRange(boolean b) {
        this.mOutofRange = b;
    }

    public int getOrientation() {
        return this.mOrientation;
    }
}

