/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.Swatch;
import gov.noaa.pmel.swing.SwatchGroup;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;

public class FocusableSwatch
extends Swatch
implements FocusListener {
    protected boolean mHasFocus = false;
    protected SwatchGroup mSwatchGroup = null;
    protected Image mOffScreen = null;
    protected int mColorIndex = 0;
    protected boolean mIsEnabled = true;
    protected boolean mDrawDropShadow = true;

    public FocusableSwatch(Color inColor, SwatchGroup swatchGroup) {
        super(inColor);
        this.mSwatchGroup = swatchGroup;
        this.mSwatchGroup.add(this);
        this.addFocusListener(this);
    }

    public FocusableSwatch(Color inColor, int width, int height, SwatchGroup swatchGroup) {
        super(inColor, width, height);
        this.mSwatchGroup = swatchGroup;
        this.mSwatchGroup.add(this);
        this.addFocusListener(this);
    }

    public int getColorIndex() {
        return this.mColorIndex;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void focusGained(FocusEvent fe) {
        if (!this.mIsEnabled) {
            return;
        }
        this.mHasFocus = true;
        Graphics g = this.getGraphics();
        this.invalidate();
        this.paintComponent(g);
    }

    @Override
    public void focusLost(FocusEvent fe) {
        if (!this.mIsEnabled) {
            return;
        }
        this.mHasFocus = false;
        Graphics g = this.getGraphics();
        this.invalidate();
        this.paintComponent(g);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.mOffScreen = null;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.mOffScreen == null) {
            this.mOffScreen = this.createImage(this.getSize().width, this.getSize().height);
            Graphics og = this.mOffScreen.getGraphics();
            super.paintComponent(og);
            if (this.mEditable && this.mDrawDropShadow) {
                og.setColor(this.getBackground());
                og.fillRect(0, 0, this.mWidth, this.mHeight);
                og.setColor(this.getBackground().darker());
                og.fillRect(3, 3, this.mWidth - 1, this.mHeight - 1);
                og.setColor(this.mColor);
                og.fillRect(1, 1, this.mWidth - 4, this.mHeight - 4);
            } else {
                og.setColor(this.getBackground());
                og.fillRect(0, 0, this.mWidth, this.mHeight);
                og.setColor(this.mColor);
                og.fillRect(1, 1, this.mWidth - 2, this.mHeight - 2);
            }
            if (this.mHasFocus) {
                og.setColor(Color.black);
                if (this.mEditable && this.mDrawDropShadow) {
                    og.drawRect(1, 1, this.mWidth - 4, this.mHeight - 4);
                } else {
                    og.drawRect(1, 1, this.mWidth - 3, this.mHeight - 3);
                }
            }
            g.drawImage(this.mOffScreen, 0, 0, null);
            og.dispose();
        } else {
            g.drawImage(this.mOffScreen, 0, 0, null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (!this.mIsEnabled) {
            return;
        }
        this.mSwatchGroup.setFocus(this);
        if (this.mEditable) {
            this.focus();
            this.mSwatchGroup.setFocus(this);
            Color oldColor = this.mColor;
            this.mColor = JColorChooser.showDialog(this.mParent, "Choose a new color:", this.mColor);
            if (this.mColor == null) {
                this.mColor = oldColor;
            } else {
                Graphics g = this.getGraphics();
                if (g != null) {
                    this.invalidate();
                    this.paintComponent(g);
                    g.dispose();
                }
            }
        }
    }

    public void focus() {
        this.mHasFocus = true;
        this.requestFocus();
        Graphics g = this.mThis.getGraphics();
        if (g != null) {
            this.invalidate();
            this.paintComponent(g);
            g.dispose();
        }
    }

    public void unFocus() {
        this.mHasFocus = false;
        Graphics g = this.mThis.getGraphics();
        if (g != null) {
            this.invalidate();
            this.paintComponent(g);
            g.dispose();
        }
    }

    @Override
    public void setEnabled(boolean state) {
        this.mIsEnabled = state;
    }

    public void setShadowed(boolean state) {
        this.mDrawDropShadow = state;
    }
}

