/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class JDateTimeGetter
extends JPanel
implements ItemListener,
PropertyChangeListener,
ActionListener {
    private Date initialDate = new Date();
    private Date earliestDateAllowed = new Date();
    private Date latestDateAllowed = new Date();
    private boolean earliestCheckingEnabled = false;
    private boolean latestCheckingEnabled = false;
    private Font regularFont;
    private Font boldFont;
    private Color panelBackground;
    private Color calBackground;
    private Color selectedButnBackground;
    private boolean mUseOK = true;
    private static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] daysOfMonth = new String[]{" 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8", " 9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    private static final String[] minutes = new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
    private static final int numWeeks = 6;
    private GregorianCalendar cal;
    private SimpleDateFormat dateFormatter;
    private SimpleDateFormat sdf;
    private TimeZone tz;
    private JPanel calPanel;
    private JPanel okPanel;
    private JPanel selectionPanel;
    private Box theBox;
    private Box timeBox;
    private Box monthYearBox;
    private Box labelBox;
    private Box hrMinBox;
    private JButton subYearButn;
    private JButton subMonthButn;
    private JButton addMonthButn;
    private JButton addYearButn;
    private JButton addHourButn;
    private JButton subHourButn;
    private JButton addMinButn;
    private JButton subMinButn;
    private JButton cancelButn;
    private JButton okButn;
    private JToggleButton[] calButtons;
    private JLabel hourLabel;
    private JLabel minLabel;
    private JLabel selectionLabel;
    private JComboBox monthList;
    private JComboBox minList;
    private JTextField hourText;
    private JTextField yearText;
    private ButtonGroup calButtonGroup;
    private Date liquidDate;
    private int xloc;
    private int yloc;
    private String title;
    private boolean hideTime;
    private JFrame aJFrame = null;
    private static CompoundBorder cp = new CompoundBorder(new BevelBorder(0), new EmptyBorder(2, 2, 2, 2));
    public static final int DATE = 5;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int MINUTE = 12;
    public static final int HOUR_OF_DAY = 11;
    private boolean macBtnOrder = false;
    private boolean TRACE = false;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void setEarliestDateAllowed(Date earliestDateAllowed) {
        this.earliestDateAllowed = earliestDateAllowed;
        this.earliestCheckingEnabled = true;
    }

    public void setLatestDateAllowed(Date latestDateAllowed) {
        this.latestDateAllowed = latestDateAllowed;
        this.latestCheckingEnabled = true;
    }

    public Date getEarliestDateAllowed() {
        return this.earliestDateAllowed;
    }

    public Date getLatestDateAllowed() {
        return this.latestDateAllowed;
    }

    public void setTimeZone(TimeZone tz) {
        this.tz = tz;
        this.setTimeZoneForTimeObjects(tz);
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    public void setOutputDateFormatter(SimpleDateFormat sdf) {
        this.sdf = sdf;
    }

    public void setInitialDate(Date initialDateIn) {
        this.initialDate = initialDateIn;
        this.liquidDate = new Date(this.initialDate.getTime());
        this.setTitle(this.composeTimeLabel(this.liquidDate));
    }

    public void setDate(Date dt) {
        if (this.TRACE) {
            System.out.println("setDate entered");
        }
        this.liquidDate = new Date(dt.getTime());
        if (this.liquidDateWithinBounds()) {
            this.updateGUIAfterLiquidDateChange();
            this.setTitle(this.composeTimeLabel(this.liquidDate));
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getInitialDate() {
        return this.initialDate;
    }

    public void setRegularFont(Font regularFontIn) {
        this.regularFont = regularFontIn;
    }

    public Font getRegularFont() {
        return this.regularFont;
    }

    public void setBoldFont(Font boldFontIn) {
        this.boldFont = boldFontIn;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    public void setPanelBackground(Color color) {
        this.panelBackground = color;
    }

    public Color getPanelBackground() {
        return this.panelBackground;
    }

    public void setCalBackground(Color color) {
        this.calBackground = color;
    }

    public Color getCalBackground() {
        return this.calBackground;
    }

    public void setSelectedButnBackground(Color color) {
        this.selectedButnBackground = color;
    }

    public Color getSelectedButnBackground() {
        return this.selectedButnBackground;
    }

    public void setHideTime(boolean ans) {
        this.hideTime = ans;
        if (ans) {
            this.removeTime();
        }
    }

    public boolean getHideTime() {
        return this.hideTime;
    }

    public JButton getOkButn() {
        return this.okButn;
    }

    public JButton getCancelButn() {
        return this.cancelButn;
    }

    public JDateTimeGetter(Date inDate) {
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        this.setInitialDate(inDate);
        this.finishConstruction();
    }

    public JDateTimeGetter(Date inDate, boolean btnorder, boolean blank) {
        this.macBtnOrder = btnorder;
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        this.setInitialDate(inDate);
        this.finishConstruction();
    }

    public JDateTimeGetter(Date inDate, boolean useOK) {
        this.mUseOK = useOK;
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        this.setInitialDate(inDate);
        this.finishConstruction();
    }

    public JDateTimeGetter(Date inDate, boolean useOK, boolean btnorder, boolean blank) {
        this.macBtnOrder = btnorder;
        this.mUseOK = useOK;
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        this.setInitialDate(inDate);
        this.finishConstruction();
    }

    public JDateTimeGetter(Date inDate, Date earliestDateAllowedIn, Date latestDateAllowedIn, int xlocIn, int ylocIn) {
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        this.xloc = xlocIn;
        this.yloc = ylocIn;
        this.setInitialDate(inDate);
        this.setEarliestDateAllowed(earliestDateAllowedIn);
        this.setLatestDateAllowed(latestDateAllowedIn);
        this.finishConstruction();
    }

    public JDateTimeGetter(Date inDate, Date earliestDateAllowedIn, Date latestDateAllowedIn, int xlocIn, int ylocIn, boolean btnorder, boolean blank) {
        this.macBtnOrder = btnorder;
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        this.xloc = xlocIn;
        this.yloc = ylocIn;
        this.setInitialDate(inDate);
        this.setEarliestDateAllowed(earliestDateAllowedIn);
        this.setLatestDateAllowed(latestDateAllowedIn);
        this.finishConstruction();
    }

    public JDateTimeGetter(Date inDate, Date earliestDateAllowedIn, Date latestDateAllowedIn, int xlocIn, int ylocIn, boolean useOK) {
        this.mUseOK = useOK;
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        this.xloc = xlocIn;
        this.yloc = ylocIn;
        this.setInitialDate(inDate);
        this.setEarliestDateAllowed(earliestDateAllowedIn);
        this.setLatestDateAllowed(latestDateAllowedIn);
        this.finishConstruction();
    }

    public JDateTimeGetter(Date inDate, Date earliestDateAllowedIn, Date latestDateAllowedIn, int xlocIn, int ylocIn, boolean useOK, boolean btnorder, boolean blank) {
        this.macBtnOrder = btnorder;
        this.mUseOK = useOK;
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        this.xloc = xlocIn;
        this.yloc = ylocIn;
        this.setInitialDate(inDate);
        this.setEarliestDateAllowed(earliestDateAllowedIn);
        this.setLatestDateAllowed(latestDateAllowedIn);
        this.finishConstruction();
    }

    public JDateTimeGetter() {
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        Date dt = new Date();
        this.cal.setTime(dt);
        this.computeFields(this.cal);
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        dt = this.cal.getTime();
        this.setInitialDate(dt);
        this.finishConstruction();
    }

    public JDateTimeGetter(boolean btnorder, boolean blank) {
        this.macBtnOrder = btnorder;
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        Date dt = new Date();
        this.cal.setTime(dt);
        this.computeFields(this.cal);
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        dt = this.cal.getTime();
        this.setInitialDate(dt);
        this.finishConstruction();
    }

    public JDateTimeGetter(boolean useOK) {
        this.mUseOK = useOK;
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        Date dt = new Date();
        this.cal.setTime(dt);
        this.computeFields(this.cal);
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        dt = this.cal.getTime();
        this.setInitialDate(dt);
        this.finishConstruction();
    }

    public JDateTimeGetter(boolean useOK, boolean btnorder, boolean blank) {
        this.macBtnOrder = btnorder;
        this.mUseOK = useOK;
        this.tz = TimeZone.getDefault();
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(this.tz);
        this.createDateFormatter();
        this.setTimeZoneForTimeObjects(this.tz);
        Date dt = new Date();
        this.cal.setTime(dt);
        this.computeFields(this.cal);
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        dt = this.cal.getTime();
        this.setInitialDate(dt);
        this.finishConstruction();
    }

    void finishConstruction() {
        this.addPropertyChangeListener(this);
        this.setSize(220, 323);
        this.regularFont = new Font("Dialog", 0, 10);
        this.boldFont = new Font("Dialog", 1, 10);
        this.setSelectedButnBackground(new Color(240, 240, 240));
        this.createCalendarPanel();
        this.createMonthYearPanel();
        this.createTimePanel();
        if (this.mUseOK) {
            this.createOkPanel();
        }
        this.createSelectionPanel();
        this.theBox = Box.createVerticalBox();
        this.theBox.add(this.monthYearBox);
        this.theBox.add(this.calPanel);
        this.theBox.add(this.timeBox);
        this.theBox.add(Box.createVerticalStrut(1));
        this.theBox.add(this.selectionPanel);
        if (this.mUseOK) {
            this.theBox.add(this.okPanel);
        }
        this.theBox.add(Box.createVerticalGlue());
        this.theBox.validate();
        this.theBox.setBackground(this.panelBackground);
        this.theBox.setBackground(Color.white);
        this.theBox.repaint();
        this.add(this.theBox);
        this.theBox.setLocation(10, 10);
        this.setLocation(this.xloc, this.yloc);
        this.validate();
        this.repaint();
        this.cal.setTime(this.getInitialDate());
        this.computeFields(this.cal);
        this.resetCalendarPanel(this.initialDate);
        this.softwareDayOfMonthClick(this.initialDate);
        this.minList.setSelectedIndex(this.cal.get(12) / 5);
        this.hourText.setText(new String(String.valueOf(this.cal.get(11))));
        this.monthList.setSelectedIndex(this.cal.get(2));
    }

    public void showInJFrame(int xloc, int yloc) {
        this.aJFrame = new JFrame();
        this.aJFrame.setSize(220, 323);
        this.aJFrame.setLocation(xloc, yloc);
        this.aJFrame.getContentPane().add(this);
        this.aJFrame.invalidate();
        this.aJFrame.validate();
        this.aJFrame.setVisible(true);
        this.aJFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JDateTimeGetter.this.closeDown();
            }
        });
    }

    void removeTime() {
        this.theBox.remove(this.timeBox);
        this.createDateFormatter();
        this.updateDateLabel();
        this.setSize(220, 260);
    }

    void setTimeZoneForTimeObjects(TimeZone tz) {
        if (this.TRACE) {
            System.out.println("setTimeZoneForTimeObjects entered");
        }
        if (this.dateFormatter != null) {
            this.dateFormatter.setTimeZone(tz);
        }
        if (this.cal != null) {
            this.cal.setTimeZone(tz);
        }
    }

    void createDateFormatter() {
        if (this.TRACE) {
            System.out.println("createDateFormatter entered");
        }
        this.dateFormatter = new SimpleDateFormat(" dd MMM yyyy HH:mm ");
        if (this.hideTime) {
            this.dateFormatter = new SimpleDateFormat("dd MMM yyyy ");
        }
        this.dateFormatter.setTimeZone(this.tz);
    }

    public void createCalendarPanel() {
        if (this.TRACE) {
            System.out.println("createCalendarPanel entered");
        }
        this.calPanel = new JPanel();
        this.calPanel.setLayout(new GridLayout(7, 7, 2, 1));
        JLabel jl = new JLabel("Sun", 0);
        jl.setFont(this.boldFont);
        this.calPanel.add(jl);
        jl = new JLabel("Mon", 0);
        jl.setFont(this.boldFont);
        this.calPanel.add(jl);
        jl = new JLabel("Tue", 0);
        jl.setFont(this.boldFont);
        this.calPanel.add(jl);
        jl = new JLabel("Wed", 0);
        jl.setFont(this.boldFont);
        this.calPanel.add(jl);
        jl = new JLabel("Thu", 0);
        jl.setFont(this.boldFont);
        this.calPanel.add(jl);
        jl = new JLabel("Fri", 0);
        jl.setFont(this.boldFont);
        this.calPanel.add(jl);
        jl = new JLabel("Sat", 0);
        jl.setFont(this.boldFont);
        this.calPanel.add(jl);
        this.calPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.calButtonGroup = new ButtonGroup();
        this.calButtons = new JToggleButton[42];
        for (int i = 0; i < 42; ++i) {
            this.calButtons[i] = new JToggleButton("  ");
            this.calButtons[i].setBorder(cp);
            this.calButtons[i].setContentAreaFilled(true);
            this.calButtons[i].addActionListener(this);
            this.calButtons[i].setFont(this.regularFont);
            this.calPanel.add(this.calButtons[i]);
            this.calButtonGroup.add(this.calButtons[i]);
            this.calButtons[i].setMinimumSize(new Dimension(17, 21));
            this.calButtons[i].setMaximumSize(new Dimension(17, 21));
            this.calButtons[i].setSize(new Dimension(17, 21));
        }
    }

    void resetCalendarPanel(Date newDate) {
        int weekOfMonth;
        int dayOfWeek;
        if (this.TRACE) {
            System.out.println("resetCalendarPanel entered");
        }
        String[][] gridLabels = new String[7][6];
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTimeZone(this.tz);
        for (dayOfWeek = 0; dayOfWeek < 7; ++dayOfWeek) {
            for (weekOfMonth = 0; weekOfMonth < 6; ++weekOfMonth) {
                gridLabels[dayOfWeek][weekOfMonth] = "  ";
            }
        }
        cal1.setTime(newDate);
        this.computeFields(cal1);
        cal1.set(5, 1);
        Date firstThisMonth = cal1.getTime();
        cal1.setTime(firstThisMonth);
        this.computeFields(cal1);
        dayOfWeek = cal1.get(7) - 1;
        if (cal1.get(2) + 1 == 13) {
            cal1.set(2, 0);
            cal1.set(1, cal1.get(1) + 1);
        } else {
            cal1.set(2, cal1.get(2) + 1);
        }
        Date firstNextMonth = cal1.getTime();
        long endTime = firstNextMonth.getTime();
        cal1.setTime(firstThisMonth);
        this.computeFields(cal1);
        weekOfMonth = 0;
        int dayOfMonth = 1;
        for (long curTime = firstThisMonth.getTime(); curTime < endTime; curTime += 86400000L) {
            if (dayOfMonth != 32) {
                gridLabels[dayOfWeek][weekOfMonth] = daysOfMonth[dayOfMonth - 1];
            }
            ++dayOfMonth;
            if (++dayOfWeek <= 6) continue;
            dayOfWeek = 0;
            ++weekOfMonth;
        }
        int ithButn = 0;
        for (weekOfMonth = 0; weekOfMonth < 6; ++weekOfMonth) {
            for (dayOfWeek = 0; dayOfWeek < 7; ++dayOfWeek) {
                if (gridLabels[dayOfWeek][weekOfMonth].equals("  ")) {
                    this.calButtons[ithButn].setText("  ");
                    this.calButtons[ithButn].setVisible(false);
                } else {
                    this.calButtons[ithButn].setText(gridLabels[dayOfWeek][weekOfMonth]);
                    this.calButtons[ithButn].setVisible(true);
                }
                ++ithButn;
            }
        }
    }

    void closeDown() {
        if (this.aJFrame != null) {
            this.aJFrame.setVisible(false);
        }
    }

    void softwareDayOfMonthClick(Date dt) {
        if (this.TRACE) {
            System.out.println("softwareDayOfMonthClick entered");
        }
        this.cal.setTime(dt);
        this.computeFields(this.cal);
        int date = this.cal.get(5);
        for (int i = 0; i < this.calButtons.length; ++i) {
            if (!this.calButtons[i].getText().equals(daysOfMonth[date - 1])) continue;
            this.calButtons[i].doClick();
        }
    }

    void selectDay(int date) {
        if (this.TRACE) {
            System.out.println("selectDay entered");
        }
        if (this.calButtons != null) {
            for (int i = 0; i < this.calButtons.length && !this.calButtons[i].getText().equals(daysOfMonth[date - 1]); ++i) {
            }
        }
    }

    String composeTimeLabel(Date dt) {
        return this.dateFormatter.format(dt);
    }

    void computeFields(Calendar caln) {
        caln.get(1);
    }

    void updateDateLabel() {
        this.selectionLabel.setText(this.composeTimeLabel(this.liquidDate));
    }

    public void createMonthYearPanel() {
        if (this.TRACE) {
            System.out.println("createMonthYearPanel entered");
        }
        this.subMonthButn = new JButton("<<");
        this.subMonthButn.setFont(this.regularFont);
        this.subMonthButn.setBorder(cp);
        this.subMonthButn.addActionListener(this);
        this.subMonthButn.setAlignmentY(0.5f);
        this.addMonthButn = new JButton(">>");
        this.addMonthButn.setFont(this.regularFont);
        this.addMonthButn.setBorder(cp);
        this.addMonthButn.addActionListener(this);
        this.addMonthButn.setAlignmentY(0.5f);
        this.monthList = new JComboBox<String>(months);
        this.monthList.setFont(this.regularFont);
        this.monthList.addItemListener(this);
        this.monthList.setAlignmentY(0.5f);
        this.yearText = new JTextField(new String(String.valueOf(this.cal.get(1))));
        this.yearText.setBackground(this.calBackground);
        this.yearText.addActionListener(this);
        this.yearText.setFont(this.regularFont);
        int x = this.subMonthButn.getPreferredSize().width * 3;
        int y = this.subMonthButn.getPreferredSize().height;
        this.yearText.setPreferredSize(new Dimension(x, y));
        this.yearText.setMaximumSize(new Dimension(x, y));
        this.yearText.setAlignmentY(0.5f);
        this.subYearButn = new JButton("<<");
        this.subYearButn.setFont(this.regularFont);
        this.subYearButn.setBorder(cp);
        this.subYearButn.addActionListener(this);
        this.subYearButn.setAlignmentY(0.5f);
        this.addYearButn = new JButton(">>");
        this.addYearButn.setFont(this.regularFont);
        this.addYearButn.setBorder(cp);
        this.addYearButn.addActionListener(this);
        this.addYearButn.setAlignmentY(0.5f);
        this.monthYearBox = Box.createHorizontalBox();
        this.monthYearBox.add(Box.createHorizontalGlue());
        this.monthYearBox.add(this.subMonthButn);
        this.monthYearBox.add(this.addMonthButn);
        this.monthYearBox.add(this.monthList);
        this.monthYearBox.add(Box.createHorizontalStrut(1));
        this.monthYearBox.add(this.yearText);
        this.monthYearBox.add(this.subYearButn);
        this.monthYearBox.add(this.addYearButn);
        this.monthYearBox.add(Box.createHorizontalGlue());
    }

    public void resetMonthYearPanel(Date newDate) {
        if (this.TRACE) {
            System.out.println("resetMonthYearPanel entered");
        }
        this.cal.setTime(newDate);
        this.computeFields(this.cal);
        int m = this.cal.get(2);
        Integer yr = new Integer(this.cal.get(1));
        this.monthList.setVisible(false);
        this.monthList.setSelectedIndex(m);
        this.monthList.setVisible(true);
        int yr1 = Integer.parseInt(this.yearText.getText().trim());
        if (yr != yr1) {
            this.yearText.setText(yr.toString());
        }
    }

    public void createTimePanel() {
        if (this.TRACE) {
            System.out.println("createTimePanel entered");
        }
        this.hourLabel = new JLabel("Hour(0-23)        ");
        this.hourLabel.setFont(this.boldFont);
        this.minLabel = new JLabel("Minute    ");
        this.minLabel.setFont(this.boldFont);
        JLabel colonLabel = new JLabel(":");
        Font f = new Font("Dialog", 1, 12);
        colonLabel.setFont(f);
        this.subHourButn = new JButton("<<");
        this.subHourButn.setFont(this.regularFont);
        this.subHourButn.setBorder(cp);
        this.subHourButn.addActionListener(this);
        this.subHourButn.setAlignmentY(0.5f);
        this.addHourButn = new JButton(">>");
        this.addHourButn.setFont(this.regularFont);
        this.addHourButn.setBorder(cp);
        this.addHourButn.addActionListener(this);
        this.addHourButn.setAlignmentY(0.5f);
        this.hourText = new JTextField();
        this.hourText.setText("     00");
        this.hourText.setFont(this.regularFont);
        this.hourText.setBackground(this.calBackground);
        this.hourText.addActionListener(this);
        this.hourText.setHorizontalAlignment(4);
        int x = this.addHourButn.getPreferredSize().width * 2;
        int y = this.addHourButn.getPreferredSize().height;
        this.hourText.setPreferredSize(new Dimension(x, y));
        this.hourText.setMaximumSize(this.hourText.getPreferredSize());
        this.hourText.setSize(this.hourText.getPreferredSize());
        this.hourText.setAlignmentY(0.5f);
        this.minList = new JComboBox<String>(minutes);
        this.minList.addItemListener(this);
        this.minList.setFont(this.regularFont);
        x = this.addHourButn.getPreferredSize().width * 2;
        y = this.addHourButn.getPreferredSize().height;
        this.minList.setPreferredSize(new Dimension(x, y));
        this.minList.setMaximumSize(this.minList.getPreferredSize());
        this.minList.setSize(this.minList.getPreferredSize());
        this.minList.setAlignmentY(0.5f);
        this.subMinButn = new JButton("<<");
        this.subMinButn.setFont(this.regularFont);
        this.subMinButn.setBorder(cp);
        this.subMinButn.addActionListener(this);
        this.subMinButn.setAlignmentY(0.5f);
        this.addMinButn = new JButton(">>");
        this.addMinButn.setFont(this.regularFont);
        this.addMinButn.setBorder(cp);
        this.addMinButn.addActionListener(this);
        this.addMinButn.setAlignmentY(0.5f);
        this.labelBox = Box.createHorizontalBox();
        this.labelBox.add(Box.createHorizontalGlue());
        this.labelBox.add(this.hourLabel);
        this.labelBox.add(Box.createHorizontalStrut(1));
        this.labelBox.add(this.minLabel);
        this.labelBox.add(Box.createHorizontalGlue());
        this.hrMinBox = Box.createHorizontalBox();
        this.hrMinBox.add(Box.createHorizontalGlue());
        this.hrMinBox.add(this.subHourButn);
        this.hrMinBox.add(this.addHourButn);
        this.hrMinBox.add(this.hourText);
        this.hrMinBox.add(Box.createHorizontalStrut(5));
        this.hrMinBox.add(this.minList);
        this.hrMinBox.add(this.subMinButn);
        this.hrMinBox.add(this.addMinButn);
        this.hrMinBox.add(Box.createHorizontalGlue());
        this.timeBox = Box.createVerticalBox();
        this.timeBox.add(Box.createVerticalGlue());
        this.timeBox.add(this.labelBox);
        this.timeBox.add(this.hrMinBox);
        this.timeBox.add(Box.createVerticalGlue());
    }

    public void createSelectionPanel() {
        if (this.TRACE) {
            System.out.println("createSelectionPanel entered");
        }
        this.selectionLabel = new JLabel("ddd mmm dd hh:mm yyyy");
        this.selectionLabel.setBackground(Color.red);
        this.selectionLabel.setForeground(Color.black);
        this.selectionPanel = new JPanel();
        this.selectionPanel.add(this.selectionLabel);
        this.updateDateLabel();
    }

    public void createOkPanel() {
        if (this.TRACE) {
            System.out.println("createOkPanel entered");
        }
        this.okButn = new JButton("OK");
        this.okButn.addActionListener(this);
        this.cancelButn = new JButton("Cancel");
        this.cancelButn.addActionListener(this);
        JPanel dlgBtnsPanel = new JPanel();
        this.okPanel = new JPanel();
        this.okPanel.setLayout(new FlowLayout(1, 20, 1));
        dlgBtnsPanel.setLayout(new GridLayout(1, 4, 15, 1));
        if (this.macBtnOrder) {
            dlgBtnsPanel.add(this.cancelButn);
            dlgBtnsPanel.add(this.okButn);
        } else {
            dlgBtnsPanel.add(this.okButn);
            dlgBtnsPanel.add(this.cancelButn);
        }
        this.okPanel.add(dlgBtnsPanel);
    }

    void handleHourChange() {
        if (this.TRACE) {
            System.out.println("handleHourChange entered");
        }
        try {
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            int prevHr = this.cal.get(11);
            int hr = Integer.parseInt(this.hourText.getText().trim());
            hr = this.validateHours(hr);
            this.hourText.setText(new Integer(hr).toString());
            this.cal.set(11, hr);
            this.liquidDate = this.cal.getTime();
            if (!this.liquidDateWithinBounds()) {
                this.cal.set(11, prevHr);
                this.liquidDate = this.cal.getTime();
                this.hourText.setText(new Integer(prevHr).toString());
            }
            this.updateDateLabel();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void handleYearChange() {
        if (this.TRACE) {
            System.out.println("handleYearChange entered");
        }
        try {
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            int prevYr = this.cal.get(1);
            int yr = Integer.parseInt(this.yearText.getText().trim());
            this.yearText.setText(new Integer(yr).toString());
            this.cal.set(1, yr);
            this.liquidDate = this.cal.getTime();
            if (!this.liquidDateWithinBounds()) {
                this.cal.set(1, prevYr);
                this.liquidDate = this.cal.getTime();
                this.yearText.setText(new Integer(prevYr).toString());
            } else {
                this.updateGUIAfterLiquidDateChange();
            }
            this.updateDateLabel();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    int validateHours(int hr) {
        if (this.TRACE) {
            System.out.println("validateHours entered");
        }
        if (hr < 0) {
            return 0;
        }
        if (hr > 23) {
            return 23;
        }
        return hr;
    }

    boolean liquidDateWithinBounds() {
        if (this.TRACE) {
            System.out.println("liquidDateWithinBounds entered");
        }
        if (this.earliestCheckingEnabled) {
            System.out.println("liquidDate is: " + this.liquidDate);
            System.out.println("earliestDateAllowed is: " + this.earliestDateAllowed);
            if (this.liquidDate.getTime() < this.earliestDateAllowed.getTime()) {
                this.lowerBoundMsg();
                return false;
            }
        }
        if (this.latestCheckingEnabled && this.liquidDate.getTime() > this.latestDateAllowed.getTime()) {
            this.upperBoundMsg();
            return false;
        }
        return true;
    }

    public void lowerBoundMsg() {
        if (this.TRACE) {
            System.out.println("lowerBoundMsg entered");
        }
        JOptionPane.showMessageDialog(this, new String("Lower bound restricted to " + this.composeTimeLabel(this.getEarliestDateAllowed())), "Calendar Bounds Exception", 2);
    }

    public void upperBoundMsg() {
        if (this.TRACE) {
            System.out.println("upperBoundMsg entered");
        }
        JOptionPane.showMessageDialog(this, new String("Upper bound restricted to " + this.composeTimeLabel(this.getLatestDateAllowed())), "Calendar Bounds Exception", 2);
    }

    void attemptToAddOrSubtractAYear(int numYears) {
        if (this.TRACE) {
            System.out.println("attemptToAddOrSubtractAYear entered");
        }
        this.cal.setTime(this.liquidDate);
        this.computeFields(this.cal);
        int yr = this.cal.get(1) + numYears;
        this.cal.set(1, yr);
        this.liquidDate = this.cal.getTime();
        if (this.liquidDateWithinBounds()) {
            this.updateGUIAfterLiquidDateChange();
        } else {
            this.cal.set(1, this.cal.get(1) - numYears);
            this.liquidDate = this.cal.getTime();
        }
    }

    void updateGUIAfterLiquidDateChange() {
        if (this.TRACE) {
            System.out.println("updateGUIAfterLIquidDateChange entered");
        }
        this.resetMonthYearPanel(this.liquidDate);
        this.resetCalendarPanel(this.liquidDate);
        this.softwareDayOfMonthClick(this.liquidDate);
        this.updateDateLabel();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.TRACE) {
            System.out.println("itemStateChanged entered");
        }
        if (itemEvent.getSource() == this.monthList) {
            int mon = this.monthList.getSelectedIndex();
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            int prevMon = this.cal.get(2);
            if (prevMon != mon) {
                this.cal.set(2, mon);
                this.liquidDate = this.cal.getTime();
                if (!this.liquidDateWithinBounds()) {
                    this.cal.set(2, prevMon);
                    this.liquidDate = this.cal.getTime();
                }
                this.updateGUIAfterLiquidDateChange();
            }
        } else if (itemEvent.getSource() == this.minList) {
            int min = Integer.parseInt((String)this.minList.getSelectedItem());
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            int oldMin = this.cal.get(12);
            this.cal.set(12, min);
            this.liquidDate = this.cal.getTime();
            if (!this.liquidDateWithinBounds()) {
                this.cal.set(12, oldMin);
                this.liquidDate = this.cal.getTime();
                this.minList.setVisible(false);
                this.minList.setSelectedIndex(oldMin / 5);
                this.minList.setVisible(true);
            }
            this.updateDateLabel();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.TRACE) {
            System.out.println("actionPerformed entered");
        }
        Object source = event.getSource();
        int mon = 0;
        int yr = 0;
        if (source == this.okButn) {
            this.handleHourChange();
            if (this.sdf != null) {
                this.pcs.firePropertyChange("FormattedDateTime", this.sdf.format(this.getInitialDate()), this.sdf.format(this.liquidDate));
            }
            this.pcs.firePropertyChange("DateTime", this.getInitialDate(), this.liquidDate);
            this.closeDown();
        } else if (source == this.cancelButn) {
            this.closeDown();
        } else if (source == this.subYearButn) {
            this.attemptToAddOrSubtractAYear(-1);
        } else if (source == this.addYearButn) {
            this.attemptToAddOrSubtractAYear(1);
        } else if (source == this.subMonthButn) {
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            mon = this.cal.get(2) - 1;
            if (mon == -1) {
                mon = 11;
                this.cal.set(2, mon);
                yr = this.cal.get(1) - 1;
                this.cal.set(1, yr);
                this.liquidDate = this.cal.getTime();
                if (!this.liquidDateWithinBounds()) {
                    yr = this.cal.get(1) + 1;
                    this.cal.set(1, yr);
                    this.liquidDate = this.cal.getTime();
                }
            }
            this.cal.set(2, mon);
            this.liquidDate = this.cal.getTime();
            if (!this.liquidDateWithinBounds()) {
                if (++mon == 12) {
                    mon = 0;
                }
                this.cal.set(2, mon);
                this.liquidDate = this.cal.getTime();
            }
            this.updateGUIAfterLiquidDateChange();
        } else if (source == this.addMonthButn) {
            this.cal.setTime(this.liquidDate);
            this.computeFields(this.cal);
            mon = this.cal.get(2) + 1;
            if (mon == 12) {
                mon = 0;
                this.cal.set(2, 0);
                yr = this.cal.get(1) + 1;
                this.cal.set(1, yr);
                this.liquidDate = this.cal.getTime();
                if (!this.liquidDateWithinBounds()) {
                    this.cal.set(1, this.cal.get(1) - 1);
                    this.liquidDate = this.cal.getTime();
                }
            }
            this.cal.set(2, mon);
            this.liquidDate = this.cal.getTime();
            if (!this.liquidDateWithinBounds()) {
                if (--mon == -1) {
                    mon = 11;
                }
                this.cal.set(2, mon);
                this.liquidDate = this.cal.getTime();
            }
            this.updateGUIAfterLiquidDateChange();
        } else if (source == this.hourText) {
            this.handleHourChange();
        } else if (source == this.yearText) {
            this.handleYearChange();
        } else if (source == this.subHourButn) {
            try {
                this.handleHourChange();
                int hr = Integer.parseInt(this.hourText.getText().trim());
                if (--hr == -1) {
                    hr = 23;
                }
                this.hourText.setText(new Integer(hr).toString());
                this.handleHourChange();
            }
            catch (NumberFormatException hr) {}
        } else if (source == this.addHourButn) {
            try {
                this.handleHourChange();
                int hr = Integer.parseInt(this.hourText.getText().trim());
                if (++hr == 24) {
                    hr = 0;
                }
                this.hourText.setText(new Integer(hr).toString());
                this.handleHourChange();
            }
            catch (NumberFormatException hr) {}
        } else if (source == this.subMinButn) {
            try {
                int min = Integer.parseInt((String)this.minList.getSelectedItem());
                if ((min -= 5) == -5) {
                    min = 55;
                }
                this.cal.setTime(this.liquidDate);
                this.computeFields(this.cal);
                int oldMin = this.cal.get(12);
                this.cal.set(12, min);
                this.liquidDate = this.cal.getTime();
                if (!this.liquidDateWithinBounds()) {
                    this.cal.set(12, oldMin);
                    this.liquidDate = this.cal.getTime();
                    min = oldMin;
                }
                this.minList.setVisible(false);
                this.minList.setSelectedIndex(min / 5);
                this.minList.setVisible(true);
                this.updateDateLabel();
            }
            catch (NumberFormatException min) {}
        } else if (source == this.addMinButn) {
            try {
                int min = Integer.parseInt((String)this.minList.getSelectedItem());
                if ((min += 5) == 60) {
                    min = 0;
                }
                this.cal.setTime(this.liquidDate);
                this.computeFields(this.cal);
                int oldMin = this.cal.get(12);
                this.cal.set(12, min);
                this.liquidDate = this.cal.getTime();
                if (!this.liquidDateWithinBounds()) {
                    this.cal.set(12, oldMin);
                    this.liquidDate = this.cal.getTime();
                    min = oldMin;
                }
                this.minList.setVisible(false);
                this.minList.setSelectedIndex(min / 5);
                this.minList.setVisible(true);
                this.updateDateLabel();
            }
            catch (NumberFormatException min) {}
        } else if (source != this.monthList) {
            try {
                int inputDayOfMonth = Integer.parseInt(event.getActionCommand().trim());
                this.cal.setTime(this.liquidDate);
                this.computeFields(this.cal);
                int lastDate = this.cal.get(5);
                this.cal.set(5, inputDayOfMonth);
                this.liquidDate = this.cal.getTime();
                if (this.liquidDateWithinBounds()) {
                    this.selectDay(inputDayOfMonth);
                    this.updateDateLabel();
                } else {
                    this.cal.set(5, lastDate);
                    this.liquidDate = this.cal.getTime();
                }
            }
            catch (NumberFormatException e) {
                System.out.println(" !!! Trouble with " + event.getActionCommand());
            }
        }
    }

    public Date getDate() {
        return this.liquidDate;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.TRACE) {
            System.out.println("propertyChange entered");
        }
        this.setTitle(this.composeTimeLabel(this.liquidDate));
        if (event.getPropertyName().equals("DateTime") || event.getPropertyName().equals("FormattedDateTime")) {
            // empty if block
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public static void main(String[] args) {
        JDateTimeGetter dtg = new JDateTimeGetter();
        dtg.setOutputDateFormatter(new SimpleDateFormat(" dd MMM yyyy HH:mm "));
        dtg.showInJFrame(100, 100);
        dtg.addPropertyChangeListener(new WeakPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("FormattedDateTime")) {
                    System.out.println(" MAIN Property Change, old value: " + (String)event.getOldValue() + " new value: " + (String)event.getNewValue());
                }
            }
        }, dtg));
    }
}

