/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JDepthDialog
implements ActionListener {
    protected float depth;
    protected float depth2;
    protected int ans;
    protected JDialog dialog;
    protected DecimalFormat lf;
    protected JLabel zMinLbl;
    protected JLabel zMaxLbl;
    ResourceBundle b = ResourceBundle.getBundle("gov.noaa.pmel.swing.PMELSwingResources");
    JTextField jtf = null;
    JTextField jtf2 = null;

    public JDepthDialog() {
        this(0.0f, "###.###E;###.###W");
        this.depth = 0.0f;
        this.ans = 1;
    }

    public JDepthDialog(float z, String formatString) {
        this.depth = z;
        this.lf = new DecimalFormat(formatString);
        String st = this.lf.format(z);
        this.jtf = new JTextField(st);
        this.jtf.addActionListener(this);
        Object[] options = new Object[]{this.b.getString("kOK"), this.b.getString("kCancel")};
        JOptionPane pane = new JOptionPane(this.jtf, -1, -1, null, options, options[0]);
        this.dialog = pane.createDialog(null, this.b.getString("kDepth"));
        this.dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (options[0].equals(selectedValue)) {
            try {
                this.depth = this.lf.parse(this.jtf.getText()).floatValue();
            }
            catch (Exception ex) {
                String errmsg = new String("Cannot parse text: " + this.jtf.getText());
                JOptionPane.showMessageDialog(null, errmsg, "ERROR", 0);
            }
            System.out.println(" depth: " + this.depth);
        }
    }

    public JDepthDialog(float zMin, float zMax, String formatString) {
        this.zMinLbl = new JLabel(this.b.getString("kMinimum"));
        this.zMaxLbl = new JLabel(this.b.getString("kMaximum"));
        this.zMinLbl.setFont(new Font("Dialog", 0, 12));
        this.zMinLbl.setForeground(Color.black);
        this.zMaxLbl.setFont(new Font("Dialog", 0, 12));
        this.zMaxLbl.setForeground(Color.black);
        this.depth = zMin;
        this.depth2 = zMax;
        this.lf = new DecimalFormat(formatString);
        String st = this.lf.format(zMin);
        String st2 = this.lf.format(zMax);
        this.jtf = new JTextField(st, 5);
        this.jtf2 = new JTextField(st2, 5);
        this.jtf.addActionListener(this);
        this.jtf2.addActionListener(this);
        Object[] options = new Object[]{this.b.getString("kOK"), this.b.getString("kCancel")};
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout(0, 1, 1));
        jp.add(this.zMinLbl);
        jp.add(this.jtf);
        jp.add(this.zMaxLbl);
        jp.add(this.jtf2);
        JOptionPane pane = new JOptionPane(jp, -1, -1, null, options, options[0]);
        this.dialog = pane.createDialog(null, "Depth Axis Range");
        this.dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (options[0].equals(selectedValue)) {
            this.depth = Float.valueOf(this.jtf.getText()).floatValue();
            this.depth2 = Float.valueOf(this.jtf2.getText()).floatValue();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            this.depth = Float.valueOf(this.jtf.getText()).floatValue();
            if (this.jtf2 != null) {
                this.depth2 = Float.valueOf(this.jtf2.getText()).floatValue();
            }
        }
        catch (Exception ex) {
            String errmsg = new String("Cannot parse text: " + event.getActionCommand());
            JOptionPane.showMessageDialog(null, errmsg, "ERROR", 0);
        }
        this.dialog.setVisible(false);
    }

    public float getDepth() {
        return this.depth;
    }

    public float getDepth2() {
        return this.depth2;
    }

    public String toString() {
        return new String("Depth is: " + this.depth);
    }

    public static void main(String[] args) {
        JDepthDialog jsld = new JDepthDialog(45.3772f, "###.###E;###.###W");
        System.out.println(" depth: " + jsld.getDepth());
        System.exit(0);
    }
}

