/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.text.LatitudeFormat;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JLatDialog
implements ActionListener {
    protected float latitude;
    protected float latitude2;
    protected int ans;
    protected JDialog dialog;
    protected LatitudeFormat lf;
    protected JLabel latMinLbl;
    protected JLabel latMaxLbl;
    protected JTextField jtf;
    protected JTextField jtf2;
    ResourceBundle b = ResourceBundle.getBundle("gov.noaa.pmel.swing.PMELSwingResources");

    public JLatDialog() {
        this(0.0f, "###.###N;###.###S");
        this.latitude = 0.0f;
        this.ans = 1;
    }

    public JLatDialog(float lat, String formatString) {
        this.latitude = lat;
        this.lf = new LatitudeFormat(formatString);
        String st = this.lf.format(lat);
        this.jtf = new JTextField(st);
        this.jtf.addActionListener(this);
        Object[] options = new Object[]{this.b.getString("kOK"), this.b.getString("kCancel")};
        JOptionPane pane = new JOptionPane(this.jtf, -1, -1, null, options, options[0]);
        this.dialog = pane.createDialog(null, this.b.getString("kLatitude"));
        this.dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (options[0].equals(selectedValue)) {
            String latTxt = this.jtf.getText();
            if (latTxt.toUpperCase().indexOf(78) > 0 || latTxt.toUpperCase().indexOf(83) > 0) {
                this.latitude = this.lf.parse(latTxt);
            } else {
                try {
                    this.latitude = Float.valueOf(latTxt).floatValue();
                }
                catch (Exception ex) {
                    this.latitude = 0.0f;
                }
            }
        }
    }

    public JLatDialog(float latMin, float latMax, String formatString) {
        this.latMinLbl = new JLabel(this.b.getString("kSouthLatitude"));
        this.latMaxLbl = new JLabel(this.b.getString("kNorthLatitude"));
        this.latitude = latMin;
        this.latitude2 = latMax;
        this.lf = new LatitudeFormat(formatString);
        String st = this.lf.format(latMin);
        String st2 = this.lf.format(latMax);
        this.jtf = new JTextField(st, 5);
        this.jtf2 = new JTextField(st2, 5);
        Object[] options = new Object[]{this.b.getString("kOK"), this.b.getString("kCancel")};
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout(0, 1, 1));
        jp.add(this.latMinLbl);
        jp.add(this.jtf);
        jp.add(this.latMaxLbl);
        jp.add(this.jtf2);
        JOptionPane pane = new JOptionPane(jp, -1, -1, null, options, options[0]);
        this.dialog = pane.createDialog(null, this.b.getString("kLatitudeAxisRange"));
        this.dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (options[0].equals(selectedValue)) {
            String latTxt = this.jtf.getText();
            String lat2Txt = this.jtf2.getText();
            if (latTxt.toUpperCase().indexOf(78) > 0 || latTxt.toUpperCase().indexOf(83) > 0) {
                this.latitude = this.lf.parse(latTxt);
            } else {
                try {
                    this.latitude = Float.valueOf(latTxt).floatValue();
                }
                catch (Exception ex) {
                    this.latitude = 0.0f;
                }
            }
            if (lat2Txt.toUpperCase().indexOf(78) > 0 || latTxt.toUpperCase().indexOf(83) > 0) {
                this.latitude2 = this.lf.parse(lat2Txt);
            } else {
                try {
                    this.latitude2 = Float.valueOf(lat2Txt).floatValue();
                }
                catch (Exception ex) {
                    this.latitude = 0.0f;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String latTxt = this.jtf.getText();
        if (latTxt.toUpperCase().indexOf(78) > 0 || latTxt.toUpperCase().indexOf(83) > 0) {
            this.latitude = this.lf.parse(latTxt);
        } else {
            try {
                this.latitude = Float.valueOf(latTxt).floatValue();
            }
            catch (Exception ex) {
                this.latitude = 0.0f;
            }
        }
        if (this.jtf2 != null) {
            String lat2Txt = this.jtf2.getText();
            if (lat2Txt.toUpperCase().indexOf(78) > 0 || latTxt.toUpperCase().indexOf(83) > 0) {
                this.latitude2 = this.lf.parse(lat2Txt);
            } else {
                try {
                    this.latitude2 = Float.valueOf(lat2Txt).floatValue();
                }
                catch (Exception ex) {
                    this.latitude = 0.0f;
                }
            }
        }
        this.dialog.setVisible(false);
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLatitude2() {
        return this.latitude2;
    }

    public String toString() {
        return new String("Latitude is: " + this.latitude);
    }

    public static void main(String[] args) {
        JLatDialog jsld = new JLatDialog(45.3772f, "###.###N;###.###S");
        System.out.println(" latitude: " + jsld.getLatitude());
        System.exit(0);
    }
}

