/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.map.GeoPoint;
import gov.noaa.pmel.swing.map.LatInvalidException;
import gov.noaa.pmel.swing.map.Latitude;
import gov.noaa.pmel.swing.map.LonInvalidException;
import gov.noaa.pmel.swing.map.Longitude;
import gov.noaa.pmel.swing.map.MapImageScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class JSelectionMap
extends JComponent
implements ActionListener {
    private int imgW;
    private int imgH;
    private MapImagePanel mapImgPanel;
    private BtnImagePanel btnImgPanel;
    private JPanel mapBorderPanel;
    private int offset;
    public final int BORDER = 0;
    private MapImageScale mapScale;
    private Rectangle regionRect;
    private GeoPoint nw;
    private GeoPoint se;
    private Cursor oldCursor;
    private JLabel mapInfo;
    private static final String infoText = "Mouse-Drag to select region.";
    Vector rectV = new Vector();
    private JTextField northInput;
    private JTextField southInput;
    private JTextField westInput;
    private JTextField eastInput;
    private String northStr;
    private String southStr;
    private String westStr;
    private String eastStr;
    private String northDefault;
    private String southDefault;
    private String westDefault;
    private String eastDefault;
    String btnImage = null;
    String mapImage = "map/world20_380.gif";
    private int left_ = 0;
    private int right_ = 375;
    private int top_ = 0;
    private int bottom_ = 249;
    private int offset_ = 0;
    private double west_ = 20.0;
    private double north_ = 90.0;
    private double east_ = 380.0;
    private double south_ = -90.0;
    private int imgW_ = 375;
    private int imgH_ = 249;
    private boolean initCalled = false;

    public JSelectionMap() {
        this.mapScale = new MapImageScale(new Point(this.left_, this.top_), new Point(this.right_, this.bottom_), new GeoPoint(this.west_, this.north_), new GeoPoint(this.east_, this.south_));
        this.mapInfo = new JLabel(infoText);
        this.setDefaultSelection(65.0, -65.0, 50.0, -50.0);
        this.init();
    }

    public void setImageSize(int w, int h) {
        this.imgW_ = w;
        this.imgH_ = h;
        this.right_ = w;
        this.bottom_ = h;
        this.mapScale = new MapImageScale(new Point(this.left_, this.top_), new Point(this.right_, this.bottom_), new GeoPoint(this.west_, this.north_), new GeoPoint(this.east_, this.south_));
    }

    public void setButtonImage(String file) {
        this.btnImage = file;
    }

    public void setMapImage(String file) {
        this.mapImage = file;
    }

    public void setOffset(int offset) {
        this.offset_ = offset;
    }

    public int getOffset() {
        return this.offset_;
    }

    public void setDefaultSelection(double north, double south, double west, double east) {
        GeoPoint nw = new GeoPoint(west, north);
        GeoPoint se = new GeoPoint(east, south);
        String sNorth = nw.Lat().toString("");
        String sWest = nw.Lon().toString("");
        String sSouth = se.Lat().toString("");
        String sEast = se.Lon().toString("");
        this.setDefaultSelection(sNorth, sSouth, sWest, sEast);
    }

    public void setDefaultSelection(String north, String south, String west, String east) {
        this.northDefault = north;
        this.southDefault = south;
        this.westDefault = west;
        this.eastDefault = east;
        this.regionRect = this.setRect(this.northDefault, this.southDefault, this.westDefault, this.eastDefault);
    }

    public void init() {
        if (this.initCalled) {
            return;
        }
        this.initCalled = true;
        this.setBackground(Color.white);
        this.northInput = new JTextField(this.northDefault, 8);
        this.southInput = new JTextField(this.southDefault, 8);
        this.westInput = new JTextField(this.westDefault, 8);
        this.eastInput = new JTextField(this.eastDefault, 8);
        this.northInput.addActionListener(this);
        this.southInput.addActionListener(this);
        this.eastInput.addActionListener(this);
        this.westInput.addActionListener(this);
        this.setBackground(Color.white);
        this.regionRect = this.setRect(this.northDefault, this.southDefault, this.westDefault, this.eastDefault);
        try {
            this.mapImgPanel = new MapImagePanel(this.getClass().getResource(this.mapImage));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.mapImgPanel.setPreferredSize(new Dimension(this.imgW_, this.imgH_));
        if (this.btnImage != null) {
            this.btnImgPanel = new BtnImagePanel(this.getClass().getResource(this.btnImage));
        }
        this.mapBorderPanel = new JPanel();
        this.mapBorderPanel.setBorder(new EtchedBorder());
        this.makeLayout();
    }

    public void addDataRegion(String north, String south, String west, String east) {
        this.rectV.addElement(this.setRect(north, south, west, east));
    }

    public void addDataRegion(double north, double south, double west, double east) {
        GeoPoint nw = new GeoPoint(west, north);
        GeoPoint se = new GeoPoint(east, south);
        String sNorth = nw.Lat().toString("");
        String sWest = nw.Lon().toString("");
        String sSouth = se.Lat().toString("");
        String sEast = se.Lon().toString("");
        this.addDataRegion(sNorth, sSouth, sWest, sEast);
    }

    public double getMinLon() {
        GeoPoint selected_nw = new GeoPoint(this.getLongitude(this.westInput.getText()), this.getLatitude(this.northInput.getText()));
        return selected_nw.Lon().LonValue();
    }

    public double getMaxLon() {
        GeoPoint selected_se = new GeoPoint(this.getLongitude(this.eastInput.getText()), this.getLatitude(this.southInput.getText()));
        return selected_se.Lon().LonValue();
    }

    public double getMaxLat() {
        GeoPoint selected_nw = new GeoPoint(this.getLongitude(this.westInput.getText()), this.getLatitude(this.northInput.getText()));
        return selected_nw.Lat().LatValue();
    }

    public double getMinLat() {
        GeoPoint selected_se = new GeoPoint(this.getLongitude(this.eastInput.getText()), this.getLatitude(this.southInput.getText()));
        return selected_se.Lat().LatValue();
    }

    private void makeLayout() {
        JButton bt = null;
        if (this.btnImage == null) {
            bt = new JButton("Set Default Selection Range");
            bt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JSelectionMap.this.setDefault();
                }
            });
        }
        this.mapBorderPanel.setLayout(new FlowLayout(0, 0, 0));
        this.mapBorderPanel.add(this.mapImgPanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout(0, 0));
        p2.add((Component)this.mapBorderPanel, "Center");
        p2.add((Component)this.mapInfo, "South");
        this.add(p2);
        JPanel p3 = new JPanel();
        p3.setLayout(new BorderLayout(0, 10));
        p3.add((Component)this.locationTextPanel(), "North");
        if (this.btnImage == null) {
            p3.add((Component)bt, "Center");
        } else {
            JPanel btnP = new JPanel();
            btnP.setLayout(new FlowLayout(1));
            btnP.add(this.btnImgPanel);
            p3.add((Component)btnP, "Center");
        }
        this.add(p3);
        this.setLayout(new FlowLayout(0, 10, 0));
    }

    JPanel locationTextPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(3, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(1));
        p1.add(this.northInput);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(1));
        p2.add(this.westInput);
        p2.add(this.eastInput);
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout(1));
        p3.add(this.southInput);
        p.add(p1);
        p.add(p2);
        p.add(p3);
        return p;
    }

    public void setDefault() {
        this.mapImgPanel.setDefault();
    }

    private Rectangle setRect(String nstr, String sstr, String wstr, String estr) {
        this.nw = new GeoPoint(this.getLongitude(wstr), this.getLatitude(nstr));
        this.se = new GeoPoint(this.getLongitude(estr), this.getLatitude(sstr));
        Point nwPoint = this.mapScale.toPoint(this.nw);
        Point sePoint = this.mapScale.toPoint(this.se);
        int x1 = nwPoint.x;
        int y1 = nwPoint.y;
        int x2 = sePoint.x;
        int y2 = sePoint.y;
        if (x2 < x1) {
            x2 += this.imgW;
        }
        int x = x1 >= this.offset ? x1 - this.offset : x1 - this.offset + this.imgW;
        Rectangle newRect = new Rectangle(x, y1, Math.abs(x2 - x1) + 1, Math.abs(y2 - y1) + 1);
        return newRect;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.northStr = this.northInput.getText();
        this.southStr = this.southInput.getText();
        this.eastStr = this.eastInput.getText();
        this.westStr = this.westInput.getText();
        this.regionRect = this.setRect(this.northStr, this.southStr, this.westStr, this.eastStr);
        this.mapImgPanel.repaint();
    }

    public Latitude getLatitude(String s) {
        try {
            return new Latitude(s);
        }
        catch (LatInvalidException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Longitude getLongitude(String s) {
        try {
            return new Longitude(s);
        }
        catch (LonInvalidException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void clearRegion() {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        JSelectionMap map = new JSelectionMap();
        map.setDefaultSelection("45 30.0N", "45  0.0S", "156 0.0E", "110 0.0W");
        map.addDataRegion("56 22.2N", "67  0.0S", "147 18.0E", "13 22.2W");
        map.addDataRegion("5 30.0N", "5 0.0S", "175 0.0E", "95 0.0W");
        map.init();
        map.setBackground(Color.white);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                System.out.println("MinLon: " + JSelectionMap.this.getMinLon());
                System.out.println("MaxLon: " + JSelectionMap.this.getMaxLon());
                System.out.println("MinLat: " + JSelectionMap.this.getMinLat());
                System.out.println("MaxLat: " + JSelectionMap.this.getMaxLat());
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }
        });
        frame.getContentPane().add((Component)map, "Center");
        frame.setSize(600, 300);
        frame.setBackground(Color.white);
        frame.setVisible(true);
    }

    class MapImagePanel
    extends JPanel {
        private Image image;
        private int startX;
        private int startY;

        MapImagePanel(URL file) {
            this.image = this.getToolkit().createImage(file);
            this.addMouseListener(new MouseEventHandler());
            this.addMouseMotionListener(new MouseMotionEventHandler());
            MediaTracker tracker = new MediaTracker(this);
            try {
                tracker.addImage(this.image, 0);
                tracker.waitForAll(0L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JSelectionMap.this.imgW = this.image.getWidth(null);
            JSelectionMap.this.imgH = this.image.getHeight(null);
            this.setPreferredSize(new Dimension(JSelectionMap.this.imgW, JSelectionMap.this.imgH));
        }

        @Override
        public void paintComponent(Graphics g) {
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (JSelectionMap.this.offset > 0) {
                g.clipRect(0, 0, w, h);
                g.translate(JSelectionMap.this.offset, 0);
                g.drawImage(this.image, 0, 0, w, h, this);
                g.translate(-w, 0);
                g.drawImage(this.image, 0, 0, w, h, this);
            } else {
                g.drawImage(this.image, 0, 0, w, h, this);
            }
            if (JSelectionMap.this.offset != 0) {
                g.translate(w - JSelectionMap.this.offset, 0);
            }
            g.setColor(Color.red);
            for (int i = 0; i < JSelectionMap.this.rectV.size(); ++i) {
                Rectangle r = (Rectangle)JSelectionMap.this.rectV.elementAt(i);
                g.drawRect(r.x, r.y, r.width, r.height);
                if (r.width + r.x <= w) continue;
                g.drawRect(-2, r.y, r.x + r.width - w, r.height);
            }
            g.setColor(Color.blue);
            g.drawRect(((JSelectionMap)JSelectionMap.this).regionRect.x, ((JSelectionMap)JSelectionMap.this).regionRect.y, ((JSelectionMap)JSelectionMap.this).regionRect.width, ((JSelectionMap)JSelectionMap.this).regionRect.height);
            if (((JSelectionMap)JSelectionMap.this).regionRect.width + ((JSelectionMap)JSelectionMap.this).regionRect.x > w) {
                g.drawRect(-2, ((JSelectionMap)JSelectionMap.this).regionRect.y, ((JSelectionMap)JSelectionMap.this).regionRect.x + ((JSelectionMap)JSelectionMap.this).regionRect.width - w, ((JSelectionMap)JSelectionMap.this).regionRect.height);
            }
            if (((JSelectionMap)JSelectionMap.this).regionRect.x < 0) {
                g.drawRect(w + ((JSelectionMap)JSelectionMap.this).regionRect.x, ((JSelectionMap)JSelectionMap.this).regionRect.y, Math.abs(((JSelectionMap)JSelectionMap.this).regionRect.x), ((JSelectionMap)JSelectionMap.this).regionRect.height);
            }
        }

        public void mouseReleased(MouseEvent event) {
            JSelectionMap.this.nw = JSelectionMap.this.mapScale.toGeoPoint(((JSelectionMap)JSelectionMap.this).regionRect.x - JSelectionMap.this.offset, ((JSelectionMap)JSelectionMap.this).regionRect.y);
            JSelectionMap.this.se = JSelectionMap.this.mapScale.toGeoPoint(((JSelectionMap)JSelectionMap.this).regionRect.x - JSelectionMap.this.offset + ((JSelectionMap)JSelectionMap.this).regionRect.width, ((JSelectionMap)JSelectionMap.this).regionRect.y + ((JSelectionMap)JSelectionMap.this).regionRect.height);
            JSelectionMap.this.northInput.setText(JSelectionMap.this.nw.Lat().toString(""));
            JSelectionMap.this.southInput.setText(JSelectionMap.this.se.Lat().toString(""));
            JSelectionMap.this.westInput.setText(JSelectionMap.this.nw.Lon().toString(""));
            JSelectionMap.this.eastInput.setText(JSelectionMap.this.se.Lon().toString(""));
        }

        public void mousePressed(MouseEvent event) {
            this.startX = event.getX();
            this.startY = event.getY();
            JSelectionMap.this.regionRect = new Rectangle(this.startX, this.startY, 0, 0);
            this.repaint();
        }

        public void mouseMoved(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            GeoPoint gp = JSelectionMap.this.mapScale.toGeoPoint(x - JSelectionMap.this.offset, y);
            JSelectionMap.this.mapInfo.setText(gp.toString("", ""));
        }

        public void mouseDragged(MouseEvent event) {
            int w = Math.abs(event.getX() - this.startX);
            int h = Math.abs(event.getY() - this.startY);
            int topY = Math.min(this.startY, event.getY());
            int leftX = Math.min(this.startX, event.getX());
            JSelectionMap.this.regionRect = new Rectangle(leftX, topY, w, h);
            GeoPoint gp = JSelectionMap.this.mapScale.toGeoPoint(leftX + w - JSelectionMap.this.offset, topY + h);
            JSelectionMap.this.mapInfo.setText(gp.toString("", ""));
            this.repaint();
        }

        public void setDefault() {
            JSelectionMap.this.northInput.setText(JSelectionMap.this.northDefault);
            JSelectionMap.this.southInput.setText(JSelectionMap.this.southDefault);
            JSelectionMap.this.westInput.setText(JSelectionMap.this.westDefault);
            JSelectionMap.this.eastInput.setText(JSelectionMap.this.eastDefault);
            JSelectionMap.this.regionRect = JSelectionMap.this.setRect(JSelectionMap.this.northDefault, JSelectionMap.this.southDefault, JSelectionMap.this.westDefault, JSelectionMap.this.eastDefault);
            this.repaint();
        }
    }

    class BtnImagePanel
    extends JPanel {
        private Image image;

        BtnImagePanel(URL file) {
            this.image = this.getToolkit().createImage(file);
            this.addMouseListener(new ButtonActionEventHandler());
            MediaTracker tracker = new MediaTracker(this);
            try {
                tracker.addImage(this.image, 0);
                tracker.waitForAll(0L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.image, 0, 0, this);
        }

        public void mousePressed(MouseEvent event) {
            JSelectionMap.this.setDefault();
        }
    }

    class MouseMotionEventHandler
    extends MouseMotionAdapter {
        MouseMotionEventHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            JSelectionMap.this.mapImgPanel.mouseMoved(event);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            JSelectionMap.this.mapImgPanel.mouseDragged(event);
        }
    }

    public class MouseEventHandler
    extends MouseAdapter {
        @Override
        public void mouseEntered(MouseEvent event) {
            JSelectionMap.this.oldCursor = JSelectionMap.this.getCursor();
            JSelectionMap.this.setCursor(Cursor.getPredefinedCursor(1));
        }

        @Override
        public void mouseExited(MouseEvent event) {
            JSelectionMap.this.setCursor(JSelectionMap.this.oldCursor);
            JSelectionMap.this.mapInfo.setText(JSelectionMap.infoText);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            JSelectionMap.this.mapImgPanel.mousePressed(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            JSelectionMap.this.mapImgPanel.mouseReleased(event);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }
    }

    public class ButtonActionEventHandler
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent event) {
            JSelectionMap.this.btnImgPanel.mousePressed(event);
        }
    }
}

