/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.JSlider2;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.TimeRange;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JSlider2Date
extends Container
implements Serializable {
    boolean twoHandles_;
    TimeRange range_;
    GeoDate minValue_;
    GeoDate oldMinValue_;
    GeoDate maxValue_;
    GeoDate oldMaxValue_;
    double scale_;
    int oldStopMonth_;
    int oldStartMonth_;
    String format_;
    JPanel panel_;
    GridBagLayout layout_;
    JLabel labelStart_;
    JLabel labelStart00_;
    JTextField startDay_;
    JTextField startYear_;
    JTextField startHour_;
    JTextField startMin_;
    JComboBox startMonth_;
    DefaultComboBoxModel startModel_;
    JLabel labelStop_;
    JLabel labelStop00_;
    JTextField stopDay_;
    JTextField stopYear_;
    JTextField stopHour_;
    JTextField stopMin_;
    JComboBox stopMonth_;
    DefaultComboBoxModel stopModel_;
    JSlider2 slider_;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public JSlider2Date() {
        this(true);
    }

    public JSlider2Date(boolean twoHandles) {
        this.twoHandles_ = twoHandles;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() {
        this.setLayout(new BorderLayout(0, 0));
        this.panel_ = new JPanel();
        this.layout_ = new GridBagLayout();
        this.panel_.setLayout(this.layout_);
        this.panel_.setBounds(0, 0, 368, 177);
        this.slider_ = new JSlider2();
        this.slider_.setBounds(18, 70, 331, 60);
        this.panel_.add((Component)this.slider_, new GridBagConstraints(0, 0, 8, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.labelStart_ = new JLabel("Start:", 4);
        this.panel_.add((Component)this.labelStart_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.startDay_ = new JTextField();
        this.startDay_.setText("12");
        this.startDay_.setColumns(2);
        this.panel_.add((Component)this.startDay_, new GridBagConstraints(1, 1, 1, 1, 0.5, 1.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.startMonth_ = new JComboBox();
        this.startMonth_.setFont(new Font("Dialog", 0, 12));
        this.panel_.add((Component)this.startMonth_, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.startYear_ = new JTextField(5);
        this.startYear_.setText("1997");
        this.panel_.add((Component)this.startYear_, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.startHour_ = new JTextField();
        this.startHour_.setColumns(2);
        this.startHour_.setText("10");
        this.panel_.add((Component)this.startHour_, new GridBagConstraints(4, 1, 1, 1, 0.5, 1.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.labelStart00_ = new JLabel(":");
        this.labelStart00_.setHorizontalAlignment(0);
        this.panel_.add((Component)this.labelStart00_, new GridBagConstraints(5, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.startMin_ = new JTextField();
        this.startMin_.setColumns(2);
        this.startMin_.setText("10");
        this.panel_.add((Component)this.startMin_, new GridBagConstraints(6, 1, 1, 1, 0.5, 1.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.labelStop_ = new JLabel("Stop:", 4);
        this.stopDay_ = new JTextField(2);
        this.stopDay_.setText("23");
        this.stopMonth_ = new JComboBox();
        this.stopMonth_.setFont(new Font("Dialog", 0, 12));
        this.stopYear_ = new JTextField(5);
        this.stopYear_.setText("1995");
        this.stopHour_ = new JTextField(2);
        this.stopHour_.setText("10");
        this.labelStop00_ = new JLabel(":");
        this.labelStop00_.setHorizontalAlignment(0);
        this.stopMin_ = new JTextField(2);
        this.stopMin_.setText("10");
        if (this.twoHandles_) {
            this.panel_.add((Component)this.labelStop_, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 10, 5), 0, 0));
            this.panel_.add((Component)this.stopDay_, new GridBagConstraints(1, 2, 1, 1, 0.5, 1.0, 10, 2, new Insets(5, 0, 10, 5), 0, 0));
            this.panel_.add((Component)this.stopMonth_, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 10, 5), 0, 0));
            this.panel_.add((Component)this.stopYear_, new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 10, 5), 0, 0));
            this.panel_.add((Component)this.stopHour_, new GridBagConstraints(4, 2, 1, 1, 0.5, 1.0, 10, 2, new Insets(5, 5, 10, 0), 0, 0));
            this.panel_.add((Component)this.labelStop00_, new GridBagConstraints(5, 2, 1, 1, 0.0, 1.0, 10, 0, new Insets(5, 0, 10, 0), 0, 0));
            this.panel_.add((Component)this.stopMin_, new GridBagConstraints(6, 2, 1, 1, 0.5, 1.0, 10, 2, new Insets(5, 0, 10, 5), 0, 0));
        } else {
            this.labelStart_.setText("Date:");
        }
        String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        this.startModel_ = new DefaultComboBoxModel<String>(months);
        this.stopModel_ = new DefaultComboBoxModel<String>(months);
        this.startMonth_.setModel(this.startModel_);
        this.stopMonth_.setModel(this.stopModel_);
        this.add("Center", this.panel_);
        SymAction lSymAction = new SymAction();
        this.startDay_.addActionListener(lSymAction);
        this.startYear_.addActionListener(lSymAction);
        this.startHour_.addActionListener(lSymAction);
        this.startMin_.addActionListener(lSymAction);
        SymPropertyChange lSymPropertyChange = new SymPropertyChange();
        this.startMonth_.addActionListener(lSymAction);
        this.slider_.addPropertyChangeListener(new WeakPropertyChangeListener(lSymPropertyChange, this.slider_));
        this.stopDay_.addActionListener(lSymAction);
        this.stopMonth_.addActionListener(lSymAction);
        this.stopYear_.addActionListener(lSymAction);
        this.stopHour_.addActionListener(lSymAction);
        this.stopMin_.addActionListener(lSymAction);
        this.slider_.setAlwaysPost(true);
        this.slider_.setDoubleBuffered(true);
        this.format_ = "yyyy-MM-dd";
        GeoDate start = new GeoDate();
        start.now();
        GeoDate stop = new GeoDate(start);
        stop.increment(100.0, 1);
        this.range_ = new TimeRange(start, stop);
        this.setRange(this.range_);
    }

    public void setRange(GeoDate min, GeoDate max) {
        this.setRange(new TimeRange(min, max));
    }

    public void setRange(Date dmin, Date dmax) {
        GeoDate tmin = null;
        GeoDate tmax = null;
        tmin = new GeoDate(dmin);
        tmax = new GeoDate(dmax);
        this.setRange(new TimeRange(tmin, tmax));
    }

    public void setRange(TimeRange range) {
        this.range_ = range;
        this.scale_ = this.range_.end.offset(this.range_.start);
        this.slider_.setMinLabel(this.range_.start.toString(this.format_));
        this.slider_.setMaxLabel(this.range_.end.toString(this.format_));
        this.minValue_ = this.range_.start;
        this.maxValue_ = this.range_.end;
        this.setStart(false);
        this.setStop(false);
    }

    public TimeRange getRange() {
        return this.range_;
    }

    public void setMinRange(GeoDate min) {
        this.range_.start = min;
        this.setRange(this.range_);
    }

    public GeoDate getMinRange() {
        return this.range_.start;
    }

    public void setMaxRange(GeoDate max) {
        this.range_.end = max;
        this.setRange(this.range_);
    }

    public GeoDate getMaxRange() {
        return this.range_.end;
    }

    public void reset() {
        this.slider_.reset();
    }

    public void setTwoHandles(boolean th) {
        this.twoHandles_ = th;
        this.slider_.setTwoHandles(this.twoHandles_);
        if (this.twoHandles_) {
            if (!this.panel_.isAncestorOf(this.labelStop_)) {
                this.panel_.add((Component)this.labelStop_, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 0, 10, 5), 0, 0));
            }
            if (!this.panel_.isAncestorOf(this.stopDay_)) {
                this.panel_.add((Component)this.stopDay_, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 10, 5), 0, 0));
            }
            if (!this.panel_.isAncestorOf(this.stopMonth_)) {
                this.panel_.add((Component)this.stopMonth_, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 10, 5), 0, 0));
            }
            if (!this.panel_.isAncestorOf(this.stopYear_)) {
                this.panel_.add((Component)this.stopYear_, new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 10, 5), 0, 0));
            }
            if (!this.panel_.isAncestorOf(this.stopHour_)) {
                this.panel_.add((Component)this.stopHour_, new GridBagConstraints(4, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 10, 0), 0, 0));
            }
            if (!this.panel_.isAncestorOf(this.labelStop00_)) {
                this.panel_.add((Component)this.labelStop00_, new GridBagConstraints(5, 2, 1, 1, 0.0, 1.0, 10, 0, new Insets(5, 0, 10, 0), 0, 0));
            }
            if (!this.panel_.isAncestorOf(this.stopMin_)) {
                this.panel_.add((Component)this.stopMin_, new GridBagConstraints(6, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 10, 5), 0, 0));
            }
            this.labelStart_.setText("Start:");
            this.panel_.invalidate();
        } else {
            this.labelStart_.setText("Date:");
            if (this.panel_.isAncestorOf(this.labelStop_)) {
                this.panel_.remove(this.labelStop_);
            }
            if (this.panel_.isAncestorOf(this.stopDay_)) {
                this.panel_.remove(this.stopDay_);
            }
            if (this.panel_.isAncestorOf(this.stopMonth_)) {
                this.panel_.remove(this.stopMonth_);
            }
            if (this.panel_.isAncestorOf(this.stopYear_)) {
                this.panel_.remove(this.stopYear_);
            }
            if (this.panel_.isAncestorOf(this.stopHour_)) {
                this.panel_.remove(this.stopHour_);
            }
            if (this.panel_.isAncestorOf(this.labelStop00_)) {
                this.panel_.remove(this.labelStop00_);
            }
            if (this.panel_.isAncestorOf(this.stopMin_)) {
                this.panel_.remove(this.stopMin_);
            }
            this.panel_.invalidate();
        }
    }

    public boolean getTwoHandles() {
        return this.twoHandles_;
    }

    public boolean isTwoHandles() {
        return this.twoHandles_;
    }

    public void setMinDate(Date dmin) {
        GeoDate tmin = null;
        tmin = new GeoDate(dmin);
        this.setMinValue(tmin);
    }

    public Date getMinDate() {
        int day = Integer.parseInt(this.startDay_.getText());
        int year = Integer.parseInt(this.startYear_.getText());
        int hour = Integer.parseInt(this.startHour_.getText());
        int month = this.startMonth_.getSelectedIndex() + 1;
        GeoDate date = null;
        try {
            date = new GeoDate(month, day, year, hour, 0, 0, 0);
        }
        catch (IllegalTimeValue e) {
            System.out.println(e);
        }
        return date;
    }

    public void setMaxDate(Date dmax) {
        GeoDate tmax = null;
        tmax = new GeoDate(dmax);
        this.setMaxValue(tmax);
    }

    public Date getMaxDate() {
        int day = Integer.parseInt(this.stopDay_.getText());
        int year = Integer.parseInt(this.stopYear_.getText());
        int hour = Integer.parseInt(this.stopHour_.getText());
        int min = Integer.parseInt(this.stopMin_.getText());
        int month = this.stopMonth_.getSelectedIndex() + 1;
        GeoDate date = null;
        try {
            date = new GeoDate(month, day, year, hour, min, 0, 0);
        }
        catch (IllegalTimeValue e) {
            System.out.println(e);
        }
        return date;
    }

    public GeoDate getStartValue() {
        int day = Integer.parseInt(this.startDay_.getText());
        int year = Integer.parseInt(this.startYear_.getText());
        int hour = Integer.parseInt(this.startHour_.getText());
        int min = Integer.parseInt(this.startMin_.getText());
        int month = this.startMonth_.getSelectedIndex() + 1;
        try {
            this.minValue_ = new GeoDate(month, day, year, hour, min, 0, 0);
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        return this.minValue_;
    }

    public GeoDate getEndValue() {
        int day = Integer.parseInt(this.stopDay_.getText());
        int year = Integer.parseInt(this.stopYear_.getText());
        int hour = Integer.parseInt(this.stopHour_.getText());
        int min = Integer.parseInt(this.stopMin_.getText());
        int month = this.stopMonth_.getSelectedIndex() + 1;
        try {
            this.maxValue_ = new GeoDate(month, day, year, hour, min, 0, 0);
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        return this.maxValue_;
    }

    public void setStartValue(GeoDate tmin) {
        this.minValue_ = tmin;
        if (this.minValue_.before(this.range_.start)) {
            this.minValue_ = this.range_.start;
        }
        double min = this.minValue_.offset(this.range_.start) / this.scale_;
        this.slider_.setMinValue(min);
        this.setStart(false);
    }

    public void setEndValue(GeoDate tmax) {
        this.maxValue_ = tmax;
        if (this.maxValue_.after(this.range_.end)) {
            this.maxValue_ = this.range_.end;
        }
        double max = this.maxValue_.offset(this.range_.start) / this.scale_;
        this.slider_.setMaxValue(max);
        this.setStop(false);
    }

    public void setMinValue(GeoDate tmin) {
        this.minValue_ = tmin;
        if (this.minValue_.after(this.maxValue_)) {
            this.minValue_ = this.maxValue_;
        }
        double min = this.minValue_.offset(this.range_.start) / this.scale_;
        this.slider_.setMinValue(min);
        this.setStart(false);
    }

    public void setMaxValue(GeoDate tmax) {
        this.maxValue_ = tmax;
        if (this.maxValue_.before(this.minValue_)) {
            this.maxValue_ = this.minValue_;
        }
        double max = this.maxValue_.offset(this.range_.start) / this.scale_;
        this.slider_.setMaxValue(max);
        this.setStop(false);
    }

    public GeoDate getMinValue() {
        int day = Integer.parseInt(this.startDay_.getText());
        int year = Integer.parseInt(this.startYear_.getText());
        int hour = Integer.parseInt(this.startHour_.getText());
        int min = Integer.parseInt(this.startMin_.getText());
        int month = this.startMonth_.getSelectedIndex() + 1;
        try {
            this.minValue_ = new GeoDate(month, day, year, hour, min, 0, 0);
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        if (this.minValue_.after(this.maxValue_)) {
            this.minValue_ = this.maxValue_;
        }
        return this.minValue_;
    }

    public GeoDate getMaxValue() {
        int day = Integer.parseInt(this.stopDay_.getText());
        int year = Integer.parseInt(this.stopYear_.getText());
        int hour = Integer.parseInt(this.stopHour_.getText());
        int min = Integer.parseInt(this.stopMin_.getText());
        int month = this.stopMonth_.getSelectedIndex() + 1;
        try {
            this.maxValue_ = new GeoDate(month, day, year, hour, min, 0, 0);
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        if (this.maxValue_.before(this.minValue_)) {
            this.maxValue_ = this.minValue_;
        }
        return this.maxValue_;
    }

    public void setFormat(String frmt) {
        this.format_ = frmt;
        this.slider_.setMinLabel(this.range_.start.toString(this.format_));
        this.slider_.setMaxLabel(this.range_.end.toString(this.format_));
    }

    public String getFormat() {
        return this.format_;
    }

    public void setShowBorder(boolean sb) {
        this.slider_.setShowBorder(sb);
    }

    public boolean getShowBorder() {
        return this.slider_.getShowBorder();
    }

    public void setHandleSize(int sz) {
        this.slider_.setHandleSize(sz);
    }

    public int getHandleSize() {
        return this.slider_.getHandleSize();
    }

    public void setAlwaysPost(boolean ap) {
        this.slider_.setAlwaysPost(ap);
    }

    public boolean getAlwaysPost() {
        return this.slider_.getAlwaysPost();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    @Override
    public Dimension getMinimumSize() {
        int hgt = this.twoHandles_ ? 144 : 105;
        return new Dimension(375, hgt);
    }

    @Override
    public Dimension getPreferredSize() {
        int hgt = this.twoHandles_ ? 144 : 105;
        return new Dimension(375, hgt);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.validate();
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.validate();
    }

    void startMonth_ActionEvent(ActionEvent event) {
        if (this.oldStartMonth_ != this.startMonth_.getSelectedIndex() + 1) {
            this.minValue_EnterHit();
        }
    }

    void stopMonth_ActionEvent(ActionEvent event) {
        if (this.oldStopMonth_ != this.stopMonth_.getSelectedIndex() + 1) {
            this.maxValue_EnterHit();
        }
    }

    void minValue_EnterHit() {
        double min;
        int month;
        int day = Integer.parseInt(this.startDay_.getText());
        int year = Integer.parseInt(this.startYear_.getText());
        int hour = Integer.parseInt(this.startHour_.getText());
        int minute = Integer.parseInt(this.startMin_.getText());
        this.oldStartMonth_ = month = this.startMonth_.getSelectedIndex() + 1;
        try {
            this.minValue_ = new GeoDate(month, day, year, hour, minute, 0, 0);
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        if (this.minValue_.after(this.maxValue_)) {
            this.minValue_ = this.maxValue_;
        }
        if ((min = this.minValue_.offset(this.range_.start) / this.scale_) < 0.0) {
            min = 0.0;
            this.minValue_ = new GeoDate(this.range_.start);
            this.minValue_.increment(min * this.scale_, 1);
            this.setStart(false);
        }
        this.slider_.setMinValue(min);
    }

    void maxValue_EnterHit() {
        double max;
        int month;
        int day = Integer.parseInt(this.stopDay_.getText());
        int year = Integer.parseInt(this.stopYear_.getText());
        int hour = Integer.parseInt(this.stopHour_.getText());
        int minute = Integer.parseInt(this.stopMin_.getText());
        this.oldStopMonth_ = month = this.stopMonth_.getSelectedIndex() + 1;
        try {
            this.maxValue_ = new GeoDate(month, day, year, hour, minute, 0, 0);
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        if (this.maxValue_.before(this.minValue_)) {
            this.maxValue_ = this.minValue_;
        }
        if ((max = this.maxValue_.offset(this.range_.start) / this.scale_) > 1.0) {
            max = 1.0;
            this.maxValue_ = new GeoDate(this.range_.start);
            this.maxValue_.increment(max * this.scale_, 1);
            this.setStop(false);
        }
        this.slider_.setMaxValue(max);
    }

    void slider_propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("minValue")) {
            double min = (Double)event.getNewValue();
            this.minValue_ = new GeoDate(this.range_.start);
            this.minValue_.increment(min * this.scale_, 1);
            this.setStart(true);
        } else if (event.getPropertyName().equals("maxValue")) {
            double max = (Double)event.getNewValue();
            this.maxValue_ = new GeoDate(this.range_.start);
            this.maxValue_.increment(max * this.scale_, 1);
            this.setStop(true);
        }
    }

    void setStart(boolean post) {
        this.startDay_.setText(this.minValue_.toString("dd"));
        this.oldStartMonth_ = this.minValue_.getGMTMonth();
        this.startMonth_.setSelectedIndex(this.oldStartMonth_ - 1);
        this.startYear_.setText(this.minValue_.toString("yyyy"));
        this.startHour_.setText(this.minValue_.toString("HH"));
        this.startMin_.setText(this.minValue_.toString("mm"));
        if (post) {
            this.changes.firePropertyChange("minValue", this.oldMinValue_, this.minValue_);
            this.oldMinValue_ = this.minValue_;
        }
    }

    void setStop(boolean post) {
        this.stopDay_.setText(this.maxValue_.toString("dd"));
        this.oldStopMonth_ = this.maxValue_.getGMTMonth();
        this.stopMonth_.setSelectedIndex(this.oldStopMonth_ - 1);
        this.stopYear_.setText(this.maxValue_.toString("yyyy"));
        this.stopHour_.setText(this.maxValue_.toString("HH"));
        this.stopMin_.setText(this.maxValue_.toString("mm"));
        if (post) {
            this.changes.firePropertyChange("maxValue", this.oldMaxValue_, this.maxValue_);
            this.oldMaxValue_ = this.maxValue_;
        }
    }

    public static void main(String[] args) {
        String format = "yyyy-MM-dd HH:mm";
        JSlider2Date js2dt = new JSlider2Date();
        try {
            GeoDate min = new GeoDate("1999-02-15 00:00", format);
            GeoDate max = new GeoDate("2001-05-01 00:00", format);
            GeoDate start = new GeoDate("1999-10-12 12:00", format);
            GeoDate end = new GeoDate("2000-04-01 13:39", format);
            js2dt.setRange(new TimeRange(min, max));
            js2dt.setStartValue(start);
            js2dt.setEndValue(end);
            js2dt.setAlwaysPost(true);
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        JFrame jf = new JFrame("JSlider2Date Test");
        jf.setSize(500, 300);
        jf.getContentPane().setLayout(new FlowLayout());
        jf.getContentPane().add(js2dt);
        jf.setVisible(true);
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == JSlider2Date.this.startDay_ || object == JSlider2Date.this.startYear_ || object == JSlider2Date.this.startHour_ || object == JSlider2Date.this.startMin_) {
                JSlider2Date.this.minValue_EnterHit();
            } else if (object == JSlider2Date.this.stopDay_ || object == JSlider2Date.this.stopYear_ || object == JSlider2Date.this.stopHour_ || object == JSlider2Date.this.stopMin_) {
                JSlider2Date.this.maxValue_EnterHit();
            } else if (object == JSlider2Date.this.startMonth_) {
                JSlider2Date.this.startMonth_ActionEvent(event);
            } else if (object == JSlider2Date.this.stopMonth_) {
                JSlider2Date.this.stopMonth_ActionEvent(event);
            }
        }
    }

    class SymPropertyChange
    implements PropertyChangeListener {
        SymPropertyChange() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Object object = event.getSource();
            if (object == JSlider2Date.this.slider_) {
                JSlider2Date.this.slider_propertyChange(event);
            }
        }
    }
}

