/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.JSlider2;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JSlider2Double
extends JComponent
implements Serializable {
    boolean twoHandles_;
    Range2D range_;
    double minValue_;
    double oldMinValue_;
    double maxValue_;
    double oldMaxValue_;
    double scale_;
    String format_ = "";
    DecimalFormat form_;
    boolean indexed_ = false;
    double[] values_;
    double[] scaled_;
    JSlider2 slider_;
    JLabel minLabel_;
    JTextField minField_;
    JLabel maxLabel_;
    JTextField maxField_;
    JPanel panel_;
    GridBagLayout layout_;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public JSlider2Double() {
        this(true);
    }

    public JSlider2Double(boolean twoHandles) {
        this.twoHandles_ = twoHandles;
        this.setLayout(new BorderLayout(0, 0));
        this.panel_ = new JPanel();
        this.layout_ = new GridBagLayout();
        this.panel_.setLayout(this.layout_);
        this.panel_.setBounds(12, 12, 384, 156);
        this.slider_ = new JSlider2();
        this.slider_.setBounds(5, 20, 374, 49);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 5, 5);
        this.layout_.setConstraints(this.slider_, gbc);
        this.panel_.add(this.slider_);
        this.minLabel_ = new JLabel("Minimum:", 4);
        this.minLabel_.setBounds(6, 79, 68, 23);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.layout_.setConstraints(this.minLabel_, gbc);
        this.panel_.add(this.minLabel_);
        this.minField_ = new JTextField();
        this.minField_.setBounds(80, 79, 299, 23);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 5, 5);
        this.layout_.setConstraints(this.minField_, gbc);
        this.panel_.add(this.minField_);
        this.maxLabel_ = new JLabel("Maximum:", 4);
        this.maxLabel_.setBounds(5, 112, 70, 23);
        this.maxField_ = new JTextField();
        this.maxField_.setBounds(80, 112, 299, 23);
        if (this.twoHandles_) {
            gbc = new GridBagConstraints();
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 10, 5);
            this.layout_.setConstraints(this.maxLabel_, gbc);
            this.panel_.add(this.maxLabel_);
            gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 0, 10, 5);
            this.layout_.setConstraints(this.maxField_, gbc);
            this.panel_.add(this.maxField_);
        } else {
            this.minLabel_.setText("Value:");
        }
        this.add("Center", this.panel_);
        SymPropertyChange lSymPropertyChange = new SymPropertyChange();
        this.slider_.addPropertyChangeListener(new WeakPropertyChangeListener(lSymPropertyChange, this.slider_));
        SymAction lSymAction = new SymAction();
        this.minField_.addActionListener(lSymAction);
        this.maxField_.addActionListener(lSymAction);
        this.form_ = new DecimalFormat(this.format_);
        this.form_.setGroupingUsed(false);
        this.range_ = new Range2D(0.0, 1.0);
        this.setRange(this.range_);
    }

    public void setRange(double min, double max) {
        this.setRange(new Range2D(min, max));
    }

    public void setRange(Range2D range) {
        this.range_ = range;
        this.scale_ = this.range_.end - this.range_.start;
        this.slider_.setMinLabel(this.form_.format(this.range_.start));
        this.slider_.setMaxLabel(this.form_.format(this.range_.end));
        this.oldMinValue_ = this.minValue_ = this.range_.start;
        double min = (this.minValue_ - this.range_.start) / this.scale_;
        this.slider_.setMinValue(min);
        this.minField_.setText(this.form_.format(this.minValue_));
        this.oldMaxValue_ = this.maxValue_ = this.range_.end;
        double max = (this.maxValue_ - this.range_.start) / this.scale_;
        this.slider_.setMaxValue(max);
        this.maxField_.setText(this.form_.format(this.maxValue_));
        if (this.indexed_) {
            for (int i = 0; i < this.values_.length; ++i) {
                this.scaled_[i] = (this.values_[i] - this.range_.start) / this.scale_;
            }
            this.slider_.setIndexValues(this.scaled_);
        }
    }

    public Range2D getRange() {
        return this.range_;
    }

    public void setMinRange(double min) {
        this.range_.start = min;
        this.setRange(this.range_);
    }

    public double getMinRange() {
        return this.range_.start;
    }

    public void setMaxRange(double max) {
        this.range_.end = max;
        this.setRange(this.range_);
    }

    public double getMaxRange() {
        return this.range_.end;
    }

    public void reset() {
        this.slider_.reset();
    }

    public void setIndexValues(double[] array) {
        this.values_ = array;
        this.indexed_ = true;
        this.scaled_ = new double[this.values_.length];
        this.setRange(this.range_);
    }

    public void setTwoHandles(boolean th) {
        this.twoHandles_ = th;
        this.slider_.setTwoHandles(th);
        if (this.twoHandles_) {
            GridBagConstraints gbc;
            if (!this.panel_.isAncestorOf(this.maxLabel_)) {
                gbc = new GridBagConstraints();
                gbc.fill = 0;
                gbc.insets = new Insets(5, 5, 10, 5);
                this.layout_.setConstraints(this.maxLabel_, gbc);
                this.panel_.add(this.maxLabel_);
            }
            if (!this.panel_.isAncestorOf(this.maxField_)) {
                gbc = new GridBagConstraints();
                gbc.weightx = 1.0;
                gbc.fill = 2;
                gbc.insets = new Insets(5, 0, 10, 5);
                this.layout_.setConstraints(this.maxField_, gbc);
                this.panel_.add(this.maxField_);
            }
            this.minLabel_.setText("Minimum:");
            this.panel_.invalidate();
        } else {
            this.minLabel_.setText("Value:");
            if (this.panel_.isAncestorOf(this.maxLabel_)) {
                this.panel_.remove(this.maxLabel_);
            }
            if (this.panel_.isAncestorOf(this.maxField_)) {
                this.panel_.remove(this.maxField_);
            }
            this.panel_.invalidate();
        }
        this.slider_.setDoubleBuffered(true);
    }

    public boolean getTwoHandles() {
        return this.twoHandles_;
    }

    public boolean isTwoHandles() {
        return this.twoHandles_;
    }

    public void setFormat(String frmt) {
        this.format_ = frmt;
        this.form_ = new DecimalFormat(this.format_);
        this.form_.setGroupingUsed(false);
        this.setRange(this.range_);
    }

    public String getFormat() {
        return this.format_;
    }

    public double getStartValue() {
        this.minValue_ = this.range_.start > this.range_.end ? Math.min(Double.valueOf(this.minField_.getText()), this.range_.start) : Math.max(Double.valueOf(this.minField_.getText()), this.range_.start);
        return this.minValue_;
    }

    public double getEndValue() {
        this.maxValue_ = this.range_.start > this.range_.end ? Math.max(Double.valueOf(this.maxField_.getText()), this.range_.end) : Math.min(Double.valueOf(this.maxField_.getText()), this.range_.end);
        return this.maxValue_;
    }

    public void setStartValue(double min) {
        this.minValue_ = this.range_.start > this.range_.end ? Math.min(min, this.range_.start) : Math.max(min, this.range_.start);
        min = (this.minValue_ - this.range_.start) / this.scale_;
        this.slider_.setMinValue(min);
    }

    public void setEndValue(double max) {
        this.maxValue_ = this.range_.start > this.range_.end ? Math.max(max, this.range_.end) : Math.min(max, this.range_.end);
        max = (this.maxValue_ - this.range_.start) / this.scale_;
        this.slider_.setMaxValue(max);
    }

    public double getMinValue() {
        this.minValue_ = Math.max(Double.valueOf(this.minField_.getText()), this.range_.start);
        this.minValue_ = Math.min(this.minValue_, this.maxValue_);
        return this.minValue_;
    }

    public void setMinValue(double min) {
        this.minValue_ = min;
        this.minValue_ = Math.min(this.minValue_, this.maxValue_);
        min = (this.minValue_ - this.range_.start) / this.scale_;
        this.slider_.setMinValue(min);
    }

    public double getMaxValue() {
        this.maxValue_ = Math.min(Double.valueOf(this.maxField_.getText()), this.range_.end);
        this.maxValue_ = Math.max(this.maxValue_, this.minValue_);
        return this.maxValue_;
    }

    public void setMaxValue(double max) {
        this.maxValue_ = max;
        this.maxValue_ = Math.max(this.maxValue_, this.minValue_);
        max = (this.maxValue_ - this.range_.start) / this.scale_;
        this.slider_.setMaxValue(max);
    }

    public void setShowBorder(boolean sb) {
        this.slider_.setShowBorder(sb);
    }

    public boolean getShowBorder() {
        return this.slider_.getShowBorder();
    }

    public void setHandleSize(int sz) {
        this.slider_.setHandleSize(sz);
    }

    public int getHandleSize() {
        return this.slider_.getHandleSize();
    }

    public void setAlwaysPost(boolean ap) {
        this.slider_.setAlwaysPost(ap);
    }

    public boolean getAlwaysPost() {
        return this.slider_.getAlwaysPost();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    @Override
    public Dimension getMinimumSize() {
        int hgt = this.twoHandles_ ? 135 : 105;
        return new Dimension(180, hgt);
    }

    @Override
    public Dimension getPreferredSize() {
        int hgt = this.twoHandles_ ? 135 : 105;
        return new Dimension(384, hgt);
    }

    public boolean isIndexed() {
        return this.indexed_;
    }

    public void setIndexed(boolean ind) {
        this.indexed_ = ind;
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.validate();
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.validate();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    void slider_propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("minValue")) {
            this.minValue_ = this.range_.start + this.slider_.getMinValue() * this.scale_;
            this.minField_.setText(this.form_.format(this.minValue_));
            this.testMin();
        } else if (event.getPropertyName().equals("maxValue")) {
            this.maxValue_ = this.range_.start + this.slider_.getMaxValue() * this.scale_;
            this.maxField_.setText(this.form_.format(this.maxValue_));
            this.testMax();
        }
    }

    void minField_EnterHit(ActionEvent event) {
        this.minValue_ = Math.max(Double.valueOf(this.minField_.getText()), this.range_.start);
        this.minValue_ = Math.min(this.minValue_, this.maxValue_);
        double min = (this.minValue_ - this.range_.start) / this.scale_;
        this.slider_.setMinValue(min);
    }

    void maxField_EnterHit(ActionEvent event) {
        this.maxValue_ = Math.min(Double.valueOf(this.maxField_.getText()), this.range_.end);
        this.maxValue_ = Math.max(this.maxValue_, this.minValue_);
        double max = (this.maxValue_ - this.range_.start) / this.scale_;
        this.slider_.setMaxValue(max);
    }

    void testMax() {
        if (this.oldMaxValue_ != this.maxValue_) {
            Double tempOldValue = new Double(this.oldMaxValue_);
            this.oldMaxValue_ = this.maxValue_;
            this.changes.firePropertyChange("maxValue", tempOldValue, new Double(this.maxValue_));
        }
    }

    void testMin() {
        if (this.oldMinValue_ != this.minValue_) {
            Double tempOldValue = new Double(this.oldMinValue_);
            this.oldMinValue_ = this.minValue_;
            this.changes.firePropertyChange("minValue", tempOldValue, new Double(this.minValue_));
        }
    }

    public static void main(String[] args) {
        double[] values = new double[]{-20.0, -10.0, -5.0, -2.5, 0.0, 2.5, 5.0, 10.0, 15.0, 20.0};
        JFrame jf = new JFrame("JSlider2Double Test");
        jf.setSize(400, 200);
        jf.getContentPane().setLayout(new BorderLayout());
        JSlider2Double js2db = new JSlider2Double();
        js2db.setRange(new Range2D(-20.0, 20.0));
        js2db.setStartValue(-10.0);
        js2db.setEndValue(15.0);
        js2db.setIndexValues(values);
        js2db.setAlwaysPost(true);
        jf.getContentPane().add((Component)js2db, "Center");
        jf.setVisible(true);
    }

    class SymPropertyChange
    implements PropertyChangeListener {
        SymPropertyChange() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Object object = event.getSource();
            if (object == JSlider2Double.this.slider_) {
                JSlider2Double.this.slider_propertyChange(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == JSlider2Double.this.minField_) {
                JSlider2Double.this.minField_EnterHit(event);
            } else if (object == JSlider2Double.this.maxField_) {
                JSlider2Double.this.maxField_EnterHit(event);
            }
        }
    }
}

