/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.DragHandle;
import gov.noaa.pmel.swing.LegalDragArea;
import gov.noaa.pmel.swing.PolygonSpline;
import gov.noaa.pmel.swing.Rubberband;
import gov.noaa.pmel.swing.RubberbandRectangle;
import gov.noaa.pmel.swing.RubberbandRenderer;
import gov.noaa.pmel.swing.SectionSpline;
import gov.noaa.pmel.swing.SelectionRegion;
import gov.noaa.pmel.swing.StretchActionListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;

public abstract class JStretchPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
LegalDragArea,
RubberbandRenderer {
    private int componentCount = 0;
    protected Rubberband rbRect;
    protected DragHandle mXAxisLeft;
    protected DragHandle mXAxisCtr;
    protected DragHandle mXAxisRight;
    protected DragHandle mYAxisUpper;
    protected DragHandle mYAxisCtr;
    protected DragHandle mYAxisLower;
    public Vector mDragHandleListeners = new Vector();
    private DragHandle handleBeingDragged = null;
    private boolean draggingHandle;
    private boolean axisClicked;
    private String theClickedAxis;
    protected SelectionRegion mHilitedRegion = null;
    protected Object parentObject;
    public static Color DEFAULT_SELECTION_REGION_OUTLINE_COLOR = new Color(255, 255, 255, 240);
    public static Color DEFAULT_SELECTION_REGION_BG_COLOR = new Color(255, 255, 255, 100);
    private int pad0_x = 0;
    private int pad0_y = 0;
    private int etchedEdgeSize = 1;
    private int pad1_left = 0;
    private int pad1_right = 0;
    private int pad1_bottom = 0;
    private int pad1_top = 0;
    private int pad2_bottom = 0;
    private int indentForMsgArea_left = 4;
    private int indentForMsgArea_right = 0;
    private int etchedEdgeHide_x = 0;
    private int etchedEdgeHide_y = 0;
    private Insets insets;
    private Rectangle dragBoxArea;
    private SoftBevelBorder loweredSoftBevel;
    private boolean isFocusPanel;
    private String msg = " ";
    private Font msgFont;
    private int minWidth;
    private int minHeight;
    private int maxWidth = 500;
    private int maxHeight = 500;
    private int compStartX;
    private int compStartY;
    private Color gray = new Color(128, 128, 128);
    private Color gray200;
    private Color dragBoxBackground = this.gray200 = new Color(200, 200, 200);
    private int dragAreaWidth = 18;
    private int dragAreaHeight = 20;
    private int textAreaHeight = 20;
    private int xbeg;
    private int xend;
    private int ybeg;
    private int yend;
    private Color lightEtchColor = new Color(228, 228, 228);
    private Color darkEtchColor = new Color(128, 128, 128);
    private boolean hasEastEtch = false;
    private boolean hasNorthEtch = false;
    private boolean hasWestEtch = false;
    private boolean hasSouthEtch = false;
    protected int diffx;
    protected int diffy;
    protected boolean dragging;
    protected int lastDragX;
    protected int lastDragY;
    protected EventListenerList listenerList = new EventListenerList();
    private Image mOffScreen = null;
    protected GeneralPath mSelectionRect = new GeneralPath();
    private GeneralPath mSplinePath = new GeneralPath();
    BasicStroke lw1 = new BasicStroke(1.0f);
    BasicStroke lw2 = new BasicStroke(2.0f);
    Rectangle oldRect = new Rectangle();
    protected Vector mSplinePoints = new Vector();
    protected boolean independentHandles = false;
    protected ChangeEvent changeEvent = null;

    public JStretchPanel() {
        this.setMinimumSize(new Dimension(this.minWidth, this.minHeight));
        this.setMaximumSize(new Dimension(this.maxWidth, this.maxHeight));
        this.setPreferredSize(new Dimension(this.maxWidth, this.maxHeight));
        this.setSize(new Dimension(this.maxWidth, this.maxHeight));
        this.compStartX = this.pad0_x + this.etchedEdgeSize + this.pad1_left;
        this.compStartY = this.pad0_y + this.etchedEdgeSize + 2 + this.pad1_bottom;
        this.setLayout(null);
        this.setOpaque(true);
        this.isFocusPanel = false;
        this.minWidth = this.dragAreaWidth + (this.pad0_x + this.etchedEdgeSize) * 2 + this.pad1_left + this.pad1_right + this.indentForMsgArea_right;
        this.minHeight = this.dragAreaHeight + (this.pad0_y + this.etchedEdgeSize) * 2 + this.pad1_top + this.pad1_bottom;
        this.insets = new Insets(this.pad0_y + this.etchedEdgeSize + this.pad1_top, this.compStartX, this.compStartY + this.dragAreaHeight + this.pad2_bottom, this.pad0_x + this.etchedEdgeSize + this.pad1_right);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.loweredSoftBevel = new SoftBevelBorder(1, new Color(255, 255, 255), new Color(142, 142, 142));
        this.setBorder(this.loweredSoftBevel);
        this.msgFont = new Font("Dialog", 0, 9);
        boolean windows = false;
        if (-1 != System.getProperty("os.name").indexOf("Windows")) {
            windows = true;
        }
        if (windows) {
            this.msgFont = new Font("Courier", 0, 12);
        }
        this.setDoubleBuffered(true);
    }

    public abstract void rubberbandEnded(Rubberband var1, boolean var2);

    public abstract void processSectionSpline(boolean var1);

    public abstract void processPolygonSpline(boolean var1);

    public void setIndependentHandles(boolean val) {
        this.independentHandles = val;
    }

    public boolean isIndependentHandles() {
        return this.independentHandles;
    }

    public void handleDragEnded(DragHandle dh) {
        this.handleDragEnded(dh);
    }

    public abstract void handleAxisClick(String var1, Point var2);

    public abstract void handleAxisRangeClick(String var1);

    @Override
    public void setRubberbandDisplayObject(Object obj, boolean concat) {
        this.mSelectionRect = (GeneralPath)obj;
        this.repaint();
    }

    @Override
    public Vector getSplinePoints() {
        return this.mSplinePoints;
    }

    @Override
    public void addSplinePoint(Point pt) {
        this.mSplinePoints.addElement(pt);
        this.setRubberbandDisplayObject(null, false);
    }

    public void setRubberband(Rubberband rb) {
        if (this.rbRect != null) {
            this.rbRect.setActive(false);
        }
        this.rbRect = rb;
        if (this.rbRect != null) {
            this.rbRect.setActive(true);
            this.rbRect.setComponent(this);
        }
    }

    public Rubberband getRubberband() {
        return this.rbRect;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setMsgFont(Font msgFont) {
        this.msgFont = msgFont;
    }

    public Font getMsgFont() {
        return this.msgFont;
    }

    public boolean getIsFocusPanel() {
        return this.isFocusPanel;
    }

    public void setIsFocusPanel(boolean isFocus) {
        if (Rubberband.rubberbandIsActive) {
            return;
        }
        this.isFocusPanel = isFocus;
    }

    @Override
    public Component add(Component comp) {
        if (this.componentCount != 1) {
            super.add(comp);
            this.componentCount = 1;
            int x1 = this.pad0_x + this.etchedEdgeSize + this.pad1_left;
            int y1 = this.pad0_y + this.etchedEdgeSize + this.pad1_top;
            int x2 = this.getWidth() - 1 - this.pad0_x - this.etchedEdgeSize - this.pad1_right;
            int y2 = this.getHeight() - 1 - this.pad0_y - this.etchedEdgeSize - this.pad1_bottom - this.dragAreaHeight;
            comp.setBounds(x1, y1, x2 - x1, y2 - y1);
        }
        return comp;
    }

    public void setDragBoxBackground(Color dbc) {
        this.dragBoxBackground = dbc;
    }

    public Color getDragBoxBackground() {
        return this.dragBoxBackground;
    }

    public void addNorthEtch() {
        this.hasNorthEtch = true;
    }

    public void addEastEtch() {
        this.hasEastEtch = true;
    }

    public void removeNorthEtch() {
        this.hasNorthEtch = false;
    }

    public void removeEastEtch() {
        this.hasEastEtch = false;
    }

    @Override
    public void invalidate() {
        try {
            super.invalidate();
            if (this.mOffScreen != null) {
                this.mOffScreen = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paintPanelData(Graphics g, int width, int height, int top, int left, int bott, int right) {
    }

    public void setCPCursor(Point p, boolean shiftDown) {
    }

    public boolean isInDragArea(Point p) {
        return true;
    }

    public String isInAxesArea(Point p) {
        return "";
    }

    public String isInAxesRangeArea(Point p) {
        return "";
    }

    public int getLegendInset() {
        return 0;
    }

    @Override
    public void paint(Graphics ig) {
        Graphics2D g = (Graphics2D)ig;
        if (g == null) {
            return;
        }
        super.paint(g);
        if (this.hasNorthEtch) {
            g.setColor(this.darkEtchColor);
            g.drawLine(this.pad0_x + this.etchedEdgeHide_x, this.pad0_y, this.getWidth() - 1 - this.pad0_x - this.etchedEdgeHide_x, this.pad0_y);
            g.setColor(this.lightEtchColor);
            g.drawLine(this.pad0_x + this.etchedEdgeHide_x, this.pad0_y + 1, this.getWidth() - 1 - this.pad0_x - this.etchedEdgeHide_x, this.pad0_y + 1);
            g.drawLine(this.pad0_x + this.etchedEdgeHide_x, this.pad0_y + 2, this.getWidth() - 1 - this.pad0_x - this.etchedEdgeHide_x, this.pad0_y + 2);
        }
        if (this.hasSouthEtch) {
            g.setColor(this.lightEtchColor);
            g.drawLine(this.pad0_x + this.etchedEdgeHide_x, this.getHeight() - 1 - this.pad0_y, this.getWidth() - 1 - this.pad0_x - this.etchedEdgeHide_x, this.getHeight() - 1 - this.pad0_y);
            g.drawLine(this.pad0_x + this.etchedEdgeHide_x, this.getHeight() - 1 - this.pad0_y - 1, this.getWidth() - 1 - this.pad0_x - this.etchedEdgeHide_x, this.getHeight() - 1 - this.pad0_y - 1);
            g.setColor(this.darkEtchColor);
            g.drawLine(this.pad0_x + this.etchedEdgeHide_x, this.getHeight() - 1 - this.pad0_y - 2, this.getWidth() - 1 - this.pad0_x - this.etchedEdgeHide_x, this.getHeight() - 1 - this.pad0_y - 2);
        }
        if (this.hasWestEtch) {
            g.setColor(this.lightEtchColor);
            g.drawLine(this.pad0_x, this.pad0_y + this.etchedEdgeHide_y, this.pad0_x, this.getHeight() - 1 - this.pad0_y - this.etchedEdgeHide_y);
            g.drawLine(this.pad0_x + 1, this.pad0_y + this.etchedEdgeHide_y, this.pad0_x + 1, this.getHeight() - 1 - this.pad0_y - this.etchedEdgeHide_y);
            g.setColor(this.darkEtchColor);
            g.drawLine(this.pad0_x + 2, this.pad0_y + this.etchedEdgeHide_y, this.pad0_x + 2, this.getHeight() - 1 - this.pad0_y - this.etchedEdgeHide_y);
        }
        if (this.hasEastEtch) {
            g.setColor(this.darkEtchColor);
            g.drawLine(this.getWidth() - 1 - this.pad0_x, this.pad0_y + this.etchedEdgeHide_y, this.getWidth() - 1 - this.pad0_x, this.getHeight() - 1 - this.pad0_y - this.etchedEdgeHide_y);
            g.setColor(this.lightEtchColor);
            g.drawLine(this.getWidth() - 1 - this.pad0_x - 1, this.pad0_y + this.etchedEdgeHide_y, this.getWidth() - 1 - this.pad0_x - 1, this.getHeight() - 1 - this.pad0_y - this.etchedEdgeHide_y);
            g.drawLine(this.getWidth() - 1 - this.pad0_x - 2, this.pad0_y + this.etchedEdgeHide_y, this.getWidth() - 1 - this.pad0_x - 2, this.getHeight() - 1 - this.pad0_y - this.etchedEdgeHide_y);
        }
        this.xbeg = this.getWidth() - 1 - this.compStartX;
        this.xend = this.getWidth() - 1 - this.compStartX;
        this.ybeg = this.getHeight() - 1 - this.compStartY;
        this.yend = this.getHeight() - 1 - this.compStartY;
        this.dragBoxArea = new Rectangle(this.xbeg - this.dragAreaWidth, this.ybeg - this.dragAreaHeight, this.dragAreaWidth, this.dragAreaHeight);
        --this.xbeg;
        --this.xend;
        --this.ybeg;
        --this.yend;
        g.setColor(this.gray);
        g.drawLine(this.xbeg, this.ybeg, this.xend, this.yend);
        --this.xbeg;
        --this.yend;
        g.setColor(this.gray);
        g.drawLine(this.xbeg, this.ybeg, this.xend, this.yend);
        --this.xbeg;
        --this.yend;
        g.setColor(new Color(255, 255, 255));
        g.drawLine(this.xbeg, this.ybeg, this.xend, this.yend);
        this.xbeg -= 2;
        this.yend -= 2;
        g.setColor(this.gray);
        g.drawLine(this.xbeg, this.ybeg, this.xend, this.yend);
        --this.xbeg;
        --this.yend;
        g.setColor(this.gray);
        g.drawLine(this.xbeg, this.ybeg, this.xend, this.yend);
        --this.xbeg;
        --this.yend;
        g.setColor(new Color(255, 255, 255));
        g.drawLine(this.xbeg, this.ybeg, this.xend, this.yend);
        this.xbeg -= 2;
        this.yend -= 2;
        g.setColor(this.gray);
        g.drawLine(this.xbeg, this.ybeg, this.xend, this.yend);
        --this.xbeg;
        --this.yend;
        g.setColor(this.gray);
        g.drawLine(this.xbeg, this.ybeg, this.xend, this.yend);
        --this.xbeg;
        --this.yend;
        g.setColor(new Color(255, 255, 255));
        g.drawLine(this.xbeg, this.ybeg, this.xend, this.yend);
        this.xbeg = this.compStartX + this.indentForMsgArea_left;
        this.xend = this.getWidth() - 1 - this.compStartX - this.dragAreaWidth - this.indentForMsgArea_right;
        this.ybeg = this.getHeight() - 1 - this.compStartY - this.textAreaHeight;
        this.yend = this.getHeight() - 1 - this.compStartY - 1;
        if (this.mOffScreen == null) {
            this.mOffScreen = this.createImage(this.getSize().width - 10, this.getSize().height - 75);
            Graphics og = this.mOffScreen.getGraphics();
            super.paintComponent(og);
            this.paintPanelData(og, this.getSize().width - 10 - this.getLegendInset(), this.getSize().height - 50, 5, 5, 5, 5);
            if (this.mOffScreen != null) {
                g.drawImage(this.mOffScreen, 5, 5, null);
            }
            og.dispose();
        } else {
            g.drawImage(this.mOffScreen, 5, 5, null);
        }
        if (this.mXAxisLeft != null) {
            this.mXAxisLeft.draw(g);
        }
        if (this.mXAxisCtr != null) {
            this.mXAxisCtr.draw(g);
        }
        if (this.mXAxisRight != null) {
            this.mXAxisRight.draw(g);
        }
        if (this.mYAxisUpper != null) {
            this.mYAxisUpper.draw(g);
        }
        if (this.mYAxisCtr != null) {
            this.mYAxisCtr.draw(g);
        }
        if (this.mYAxisLower != null) {
            this.mYAxisLower.draw(g);
        }
        if (this.mHilitedRegion != null) {
            g.setClip(this.mXAxisLeft.getAxisOrigin(), this.mYAxisUpper.getAxisOrigin(), this.mXAxisLeft.getAxisRange(), this.mYAxisUpper.getAxisRange());
            int mSelHMin = this.mHilitedRegion.getSelXMin();
            int mSelHMax = this.mHilitedRegion.getSelXMax();
            int mSelHCtr = this.mHilitedRegion.getSelXCtr();
            int mSelVMin = this.mHilitedRegion.getSelYMin();
            int mSelVMax = this.mHilitedRegion.getSelYMax();
            int mSelVCtr = this.mHilitedRegion.getSelYCtr();
            int selOffset = 0;
            int mXAxisOrig = this.mHilitedRegion.getXAxisOrig();
            int mXAxisLen = this.mHilitedRegion.getXAxisLen();
            int mYAxisOrig = this.mHilitedRegion.getYAxisOrig();
            int mYAxisLen = this.mHilitedRegion.getYAxisLen();
            g.setColor(DEFAULT_SELECTION_REGION_BG_COLOR);
            g.fillRect(mSelHMin, mSelVMin, mSelHMax - mSelHMin, mSelVMax - mSelVMin);
            g.setColor(DEFAULT_SELECTION_REGION_OUTLINE_COLOR);
            g.drawLine(mSelHMin + selOffset, mYAxisOrig + selOffset, mSelHMin + selOffset, mYAxisOrig + mYAxisLen + selOffset);
            g.drawLine(mSelHMax + selOffset, mYAxisOrig + selOffset, mSelHMax + selOffset, mYAxisOrig + mYAxisLen + selOffset);
            g.drawLine(mSelHCtr + selOffset, mYAxisOrig - 16 + selOffset, mSelHCtr + selOffset, mYAxisOrig + mYAxisLen);
            g.drawLine(mXAxisOrig + selOffset, mSelVMin + selOffset, mXAxisOrig + mXAxisLen + selOffset, mSelVMin + selOffset);
            g.drawLine(mXAxisOrig + selOffset, mSelVMax + selOffset, mXAxisOrig + mXAxisLen + selOffset, mSelVMax + selOffset);
            g.drawLine(mXAxisOrig + selOffset, mSelVCtr + selOffset, mXAxisOrig + mXAxisLen + 16 + selOffset, mSelVCtr + selOffset);
            g.setClip(0, 0, 1000, 1000);
        }
        try {
            if (this.mSplinePoints.size() > 0) {
                this.mSplinePath.reset();
                Point pt = (Point)this.mSplinePoints.elementAt(0);
                this.mSplinePath.moveTo(pt.x, pt.y);
                g.setColor(DEFAULT_SELECTION_REGION_OUTLINE_COLOR);
                g.setStroke(this.lw2);
                for (int i = 1; i < this.mSplinePoints.size(); ++i) {
                    pt = (Point)this.mSplinePoints.elementAt(i);
                    this.mSplinePath.lineTo(pt.x, pt.y);
                }
                try {
                    g.draw(this.mSplinePath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.mSelectionRect != null) {
                g.setColor(DEFAULT_SELECTION_REGION_BG_COLOR);
                g.fill(this.mSelectionRect);
                g.setColor(DEFAULT_SELECTION_REGION_OUTLINE_COLOR);
                g.setStroke(this.lw2);
                g.draw(this.mSelectionRect);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.basicPanel_mouseDragged(event);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setCPCursor(e.getPoint(), e.isShiftDown());
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.basicPanel_mousePressed(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.dragging) {
            this.fireDragStopped();
        } else if (this.draggingHandle) {
            this.handleDragEnded(this.handleBeingDragged);
        } else if (this.axisClicked) {
            this.handleAxisClick(this.theClickedAxis, event.getPoint());
        } else if (!this.draggingHandle && this.rbRect != null && this.isInDragArea(this.rbRect.getStretched())) {
            this.rubberbandEnded(this.rbRect, event.isShiftDown());
            this.rbRect.reset();
        }
        this.setRubberbandDisplayObject(null, false);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    void basicPanel_mousePressed(MouseEvent event) {
        this.axisClicked = false;
        this.rbRect.setActive(false);
        if (this.isInDragArea(event.getPoint())) {
            this.rbRect.setActive(true);
        } else {
            this.theClickedAxis = this.isInAxesArea(event.getPoint());
            if (this.theClickedAxis != null) {
                this.axisClicked = true;
            }
        }
        this.lastDragX = event.getX();
        this.lastDragY = event.getY();
        if (this.dragBoxArea != null && this.dragBoxArea.contains(event.getX(), event.getY())) {
            this.dragging = true;
            this.draggingHandle = false;
            this.fireDragStarted();
        } else {
            this.dragging = false;
        }
        this.handleBeingDragged = this.getWhichDragHandle(event.getX(), event.getY());
        if (this.handleBeingDragged != null) {
            this.draggingHandle = true;
            this.dragging = false;
            this.handleBeingDragged.setDragPoint(event.getX(), event.getY());
        } else {
            this.draggingHandle = false;
        }
    }

    public DragHandle getWhichDragHandle(int x, int y) {
        if (this.mXAxisLeft == null) {
            return null;
        }
        if (this.mXAxisLeft.pointInHandle(x, y)) {
            return this.mXAxisLeft;
        }
        if (this.mXAxisCtr.pointInHandle(x, y)) {
            return this.mXAxisCtr;
        }
        if (this.mXAxisRight.pointInHandle(x, y)) {
            return this.mXAxisRight;
        }
        if (this.mYAxisUpper.pointInHandle(x, y)) {
            return this.mYAxisUpper;
        }
        if (this.mYAxisCtr.pointInHandle(x, y)) {
            return this.mYAxisCtr;
        }
        if (this.mYAxisLower.pointInHandle(x, y)) {
            return this.mYAxisLower;
        }
        return null;
    }

    void basicPanel_mouseDragged(MouseEvent event) {
        if (event.isPopupTrigger()) {
            return;
        }
        if (!this.dragging && !this.draggingHandle) {
            return;
        }
        int diffx = event.getX() - this.lastDragX;
        int diffy = event.getY() - this.lastDragY;
        if (this.dragging) {
            int w = this.getWidth() + diffx;
            int h = this.getHeight() + diffy;
            this.setSize(w, h);
            this.setPreferredSize(this.getSize());
            this.invalidate();
            this.validate();
        } else if (this.draggingHandle) {
            Point p = this.handleBeingDragged.constrainPoint(event.getX(), event.getY());
            double newVal = 0.0;
            newVal = this.handleBeingDragged.mOrientation == DragHandle.HORIENTATION ? this.handleBeingDragged.getNewValue(p.x) : this.handleBeingDragged.getNewValue(p.y);
            this.handleBeingDragged.setValue(newVal);
            this.handleBeingDragged.setLocation(p);
            this.handleBeingDragged.setNeighbors(this.independentHandles);
            this.repaint();
        }
        this.lastDragX = event.getX();
        this.lastDragY = event.getY();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, this.calibrateWidth(width), this.calibrateHeight(height));
    }

    public int calibrateWidth(int w) {
        int minOfTheMaximumWidths;
        int ww = w;
        int maxOfTheMinimumWidths = Math.max(this.getMinimumSize().width, this.minWidth);
        if (ww < maxOfTheMinimumWidths) {
            ww = maxOfTheMinimumWidths;
        }
        if (ww > (minOfTheMaximumWidths = Math.min(this.getMaximumSize().width, this.maxWidth))) {
            ww = minOfTheMaximumWidths;
        }
        return ww;
    }

    public int calibrateHeight(int h) {
        int minOfTheMaximumHeights;
        int hh = h;
        int maxOfTheMinimumHeights = Math.max(this.getMinimumSize().height, this.minHeight);
        if (hh < maxOfTheMinimumHeights) {
            hh = maxOfTheMinimumHeights;
        }
        if (hh > (minOfTheMaximumHeights = Math.min(this.getMaximumSize().height, this.maxHeight))) {
            hh = minOfTheMaximumHeights;
        }
        return hh;
    }

    public void addStretchActionListener(StretchActionListener l) {
        this.listenerList.add(StretchActionListener.class, l);
    }

    public void removeStretchActionListener(StretchActionListener l) {
        this.listenerList.remove(StretchActionListener.class, l);
    }

    protected void fireDragStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StretchActionListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((StretchActionListener)listeners[i + 1]).stretchStarted(this.changeEvent);
        }
    }

    protected void fireDragStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StretchActionListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((StretchActionListener)listeners[i + 1]).stretchStopped(this.changeEvent);
        }
    }

    public double getSelMinXVal() {
        if (this.mXAxisLeft != null) {
            return this.mXAxisLeft.getValue();
        }
        return 0.0;
    }

    public double getSelMaxXVal() {
        if (this.mXAxisRight != null) {
            return this.mXAxisRight.getValue();
        }
        return 0.0;
    }

    public double getSelMinYVal() {
        if (this.mYAxisLower != null) {
            return this.mYAxisLower.getValue();
        }
        return 0.0;
    }

    public double getSelMaxYVal() {
        if (this.mYAxisUpper != null) {
            return this.mYAxisUpper.getValue();
        }
        return 0.0;
    }

    public void setSelMinXVal(double val) {
        this.mXAxisLeft.setValue(val);
    }

    public void setSelMaxXVal(double val) {
        this.mXAxisRight.setValue(val);
    }

    public void setSelMinYVal(double val) {
        this.mYAxisLower.setValue(val);
    }

    public void setSelMaxYVal(double val) {
        this.mYAxisUpper.setValue(val);
    }

    public SelectionRegion getSelectionRegion() {
        return this.mHilitedRegion;
    }

    @Override
    public int getMinX() {
        return 0;
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getMaxX() {
        return 0;
    }

    @Override
    public int getMaxY() {
        return 0;
    }

    public void setSelectionAsRectangle() {
        this.rbRect.resetRect();
        this.rbRect.setActive(false);
        this.rbRect = null;
        this.rbRect = new RubberbandRectangle(this);
        this.rbRect.setActive(true);
        this.rbRect.resetRect();
    }

    public void setSelectionAsLine() {
        this.rbRect.resetRect();
        this.rbRect.setActive(false);
        this.rbRect = null;
        this.rbRect = new SectionSpline(this);
        this.rbRect.setActive(true);
        this.rbRect.resetRect();
    }

    public void setSelectionAsPolygon() {
        this.rbRect.resetRect();
        this.rbRect.setActive(false);
        this.rbRect = null;
        this.rbRect = new PolygonSpline(this);
        this.rbRect.setActive(true);
        this.rbRect.resetRect();
    }

    public abstract int ComputeSectionPixelWidth(Point var1);
}

