/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class JViewHTMLDialog
extends JDialog {
    boolean fComponentsAdjusted = false;
    JScrollPane usingScroll = new JScrollPane();
    JEditorPane usingText = new JEditorPane();
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();

    public JViewHTMLDialog() {
        this((Frame)null, (String)null, false);
    }

    public JViewHTMLDialog(String title) {
        this((Frame)null, title, false);
    }

    public JViewHTMLDialog(Frame frame, String title) {
        this(frame, title, false);
    }

    public JViewHTMLDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        if (title == null) {
            this.setTitle("HTML Viewer");
        }
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        this.setSize(586, 501);
        this.usingScroll = new JScrollPane();
        this.usingScroll.setOpaque(true);
        this.usingScroll.setBounds(0, 0, 586, 466);
        this.usingScroll.setFont(new Font("Dialog", 0, 12));
        this.usingScroll.setForeground(Color.black);
        this.usingScroll.setBackground(new Color(204, 204, 204));
        this.getContentPane().add("Center", this.usingScroll);
        this.usingText = new JEditorPane();
        this.usingText.setMargin(new Insets(3, 3, 3, 3));
        this.usingText.setEditable(false);
        this.usingText.setBounds(0, 0, 583, 463);
        this.usingText.setFont(new Font("Dialog", 0, 12));
        this.usingText.setBackground(Color.white);
        this.usingScroll.getViewport().add(this.usingText);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.buttonPanel.setBounds(0, 466, 586, 35);
        this.buttonPanel.setFont(new Font("Dialog", 0, 12));
        this.buttonPanel.setForeground(Color.black);
        this.buttonPanel.setBackground(new Color(204, 204, 204));
        this.getContentPane().add("South", this.buttonPanel);
        this.okButton = new JButton();
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.setBounds(267, 5, 51, 25);
        this.okButton.setFont(new Font("Dialog", 1, 12));
        this.okButton.setBackground(new Color(204, 204, 204));
        this.buttonPanel.add(this.okButton);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.okButton.addActionListener(lSymAction);
        Hyperactive hyper = new Hyperactive();
        this.usingText.addHyperlinkListener(hyper);
    }

    public void setPage(String pageURL) {
        try {
            this.usingText.setContentType("text/html");
            this.usingText.setPage(pageURL);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        Insets in = this.getInsets();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(in.left + in.right + d.width, in.top + in.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(in.left, in.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(150, 150);
        }
        super.setVisible(b);
    }

    void JViewHTMLDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        JViewHTMLDialog jv = new JViewHTMLDialog();
        jv.setTitle("Test HTML Dialog");
        jv.setPage("http://www.epic.noaa.gov/java/ncBrowse/news.html");
        jv.setVisible(true);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == JViewHTMLDialog.this) {
                JViewHTMLDialog.this.JViewHTMLDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == JViewHTMLDialog.this.okButton) {
                JViewHTMLDialog.this.okButton_actionPerformed(event);
            }
        }
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        pane.setPage(e.getURL());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

