/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.DragHandle;
import gov.noaa.pmel.swing.JStretchPanel;
import java.awt.Graphics;
import java.awt.Point;

public class LeftDragHandle
extends DragHandle {
    private static Point setPt = new Point(0, 0);

    public LeftDragHandle(JStretchPanel jsp, int h, int v, int type, int style, int orient, int axis, int uporleft, int loworright, double uporleftval, double loworrightval, double val) {
        super(jsp, h, v, type, style, orient, axis, uporleft, loworright, uporleftval, loworrightval, val);
    }

    @Override
    public void draw(Graphics g) {
        int drawnH = this.mH;
        if (this.mH < this.getAxisOrigin() - 2) {
            drawnH = this.getAxisOrigin();
            this.setOutOfRange(true);
            this.setStyle(FLAGSTYLE);
        } else if (this.mH > this.getAxisOrigin() + this.getAxisRange() + 2) {
            drawnH = this.getAxisOrigin() + this.getAxisRange();
            this.setOutOfRange(true);
            this.setStyle(FLAGSTYLE);
        } else {
            this.setOutOfRange(false);
            this.setStyle(RECTSTYLE);
        }
        if (this.isOutOfRange()) {
            return;
        }
        if (this.mStyle == RECTSTYLE) {
            if (this.isFocused()) {
                g.setColor(this.grey100);
                g.fillRect(drawnH - 7, this.mV - 18, 7, 18);
            } else {
                g.setColor(this.grey100);
                g.drawRect(drawnH - 7, this.mV - 18, 7, 18);
            }
        } else {
            int[] xp = new int[]{drawnH, drawnH, drawnH - 8};
            int[] yp = new int[]{this.mV - 18, this.mV, this.mV - 8};
            g.fillPolygon(xp, yp, 3);
        }
    }

    @Override
    public void getRect() {
        this.currHandleRect.x = this.mH - 7;
        this.currHandleRect.y = this.mV - 18;
        this.currHandleRect.width = 7;
        this.currHandleRect.height = 18;
    }

    @Override
    public Point constrainPoint(int h, int v) {
        int locOfNhbr;
        int hh = h;
        int vv = v;
        vv = this.mVLimit;
        if (h > this.mLowerOrRightLimit) {
            hh = this.mLowerOrRightLimit;
        }
        if (h < this.mUpperOrLeftLimit) {
            hh = this.mUpperOrLeftLimit;
        }
        if (h > (locOfNhbr = this.mFarNeighbor.getCurrLocation().x) - 8) {
            hh = this.mFarNeighbor.getCurrLocation().x - 8;
        }
        this.constrainedPoint.x = hh + this.mDeltaH;
        this.constrainedPoint.y = vv;
        return this.constrainedPoint;
    }

    @Override
    public void setNeighbors(boolean setFar) {
        int del = this.mCtrNeighbor.getCurrLocation().x - this.getCurrLocation().x;
        if (del == 0) {
            return;
        }
        if (!setFar) {
            LeftDragHandle.setPt.x = this.mCtrNeighbor.getCurrLocation().x + del;
            LeftDragHandle.setPt.y = this.getCurrLocation().y;
            double newVal = this.mFarNeighbor.getNewValue(LeftDragHandle.setPt.x);
            this.mFarNeighbor.setValue(newVal);
            this.mFarNeighbor.setDontBroadcast(true);
            this.mFarNeighbor.setLocation(setPt);
        } else {
            int x = this.getCurrLocation().x;
            int fx = this.mFarNeighbor.getCurrLocation().x;
            LeftDragHandle.setPt.x = x + (fx - x) / 2;
            LeftDragHandle.setPt.y = this.getCurrLocation().y;
            double newVal = this.mCtrNeighbor.getNewValue(LeftDragHandle.setPt.x);
            this.mCtrNeighbor.setValue(newVal);
            this.mCtrNeighbor.setDontBroadcast(true);
            this.mCtrNeighbor.setLocation(setPt);
        }
    }

    @Override
    public void setNeighbors(int del, boolean setFar) {
        if (del == 0) {
            return;
        }
        if (!setFar) {
            LeftDragHandle.setPt.x = this.mCtrNeighbor.getCurrLocation().x + del;
            LeftDragHandle.setPt.y = this.getCurrLocation().y;
            double newVal = this.mFarNeighbor.getNewValue(LeftDragHandle.setPt.x);
            this.mFarNeighbor.setValue(newVal);
            this.mFarNeighbor.setDontBroadcast(true);
            this.mFarNeighbor.setLocation(setPt);
        } else {
            int x = this.getCurrLocation().x;
            int fx = this.mFarNeighbor.getCurrLocation().x;
            LeftDragHandle.setPt.x = x + (fx - x) / 2;
            LeftDragHandle.setPt.y = this.getCurrLocation().y;
            double newVal = this.mCtrNeighbor.getNewValue(LeftDragHandle.setPt.x);
            this.mCtrNeighbor.setValue(newVal);
            this.mCtrNeighbor.setDontBroadcast(true);
            this.mCtrNeighbor.setLocation(setPt);
        }
    }

    @Override
    public String getPropertyName() {
        switch (this.mAxis) {
            case 0: {
                return new String("latmin");
            }
            case 1: {
                return new String("lonmin");
            }
            case 2: {
                return new String("zmin");
            }
            case 3: {
                return new String("timmin");
            }
        }
        return null;
    }
}

