/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.LossyConstraints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class LossyLayout
implements LayoutManager2 {
    Hashtable comps = new Hashtable();
    boolean vertical;
    Vector tossList = new Vector();
    int tossThreshold = 0;
    static JPanel jpane;
    static LossyLayout ll;

    public LossyLayout(boolean vertical) {
        this.vertical = vertical;
    }

    @Override
    public float getLayoutAlignmentX(Container cont) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container cont) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container cont) {
    }

    @Override
    public Dimension maximumLayoutSize(Container cont) {
        return new Dimension(0, 0);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        LossyConstraints lc_ = (LossyConstraints)constraints;
        LossyConstraints lc = new LossyConstraints();
        lc.setType(lc_.getType());
        lc.setTossPriority(lc_.getTossPriority());
        lc.setFillerPercentage(lc_.getFillerPercentage());
        this.comps.put(comp, lc);
        if (lc.getTossPriority() != 1000) {
            this.insertInTossList(comp);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this.getTossPriority(comp) != 1000) {
            this.tossList.removeElement(comp);
        }
        this.comps.remove(comp);
    }

    void insertInTossList(Component comp) {
        boolean inserted = false;
        for (int j = 0; j < this.tossList.size() && !inserted; ++j) {
            if (this.getTossPriority(comp) >= this.getTossPriority((Component)this.tossList.elementAt(j))) continue;
            this.tossList.insertElementAt(comp, j);
            inserted = true;
        }
        if (!inserted) {
            this.tossList.addElement(comp);
        }
    }

    boolean tossIt(Component comp) {
        return this.getTossPriority(comp) <= this.tossThreshold;
    }

    int getFillerPercentageTotal(Container parent) {
        Component c;
        int total = 0;
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            c = parent.getComponent(i);
            if (!this.isFiller(c)) continue;
            total += this.getFillerPercentage(c);
        }
        for (int j = 0; j < this.tossList.size(); ++j) {
            c = (Component)this.tossList.elementAt(j);
            if (!this.isFiller(c) || !this.tossIt(c)) continue;
            total -= this.getFillerPercentage(c);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension layoutSize(Container parent, boolean minimum) {
        Insets insets = parent.getInsets();
        int w = 0;
        int h = 0;
        Object object = parent.getTreeLock();
        synchronized (object) {
            int n = parent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Dimension d;
                Component c = parent.getComponent(i);
                Dimension dimension = d = minimum ? c.getMinimumSize() : c.getPreferredSize();
                if (this.vertical) {
                    w = Math.max(w, d.width);
                    h += d.height;
                    continue;
                }
                w += d.width;
                h = Math.max(h, d.height);
            }
        }
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, true);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent, false);
    }

    public boolean isFiller(Component c) {
        LossyConstraints lc = (LossyConstraints)this.comps.get(c);
        return lc.isFiller();
    }

    public int getFillerPercentage(Component c) {
        LossyConstraints lc = (LossyConstraints)this.comps.get(c);
        return lc.getFillerPercentage();
    }

    public int getTossPriority(Component c) {
        LossyConstraints lc = (LossyConstraints)this.comps.get(c);
        return lc.getTossPriority();
    }

    public int getMaxWidth(Container parent) {
        return parent.getSize().width - (parent.getInsets().left + parent.getInsets().right);
    }

    public int getMaxHeight(Container parent) {
        return parent.getSize().height - (parent.getInsets().top + parent.getInsets().bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int i;
            int n = parent.getComponentCount();
            int height = 0;
            int width = 0;
            int nFixed = 0;
            for (i = 0; i < n; ++i) {
                if (this.isFiller(parent.getComponent(i))) continue;
                ++nFixed;
                if (this.vertical) {
                    height += parent.getComponent((int)i).getPreferredSize().height;
                    continue;
                }
                width += parent.getComponent((int)i).getPreferredSize().width;
            }
            int extra = this.vertical ? parent.getSize().height - height - parent.getInsets().top - parent.getInsets().bottom : parent.getSize().width - width - parent.getInsets().left - parent.getInsets().right;
            this.tossThreshold = 0;
            if (extra < 0) {
                for (i = 0; i < this.tossList.size() && extra < 0; ++i) {
                    Component c = (Component)this.tossList.elementAt(i);
                    if (this.isFiller(c)) continue;
                    extra = this.vertical ? (extra += c.getPreferredSize().height) : (extra += c.getPreferredSize().width);
                    this.tossThreshold = this.getTossPriority(c);
                }
            }
            this.doLayout(parent, extra);
        }
    }

    void doLayout(Container parent, int extra) {
        Insets insets = parent.getInsets();
        int remainder = extra;
        int n = parent.getComponentCount();
        int fillerNormalize = this.getFillerPercentageTotal(parent);
        if (this.vertical) {
            int y = insets.top;
            for (int i = 0; i < n; ++i) {
                int x = insets.left;
                Component c = parent.getComponent(i);
                Dimension d = c.getPreferredSize();
                if (!this.tossIt(c)) {
                    if (this.isFiller(c)) {
                        float amt1 = (float)extra * (float)this.getFillerPercentage(c) / (float)fillerNormalize;
                        int amt = new Float(amt1).intValue();
                        if (amt > remainder) {
                            d.height = remainder;
                            remainder = 0;
                        } else {
                            d.height = amt;
                            remainder -= amt;
                        }
                    }
                    int w = Math.min(d.width, this.getMaxWidth(parent));
                    x = (parent.getSize().width - d.width) / 2;
                    c.setBounds(x, y, w, d.height);
                    y += d.height;
                    continue;
                }
                c.setBounds(0, 0, 0, 0);
            }
        } else {
            int x = insets.left;
            for (int i = 0; i < n; ++i) {
                int y = insets.top;
                Component c = parent.getComponent(i);
                Dimension d = c.getPreferredSize();
                if (!this.tossIt(c)) {
                    if (this.isFiller(c)) {
                        float amt1 = (float)extra * (float)this.getFillerPercentage(c) / (float)fillerNormalize;
                        int amt = new Float(amt1).intValue();
                        if (amt > remainder) {
                            d.width = remainder;
                            remainder = 0;
                        } else {
                            d.width = amt;
                            remainder -= amt;
                        }
                    }
                    y = (parent.getSize().height - d.height) / 2;
                    c.setBounds(x, y, d.width, d.height);
                    x += d.width;
                    continue;
                }
                c.setBounds(0, 0, 0, 0);
            }
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame();
        fr.setSize(700, 600);
        fr.setVisible(true);
        fr.getContentPane().setLayout(null);
        LossyConstraints lcf = new LossyConstraints();
        lcf.setType(0);
        LossyConstraints lcs = new LossyConstraints();
        lcs.setType(1);
        jpane = new JPanel();
        jpane.setBounds(10, 10, 600, 600);
        jpane.setVisible(true);
        jpane.setBackground(Color.red);
        fr.getContentPane().add(jpane);
        ll = new LossyLayout(false);
        jpane.setLayout(ll);
        JPanel fill1 = new JPanel();
        fill1.setBackground(new Color(125, 125, 125));
        fill1.setMinimumSize(new Dimension(30, 30));
        fill1.setPreferredSize(new Dimension(30, 30));
        lcf.setFillerPercentage(30);
        jpane.add((Component)fill1, lcf);
        lcs.setTossPriority(1);
        jpane.add((Component)new JButton("firstToGo"), lcs);
        JPanel fill2 = new JPanel();
        fill2.setBackground(new Color(175, 175, 175));
        fill2.setMinimumSize(new Dimension(30, 30));
        fill2.setPreferredSize(new Dimension(30, 30));
        lcf.setFillerPercentage(10);
        lcf.setTossPriority(1);
        jpane.add((Component)fill2, lcf);
        lcs.setTossPriority(2);
        jpane.add((Component)new JButton("secondToGo"), lcs);
        JPanel fill3 = new JPanel();
        fill3.setBackground(new Color(200, 200, 200));
        fill3.setMinimumSize(new Dimension(30, 30));
        fill3.setPreferredSize(new Dimension(30, 30));
        lcf.setFillerPercentage(10);
        lcf.setTossPriority(2);
        jpane.add((Component)fill3, lcf);
        lcs.setTossPriority(3);
        jpane.add((Component)new JButton("thirdToGo"), lcs);
        JPanel fill4 = new JPanel();
        fill4.setBackground(new Color(225, 225, 225));
        fill4.setMinimumSize(new Dimension(30, 30));
        fill4.setPreferredSize(new Dimension(30, 30));
        lcf.setFillerPercentage(10);
        lcf.setTossPriority(3);
        jpane.add((Component)fill4, lcf);
        JButton jb1 = new JButton("increaseSize");
        lcs.setTossPriority(1000);
        jpane.add((Component)jb1, lcs);
        jb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LossyLayout.ll.vertical) {
                    jpane.setSize(new Dimension(jpane.getWidth(), jpane.getHeight() + 10));
                } else {
                    jpane.setSize(new Dimension(jpane.getWidth() + 10, jpane.getHeight()));
                }
                jpane.invalidate();
                jpane.validate();
            }
        });
        lcs.setTossPriority(1000);
        jpane.add((Component)jb1, lcs);
        JPanel fill5 = new JPanel();
        fill5.setBackground(new Color(250, 250, 250));
        fill5.setMinimumSize(new Dimension(30, 30));
        fill5.setPreferredSize(new Dimension(30, 30));
        lcf.setFillerPercentage(10);
        lcf.setTossPriority(1000);
        jpane.add((Component)fill5, lcf);
        JButton jb2 = new JButton("decreaseSize");
        lcs.setTossPriority(1000);
        jpane.add((Component)jb2, lcs);
        jb2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LossyLayout.ll.vertical) {
                    jpane.setSize(new Dimension(jpane.getWidth(), jpane.getHeight() - 10));
                } else {
                    jpane.setSize(new Dimension(jpane.getWidth() - 10, jpane.getHeight()));
                }
                jpane.invalidate();
                jpane.validate();
            }
        });
        JPanel fill6 = new JPanel();
        fill6.setBackground(new Color(100, 100, 100));
        fill6.setMinimumSize(new Dimension(30, 30));
        fill6.setPreferredSize(new Dimension(30, 30));
        lcf.setFillerPercentage(30);
        lcf.setTossPriority(1000);
        jpane.add((Component)fill6, lcf);
        jpane.invalidate();
        jpane.validate();
        fr.invalidate();
        fr.validate();
    }
}

