/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.DragHandle;
import gov.noaa.pmel.swing.JStretchPanel;
import java.awt.Graphics;
import java.awt.Point;

public class LowerDragHandle
extends DragHandle {
    private static Point setPt = new Point(0, 0);

    public LowerDragHandle(JStretchPanel jsp, int h, int v, int type, int style, int orient, int axis, int uporleft, int loworright, double uporleftval, double loworrightval, double val) {
        super(jsp, h, v, type, style, orient, axis, uporleft, loworright, uporleftval, loworrightval, val);
    }

    @Override
    public void draw(Graphics g) {
        int drawnV = this.mV;
        if (this.mV > this.getAxisOrigin() + this.getAxisRange() + 2) {
            drawnV = this.getAxisOrigin() + this.getAxisRange();
            this.setOutOfRange(true);
            this.setStyle(FLAGSTYLE);
        } else if (this.mV < this.getAxisOrigin() - 2) {
            drawnV = this.getAxisOrigin();
            this.setOutOfRange(true);
            this.setStyle(FLAGSTYLE);
        } else {
            this.setOutOfRange(false);
            this.setStyle(RECTSTYLE);
        }
        if (this.isOutOfRange()) {
            return;
        }
        if (this.mStyle == RECTSTYLE) {
            if (this.isFocused()) {
                g.setColor(this.grey100);
                g.fillRect(this.mH, drawnV, 18, 7);
            } else {
                g.setColor(this.grey100);
                g.drawRect(this.mH, drawnV, 18, 7);
            }
        } else {
            int[] xp = new int[]{this.mH, this.mH + 18, this.mH + 9};
            int[] yp = new int[]{drawnV, drawnV, drawnV + 8};
            g.fillPolygon(xp, yp, 3);
        }
    }

    @Override
    public void getRect() {
        this.currHandleRect.x = this.mH;
        this.currHandleRect.y = this.mV;
        this.currHandleRect.width = 18;
        this.currHandleRect.height = 7;
    }

    @Override
    public Point constrainPoint(int h, int v) {
        int locOfNhbr;
        int hh = h;
        int vv = v;
        hh = this.mHLimit;
        if (v > this.mLowerOrRightLimit) {
            vv = this.mLowerOrRightLimit;
        }
        if (v < this.mUpperOrLeftLimit) {
            vv = this.mUpperOrLeftLimit;
        }
        if (v < (locOfNhbr = this.mFarNeighbor.getCurrLocation().y) + 8) {
            vv = this.mFarNeighbor.getCurrLocation().y + 8;
        }
        this.constrainedPoint.x = hh;
        this.constrainedPoint.y = vv + this.mDeltaV;
        return this.constrainedPoint;
    }

    @Override
    public void setNeighbors(boolean setFar) {
        int del = this.getCurrLocation().y - this.mCtrNeighbor.getCurrLocation().y;
        if (del == 0) {
            return;
        }
        if (!setFar) {
            LowerDragHandle.setPt.y = this.mCtrNeighbor.getCurrLocation().y - del;
            LowerDragHandle.setPt.x = this.getCurrLocation().x;
            double newVal = this.mFarNeighbor.getNewValue(LowerDragHandle.setPt.y);
            this.mFarNeighbor.setValue(newVal);
            this.mFarNeighbor.setDontBroadcast(true);
            this.mFarNeighbor.setLocation(setPt);
        } else {
            int y = this.getCurrLocation().y;
            int fy = this.mFarNeighbor.getCurrLocation().y;
            LowerDragHandle.setPt.y = y + (fy - y) / 2;
            LowerDragHandle.setPt.x = this.getCurrLocation().x;
            double newVal = this.mCtrNeighbor.getNewValue(LowerDragHandle.setPt.y);
            this.mCtrNeighbor.setValue(newVal);
            this.mCtrNeighbor.setDontBroadcast(true);
            this.mCtrNeighbor.setLocation(setPt);
        }
    }

    @Override
    public void setNeighbors(int del, boolean setFar) {
        if (del == 0) {
            return;
        }
        if (!setFar) {
            LowerDragHandle.setPt.y = this.mCtrNeighbor.getCurrLocation().y - del;
            LowerDragHandle.setPt.x = this.getCurrLocation().x;
            double newVal = this.mFarNeighbor.getNewValue(LowerDragHandle.setPt.y);
            this.mFarNeighbor.setValue(newVal);
            this.mFarNeighbor.setDontBroadcast(true);
            this.mFarNeighbor.setLocation(setPt);
        } else {
            int y = this.getCurrLocation().y;
            int fy = this.mFarNeighbor.getCurrLocation().y;
            LowerDragHandle.setPt.y = y + (fy - y) / 2;
            LowerDragHandle.setPt.x = this.getCurrLocation().x;
            double newVal = this.mCtrNeighbor.getNewValue(LowerDragHandle.setPt.y);
            this.mCtrNeighbor.setValue(newVal);
            this.mCtrNeighbor.setDontBroadcast(true);
            this.mCtrNeighbor.setLocation(setPt);
        }
    }

    @Override
    public String getPropertyName() {
        switch (this.mAxis) {
            case 0: {
                return new String("latmin");
            }
            case 1: {
                return new String("lonmin");
            }
            case 2: {
                return new String("zmax");
            }
            case 3: {
                return new String("timmin");
            }
        }
        return null;
    }
}

