/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.JStretchPanel;
import gov.noaa.pmel.swing.Rubberband;
import gov.noaa.pmel.swing.RubberbandRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;

public class PolygonSpline
extends Rubberband {
    boolean mIstarted = false;
    int mStartWidth;
    GeneralPath aLine = new GeneralPath();

    @Override
    public void drawLast(Graphics graphics) {
        double dx = this.anchorPt.x - this.lastPt.x;
        double dy = this.anchorPt.y - this.lastPt.y;
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        this.drawLine(this.anchorPt.x, this.anchorPt.y, this.lastPt.x, this.lastPt.y);
    }

    @Override
    public void drawNext(Graphics graphics) {
        double dx = this.anchorPt.x - this.stretchedPt.x;
        double dy = this.anchorPt.y - this.stretchedPt.y;
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        this.drawLine(this.anchorPt.x, this.anchorPt.y, this.stretchedPt.x, this.stretchedPt.y);
    }

    public void drawPtToPt(Graphics graphics, Point p1, Point p2) {
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        this.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    public void drawLine(int x, int y, int x2, int y2) {
        this.aLine.reset();
        this.aLine.moveTo(x, y);
        this.aLine.lineTo(x2, y2);
        ((RubberbandRenderer)((Object)this.component)).setRubberbandDisplayObject(this.aLine, false);
    }

    public PolygonSpline() {
    }

    public PolygonSpline(Component c) {
        this.setComponent(c);
    }

    @Override
    public void setComponent(Component ic) {
        this.component = ic;
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (PolygonSpline.this.isActive()) {
                    PolygonSpline.this.anchor(me.getPoint());
                    if (!PolygonSpline.this.mIstarted) {
                        ((JStretchPanel)PolygonSpline.this.component).getSplinePoints().removeAllElements();
                        ((JStretchPanel)PolygonSpline.this.component).getSplinePoints().addElement(new Point(PolygonSpline.this.anchorPt));
                        PolygonSpline.this.mIstarted = true;
                    } else {
                        if (me.getClickCount() == 2 && PolygonSpline.this.mIstarted) {
                            ((JStretchPanel)PolygonSpline.this.component).addSplinePoint(new Point(PolygonSpline.this.anchorPt));
                            PolygonSpline.this.mIstarted = false;
                            me.consume();
                            ((JStretchPanel)PolygonSpline.this.component).processPolygonSpline(me.isShiftDown());
                        } else {
                            ((JStretchPanel)PolygonSpline.this.component).addSplinePoint(new Point(PolygonSpline.this.anchorPt));
                        }
                        PolygonSpline.this.end(me.getPoint());
                    }
                }
            }
        });
        this.component.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                if (PolygonSpline.this.isActive() && PolygonSpline.this.mIstarted) {
                    PolygonSpline.this.stretch(event.getPoint());
                }
            }
        });
    }

    @Override
    public boolean splineActive() {
        return this.mIstarted;
    }

    @Override
    public int getUpperLeftX() {
        Rectangle newBounds = this.lastBounds();
        return newBounds.x;
    }

    @Override
    public int getLowerRightX() {
        Rectangle newBounds = this.lastBounds();
        return newBounds.x + newBounds.width;
    }

    @Override
    public int getUpperLeftY() {
        Rectangle newBounds = this.lastBounds();
        return newBounds.y;
    }

    @Override
    public int getLowerRightY() {
        Rectangle newBounds = this.lastBounds();
        return newBounds.y + newBounds.height;
    }

    @Override
    public int getUpperRightX() {
        return -99;
    }

    @Override
    public int getUpperRightY() {
        return -99;
    }

    @Override
    public int getLowerLeftX() {
        return -99;
    }

    @Override
    public int getLowerLeftY() {
        return -99;
    }

    @Override
    public void resetRect() {
    }

    @Override
    public boolean isPoint() {
        return false;
    }
}

